# coding: utf-8

"""
    Zarban Wallet API

    API for Zarban wallet services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.wallet.openapi_client.configuration import Configuration


class Transaction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'time': 'Timestamp',
        'type': 'TransactionType',
        '_from': 'str',
        'to': 'str',
        'symbol': 'Symbol',
        'amount': 'dict(str, str)',
        'direction': 'str',
        'external_transaction': 'ExternalTransaction'
    }

    attribute_map = {
        'id': 'id',
        'time': 'time',
        'type': 'type',
        '_from': 'from',
        'to': 'to',
        'symbol': 'symbol',
        'amount': 'amount',
        'direction': 'direction',
        'external_transaction': 'externalTransaction'
    }

    def __init__(self, id=None, time=None, type=None, _from=None, to=None, symbol=None, amount=None, direction=None, external_transaction=None, local_vars_configuration=None):  # noqa: E501
        """Transaction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._time = None
        self._type = None
        self.__from = None
        self._to = None
        self._symbol = None
        self._amount = None
        self._direction = None
        self._external_transaction = None
        self.discriminator = None

        self.id = id
        self.time = time
        self.type = type
        self._from = _from
        self.to = to
        self.symbol = symbol
        self.amount = amount
        self.direction = direction
        if external_transaction is not None:
            self.external_transaction = external_transaction

    @property
    def id(self):
        """Gets the id of this Transaction.  # noqa: E501

        Unique identifier of the transaction  # noqa: E501

        :return: The id of this Transaction.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Transaction.

        Unique identifier of the transaction  # noqa: E501

        :param id: The id of this Transaction.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def time(self):
        """Gets the time of this Transaction.  # noqa: E501


        :return: The time of this Transaction.  # noqa: E501
        :rtype: Timestamp
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this Transaction.


        :param time: The time of this Transaction.  # noqa: E501
        :type: Timestamp
        """
        if self.local_vars_configuration.client_side_validation and time is None:  # noqa: E501
            raise ValueError("Invalid value for `time`, must not be `None`")  # noqa: E501

        self._time = time

    @property
    def type(self):
        """Gets the type of this Transaction.  # noqa: E501


        :return: The type of this Transaction.  # noqa: E501
        :rtype: TransactionType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Transaction.


        :param type: The type of this Transaction.  # noqa: E501
        :type: TransactionType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def _from(self):
        """Gets the _from of this Transaction.  # noqa: E501

        The ID of the user from whom the transaction originated  # noqa: E501

        :return: The _from of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this Transaction.

        The ID of the user from whom the transaction originated  # noqa: E501

        :param _from: The _from of this Transaction.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and _from is None:  # noqa: E501
            raise ValueError("Invalid value for `_from`, must not be `None`")  # noqa: E501

        self.__from = _from

    @property
    def to(self):
        """Gets the to of this Transaction.  # noqa: E501

        The ID of the user to whom the transaction is directed  # noqa: E501

        :return: The to of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this Transaction.

        The ID of the user to whom the transaction is directed  # noqa: E501

        :param to: The to of this Transaction.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and to is None:  # noqa: E501
            raise ValueError("Invalid value for `to`, must not be `None`")  # noqa: E501

        self._to = to

    @property
    def symbol(self):
        """Gets the symbol of this Transaction.  # noqa: E501


        :return: The symbol of this Transaction.  # noqa: E501
        :rtype: Symbol
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """Sets the symbol of this Transaction.


        :param symbol: The symbol of this Transaction.  # noqa: E501
        :type: Symbol
        """
        if self.local_vars_configuration.client_side_validation and symbol is None:  # noqa: E501
            raise ValueError("Invalid value for `symbol`, must not be `None`")  # noqa: E501

        self._symbol = symbol

    @property
    def amount(self):
        """Gets the amount of this Transaction.  # noqa: E501


        :return: The amount of this Transaction.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Transaction.


        :param amount: The amount of this Transaction.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def direction(self):
        """Gets the direction of this Transaction.  # noqa: E501

        Equal to \"Inbound\" if the transaction is directed to the user, and \"Outbound\" if the transaction is directed from the user.  # noqa: E501

        :return: The direction of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this Transaction.

        Equal to \"Inbound\" if the transaction is directed to the user, and \"Outbound\" if the transaction is directed from the user.  # noqa: E501

        :param direction: The direction of this Transaction.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and direction is None:  # noqa: E501
            raise ValueError("Invalid value for `direction`, must not be `None`")  # noqa: E501
        allowed_values = ["Inbound", "Outbound"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and direction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `direction` ({0}), must be one of {1}"  # noqa: E501
                .format(direction, allowed_values)
            )

        self._direction = direction

    @property
    def external_transaction(self):
        """Gets the external_transaction of this Transaction.  # noqa: E501


        :return: The external_transaction of this Transaction.  # noqa: E501
        :rtype: ExternalTransaction
        """
        return self._external_transaction

    @external_transaction.setter
    def external_transaction(self, external_transaction):
        """Sets the external_transaction of this Transaction.


        :param external_transaction: The external_transaction of this Transaction.  # noqa: E501
        :type: ExternalTransaction
        """

        self._external_transaction = external_transaction

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Transaction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Transaction):
            return True

        return self.to_dict() != other.to_dict()
