# Do not edit this file. It was auto-generated from the
# corresponding YAML file.
spec = {
    "name": "BURDI",
    "title": "BUR GHG emission categories (DI query interface)",
    "comment": "Biannual Update Report categories of GHG emissions and removals and some other quantities as obtained from the di.unfccc.int flexible query interface",
    "references": "https://unfccc.int/process-and-meetings/transparency-and-reporting/greenhouse-gas-data/data-interface-help#eq-7 and decision 17/CP.8, 'Guidelines for the preparation of national communications from Parties not included in Annex I to the Convention' available at https://unfccc.int/files/meetings/workshops/other_meetings/application/pdf/dec17-cp.pdf",
    "institution": "UNFCCC",
    "hierarchical": True,
    "last_update": "2021-11-05",
    "total_sum": True,
    "canonical_top_level_category": "24540",
    "categories": {
        "10502": {"title": "Total land area", "info": {"numerical_ids": ["10502"]}},
        "10503": {"title": "GDP", "info": {"numerical_ids": ["10503"]}},
        "10504": {"title": "Total population", "info": {"numerical_ids": ["10504"]}},
        "14423": {"title": "Marine", "info": {"numerical_ids": ["14423"]}},
        "14424": {"title": "Aviation", "info": {"numerical_ids": ["14424"]}},
        "14568": {
            "title": "Memo Items",
            "alternative_codes": ["24568"],
            "info": {"numerical_ids": ["14568", "24568"]},
            "children": [["14637", "14638"]],
        },
        "14637": {
            "title": "International Bunkers",
            "info": {"numerical_ids": ["14637"]},
            "children": [["14423", "14424"]],
        },
        "14638": {
            "title": "CO₂ Emissions from Biomass",
            "info": {"numerical_ids": ["14638"]},
        },
        "15163": {
            "title": "Total GHG emissions excluding LULUCF/LUCF",
            "info": {"numerical_ids": ["15163"]},
            "children": [["1", "14568", "2", "3", "4", "6", "7"]],
        },
        "24540": {
            "title": "Total GHG emissions including LULUCF/LUCF",
            "info": {"numerical_ids": ["24540"]},
            "children": [["1", "14568", "2", "3", "4", "5", "6", "7"]],
        },
        "1": {
            "title": "Energy",
            "alternative_codes": ["1.", "14544", "24544"],
            "info": {"numerical_ids": ["14544", "24544"]},
            "children": [["1.A", "1.B"]],
        },
        "1.A": {
            "title": "Fuel Combustion - Sectoral Approach",
            "alternative_codes": ["14645", "1A", "1 A"],
            "info": {"numerical_ids": ["14645"]},
            "children": [["1.A.1", "1.A.2", "1.A.3", "1.A.4", "1.A.5"]],
        },
        "1.A.1": {
            "title": "Energy Industries",
            "alternative_codes": ["14434", "1A1", "1 A 1"],
            "info": {"numerical_ids": ["14434"]},
        },
        "1.A.2": {
            "title": "Manufacturing Industries and Construction",
            "alternative_codes": ["14432", "1A2", "1 A 2"],
            "info": {"numerical_ids": ["14432"]},
        },
        "1.A.3": {
            "title": "Transport",
            "alternative_codes": ["14435", "1A3", "1 A 3"],
            "info": {"numerical_ids": ["14435"]},
        },
        "1.A.4": {
            "title": "Other Sectors",
            "alternative_codes": ["14436", "1A4", "1 A 4"],
            "info": {"numerical_ids": ["14436"]},
        },
        "1.A.5": {
            "title": "Other (Not elsewhere specified)",
            "alternative_codes": ["14433", "1A5", "1 A 5"],
            "info": {"numerical_ids": ["14433"]},
        },
        "1.B": {
            "title": "Fugitive Emissions from Fuels",
            "alternative_codes": ["14569", "1B", "1 B"],
            "info": {"numerical_ids": ["14569"]},
            "children": [["1.B.1", "1.B.2"]],
        },
        "1.B.1": {
            "title": "Solid Fuels",
            "alternative_codes": ["14640", "1B1", "1 B 1"],
            "info": {"numerical_ids": ["14640"]},
            "children": [["1.B.1.a", "1.B.1.b"]],
        },
        "1.B.1.a": {
            "title": "Underground Mines",
            "alternative_codes": ["14669", "1B1a", "1 B 1 a"],
            "info": {"numerical_ids": ["14669"]},
        },
        "1.B.1.b": {
            "title": "Surface Mines",
            "alternative_codes": ["14689", "1B1b", "1 B 1 b"],
            "info": {"numerical_ids": ["14689"]},
        },
        "1.B.2": {
            "title": "Oil and Natural Gas",
            "alternative_codes": ["14641", "1B2", "1 B 2"],
            "info": {"numerical_ids": ["14641"]},
            "children": [["1.B.2.a", "1.B.2.b", "1.B.2.c"]],
        },
        "1.B.2.a": {
            "title": "Oil",
            "alternative_codes": ["14790", "1B2a", "1 B 2 a"],
            "info": {"numerical_ids": ["14790"]},
            "children": [
                [
                    "1.B.2.a.i",
                    "1.B.2.a.ii",
                    "1.B.2.a.iii",
                    "1.B.2.a.iv",
                    "1.B.2.a.v",
                    "1.B.2.a.vi",
                ]
            ],
        },
        "1.B.2.a.i": {
            "title": "Exploration",
            "alternative_codes": ["14791", "1B2ai", "1 B 2 a i"],
            "info": {"numerical_ids": ["14791"]},
        },
        "1.B.2.a.ii": {
            "title": "Production",
            "alternative_codes": ["14673", "1B2aii", "1 B 2 a ii"],
            "info": {"numerical_ids": ["14673"]},
        },
        "1.B.2.a.iii": {
            "title": "Transport",
            "alternative_codes": ["14712", "1B2aiii", "1 B 2 a iii"],
            "info": {"numerical_ids": ["14712"]},
        },
        "1.B.2.a.iv": {
            "title": "Refining / Storage",
            "alternative_codes": ["14727", "1B2aiv", "1 B 2 a iv"],
            "info": {"numerical_ids": ["14727"]},
        },
        "1.B.2.a.v": {
            "title": "Distribution of Oil Products",
            "alternative_codes": ["14751", "1B2av", "1 B 2 a v"],
            "info": {"numerical_ids": ["14751"]},
        },
        "1.B.2.a.vi": {
            "title": "Other",
            "alternative_codes": ["14792", "1B2avi", "1 B 2 a vi"],
            "info": {"numerical_ids": ["14792"]},
        },
        "1.B.2.b": {
            "title": "Natural Gas",
            "alternative_codes": ["14793", "1B2b", "1 B 2 b"],
            "info": {"numerical_ids": ["14793"]},
            "children": [
                ["1.B.2.b.i", "1.B.2.b.ii", "1.B.2.b.iii", "1.B.2.b.iv", "1.B.2.b.v"]
            ],
        },
        "1.B.2.b.i": {
            "title": "Exploration",
            "alternative_codes": ["14662", "1B2bi", "1 B 2 b i"],
            "info": {"numerical_ids": ["14662"]},
        },
        "1.B.2.b.ii": {
            "title": "Production / Processing",
            "alternative_codes": ["14666", "1B2bii", "1 B 2 b ii"],
            "info": {"numerical_ids": ["14666"]},
        },
        "1.B.2.b.iii": {
            "title": "Transmission",
            "alternative_codes": ["14726", "1B2biii", "1 B 2 b iii"],
            "info": {"numerical_ids": ["14726"]},
        },
        "1.B.2.b.iv": {
            "title": "Distribution",
            "alternative_codes": ["14651", "1B2biv", "1 B 2 b iv"],
            "info": {"numerical_ids": ["14651"]},
        },
        "1.B.2.b.v": {
            "title": "Other Leakage",
            "alternative_codes": ["14740", "1B2bv", "1 B 2 b v"],
            "info": {"numerical_ids": ["14740"]},
        },
        "1.B.2.c": {
            "title": "Venting and Flaring",
            "alternative_codes": ["14794", "1B2c", "1 B 2 c"],
            "info": {"numerical_ids": ["14794"]},
            "children": [["1.B.2.c.i", "1.B.2.c.ii"]],
        },
        "1.B.2.c.i": {
            "title": "Venting",
            "alternative_codes": ["14795", "1B2ci", "1 B 2 c i"],
            "info": {"numerical_ids": ["14795"]},
            "children": [["1.B.2.c.i.a", "1.B.2.c.i.b", "1.B.2.c.i.c"]],
        },
        "1.B.2.c.i.a": {
            "title": "Oil",
            "alternative_codes": ["14796", "1B2cia", "1 B 2 c i a"],
            "info": {"numerical_ids": ["14796"]},
        },
        "1.B.2.c.i.b": {
            "title": "Gas",
            "alternative_codes": ["14661", "1B2cib", "1 B 2 c i b"],
            "info": {"numerical_ids": ["14661"]},
        },
        "1.B.2.c.i.c": {
            "title": "Combined",
            "alternative_codes": ["14797", "1B2cic", "1 B 2 c i c"],
            "info": {"numerical_ids": ["14797"]},
        },
        "1.B.2.c.ii": {
            "title": "Flaring",
            "alternative_codes": ["14798", "1B2cii", "1 B 2 c ii"],
            "info": {"numerical_ids": ["14798"]},
            "children": [["1.B.2.c.ii.a", "1.B.2.c.ii.b", "1.B.2.c.ii.c"]],
        },
        "1.B.2.c.ii.a": {
            "title": "Oil",
            "alternative_codes": ["14648", "1B2ciia", "1 B 2 c ii a"],
            "info": {"numerical_ids": ["14648"]},
        },
        "1.B.2.c.ii.b": {
            "title": "Gas",
            "alternative_codes": ["14677", "1B2ciib", "1 B 2 c ii b"],
            "info": {"numerical_ids": ["14677"]},
        },
        "1.B.2.c.ii.c": {
            "title": "Combined",
            "alternative_codes": ["14799", "1B2ciic", "1 B 2 c ii c"],
            "info": {"numerical_ids": ["14799"]},
        },
        "2": {
            "title": "Industrial Processes",
            "alternative_codes": ["2.", "14542", "24542"],
            "info": {"numerical_ids": ["14542", "24542"]},
            "children": [["2.A", "2.B", "2.C", "2.D", "2.E", "2.F", "2.G"]],
        },
        "2.A": {
            "title": "Mineral Products",
            "alternative_codes": ["14553", "2A", "2 A"],
            "info": {"numerical_ids": ["14553"]},
            "children": [
                ["2.A.1", "2.A.2", "2.A.3", "2.A.4", "2.A.5", "2.A.6", "2.A.7"]
            ],
        },
        "2.A.1": {
            "title": "Cement Production",
            "alternative_codes": ["14693", "2A1", "2 A 1"],
            "info": {"numerical_ids": ["14693"]},
        },
        "2.A.2": {
            "title": "Lime Production",
            "alternative_codes": ["14668", "2A2", "2 A 2"],
            "info": {"numerical_ids": ["14668"]},
        },
        "2.A.3": {
            "title": "Limestone and Dolomite Use",
            "alternative_codes": ["14676", "2A3", "2 A 3"],
            "info": {"numerical_ids": ["14676"]},
        },
        "2.A.4": {
            "title": "Soda Ash",
            "alternative_codes": ["14800", "2A4", "2 A 4"],
            "info": {"numerical_ids": ["14800"]},
            "children": [["2.A.4.a", "2.A.4.b"]],
        },
        "2.A.4.a": {
            "title": "Soda Ash Production",
            "alternative_codes": ["14687", "2A4a", "2 A 4 a"],
            "info": {"numerical_ids": ["14687"]},
        },
        "2.A.4.b": {
            "title": "Soda Ash Use",
            "alternative_codes": ["14745", "2A4b", "2 A 4 b"],
            "info": {"numerical_ids": ["14745"]},
        },
        "2.A.5": {
            "title": "Asphalt Roofing",
            "alternative_codes": ["14652", "2A5", "2 A 5"],
            "info": {"numerical_ids": ["14652"]},
        },
        "2.A.6": {
            "title": "Road Paving with Asphalt",
            "alternative_codes": ["14721", "2A6", "2 A 6"],
            "info": {"numerical_ids": ["14721"]},
        },
        "2.A.7": {
            "title": "Other",
            "alternative_codes": ["14801", "2A7", "2 A 7"],
            "info": {"numerical_ids": ["14801"]},
            "children": [["2.A.7.a"]],
        },
        "2.A.7.a": {
            "title": "Glass Production",
            "alternative_codes": ["14748", "2A7a", "2 A 7 a"],
            "info": {"numerical_ids": ["14748"]},
        },
        "2.B": {
            "title": "Chemical Industry",
            "alternative_codes": ["14558", "2B", "2 B"],
            "info": {"numerical_ids": ["14558"]},
            "children": [["2.B.1", "2.B.2", "2.B.3", "2.B.4", "2.B.5"]],
        },
        "2.B.1": {
            "title": "Ammonia Production",
            "alternative_codes": ["14691", "2B1", "2 B 1"],
            "info": {"numerical_ids": ["14691"]},
        },
        "2.B.2": {
            "title": "Nitric Acid Production",
            "alternative_codes": ["14697", "2B2", "2 B 2"],
            "info": {"numerical_ids": ["14697"]},
        },
        "2.B.3": {
            "title": "Adipic Acid Production",
            "alternative_codes": ["14658", "2B3", "2 B 3"],
            "info": {"numerical_ids": ["14658"]},
        },
        "2.B.4": {
            "title": "Carbide Production",
            "alternative_codes": ["14713", "2B4", "2 B 4"],
            "info": {"numerical_ids": ["14713"]},
            "children": [["2.B.4.a", "2.B.4.b"]],
        },
        "2.B.4.a": {
            "title": "Silicon Carbide",
            "alternative_codes": ["14743", "2B4a", "2 B 4 a"],
            "info": {"numerical_ids": ["14743"]},
        },
        "2.B.4.b": {
            "title": "Calcium Carbide",
            "alternative_codes": ["14720", "2B4b", "2 B 4 b"],
            "info": {"numerical_ids": ["14720"]},
        },
        "2.B.5": {
            "title": "Other",
            "alternative_codes": ["14802", "2B5", "2 B 5"],
            "info": {"numerical_ids": ["14802"]},
            "children": [["2.B.5.a", "2.B.5.b", "2.B.5.c", "2.B.5.d", "2.B.5.e"]],
        },
        "2.B.5.a": {
            "title": "Carbon Black",
            "alternative_codes": ["14670", "2B5a", "2 B 5 a"],
            "info": {"numerical_ids": ["14670"]},
        },
        "2.B.5.b": {
            "title": "Ethylene",
            "alternative_codes": ["14719", "2B5b", "2 B 5 b"],
            "info": {"numerical_ids": ["14719"]},
        },
        "2.B.5.c": {
            "title": "Dichloroethylene",
            "alternative_codes": ["14653", "2B5c", "2 B 5 c"],
            "info": {"numerical_ids": ["14653"]},
        },
        "2.B.5.d": {
            "title": "Styrene",
            "alternative_codes": ["14674", "2B5d", "2 B 5 d"],
            "info": {"numerical_ids": ["14674"]},
        },
        "2.B.5.e": {
            "title": "Methanol",
            "alternative_codes": ["14646", "2B5e", "2 B 5 e"],
            "info": {"numerical_ids": ["14646"]},
        },
        "2.C": {
            "title": "Metal Production",
            "alternative_codes": ["14552", "2C", "2 C"],
            "info": {"numerical_ids": ["14552"]},
            "children": [["2.C.1", "2.C.2", "2.C.3", "2.C.4"]],
        },
        "2.C.1": {
            "title": "Iron and Steel Production",
            "alternative_codes": ["14803", "2C1", "2 C 1"],
            "info": {"numerical_ids": ["14803"]},
            "children": [["2.C.1.a", "2.C.1.b", "2.C.1.c", "2.C.1.d"]],
        },
        "2.C.1.a": {
            "title": "Steel",
            "alternative_codes": ["14725", "2C1a", "2 C 1 a"],
            "info": {"numerical_ids": ["14725"]},
        },
        "2.C.1.b": {
            "title": "Pig Iron",
            "alternative_codes": ["14744", "2C1b", "2 C 1 b"],
            "info": {"numerical_ids": ["14744"]},
        },
        "2.C.1.c": {
            "title": "Sinter",
            "alternative_codes": ["14804", "2C1c", "2 C 1 c"],
            "info": {"numerical_ids": ["14804"]},
        },
        "2.C.1.d": {
            "title": "Coke",
            "alternative_codes": ["14705", "2C1d", "2 C 1 d"],
            "info": {"numerical_ids": ["14705"]},
        },
        "2.C.2": {
            "title": "Ferroalloys Production",
            "alternative_codes": ["14729", "2C2", "2 C 2"],
            "info": {"numerical_ids": ["14729"]},
        },
        "2.C.3": {
            "title": "Aluminium Production",
            "alternative_codes": ["14701", "2C3", "2 C 3"],
            "info": {"numerical_ids": ["14701"]},
        },
        "2.C.4": {
            "title": "SF6 Used in Aluminium and Magnesium Foundries",
            "alternative_codes": ["14805", "2C4", "2 C 4"],
            "info": {"numerical_ids": ["14805"]},
            "children": [["2.C.4.a", "2.C.4.b"]],
        },
        "2.C.4.a": {
            "title": "Aluminium Foundries",
            "alternative_codes": ["14806", "2C4a", "2 C 4 a"],
            "info": {"numerical_ids": ["14806"]},
        },
        "2.C.4.b": {
            "title": "Magnesium Foundries",
            "alternative_codes": ["14807", "2C4b", "2 C 4 b"],
            "info": {"numerical_ids": ["14807"]},
        },
        "2.D": {
            "title": "Other Production",
            "alternative_codes": ["14556", "2D", "2 D"],
            "info": {"numerical_ids": ["14556"]},
            "children": [["2.D.1", "2.D.2"]],
        },
        "2.D.1": {
            "title": "Pulp and Paper",
            "alternative_codes": ["14808", "2D1", "2 D 1"],
            "info": {"numerical_ids": ["14808"]},
        },
        "2.D.2": {
            "title": "Food and Drink",
            "alternative_codes": ["14746", "2D2", "2 D 2"],
            "info": {"numerical_ids": ["14746"]},
        },
        "2.E": {
            "title": "Production of Halocarbons and SF₆",
            "alternative_codes": ["14557", "2E", "2 E"],
            "info": {"numerical_ids": ["14557"]},
            "children": [["2.E.1"]],
        },
        "2.E.1": {
            "title": "By-product emissions",
            "alternative_codes": ["14826", "2E1", "2 E 1"],
            "info": {"numerical_ids": ["14826"]},
        },
        "2.F": {
            "title": "Consumption of Halocarbons and SF₆",
            "alternative_codes": ["14559", "2F", "2 F"],
            "info": {"numerical_ids": ["14559"]},
        },
        "2.G": {
            "title": "Other",
            "alternative_codes": ["14554", "2G", "2 G"],
            "info": {"numerical_ids": ["14554"]},
        },
        "3": {
            "title": "Solvent and Other Product Use",
            "alternative_codes": ["3.", "14541", "24541"],
            "info": {"numerical_ids": ["14541", "24541"]},
        },
        "4": {
            "title": "Agriculture",
            "alternative_codes": ["4.", "14545", "24545"],
            "info": {"numerical_ids": ["14545", "24545"]},
            "children": [["4.A", "4.B", "4.C", "4.D", "4.E", "4.F", "4.G"]],
        },
        "4.A": {
            "title": "Enteric Fermentation",
            "alternative_codes": ["14577", "4A", "4 A"],
            "info": {"numerical_ids": ["14577"]},
        },
        "4.B": {
            "title": "Manure Management",
            "alternative_codes": ["14571", "4B", "4 B"],
            "info": {"numerical_ids": ["14571"]},
        },
        "4.C": {
            "title": "Rice Cultivation",
            "alternative_codes": ["14575", "4C", "4 C"],
            "info": {"numerical_ids": ["14575"]},
            "children": [["4.C.1", "4.C.2", "4.C.3"]],
        },
        "4.C.1": {
            "title": "Irrigated",
            "alternative_codes": ["14809", "4C1", "4 C 1"],
            "info": {"numerical_ids": ["14809"]},
            "children": [["4.C.1.a", "4.C.1.b"]],
        },
        "4.C.1.a": {
            "title": "Continuously Flooded",
            "alternative_codes": ["14696", "4C1a", "4 C 1 a"],
            "info": {"numerical_ids": ["14696"]},
        },
        "4.C.1.b": {
            "title": "Intermittently Flooded",
            "alternative_codes": ["14810", "4C1b", "4 C 1 b"],
            "info": {"numerical_ids": ["14810"]},
            "children": [["4.C.1.b.i", "4.C.1.b.ii"]],
        },
        "4.C.1.b.i": {
            "title": "Single Aeration",
            "alternative_codes": ["14678", "4C1bi", "4 C 1 b i"],
            "info": {"numerical_ids": ["14678"]},
        },
        "4.C.1.b.ii": {
            "title": "Multiple Aeration",
            "alternative_codes": ["14654", "4C1bii", "4 C 1 b ii"],
            "info": {"numerical_ids": ["14654"]},
        },
        "4.C.2": {
            "title": "Rainfed",
            "alternative_codes": ["14811", "4C2", "4 C 2"],
            "info": {"numerical_ids": ["14811"]},
            "children": [["4.C.2.a", "4.C.2.b"]],
        },
        "4.C.2.a": {
            "title": "Flood Prone",
            "alternative_codes": ["14659", "4C2a", "4 C 2 a"],
            "info": {"numerical_ids": ["14659"]},
        },
        "4.C.2.b": {
            "title": "Drought Prone",
            "alternative_codes": ["14711", "4C2b", "4 C 2 b"],
            "info": {"numerical_ids": ["14711"]},
        },
        "4.C.3": {
            "title": "Deep Water",
            "alternative_codes": ["14812", "4C3", "4 C 3"],
            "info": {"numerical_ids": ["14812"]},
            "children": [["4.C.3.a", "4.C.3.b"]],
        },
        "4.C.3.a": {
            "title": "Water Depth 50-100cm",
            "alternative_codes": ["14813", "4C3a", "4 C 3 a"],
            "info": {"numerical_ids": ["14813"]},
        },
        "4.C.3.b": {
            "title": "Water Depth > 100cm",
            "alternative_codes": ["14814", "4C3b", "4 C 3 b"],
            "info": {"numerical_ids": ["14814"]},
        },
        "4.D": {
            "title": "Agricultural Soils",
            "alternative_codes": ["14572", "4D", "4 D"],
            "info": {"numerical_ids": ["14572"]},
            "children": [["4.D.1", "4.D.2", "4.D.3"]],
        },
        "4.D.1": {
            "title": "Direct Soil Emissions",
            "alternative_codes": ["14815", "4D1", "4 D 1"],
            "info": {"numerical_ids": ["14815"]},
            "children": [["4.D.1.a", "4.D.1.b", "4.D.1.c", "4.D.1.d", "4.D.1.e"]],
        },
        "4.D.1.a": {
            "title": "Synthetic Fertilizers",
            "alternative_codes": ["14742", "4D1a", "4 D 1 a"],
            "info": {"numerical_ids": ["14742"]},
        },
        "4.D.1.b": {
            "title": "Animal Manure Applied to Soils",
            "alternative_codes": ["14731", "4D1b", "4 D 1 b"],
            "info": {"numerical_ids": ["14731"]},
        },
        "4.D.1.c": {
            "title": "N-fixing Crops",
            "alternative_codes": ["14707", "4D1c", "4 D 1 c"],
            "info": {"numerical_ids": ["14707"]},
        },
        "4.D.1.d": {
            "title": "Crop Residue",
            "alternative_codes": ["14699", "4D1d", "4 D 1 d"],
            "info": {"numerical_ids": ["14699"]},
        },
        "4.D.1.e": {
            "title": "Cultivation of Histosols",
            "alternative_codes": ["14694", "4D1e", "4 D 1 e"],
            "info": {"numerical_ids": ["14694"]},
        },
        "4.D.2": {
            "title": "Pasture, Range and Paddock Manure",
            "alternative_codes": ["14738", "4D2", "4 D 2"],
            "info": {"numerical_ids": ["14738"]},
        },
        "4.D.3": {
            "title": "Indirect  Emissions",
            "alternative_codes": ["14816", "4D3", "4 D 3"],
            "info": {"numerical_ids": ["14816"]},
            "children": [["4.D.3.a", "4.D.3.b"]],
        },
        "4.D.3.a": {
            "title": "Atmospheric Deposition",
            "alternative_codes": ["14684", "4D3a", "4 D 3 a"],
            "info": {"numerical_ids": ["14684"]},
        },
        "4.D.3.b": {
            "title": "Nitrogen Leaching and Run-off",
            "alternative_codes": ["14672", "4D3b", "4 D 3 b"],
            "info": {"numerical_ids": ["14672"]},
        },
        "4.E": {
            "title": "Prescribed Burning of Savannas",
            "alternative_codes": ["14574", "4E", "4 E"],
            "info": {"numerical_ids": ["14574"]},
        },
        "4.F": {
            "title": "Field Burning of Agricultural Residues",
            "alternative_codes": ["14573", "4F", "4 F"],
            "info": {"numerical_ids": ["14573"]},
            "children": [["4.F.1", "4.F.2", "4.F.3", "4.F.4"]],
        },
        "4.F.1": {
            "title": "Cereals",
            "alternative_codes": ["14817", "4F1", "4 F 1"],
            "info": {"numerical_ids": ["14817"]},
            "children": [
                ["4.F.1.a", "4.F.1.b", "4.F.1.c", "4.F.1.d", "4.F.1.e", "4.F.1.f"]
            ],
        },
        "4.F.1.a": {
            "title": "Wheat",
            "alternative_codes": ["14716", "4F1a", "4 F 1 a"],
            "info": {"numerical_ids": ["14716"]},
        },
        "4.F.1.b": {
            "title": "Barley",
            "alternative_codes": ["14667", "4F1b", "4 F 1 b"],
            "info": {"numerical_ids": ["14667"]},
        },
        "4.F.1.c": {
            "title": "Maize",
            "alternative_codes": ["14688", "4F1c", "4 F 1 c"],
            "info": {"numerical_ids": ["14688"]},
        },
        "4.F.1.d": {
            "title": "Oats",
            "alternative_codes": ["14714", "4F1d", "4 F 1 d"],
            "info": {"numerical_ids": ["14714"]},
        },
        "4.F.1.e": {
            "title": "Rye",
            "alternative_codes": ["14682", "4F1e", "4 F 1 e"],
            "info": {"numerical_ids": ["14682"]},
        },
        "4.F.1.f": {
            "title": "Rice",
            "alternative_codes": ["14657", "4F1f", "4 F 1 f"],
            "info": {"numerical_ids": ["14657"]},
        },
        "4.F.2": {
            "title": "Pulses",
            "alternative_codes": ["14818", "4F2", "4 F 2"],
            "info": {"numerical_ids": ["14818"]},
            "children": [["4.F.2.a", "4.F.2.b", "4.F.2.c"]],
        },
        "4.F.2.a": {
            "title": "Dry Bean",
            "alternative_codes": ["14655", "4F2a", "4 F 2 a"],
            "info": {"numerical_ids": ["14655"]},
        },
        "4.F.2.b": {
            "title": "Peas",
            "alternative_codes": ["14708", "4F2b", "4 F 2 b"],
            "info": {"numerical_ids": ["14708"]},
        },
        "4.F.2.c": {
            "title": "Soybeans",
            "alternative_codes": ["14736", "4F2c", "4 F 2 c"],
            "info": {"numerical_ids": ["14736"]},
        },
        "4.F.3": {
            "title": "Tubers and Roots",
            "alternative_codes": ["14819", "4F3", "4 F 3"],
            "info": {"numerical_ids": ["14819"]},
            "children": [["4.F.3.a"]],
        },
        "4.F.3.a": {
            "title": "Potatoes",
            "alternative_codes": ["14737", "4F3a", "4 F 3 a"],
            "info": {"numerical_ids": ["14737"]},
        },
        "4.F.4": {
            "title": "Sugar Cane",
            "alternative_codes": ["14656", "4F4", "4 F 4"],
            "info": {"numerical_ids": ["14656"]},
        },
        "4.G": {
            "title": "Other",
            "alternative_codes": ["14576", "4G", "4 G"],
            "info": {"numerical_ids": ["14576"]},
        },
        "5": {
            "title": "Land-Use Change and Forestry",
            "alternative_codes": ["5.", "25183"],
            "info": {"numerical_ids": ["25183"]},
            "children": [["5.A", "5.B", "5.C", "5.D", "5.E"]],
        },
        "5.A": {
            "title": "Changes in Forest and Other Woody Biomass Stocks",
            "alternative_codes": ["15185", "5A", "5 A"],
            "info": {"numerical_ids": ["15185"]},
            "children": [["5.A.1", "5.A.2", "5.A.3"]],
        },
        "5.A.1": {
            "title": "Tropical Forests",
            "alternative_codes": ["14752", "5A1", "5 A 1"],
            "info": {"numerical_ids": ["14752"]},
            "children": [["5.A.1.a", "5.A.1.b", "5.A.1.c"]],
        },
        "5.A.1.a": {
            "title": "Plantations",
            "alternative_codes": ["14753", "5A1a", "5 A 1 a"],
            "info": {"numerical_ids": ["14753"]},
            "children": [
                [
                    "5.A.1.a.i",
                    "5.A.1.a.ii",
                    "5.A.1.a.iii",
                    "5.A.1.a.iv",
                    "5.A.1.a.v",
                    "5.A.1.a.vi",
                    "5.A.1.a.vii",
                    "5.A.1.a.viii",
                ]
            ],
        },
        "5.A.1.a.i": {
            "title": "Acacia spp.",
            "alternative_codes": ["14663", "5A1ai", "5 A 1 a i"],
            "info": {"numerical_ids": ["14663"]},
        },
        "5.A.1.a.ii": {
            "title": "Eucalyptus spp.",
            "alternative_codes": ["14717", "5A1aii", "5 A 1 a ii"],
            "info": {"numerical_ids": ["14717"]},
        },
        "5.A.1.a.iii": {
            "title": "Tectona grandis",
            "alternative_codes": ["14685", "5A1aiii", "5 A 1 a iii"],
            "info": {"numerical_ids": ["14685"]},
        },
        "5.A.1.a.iv": {
            "title": "Pinus spp",
            "alternative_codes": ["14698", "5A1aiv", "5 A 1 a iv"],
            "info": {"numerical_ids": ["14698"]},
        },
        "5.A.1.a.v": {
            "title": "Pinus caribaea",
            "alternative_codes": ["14679", "5A1av", "5 A 1 a v"],
            "info": {"numerical_ids": ["14679"]},
        },
        "5.A.1.a.vi": {
            "title": "Mixed Hardwoods",
            "alternative_codes": ["14683", "5A1avi", "5 A 1 a vi"],
            "info": {"numerical_ids": ["14683"]},
        },
        "5.A.1.a.vii": {
            "title": "Mixed Fast-Growing Hardwoods",
            "alternative_codes": ["14827", "5A1avii", "5 A 1 a vii"],
            "info": {"numerical_ids": ["14827"]},
        },
        "5.A.1.a.viii": {
            "title": "Mixed Softwoods",
            "alternative_codes": ["14828", "5A1aviii", "5 A 1 a viii"],
            "info": {"numerical_ids": ["14828"]},
        },
        "5.A.1.b": {
            "title": "Other Forests",
            "alternative_codes": ["14754", "5A1b", "5 A 1 b"],
            "info": {"numerical_ids": ["14754"]},
            "children": [["5.A.1.b.i", "5.A.1.b.ii", "5.A.1.b.iii"]],
        },
        "5.A.1.b.i": {
            "title": "Moist",
            "alternative_codes": ["14675", "5A1bi", "5 A 1 b i"],
            "info": {"numerical_ids": ["14675"]},
        },
        "5.A.1.b.ii": {
            "title": "Seasonal",
            "alternative_codes": ["14702", "5A1bii", "5 A 1 b ii"],
            "info": {"numerical_ids": ["14702"]},
        },
        "5.A.1.b.iii": {
            "title": "Dry",
            "alternative_codes": ["14730", "5A1biii", "5 A 1 b iii"],
            "info": {"numerical_ids": ["14730"]},
        },
        "5.A.1.c": {
            "title": "Other (specify)",
            "alternative_codes": ["14831", "5A1c", "5 A 1 c"],
            "info": {"numerical_ids": ["14831"]},
        },
        "5.A.2": {
            "title": "Temperate Forests",
            "alternative_codes": ["14755", "5A2", "5 A 2"],
            "info": {"numerical_ids": ["14755"]},
            "children": [["5.A.2.a", "5.A.2.b", "5.A.2.c"]],
        },
        "5.A.2.a": {
            "title": "Plantations",
            "alternative_codes": ["14722", "5A2a", "5 A 2 a"],
            "info": {"numerical_ids": ["14722"]},
            "children": [["5.A.2.a.i", "5.A.2.a.ii"]],
        },
        "5.A.2.a.i": {
            "title": "Douglas fir",
            "alternative_codes": ["14832", "5A2ai", "5 A 2 a i"],
            "info": {"numerical_ids": ["14832"]},
        },
        "5.A.2.a.ii": {
            "title": "Loblolly pine",
            "alternative_codes": ["14833", "5A2aii", "5 A 2 a ii"],
            "info": {"numerical_ids": ["14833"]},
        },
        "5.A.2.b": {
            "title": "Commercial",
            "alternative_codes": ["14756", "5A2b", "5 A 2 b"],
            "info": {"numerical_ids": ["14756"]},
            "children": [["5.A.2.b.i", "5.A.2.b.ii"]],
        },
        "5.A.2.b.i": {
            "title": "Evergreen",
            "alternative_codes": ["14750", "5A2bi", "5 A 2 b i"],
            "info": {"numerical_ids": ["14750"]},
        },
        "5.A.2.b.ii": {
            "title": "Deciduous",
            "alternative_codes": ["14739", "5A2bii", "5 A 2 b ii"],
            "info": {"numerical_ids": ["14739"]},
        },
        "5.A.2.c": {
            "title": "Other",
            "alternative_codes": ["14686", "5A2c", "5 A 2 c"],
            "info": {"numerical_ids": ["14686"]},
        },
        "5.A.3": {
            "title": "Boreal Forests",
            "alternative_codes": ["14757", "5A3", "5 A 3"],
            "info": {"numerical_ids": ["14757"]},
        },
        "5.B": {
            "title": "Forest and Grassland Conversion",
            "alternative_codes": ["15184", "5B", "5 B"],
            "info": {"numerical_ids": ["15184"]},
            "children": [
                ["5.B.1", "5.B.2", "5.B.3", "5.B.4", "5.B.5", "5.B.6", "5.B.7"]
            ],
        },
        "5.B.1": {
            "title": "Tropical Forests",
            "alternative_codes": ["14758", "5B1", "5 B 1"],
            "info": {"numerical_ids": ["14758"]},
            "children": [
                ["5.B.1.a", "5.B.1.b", "5.B.1.c", "5.B.1.d", "5.B.1.e", "5.B.1.f"]
            ],
        },
        "5.B.1.a": {
            "title": "Wet / Very Moist",
            "alternative_codes": ["14749", "5B1a", "5 B 1 a"],
            "info": {"numerical_ids": ["14749"]},
        },
        "5.B.1.b": {
            "title": "Moist, Short Dry Season",
            "alternative_codes": ["14723", "5B1b", "5 B 1 b"],
            "info": {"numerical_ids": ["14723"]},
        },
        "5.B.1.c": {
            "title": "Moist, Long Dry Season",
            "alternative_codes": ["14664", "5B1c", "5 B 1 c"],
            "info": {"numerical_ids": ["14664"]},
        },
        "5.B.1.d": {
            "title": "Dry",
            "alternative_codes": ["14681", "5B1d", "5 B 1 d"],
            "info": {"numerical_ids": ["14681"]},
        },
        "5.B.1.e": {
            "title": "Montane Moist",
            "alternative_codes": ["14747", "5B1e", "5 B 1 e"],
            "info": {"numerical_ids": ["14747"]},
        },
        "5.B.1.f": {
            "title": "Montane Dry",
            "alternative_codes": ["14680", "5B1f", "5 B 1 f"],
            "info": {"numerical_ids": ["14680"]},
        },
        "5.B.2": {
            "title": "Tropical Savanna / Grasslands",
            "alternative_codes": ["14766", "5B2", "5 B 2"],
            "info": {"numerical_ids": ["14766"]},
        },
        "5.B.3": {
            "title": "Temperate Forests",
            "alternative_codes": ["14759", "5B3", "5 B 3"],
            "info": {"numerical_ids": ["14759"]},
            "children": [["5.B.3.a", "5.B.3.b", "5.B.3.c"]],
        },
        "5.B.3.a": {
            "title": "Coniferous",
            "alternative_codes": ["14660", "5B3a", "5 B 3 a"],
            "info": {"numerical_ids": ["14660"]},
        },
        "5.B.3.b": {
            "title": "Broadleaf",
            "alternative_codes": ["14692", "5B3b", "5 B 3 b"],
            "info": {"numerical_ids": ["14692"]},
        },
        "5.B.3.c": {
            "title": "Mixed Broadleaf / Coniferous",
            "alternative_codes": ["14829", "5B3c", "5 B 3 c"],
            "info": {"numerical_ids": ["14829"]},
        },
        "5.B.4": {
            "title": "Grasslands",
            "alternative_codes": ["14767", "5B4", "5 B 4"],
            "info": {"numerical_ids": ["14767"]},
        },
        "5.B.5": {
            "title": "Boreal Forests",
            "alternative_codes": ["14760", "5B5", "5 B 5"],
            "info": {"numerical_ids": ["14760"]},
            "children": [["5.B.5.a", "5.B.5.b", "5.B.5.c"]],
        },
        "5.B.5.a": {
            "title": "Mixed Broadleaf / Coniferous",
            "alternative_codes": ["14761", "5B5a", "5 B 5 a"],
            "info": {"numerical_ids": ["14761"]},
        },
        "5.B.5.b": {
            "title": "Coniferous",
            "alternative_codes": ["14762", "5B5b", "5 B 5 b"],
            "info": {"numerical_ids": ["14762"]},
        },
        "5.B.5.c": {
            "title": "Forest Tundra",
            "alternative_codes": ["14763", "5B5c", "5 B 5 c"],
            "info": {"numerical_ids": ["14763"]},
        },
        "5.B.6": {
            "title": "Grasslands / Tundra",
            "alternative_codes": ["14764", "5B6", "5 B 6"],
            "info": {"numerical_ids": ["14764"]},
        },
        "5.B.7": {
            "title": "Other",
            "alternative_codes": ["14765", "5B7", "5 B 7"],
            "info": {"numerical_ids": ["14765"]},
        },
        "5.C": {
            "title": "Abandonment of Managed Lands",
            "alternative_codes": ["15188", "5C", "5 C"],
            "info": {"numerical_ids": ["15188"]},
            "children": [
                ["5.C.1", "5.C.2", "5.C.3", "5.C.4", "5.C.5", "5.C.6", "5.C.7"]
            ],
        },
        "5.C.1": {
            "title": "Tropical Forests",
            "alternative_codes": ["14768", "5C1", "5 C 1"],
            "info": {"numerical_ids": ["14768"]},
            "children": [
                ["5.C.1.a", "5.C.1.b", "5.C.1.c", "5.C.1.d", "5.C.1.e", "5.C.1.f"]
            ],
        },
        "5.C.1.a": {
            "title": "Wet / Very Moist",
            "alternative_codes": ["14704", "5C1a", "5 C 1 a"],
            "info": {"numerical_ids": ["14704"]},
        },
        "5.C.1.b": {
            "title": "Moist, Short Dry Season",
            "alternative_codes": ["14703", "5C1b", "5 C 1 b"],
            "info": {"numerical_ids": ["14703"]},
        },
        "5.C.1.c": {
            "title": "Moist, Long Dry Season",
            "alternative_codes": ["14647", "5C1c", "5 C 1 c"],
            "info": {"numerical_ids": ["14647"]},
        },
        "5.C.1.d": {
            "title": "Dry",
            "alternative_codes": ["14769", "5C1d", "5 C 1 d"],
            "info": {"numerical_ids": ["14769"]},
        },
        "5.C.1.e": {
            "title": "Montane Moist",
            "alternative_codes": ["14649", "5C1e", "5 C 1 e"],
            "info": {"numerical_ids": ["14649"]},
        },
        "5.C.1.f": {
            "title": "Montane Dry",
            "alternative_codes": ["14741", "5C1f", "5 C 1 f"],
            "info": {"numerical_ids": ["14741"]},
        },
        "5.C.2": {
            "title": "Tropical Savanna / Grasslands",
            "alternative_codes": ["14779", "5C2", "5 C 2"],
            "info": {"numerical_ids": ["14779"]},
        },
        "5.C.3": {
            "title": "Temperate Forests",
            "alternative_codes": ["14770", "5C3", "5 C 3"],
            "info": {"numerical_ids": ["14770"]},
            "children": [["5.C.3.a", "5.C.3.b", "5.C.3.c"]],
        },
        "5.C.3.a": {
            "title": "Mixed Broadleaf / Coniferous",
            "alternative_codes": ["14830", "5C3a", "5 C 3 a"],
            "info": {"numerical_ids": ["14830"]},
        },
        "5.C.3.b": {
            "title": "Coniferous",
            "alternative_codes": ["14771", "5C3b", "5 C 3 b"],
            "info": {"numerical_ids": ["14771"]},
        },
        "5.C.3.c": {
            "title": "Broadleaf",
            "alternative_codes": ["14772", "5C3c", "5 C 3 c"],
            "info": {"numerical_ids": ["14772"]},
        },
        "5.C.4": {
            "title": "Grasslands",
            "alternative_codes": ["14780", "5C4", "5 C 4"],
            "info": {"numerical_ids": ["14780"]},
        },
        "5.C.5": {
            "title": "Boreal Forests",
            "alternative_codes": ["14773", "5C5", "5 C 5"],
            "info": {"numerical_ids": ["14773"]},
            "children": [["5.C.5.a", "5.C.5.b", "5.C.5.c"]],
        },
        "5.C.5.a": {
            "title": "Mixed Broadleaf / Coniferous",
            "alternative_codes": ["14774", "5C5a", "5 C 5 a"],
            "info": {"numerical_ids": ["14774"]},
        },
        "5.C.5.b": {
            "title": "Coniferous",
            "alternative_codes": ["14775", "5C5b", "5 C 5 b"],
            "info": {"numerical_ids": ["14775"]},
        },
        "5.C.5.c": {
            "title": "Forest Tundra",
            "alternative_codes": ["14776", "5C5c", "5 C 5 c"],
            "info": {"numerical_ids": ["14776"]},
        },
        "5.C.6": {
            "title": "Grasslands / Tundra",
            "alternative_codes": ["14777", "5C6", "5 C 6"],
            "info": {"numerical_ids": ["14777"]},
        },
        "5.C.7": {
            "title": "Other",
            "alternative_codes": ["14778", "5C7", "5 C 7"],
            "info": {"numerical_ids": ["14778"]},
        },
        "5.D": {
            "title": "CO₂ Emissions and Removals from Soil",
            "alternative_codes": ["15187", "5D", "5 D"],
            "info": {"numerical_ids": ["15187"]},
            "children": [["5.D.1", "5.D.2", "5.D.3"]],
        },
        "5.D.1": {
            "title": "Cultivation of Mineral Soils",
            "alternative_codes": ["14665", "5D1", "5 D 1"],
            "info": {"numerical_ids": ["14665"]},
            "children": [["5.D.1.a", "5.D.1.b", "5.D.1.c", "5.D.1.d", "5.D.1.e"]],
        },
        "5.D.1.a": {
            "title": "High Activity Soils",
            "alternative_codes": ["14734", "5D1a", "5 D 1 a"],
            "info": {"numerical_ids": ["14734"]},
        },
        "5.D.1.b": {
            "title": "Low Activity Soils",
            "alternative_codes": ["14732", "5D1b", "5 D 1 b"],
            "info": {"numerical_ids": ["14732"]},
        },
        "5.D.1.c": {
            "title": "Sandy",
            "alternative_codes": ["14671", "5D1c", "5 D 1 c"],
            "info": {"numerical_ids": ["14671"]},
        },
        "5.D.1.d": {
            "title": "Volcanic",
            "alternative_codes": ["14781", "5D1d", "5 D 1 d"],
            "info": {"numerical_ids": ["14781"]},
        },
        "5.D.1.e": {
            "title": "Wetland (Aquic)",
            "alternative_codes": ["14782", "5D1e", "5 D 1 e"],
            "info": {"numerical_ids": ["14782"]},
        },
        "5.D.2": {
            "title": "Cultivation of Organic Soils",
            "alternative_codes": ["14709", "5D2", "5 D 2"],
            "info": {"numerical_ids": ["14709"]},
            "children": [["5.D.2.a", "5.D.2.b", "5.D.2.c"]],
        },
        "5.D.2.a": {
            "title": "Cool Temperate",
            "alternative_codes": ["14783", "5D2a", "5 D 2 a"],
            "info": {"numerical_ids": ["14783"]},
            "children": [["5.D.2.a.i", "5.D.2.a.ii"]],
        },
        "5.D.2.a.i": {
            "title": "Upland Crops",
            "alternative_codes": ["14784", "5D2ai", "5 D 2 a i"],
            "info": {"numerical_ids": ["14784"]},
        },
        "5.D.2.a.ii": {
            "title": "Pasture / Forest",
            "alternative_codes": ["14718", "5D2aii", "5 D 2 a ii"],
            "info": {"numerical_ids": ["14718"]},
        },
        "5.D.2.b": {
            "title": "Warm Temperate",
            "alternative_codes": ["14785", "5D2b", "5 D 2 b"],
            "info": {"numerical_ids": ["14785"]},
            "children": [["5.D.2.b.i", "5.D.2.b.ii"]],
        },
        "5.D.2.b.i": {
            "title": "Upland Crops",
            "alternative_codes": ["14700", "5D2bi", "5 D 2 b i"],
            "info": {"numerical_ids": ["14700"]},
        },
        "5.D.2.b.ii": {
            "title": "Pasture / Forest",
            "alternative_codes": ["14786", "5D2bii", "5 D 2 b ii"],
            "info": {"numerical_ids": ["14786"]},
        },
        "5.D.2.c": {
            "title": "Tropical",
            "alternative_codes": ["14787", "5D2c", "5 D 2 c"],
            "info": {"numerical_ids": ["14787"]},
            "children": [["5.D.2.c.i", "5.D.2.c.ii"]],
        },
        "5.D.2.c.i": {
            "title": "Upland Crops",
            "alternative_codes": ["14715", "5D2ci", "5 D 2 c i"],
            "info": {"numerical_ids": ["14715"]},
        },
        "5.D.2.c.ii": {
            "title": "Pasture / Forest",
            "alternative_codes": ["14695", "5D2cii", "5 D 2 c ii"],
            "info": {"numerical_ids": ["14695"]},
        },
        "5.D.3": {
            "title": "Liming of Agricultural Soils",
            "alternative_codes": ["14788", "5D3", "5 D 3"],
            "info": {"numerical_ids": ["14788"]},
            "children": [["5.D.3.a", "5.D.3.b"]],
        },
        "5.D.3.a": {
            "title": "Limestone Ca(CO3)",
            "alternative_codes": ["14733", "5D3a", "5 D 3 a"],
            "info": {"numerical_ids": ["14733"]},
        },
        "5.D.3.b": {
            "title": "Dolomite CaMg(CO3)",
            "alternative_codes": ["14789", "5D3b", "5 D 3 b"],
            "info": {"numerical_ids": ["14789"]},
        },
        "5.E": {
            "title": "Other",
            "alternative_codes": ["15186", "5E", "5 E"],
            "info": {"numerical_ids": ["15186"]},
        },
        "6": {
            "title": "Waste",
            "alternative_codes": ["6.", "14546", "24546"],
            "info": {"numerical_ids": ["14546", "24546"]},
            "children": [["6.A", "6.B", "6.C", "6.D"]],
        },
        "6.A": {
            "title": "Solid Waste Disposal on Land",
            "alternative_codes": ["14578", "6A", "6 A"],
            "info": {"numerical_ids": ["14578"]},
            "children": [["6.A.1", "6.A.2"]],
        },
        "6.A.1": {
            "title": "Managed Waste Disposal on Land",
            "alternative_codes": ["14710", "6A1", "6 A 1"],
            "info": {"numerical_ids": ["14710"]},
        },
        "6.A.2": {
            "title": "Unmanaged Waste Disposal Sites",
            "alternative_codes": ["14728", "6A2", "6 A 2"],
            "info": {"numerical_ids": ["14728"]},
            "children": [["6.A.2.a", "6.A.2.b"]],
        },
        "6.A.2.a": {
            "title": "Deep (>5 m)",
            "alternative_codes": ["14706", "6A2a", "6 A 2 a"],
            "info": {"numerical_ids": ["14706"]},
        },
        "6.A.2.b": {
            "title": "Shallow (<5 m)",
            "alternative_codes": ["14650", "6A2b", "6 A 2 b"],
            "info": {"numerical_ids": ["14650"]},
        },
        "6.B": {
            "title": "Wastewater Handling",
            "alternative_codes": ["14579", "6B", "6 B"],
            "info": {"numerical_ids": ["14579"]},
            "children": [["6.B.1", "6.B.2"]],
        },
        "6.B.1": {
            "title": "Industrial Wastewater",
            "alternative_codes": ["14724", "6B1", "6 B 1"],
            "info": {"numerical_ids": ["14724"]},
            "children": [["6.B.1.a", "6.B.1.b"]],
        },
        "6.B.1.a": {
            "title": "Wastewater",
            "alternative_codes": ["14820", "6B1a", "6 B 1 a"],
            "info": {"numerical_ids": ["14820"]},
        },
        "6.B.1.b": {
            "title": "Sludge",
            "alternative_codes": ["14821", "6B1b", "6 B 1 b"],
            "info": {"numerical_ids": ["14821"]},
        },
        "6.B.2": {
            "title": "Domestic and Commercial Wastewater",
            "alternative_codes": ["14735", "6B2", "6 B 2"],
            "info": {"numerical_ids": ["14735"]},
            "children": [["6.B.2.a", "6.B.2.b", "6.B.2.c"]],
        },
        "6.B.2.a": {
            "title": "Wastewater",
            "alternative_codes": ["14822", "6B2a", "6 B 2 a"],
            "info": {"numerical_ids": ["14822"]},
        },
        "6.B.2.b": {
            "title": "Sludge",
            "alternative_codes": ["14823", "6B2b", "6 B 2 b"],
            "info": {"numerical_ids": ["14823"]},
        },
        "6.B.2.c": {
            "title": "Human sewage",
            "alternative_codes": ["14690", "6B2c", "6 B 2 c"],
            "info": {"numerical_ids": ["14690"]},
        },
        "6.C": {
            "title": "Waste Incineration",
            "alternative_codes": ["14580", "6C", "6 C"],
            "info": {"numerical_ids": ["14580"]},
            "children": [["6.C.1", "6.C.2"]],
        },
        "6.C.1": {
            "title": "Biogenic",
            "alternative_codes": ["14824", "6C1", "6 C 1"],
            "info": {"numerical_ids": ["14824"]},
        },
        "6.C.2": {
            "title": "Other (non-biogenic)",
            "alternative_codes": ["14825", "6C2", "6 C 2"],
            "info": {"numerical_ids": ["14825"]},
        },
        "6.D": {
            "title": "Other",
            "alternative_codes": ["14581", "6D", "6 D"],
            "info": {"numerical_ids": ["14581"]},
        },
        "7": {
            "title": "Other",
            "alternative_codes": ["7.", "14547", "24547"],
            "info": {"numerical_ids": ["14547", "24547"]},
        },
    },
}
