# Do not edit this file. It was auto-generated from the
# corresponding YAML file.
spec = {
    "name": "ISO3",
    "title": "ISO 3166-1 countries with climate-relevant groupings",
    "comment": "Countries, regions, and other areas. Also includes information on groups like being included in Annex I of the UN Framework Convention on Climate Change.",
    "references": "ISO 3166, https://www.iso.org/iso-3166-country-codes.html;\niso-codes package, https://salsa.debian.org/iso-codes-team/iso-codes;\nUNFCCC Parties & Observers, https://unfccc.int/parties-observers;\nEU members,\nhttps://ec.europa.eu/eurostat/statistics-explained/index.php?title=Glossary:EU_enlargements;\n G7 and G20, https://www.bmuv.de/themen/europa-internationales/internationales/g7-und-g20;\n OECD members, https://www.oecd.org/about/document/ratification-oecd-convention.htm;\n AOSIS members, https://www.aosis.org/about/member-states/",
    "institution": "UN",
    "hierarchical": True,
    "last_update": "2023-06-22",
    "version": "2023-06-22",
    "total_sum": False,
    "canonical_top_level_category": "World",
    "categories": {
        "ABW": {"title": "Aruba", "alternative_codes": ["AW", "533"]},
        "AFG": {
            "title": "Afghanistan",
            "alternative_codes": ["AF", "004"],
            "info": {"official_name": "Islamic Republic of Afghanistan"},
        },
        "AGO": {
            "title": "Angola",
            "alternative_codes": ["AO", "024"],
            "info": {"official_name": "Republic of Angola"},
        },
        "AIA": {"title": "Anguilla", "alternative_codes": ["AI", "660"]},
        "ALA": {"title": "Åland Islands", "alternative_codes": ["AX", "248"]},
        "ALB": {
            "title": "Albania",
            "alternative_codes": ["AL", "008"],
            "info": {"official_name": "Republic of Albania"},
        },
        "AND": {
            "title": "Andorra",
            "alternative_codes": ["AD", "020"],
            "info": {"official_name": "Principality of Andorra"},
        },
        "ARE": {"title": "United Arab Emirates", "alternative_codes": ["AE", "784"]},
        "ARG": {
            "title": "Argentina",
            "alternative_codes": ["AR", "032"],
            "info": {"official_name": "Argentine Republic"},
        },
        "ARM": {
            "title": "Armenia",
            "alternative_codes": ["AM", "051"],
            "info": {"official_name": "Republic of Armenia"},
        },
        "ASM": {"title": "American Samoa", "alternative_codes": ["AS", "016"]},
        "ATA": {"title": "Antarctica", "alternative_codes": ["AQ", "010"]},
        "ATF": {
            "title": "French Southern Territories",
            "alternative_codes": ["TF", "260"],
        },
        "ATG": {"title": "Antigua and Barbuda", "alternative_codes": ["AG", "028"]},
        "AUS": {"title": "Australia", "alternative_codes": ["AU", "036"]},
        "AUT": {
            "title": "Austria",
            "alternative_codes": ["AT", "040"],
            "info": {"official_name": "Republic of Austria"},
        },
        "AZE": {
            "title": "Azerbaijan",
            "alternative_codes": ["AZ", "031"],
            "info": {"official_name": "Republic of Azerbaijan"},
        },
        "BDI": {
            "title": "Burundi",
            "alternative_codes": ["BI", "108"],
            "info": {"official_name": "Republic of Burundi"},
        },
        "BEL": {
            "title": "Belgium",
            "alternative_codes": ["BE", "056"],
            "info": {"official_name": "Kingdom of Belgium"},
        },
        "BEN": {
            "title": "Benin",
            "alternative_codes": ["BJ", "204"],
            "info": {"official_name": "Republic of Benin"},
        },
        "BES": {
            "title": "Bonaire, Sint Eustatius and Saba",
            "alternative_codes": ["BQ", "535"],
            "info": {"official_name": "Bonaire, Sint Eustatius and Saba"},
        },
        "BFA": {"title": "Burkina Faso", "alternative_codes": ["BF", "854"]},
        "BGD": {
            "title": "Bangladesh",
            "alternative_codes": ["BD", "050"],
            "info": {"official_name": "People's Republic of Bangladesh"},
        },
        "BGR": {
            "title": "Bulgaria",
            "alternative_codes": ["BG", "100"],
            "info": {"official_name": "Republic of Bulgaria"},
        },
        "BHR": {
            "title": "Bahrain",
            "alternative_codes": ["BH", "048"],
            "info": {"official_name": "Kingdom of Bahrain"},
        },
        "BHS": {
            "title": "Bahamas",
            "alternative_codes": ["BS", "044"],
            "info": {"official_name": "Commonwealth of the Bahamas"},
        },
        "BIH": {
            "title": "Bosnia and Herzegovina",
            "alternative_codes": ["BA", "070"],
            "info": {"official_name": "Republic of Bosnia and Herzegovina"},
        },
        "BLM": {"title": "Saint Barthélemy", "alternative_codes": ["BL", "652"]},
        "BLR": {
            "title": "Belarus",
            "alternative_codes": ["BY", "112"],
            "info": {"official_name": "Republic of Belarus"},
        },
        "BLZ": {"title": "Belize", "alternative_codes": ["BZ", "084"]},
        "BMU": {"title": "Bermuda", "alternative_codes": ["BM", "060"]},
        "BOL": {
            "title": "Bolivia, Plurinational State of",
            "alternative_codes": ["BO", "068"],
            "info": {
                "official_name": "Plurinational State of Bolivia",
                "common_name": "Bolivia",
                "unfccc_name": "Bolivia (Plurinational State of)",
            },
        },
        "BRA": {
            "title": "Brazil",
            "alternative_codes": ["BR", "076"],
            "info": {"official_name": "Federative Republic of Brazil"},
        },
        "BRB": {"title": "Barbados", "alternative_codes": ["BB", "052"]},
        "BRN": {"title": "Brunei Darussalam", "alternative_codes": ["BN", "096"]},
        "BTN": {
            "title": "Bhutan",
            "alternative_codes": ["BT", "064"],
            "info": {"official_name": "Kingdom of Bhutan"},
        },
        "BVT": {"title": "Bouvet Island", "alternative_codes": ["BV", "074"]},
        "BWA": {
            "title": "Botswana",
            "alternative_codes": ["BW", "072"],
            "info": {"official_name": "Republic of Botswana"},
        },
        "CAF": {
            "title": "Central African Republic",
            "alternative_codes": ["CF", "140"],
        },
        "CAN": {"title": "Canada", "alternative_codes": ["CA", "124"]},
        "CCK": {"title": "Cocos (Keeling) Islands", "alternative_codes": ["CC", "166"]},
        "CHE": {
            "title": "Switzerland",
            "alternative_codes": ["CH", "756"],
            "info": {"official_name": "Swiss Confederation"},
        },
        "CHL": {
            "title": "Chile",
            "alternative_codes": ["CL", "152"],
            "info": {"official_name": "Republic of Chile"},
        },
        "CHN": {
            "title": "China",
            "alternative_codes": ["CN", "156"],
            "info": {"official_name": "People's Republic of China"},
        },
        "CIV": {
            "title": "Côte d'Ivoire",
            "alternative_codes": ["CI", "384"],
            "info": {"official_name": "Republic of Côte d'Ivoire"},
        },
        "CMR": {
            "title": "Cameroon",
            "alternative_codes": ["CM", "120"],
            "info": {"official_name": "Republic of Cameroon"},
        },
        "COD": {
            "title": "Congo, The Democratic Republic of the",
            "alternative_codes": ["CD", "180"],
            "info": {"unfccc_name": "Democratic Republic of the Congo"},
        },
        "COG": {
            "title": "Congo",
            "alternative_codes": ["CG", "178"],
            "info": {"official_name": "Republic of the Congo"},
        },
        "COK": {"title": "Cook Islands", "alternative_codes": ["CK", "184"]},
        "COL": {
            "title": "Colombia",
            "alternative_codes": ["CO", "170"],
            "info": {"official_name": "Republic of Colombia"},
        },
        "COM": {
            "title": "Comoros",
            "alternative_codes": ["KM", "174"],
            "info": {"official_name": "Union of the Comoros"},
        },
        "CPV": {
            "title": "Cabo Verde",
            "alternative_codes": ["CV", "132"],
            "info": {"official_name": "Republic of Cabo Verde"},
        },
        "CRI": {
            "title": "Costa Rica",
            "alternative_codes": ["CR", "188"],
            "info": {"official_name": "Republic of Costa Rica"},
        },
        "CUB": {
            "title": "Cuba",
            "alternative_codes": ["CU", "192"],
            "info": {"official_name": "Republic of Cuba"},
        },
        "CUW": {
            "title": "Curaçao",
            "alternative_codes": ["CW", "531"],
            "info": {"official_name": "Curaçao"},
        },
        "CXR": {"title": "Christmas Island", "alternative_codes": ["CX", "162"]},
        "CYM": {"title": "Cayman Islands", "alternative_codes": ["KY", "136"]},
        "CYP": {
            "title": "Cyprus",
            "alternative_codes": ["CY", "196"],
            "info": {"official_name": "Republic of Cyprus"},
        },
        "CZE": {
            "title": "Czechia",
            "alternative_codes": ["CZ", "203"],
            "info": {"official_name": "Czech Republic"},
        },
        "DEU": {
            "title": "Germany",
            "alternative_codes": ["DE", "276"],
            "info": {"official_name": "Federal Republic of Germany"},
        },
        "DJI": {
            "title": "Djibouti",
            "alternative_codes": ["DJ", "262"],
            "info": {"official_name": "Republic of Djibouti"},
        },
        "DMA": {
            "title": "Dominica",
            "alternative_codes": ["DM", "212"],
            "info": {"official_name": "Commonwealth of Dominica"},
        },
        "DNK": {
            "title": "Denmark",
            "alternative_codes": ["DK", "208"],
            "info": {"official_name": "Kingdom of Denmark"},
        },
        "DOM": {"title": "Dominican Republic", "alternative_codes": ["DO", "214"]},
        "DZA": {
            "title": "Algeria",
            "alternative_codes": ["DZ", "012"],
            "info": {"official_name": "People's Democratic Republic of Algeria"},
        },
        "ECU": {
            "title": "Ecuador",
            "alternative_codes": ["EC", "218"],
            "info": {"official_name": "Republic of Ecuador"},
        },
        "EGY": {
            "title": "Egypt",
            "alternative_codes": ["EG", "818"],
            "info": {"official_name": "Arab Republic of Egypt"},
        },
        "ERI": {
            "title": "Eritrea",
            "alternative_codes": ["ER", "232"],
            "info": {"official_name": "the State of Eritrea"},
        },
        "ESH": {"title": "Western Sahara", "alternative_codes": ["EH", "732"]},
        "ESP": {
            "title": "Spain",
            "alternative_codes": ["ES", "724"],
            "info": {"official_name": "Kingdom of Spain"},
        },
        "EST": {
            "title": "Estonia",
            "alternative_codes": ["EE", "233"],
            "info": {"official_name": "Republic of Estonia"},
        },
        "ETH": {
            "title": "Ethiopia",
            "alternative_codes": ["ET", "231"],
            "info": {"official_name": "Federal Democratic Republic of Ethiopia"},
        },
        "FIN": {
            "title": "Finland",
            "alternative_codes": ["FI", "246"],
            "info": {"official_name": "Republic of Finland"},
        },
        "FJI": {
            "title": "Fiji",
            "alternative_codes": ["FJ", "242"],
            "info": {"official_name": "Republic of Fiji"},
        },
        "FLK": {
            "title": "Falkland Islands (Malvinas)",
            "alternative_codes": ["FK", "238"],
        },
        "FRA": {
            "title": "France",
            "alternative_codes": ["FR", "250"],
            "info": {"official_name": "French Republic"},
        },
        "FRO": {"title": "Faroe Islands", "alternative_codes": ["FO", "234"]},
        "FSM": {
            "title": "Micronesia, Federated States of",
            "alternative_codes": ["FM", "583"],
            "info": {
                "official_name": "Federated States of Micronesia",
                "unfccc_name": "Micronesia (Federated States of)",
            },
        },
        "GAB": {
            "title": "Gabon",
            "alternative_codes": ["GA", "266"],
            "info": {"official_name": "Gabonese Republic"},
        },
        "GBR": {
            "title": "United Kingdom",
            "alternative_codes": ["GB", "826"],
            "info": {
                "official_name": "United Kingdom of Great Britain and Northern Ireland"
            },
        },
        "GEO": {"title": "Georgia", "alternative_codes": ["GE", "268"]},
        "GGY": {"title": "Guernsey", "alternative_codes": ["GG", "831"]},
        "GHA": {
            "title": "Ghana",
            "alternative_codes": ["GH", "288"],
            "info": {"official_name": "Republic of Ghana"},
        },
        "GIB": {"title": "Gibraltar", "alternative_codes": ["GI", "292"]},
        "GIN": {
            "title": "Guinea",
            "alternative_codes": ["GN", "324"],
            "info": {"official_name": "Republic of Guinea"},
        },
        "GLP": {"title": "Guadeloupe", "alternative_codes": ["GP", "312"]},
        "GMB": {
            "title": "Gambia",
            "alternative_codes": ["GM", "270"],
            "info": {"official_name": "Republic of the Gambia"},
        },
        "GNB": {
            "title": "Guinea-Bissau",
            "alternative_codes": ["GW", "624"],
            "info": {"official_name": "Republic of Guinea-Bissau"},
        },
        "GNQ": {
            "title": "Equatorial Guinea",
            "alternative_codes": ["GQ", "226"],
            "info": {"official_name": "Republic of Equatorial Guinea"},
        },
        "GRC": {
            "title": "Greece",
            "alternative_codes": ["GR", "300"],
            "info": {"official_name": "Hellenic Republic"},
        },
        "GRD": {"title": "Grenada", "alternative_codes": ["GD", "308"]},
        "GRL": {"title": "Greenland", "alternative_codes": ["GL", "304"]},
        "GTM": {
            "title": "Guatemala",
            "alternative_codes": ["GT", "320"],
            "info": {"official_name": "Republic of Guatemala"},
        },
        "GUF": {"title": "French Guiana", "alternative_codes": ["GF", "254"]},
        "GUM": {"title": "Guam", "alternative_codes": ["GU", "316"]},
        "GUY": {
            "title": "Guyana",
            "alternative_codes": ["GY", "328"],
            "info": {"official_name": "Republic of Guyana"},
        },
        "HKG": {
            "title": "Hong Kong",
            "alternative_codes": ["HK", "344"],
            "info": {
                "official_name": "Hong Kong Special Administrative Region of China"
            },
        },
        "HMD": {
            "title": "Heard Island and McDonald Islands",
            "alternative_codes": ["HM", "334"],
        },
        "HND": {
            "title": "Honduras",
            "alternative_codes": ["HN", "340"],
            "info": {"official_name": "Republic of Honduras"},
        },
        "HRV": {
            "title": "Croatia",
            "alternative_codes": ["HR", "191"],
            "info": {"official_name": "Republic of Croatia"},
        },
        "HTI": {
            "title": "Haiti",
            "alternative_codes": ["HT", "332"],
            "info": {"official_name": "Republic of Haiti"},
        },
        "HUN": {
            "title": "Hungary",
            "alternative_codes": ["HU", "348"],
            "info": {"official_name": "Hungary"},
        },
        "IDN": {
            "title": "Indonesia",
            "alternative_codes": ["ID", "360"],
            "info": {"official_name": "Republic of Indonesia"},
        },
        "IMN": {"title": "Isle of Man", "alternative_codes": ["IM", "833"]},
        "IND": {
            "title": "India",
            "alternative_codes": ["IN", "356"],
            "info": {"official_name": "Republic of India"},
        },
        "IOT": {
            "title": "British Indian Ocean Territory",
            "alternative_codes": ["IO", "086"],
        },
        "IRL": {"title": "Ireland", "alternative_codes": ["IE", "372"]},
        "IRN": {
            "title": "Iran, Islamic Republic of",
            "alternative_codes": ["IR", "364"],
            "info": {
                "official_name": "Islamic Republic of Iran",
                "common_name": "Iran",
                "unfccc_name": "Iran (Islamic Republic of)",
            },
        },
        "IRQ": {
            "title": "Iraq",
            "alternative_codes": ["IQ", "368"],
            "info": {"official_name": "Republic of Iraq"},
        },
        "ISL": {
            "title": "Iceland",
            "alternative_codes": ["IS", "352"],
            "info": {"official_name": "Republic of Iceland"},
        },
        "ISR": {
            "title": "Israel",
            "alternative_codes": ["IL", "376"],
            "info": {"official_name": "State of Israel"},
        },
        "ITA": {
            "title": "Italy",
            "alternative_codes": ["IT", "380"],
            "info": {"official_name": "Italian Republic"},
        },
        "JAM": {"title": "Jamaica", "alternative_codes": ["JM", "388"]},
        "JEY": {"title": "Jersey", "alternative_codes": ["JE", "832"]},
        "JOR": {
            "title": "Jordan",
            "alternative_codes": ["JO", "400"],
            "info": {"official_name": "Hashemite Kingdom of Jordan"},
        },
        "JPN": {"title": "Japan", "alternative_codes": ["JP", "392"]},
        "KAZ": {
            "title": "Kazakhstan",
            "alternative_codes": ["KZ", "398"],
            "info": {"official_name": "Republic of Kazakhstan"},
        },
        "KEN": {
            "title": "Kenya",
            "alternative_codes": ["KE", "404"],
            "info": {"official_name": "Republic of Kenya"},
        },
        "KGZ": {
            "title": "Kyrgyzstan",
            "alternative_codes": ["KG", "417"],
            "info": {"official_name": "Kyrgyz Republic"},
        },
        "KHM": {
            "title": "Cambodia",
            "alternative_codes": ["KH", "116"],
            "info": {"official_name": "Kingdom of Cambodia"},
        },
        "KIR": {
            "title": "Kiribati",
            "alternative_codes": ["KI", "296"],
            "info": {"official_name": "Republic of Kiribati"},
        },
        "KNA": {"title": "Saint Kitts and Nevis", "alternative_codes": ["KN", "659"]},
        "KOR": {
            "title": "Korea, Republic of",
            "alternative_codes": ["KR", "410"],
            "info": {"common_name": "South Korea", "unfccc_name": "Republic of Korea"},
        },
        "KWT": {
            "title": "Kuwait",
            "alternative_codes": ["KW", "414"],
            "info": {"official_name": "State of Kuwait"},
        },
        "LAO": {
            "title": "Lao People's Democratic Republic",
            "alternative_codes": ["LA", "418"],
            "info": {"common_name": "Laos"},
        },
        "LBN": {
            "title": "Lebanon",
            "alternative_codes": ["LB", "422"],
            "info": {"official_name": "Lebanese Republic"},
        },
        "LBR": {
            "title": "Liberia",
            "alternative_codes": ["LR", "430"],
            "info": {"official_name": "Republic of Liberia"},
        },
        "LBY": {
            "title": "Libya",
            "alternative_codes": ["LY", "434"],
            "info": {"official_name": "Libya"},
        },
        "LCA": {"title": "Saint Lucia", "alternative_codes": ["LC", "662"]},
        "LIE": {
            "title": "Liechtenstein",
            "alternative_codes": ["LI", "438"],
            "info": {"official_name": "Principality of Liechtenstein"},
        },
        "LKA": {
            "title": "Sri Lanka",
            "alternative_codes": ["LK", "144"],
            "info": {"official_name": "Democratic Socialist Republic of Sri Lanka"},
        },
        "LSO": {
            "title": "Lesotho",
            "alternative_codes": ["LS", "426"],
            "info": {"official_name": "Kingdom of Lesotho"},
        },
        "LTU": {
            "title": "Lithuania",
            "alternative_codes": ["LT", "440"],
            "info": {"official_name": "Republic of Lithuania"},
        },
        "LUX": {
            "title": "Luxembourg",
            "alternative_codes": ["LU", "442"],
            "info": {"official_name": "Grand Duchy of Luxembourg"},
        },
        "LVA": {
            "title": "Latvia",
            "alternative_codes": ["LV", "428"],
            "info": {"official_name": "Republic of Latvia"},
        },
        "MAC": {
            "title": "Macao",
            "alternative_codes": ["MO", "446"],
            "info": {"official_name": "Macao Special Administrative Region of China"},
        },
        "MAF": {
            "title": "Saint Martin (French part)",
            "alternative_codes": ["MF", "663"],
        },
        "MAR": {
            "title": "Morocco",
            "alternative_codes": ["MA", "504"],
            "info": {"official_name": "Kingdom of Morocco"},
        },
        "MCO": {
            "title": "Monaco",
            "alternative_codes": ["MC", "492"],
            "info": {"official_name": "Principality of Monaco"},
        },
        "MDA": {
            "title": "Moldova, Republic of",
            "alternative_codes": ["MD", "498"],
            "info": {"official_name": "Republic of Moldova", "common_name": "Moldova"},
        },
        "MDG": {
            "title": "Madagascar",
            "alternative_codes": ["MG", "450"],
            "info": {"official_name": "Republic of Madagascar"},
        },
        "MDV": {
            "title": "Maldives",
            "alternative_codes": ["MV", "462"],
            "info": {"official_name": "Republic of Maldives"},
        },
        "MEX": {
            "title": "Mexico",
            "alternative_codes": ["MX", "484"],
            "info": {"official_name": "United Mexican States"},
        },
        "MHL": {
            "title": "Marshall Islands",
            "alternative_codes": ["MH", "584"],
            "info": {"official_name": "Republic of the Marshall Islands"},
        },
        "MKD": {
            "title": "North Macedonia",
            "alternative_codes": ["MK", "807"],
            "info": {"official_name": "Republic of North Macedonia"},
        },
        "MLI": {
            "title": "Mali",
            "alternative_codes": ["ML", "466"],
            "info": {"official_name": "Republic of Mali"},
        },
        "MLT": {
            "title": "Malta",
            "alternative_codes": ["MT", "470"],
            "info": {"official_name": "Republic of Malta"},
        },
        "MMR": {
            "title": "Myanmar",
            "alternative_codes": ["MM", "104"],
            "info": {"official_name": "Republic of Myanmar"},
        },
        "MNE": {
            "title": "Montenegro",
            "alternative_codes": ["ME", "499"],
            "info": {"official_name": "Montenegro"},
        },
        "MNG": {"title": "Mongolia", "alternative_codes": ["MN", "496"]},
        "MNP": {
            "title": "Northern Mariana Islands",
            "alternative_codes": ["MP", "580"],
            "info": {"official_name": "Commonwealth of the Northern Mariana Islands"},
        },
        "MOZ": {
            "title": "Mozambique",
            "alternative_codes": ["MZ", "508"],
            "info": {"official_name": "Republic of Mozambique"},
        },
        "MRT": {
            "title": "Mauritania",
            "alternative_codes": ["MR", "478"],
            "info": {"official_name": "Islamic Republic of Mauritania"},
        },
        "MSR": {"title": "Montserrat", "alternative_codes": ["MS", "500"]},
        "MTQ": {"title": "Martinique", "alternative_codes": ["MQ", "474"]},
        "MUS": {
            "title": "Mauritius",
            "alternative_codes": ["MU", "480"],
            "info": {"official_name": "Republic of Mauritius"},
        },
        "MWI": {
            "title": "Malawi",
            "alternative_codes": ["MW", "454"],
            "info": {"official_name": "Republic of Malawi"},
        },
        "MYS": {"title": "Malaysia", "alternative_codes": ["MY", "458"]},
        "MYT": {"title": "Mayotte", "alternative_codes": ["YT", "175"]},
        "NAM": {
            "title": "Namibia",
            "alternative_codes": ["NA", "516"],
            "info": {"official_name": "Republic of Namibia"},
        },
        "NCL": {"title": "New Caledonia", "alternative_codes": ["NC", "540"]},
        "NER": {
            "title": "Niger",
            "alternative_codes": ["NE", "562"],
            "info": {"official_name": "Republic of the Niger"},
        },
        "NFK": {"title": "Norfolk Island", "alternative_codes": ["NF", "574"]},
        "NGA": {
            "title": "Nigeria",
            "alternative_codes": ["NG", "566"],
            "info": {"official_name": "Federal Republic of Nigeria"},
        },
        "NIC": {
            "title": "Nicaragua",
            "alternative_codes": ["NI", "558"],
            "info": {"official_name": "Republic of Nicaragua"},
        },
        "NIU": {
            "title": "Niue",
            "alternative_codes": ["NU", "570"],
            "info": {"official_name": "Niue"},
        },
        "NLD": {
            "title": "Netherlands",
            "alternative_codes": ["NL", "528"],
            "info": {"official_name": "Kingdom of the Netherlands"},
        },
        "NOR": {
            "title": "Norway",
            "alternative_codes": ["NO", "578"],
            "info": {"official_name": "Kingdom of Norway"},
        },
        "NPL": {
            "title": "Nepal",
            "alternative_codes": ["NP", "524"],
            "info": {"official_name": "Federal Democratic Republic of Nepal"},
        },
        "NRU": {
            "title": "Nauru",
            "alternative_codes": ["NR", "520"],
            "info": {"official_name": "Republic of Nauru"},
        },
        "NZL": {"title": "New Zealand", "alternative_codes": ["NZ", "554"]},
        "OMN": {
            "title": "Oman",
            "alternative_codes": ["OM", "512"],
            "info": {"official_name": "Sultanate of Oman"},
        },
        "PAK": {
            "title": "Pakistan",
            "alternative_codes": ["PK", "586"],
            "info": {"official_name": "Islamic Republic of Pakistan"},
        },
        "PAN": {
            "title": "Panama",
            "alternative_codes": ["PA", "591"],
            "info": {"official_name": "Republic of Panama"},
        },
        "PCN": {"title": "Pitcairn", "alternative_codes": ["PN", "612"]},
        "PER": {
            "title": "Peru",
            "alternative_codes": ["PE", "604"],
            "info": {"official_name": "Republic of Peru"},
        },
        "PHL": {
            "title": "Philippines",
            "alternative_codes": ["PH", "608"],
            "info": {"official_name": "Republic of the Philippines"},
        },
        "PLW": {
            "title": "Palau",
            "alternative_codes": ["PW", "585"],
            "info": {"official_name": "Republic of Palau"},
        },
        "PNG": {
            "title": "Papua New Guinea",
            "alternative_codes": ["PG", "598"],
            "info": {"official_name": "Independent State of Papua New Guinea"},
        },
        "POL": {
            "title": "Poland",
            "alternative_codes": ["PL", "616"],
            "info": {"official_name": "Republic of Poland"},
        },
        "PRI": {"title": "Puerto Rico", "alternative_codes": ["PR", "630"]},
        "PRK": {
            "title": "Korea, Democratic People's Republic of",
            "alternative_codes": ["KP", "408"],
            "info": {
                "official_name": "Democratic People's Republic of Korea",
                "common_name": "North Korea",
            },
        },
        "PRT": {
            "title": "Portugal",
            "alternative_codes": ["PT", "620"],
            "info": {"official_name": "Portuguese Republic"},
        },
        "PRY": {
            "title": "Paraguay",
            "alternative_codes": ["PY", "600"],
            "info": {"official_name": "Republic of Paraguay"},
        },
        "PSE": {
            "title": "Palestine, State of",
            "alternative_codes": ["PS", "275"],
            "info": {
                "official_name": "the State of Palestine",
                "unfccc_name": "State of Palestine",
            },
        },
        "PYF": {"title": "French Polynesia", "alternative_codes": ["PF", "258"]},
        "QAT": {
            "title": "Qatar",
            "alternative_codes": ["QA", "634"],
            "info": {"official_name": "State of Qatar"},
        },
        "REU": {"title": "Réunion", "alternative_codes": ["RE", "638"]},
        "ROU": {"title": "Romania", "alternative_codes": ["RO", "642"]},
        "RUS": {"title": "Russian Federation", "alternative_codes": ["RU", "643"]},
        "RWA": {
            "title": "Rwanda",
            "alternative_codes": ["RW", "646"],
            "info": {"official_name": "Rwandese Republic"},
        },
        "SAU": {
            "title": "Saudi Arabia",
            "alternative_codes": ["SA", "682"],
            "info": {"official_name": "Kingdom of Saudi Arabia"},
        },
        "SDN": {
            "title": "Sudan",
            "alternative_codes": ["SD", "729"],
            "info": {"official_name": "Republic of the Sudan"},
        },
        "SEN": {
            "title": "Senegal",
            "alternative_codes": ["SN", "686"],
            "info": {"official_name": "Republic of Senegal"},
        },
        "SGP": {
            "title": "Singapore",
            "alternative_codes": ["SG", "702"],
            "info": {"official_name": "Republic of Singapore"},
        },
        "SGS": {
            "title": "South Georgia and the South Sandwich Islands",
            "alternative_codes": ["GS", "239"],
        },
        "SHN": {
            "title": "Saint Helena, Ascension and Tristan da Cunha",
            "alternative_codes": ["SH", "654"],
        },
        "SJM": {"title": "Svalbard and Jan Mayen", "alternative_codes": ["SJ", "744"]},
        "SLB": {"title": "Solomon Islands", "alternative_codes": ["SB", "090"]},
        "SLE": {
            "title": "Sierra Leone",
            "alternative_codes": ["SL", "694"],
            "info": {"official_name": "Republic of Sierra Leone"},
        },
        "SLV": {
            "title": "El Salvador",
            "alternative_codes": ["SV", "222"],
            "info": {"official_name": "Republic of El Salvador"},
        },
        "SMR": {
            "title": "San Marino",
            "alternative_codes": ["SM", "674"],
            "info": {"official_name": "Republic of San Marino"},
        },
        "SOM": {
            "title": "Somalia",
            "alternative_codes": ["SO", "706"],
            "info": {"official_name": "Federal Republic of Somalia"},
        },
        "SPM": {
            "title": "Saint Pierre and Miquelon",
            "alternative_codes": ["PM", "666"],
        },
        "SRB": {
            "title": "Serbia",
            "alternative_codes": ["RS", "688"],
            "info": {"official_name": "Republic of Serbia"},
        },
        "SSD": {
            "title": "South Sudan",
            "alternative_codes": ["SS", "728"],
            "info": {"official_name": "Republic of South Sudan"},
        },
        "STP": {
            "title": "Sao Tome and Principe",
            "alternative_codes": ["ST", "678"],
            "info": {"official_name": "Democratic Republic of Sao Tome and Principe"},
        },
        "SUR": {
            "title": "Suriname",
            "alternative_codes": ["SR", "740"],
            "info": {"official_name": "Republic of Suriname"},
        },
        "SVK": {
            "title": "Slovakia",
            "alternative_codes": ["SK", "703"],
            "info": {"official_name": "Slovak Republic"},
        },
        "SVN": {
            "title": "Slovenia",
            "alternative_codes": ["SI", "705"],
            "info": {"official_name": "Republic of Slovenia"},
        },
        "SWE": {
            "title": "Sweden",
            "alternative_codes": ["SE", "752"],
            "info": {"official_name": "Kingdom of Sweden"},
        },
        "SWZ": {
            "title": "Eswatini",
            "alternative_codes": ["SZ", "748"],
            "info": {"official_name": "Kingdom of Eswatini"},
        },
        "SXM": {
            "title": "Sint Maarten (Dutch part)",
            "alternative_codes": ["SX", "534"],
            "info": {"official_name": "Sint Maarten (Dutch part)"},
        },
        "SYC": {
            "title": "Seychelles",
            "alternative_codes": ["SC", "690"],
            "info": {"official_name": "Republic of Seychelles"},
        },
        "SYR": {
            "title": "Syrian Arab Republic",
            "alternative_codes": ["SY", "760"],
            "info": {"common_name": "Syria"},
        },
        "TCA": {
            "title": "Turks and Caicos Islands",
            "alternative_codes": ["TC", "796"],
        },
        "TCD": {
            "title": "Chad",
            "alternative_codes": ["TD", "148"],
            "info": {"official_name": "Republic of Chad"},
        },
        "TGO": {
            "title": "Togo",
            "alternative_codes": ["TG", "768"],
            "info": {"official_name": "Togolese Republic"},
        },
        "THA": {
            "title": "Thailand",
            "alternative_codes": ["TH", "764"],
            "info": {"official_name": "Kingdom of Thailand"},
        },
        "TJK": {
            "title": "Tajikistan",
            "alternative_codes": ["TJ", "762"],
            "info": {"official_name": "Republic of Tajikistan"},
        },
        "TKL": {"title": "Tokelau", "alternative_codes": ["TK", "772"]},
        "TKM": {"title": "Turkmenistan", "alternative_codes": ["TM", "795"]},
        "TLS": {
            "title": "Timor-Leste",
            "alternative_codes": ["TL", "626"],
            "info": {"official_name": "Democratic Republic of Timor-Leste"},
        },
        "TON": {
            "title": "Tonga",
            "alternative_codes": ["TO", "776"],
            "info": {"official_name": "Kingdom of Tonga"},
        },
        "TTO": {
            "title": "Trinidad and Tobago",
            "alternative_codes": ["TT", "780"],
            "info": {"official_name": "Republic of Trinidad and Tobago"},
        },
        "TUN": {
            "title": "Tunisia",
            "alternative_codes": ["TN", "788"],
            "info": {"official_name": "Republic of Tunisia"},
        },
        "TUR": {
            "title": "Türkiye",
            "alternative_codes": ["TR", "792"],
            "info": {
                "official_name": "Republic of Türkiye",
                "historical_names": ["Turkey"],
            },
        },
        "TUV": {"title": "Tuvalu", "alternative_codes": ["TV", "798"]},
        "TWN": {
            "title": "Taiwan, Province of China",
            "alternative_codes": ["TW", "158"],
            "info": {
                "official_name": "Taiwan, Province of China",
                "common_name": "Taiwan",
            },
        },
        "TZA": {
            "title": "Tanzania, United Republic of",
            "alternative_codes": ["TZ", "834"],
            "info": {
                "official_name": "United Republic of Tanzania",
                "common_name": "Tanzania",
            },
        },
        "UGA": {
            "title": "Uganda",
            "alternative_codes": ["UG", "800"],
            "info": {"official_name": "Republic of Uganda"},
        },
        "UKR": {"title": "Ukraine", "alternative_codes": ["UA", "804"]},
        "UMI": {
            "title": "United States Minor Outlying Islands",
            "alternative_codes": ["UM", "581"],
        },
        "URY": {
            "title": "Uruguay",
            "alternative_codes": ["UY", "858"],
            "info": {"official_name": "Eastern Republic of Uruguay"},
        },
        "USA": {
            "title": "United States",
            "alternative_codes": ["US", "840"],
            "info": {"official_name": "United States of America"},
        },
        "UZB": {
            "title": "Uzbekistan",
            "alternative_codes": ["UZ", "860"],
            "info": {"official_name": "Republic of Uzbekistan"},
        },
        "VAT": {
            "title": "Holy See (Vatican City State)",
            "alternative_codes": ["VA", "336"],
            "info": {"unfccc_name": "Holy See"},
        },
        "VCT": {
            "title": "Saint Vincent and the Grenadines",
            "alternative_codes": ["VC", "670"],
        },
        "VEN": {
            "title": "Venezuela, Bolivarian Republic of",
            "alternative_codes": ["VE", "862"],
            "info": {
                "official_name": "Bolivarian Republic of Venezuela",
                "common_name": "Venezuela",
                "unfccc_name": "Venezuela (Bolivarian Republic of)",
            },
        },
        "VGB": {
            "title": "Virgin Islands, British",
            "alternative_codes": ["VG", "092"],
            "info": {"official_name": "British Virgin Islands"},
        },
        "VIR": {
            "title": "Virgin Islands, U.S.",
            "alternative_codes": ["VI", "850"],
            "info": {"official_name": "Virgin Islands of the United States"},
        },
        "VNM": {
            "title": "Viet Nam",
            "alternative_codes": ["VN", "704"],
            "info": {
                "official_name": "Socialist Republic of Viet Nam",
                "common_name": "Vietnam",
            },
        },
        "VUT": {
            "title": "Vanuatu",
            "alternative_codes": ["VU", "548"],
            "info": {"official_name": "Republic of Vanuatu"},
        },
        "WLF": {"title": "Wallis and Futuna", "alternative_codes": ["WF", "876"]},
        "WSM": {
            "title": "Samoa",
            "alternative_codes": ["WS", "882"],
            "info": {"official_name": "Independent State of Samoa"},
        },
        "YEM": {
            "title": "Yemen",
            "alternative_codes": ["YE", "887"],
            "info": {"official_name": "Republic of Yemen"},
        },
        "ZAF": {
            "title": "South Africa",
            "alternative_codes": ["ZA", "710"],
            "info": {"official_name": "Republic of South Africa"},
        },
        "ZMB": {
            "title": "Zambia",
            "alternative_codes": ["ZM", "894"],
            "info": {"official_name": "Republic of Zambia"},
        },
        "ZWE": {
            "title": "Zimbabwe",
            "alternative_codes": ["ZW", "716"],
            "info": {"official_name": "Republic of Zimbabwe"},
        },
        "World": {
            "title": "The world",
            "alternative_codes": ["EARTH", "Earth", "WORLD"],
            "children": [
                [
                    "ABW",
                    "AFG",
                    "AGO",
                    "AIA",
                    "ALA",
                    "ALB",
                    "AND",
                    "ARE",
                    "ARG",
                    "ARM",
                    "ASM",
                    "ATA",
                    "ATF",
                    "ATG",
                    "AUS",
                    "AUT",
                    "AZE",
                    "BDI",
                    "BEL",
                    "BEN",
                    "BES",
                    "BFA",
                    "BGD",
                    "BGR",
                    "BHR",
                    "BHS",
                    "BIH",
                    "BLM",
                    "BLR",
                    "BLZ",
                    "BMU",
                    "BOL",
                    "BRA",
                    "BRB",
                    "BRN",
                    "BTN",
                    "BVT",
                    "BWA",
                    "CAF",
                    "CAN",
                    "CCK",
                    "CHE",
                    "CHL",
                    "CHN",
                    "CIV",
                    "CMR",
                    "COD",
                    "COG",
                    "COK",
                    "COL",
                    "COM",
                    "CPV",
                    "CRI",
                    "CUB",
                    "CUW",
                    "CXR",
                    "CYM",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DJI",
                    "DMA",
                    "DNK",
                    "DOM",
                    "DZA",
                    "ECU",
                    "EGY",
                    "ERI",
                    "ESH",
                    "ESP",
                    "EST",
                    "ETH",
                    "FIN",
                    "FJI",
                    "FLK",
                    "FRA",
                    "FRO",
                    "FSM",
                    "GAB",
                    "GBR",
                    "GEO",
                    "GGY",
                    "GHA",
                    "GIB",
                    "GIN",
                    "GLP",
                    "GMB",
                    "GNB",
                    "GNQ",
                    "GRC",
                    "GRD",
                    "GRL",
                    "GTM",
                    "GUF",
                    "GUM",
                    "GUY",
                    "HKG",
                    "HMD",
                    "HND",
                    "HRV",
                    "HTI",
                    "HUN",
                    "IDN",
                    "IMN",
                    "IND",
                    "IOT",
                    "IRL",
                    "IRN",
                    "IRQ",
                    "ISL",
                    "ISR",
                    "ITA",
                    "JAM",
                    "JEY",
                    "JOR",
                    "JPN",
                    "KAZ",
                    "KEN",
                    "KGZ",
                    "KHM",
                    "KIR",
                    "KNA",
                    "KOR",
                    "KWT",
                    "LAO",
                    "LBN",
                    "LBR",
                    "LBY",
                    "LCA",
                    "LIE",
                    "LKA",
                    "LSO",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MAC",
                    "MAF",
                    "MAR",
                    "MCO",
                    "MDA",
                    "MDG",
                    "MDV",
                    "MEX",
                    "MHL",
                    "MKD",
                    "MLI",
                    "MLT",
                    "MMR",
                    "MNE",
                    "MNG",
                    "MNP",
                    "MOZ",
                    "MRT",
                    "MSR",
                    "MTQ",
                    "MUS",
                    "MWI",
                    "MYS",
                    "MYT",
                    "NAM",
                    "NCL",
                    "NER",
                    "NFK",
                    "NGA",
                    "NIC",
                    "NIU",
                    "NLD",
                    "NOR",
                    "NPL",
                    "NRU",
                    "NZL",
                    "OMN",
                    "PAK",
                    "PAN",
                    "PCN",
                    "PER",
                    "PHL",
                    "PLW",
                    "PNG",
                    "POL",
                    "PRI",
                    "PRK",
                    "PRT",
                    "PRY",
                    "PSE",
                    "PYF",
                    "QAT",
                    "REU",
                    "ROU",
                    "RUS",
                    "RWA",
                    "SAU",
                    "SDN",
                    "SEN",
                    "SGP",
                    "SGS",
                    "SHN",
                    "SJM",
                    "SLB",
                    "SLE",
                    "SLV",
                    "SMR",
                    "SOM",
                    "SPM",
                    "SRB",
                    "SSD",
                    "STP",
                    "SUR",
                    "SVK",
                    "SVN",
                    "SWE",
                    "SWZ",
                    "SXM",
                    "SYC",
                    "SYR",
                    "TCA",
                    "TCD",
                    "TGO",
                    "THA",
                    "TJK",
                    "TKL",
                    "TKM",
                    "TLS",
                    "TON",
                    "TTO",
                    "TUN",
                    "TUR",
                    "TUV",
                    "TWN",
                    "TZA",
                    "UGA",
                    "UKR",
                    "UMI",
                    "URY",
                    "USA",
                    "UZB",
                    "VAT",
                    "VCT",
                    "VEN",
                    "VGB",
                    "VIR",
                    "VNM",
                    "VUT",
                    "WLF",
                    "WSM",
                    "YEM",
                    "ZAF",
                    "ZMB",
                    "ZWE",
                ]
            ],
        },
        "EU_1993": {
            "title": "European Union from 1993 to 1994",
            "comment": "The European Union from 1993-11-1 to 1994-12-31.",
            "alternative_codes": ["EU12", "EU-12"],
            "children": [
                [
                    "BEL",
                    "DEU",
                    "DNK",
                    "ESP",
                    "FRA",
                    "GBR",
                    "GRC",
                    "IRL",
                    "ITA",
                    "LUX",
                    "NLD",
                    "PRT",
                ]
            ],
        },
        "EU_1995": {
            "title": "European Union from 1995 to 2004",
            "comment": "The European Union from 1995-01-01 to 2004-04-30.",
            "alternative_codes": ["EU15", "EU-15"],
            "children": [
                [
                    "AUT",
                    "BEL",
                    "DEU",
                    "DNK",
                    "ESP",
                    "FIN",
                    "FRA",
                    "GBR",
                    "GRC",
                    "IRL",
                    "ITA",
                    "LUX",
                    "NLD",
                    "PRT",
                    "SWE",
                ]
            ],
        },
        "EU_2004": {
            "title": "European Union from 2004 to 2006",
            "comment": "The European Union from 2004-05-01 to 2006-12-31.",
            "alternative_codes": ["EU25", "EU-25"],
            "children": [
                [
                    "AUT",
                    "BEL",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DNK",
                    "ESP",
                    "EST",
                    "FIN",
                    "FRA",
                    "GBR",
                    "GRC",
                    "HUN",
                    "IRL",
                    "ITA",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MLT",
                    "NLD",
                    "POL",
                    "PRT",
                    "SVK",
                    "SVN",
                    "SWE",
                ]
            ],
        },
        "EU_2007": {
            "title": "European Union from 2007 to 2013",
            "comment": "The European Union from 2007-01-01 to 2013-06-30.",
            "alternative_codes": ["EU27_2007", "EU-27_2007"],
            "children": [
                [
                    "AUT",
                    "BEL",
                    "BGR",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DNK",
                    "ESP",
                    "EST",
                    "FIN",
                    "FRA",
                    "GBR",
                    "GRC",
                    "HUN",
                    "IRL",
                    "ITA",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MLT",
                    "NLD",
                    "POL",
                    "PRT",
                    "ROU",
                    "SVK",
                    "SVN",
                    "SWE",
                ]
            ],
        },
        "EU_2013": {
            "title": "European Union from 2013 to 2020",
            "comment": "The European Union from 2013-07-01 to 2020-01-31.",
            "alternative_codes": ["EU28", "EU-28"],
            "children": [
                [
                    "AUT",
                    "BEL",
                    "BGR",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DNK",
                    "ESP",
                    "EST",
                    "FIN",
                    "FRA",
                    "GBR",
                    "GRC",
                    "HRV",
                    "HUN",
                    "IRL",
                    "ITA",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MLT",
                    "NLD",
                    "POL",
                    "PRT",
                    "ROU",
                    "SVK",
                    "SVN",
                    "SWE",
                ]
            ],
        },
        "EU_2020": {
            "title": "European Union",
            "comment": "The European Union since 2020-02-01 to date. Note that the 'EU' code will always refer to the current EU, use EU_2020 if you need a stable code.",
            "alternative_codes": ["EU27_2020", "EU-27_2020", "EU", "EU27BX"],
            "children": [
                [
                    "AUT",
                    "BEL",
                    "BGR",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DNK",
                    "ESP",
                    "EST",
                    "FIN",
                    "FRA",
                    "GRC",
                    "HRV",
                    "HUN",
                    "IRL",
                    "ITA",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MLT",
                    "NLD",
                    "POL",
                    "PRT",
                    "ROU",
                    "SVK",
                    "SVN",
                    "SWE",
                ]
            ],
        },
        "Annex-I": {
            "title": "Annex-I parties to the UNFCCC",
            "comment": "Parties to the UN Framework Convention on Climate Change listed in Annex I of the Convention.",
            "alternative_codes": ["ANNEXI"],
            "children": [
                [
                    "AUS",
                    "AUT",
                    "BEL",
                    "BGR",
                    "BLR",
                    "CAN",
                    "CHE",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DNK",
                    "ESP",
                    "EST",
                    "EU_2020",
                    "FIN",
                    "FRA",
                    "GBR",
                    "GRC",
                    "HRV",
                    "HUN",
                    "IRL",
                    "ISL",
                    "ITA",
                    "JPN",
                    "LIE",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MCO",
                    "MLT",
                    "NLD",
                    "NOR",
                    "NZL",
                    "POL",
                    "PRT",
                    "ROU",
                    "RUS",
                    "SVK",
                    "SVN",
                    "SWE",
                    "TUR",
                    "UKR",
                    "USA",
                ]
            ],
        },
        "Non-Annex-I": {
            "title": "Non-Annex-I parties to the UNFCCC",
            "comment": "Parties to the UN Framework Convention on Climate Change not listed in Annex I of the Convention.",
            "alternative_codes": ["NONANNEXI", "Non Annex-I"],
            "children": [
                [
                    "AFG",
                    "AGO",
                    "ALB",
                    "AND",
                    "ARE",
                    "ARG",
                    "ARM",
                    "ATG",
                    "AZE",
                    "BDI",
                    "BEN",
                    "BFA",
                    "BGD",
                    "BHR",
                    "BHS",
                    "BIH",
                    "BLZ",
                    "BOL",
                    "BRA",
                    "BRB",
                    "BRN",
                    "BTN",
                    "BWA",
                    "CAF",
                    "CHL",
                    "CHN",
                    "CIV",
                    "CMR",
                    "COD",
                    "COG",
                    "COK",
                    "COL",
                    "COM",
                    "CPV",
                    "CRI",
                    "CUB",
                    "DJI",
                    "DMA",
                    "DOM",
                    "DZA",
                    "ECU",
                    "EGY",
                    "ERI",
                    "ETH",
                    "FJI",
                    "FSM",
                    "GAB",
                    "GEO",
                    "GHA",
                    "GIN",
                    "GMB",
                    "GNB",
                    "GNQ",
                    "GRD",
                    "GTM",
                    "GUY",
                    "HND",
                    "HTI",
                    "IDN",
                    "IND",
                    "IRN",
                    "IRQ",
                    "ISR",
                    "JAM",
                    "JOR",
                    "KAZ",
                    "KEN",
                    "KGZ",
                    "KHM",
                    "KIR",
                    "KNA",
                    "KOR",
                    "KWT",
                    "LAO",
                    "LBN",
                    "LBR",
                    "LBY",
                    "LCA",
                    "LKA",
                    "LSO",
                    "MAR",
                    "MDA",
                    "MDG",
                    "MDV",
                    "MEX",
                    "MHL",
                    "MKD",
                    "MLI",
                    "MMR",
                    "MNE",
                    "MNG",
                    "MOZ",
                    "MRT",
                    "MUS",
                    "MWI",
                    "MYS",
                    "NAM",
                    "NER",
                    "NGA",
                    "NIC",
                    "NIU",
                    "NPL",
                    "NRU",
                    "OMN",
                    "PAK",
                    "PAN",
                    "PER",
                    "PHL",
                    "PLW",
                    "PNG",
                    "PRK",
                    "PRY",
                    "PSE",
                    "QAT",
                    "RWA",
                    "SAU",
                    "SDN",
                    "SEN",
                    "SGP",
                    "SLB",
                    "SLE",
                    "SLV",
                    "SMR",
                    "SOM",
                    "SRB",
                    "SSD",
                    "STP",
                    "SUR",
                    "SWZ",
                    "SYC",
                    "SYR",
                    "TCD",
                    "TGO",
                    "THA",
                    "TJK",
                    "TKM",
                    "TLS",
                    "TON",
                    "TTO",
                    "TUN",
                    "TUV",
                    "TZA",
                    "UGA",
                    "URY",
                    "UZB",
                    "VAT",
                    "VCT",
                    "VEN",
                    "VNM",
                    "VUT",
                    "WSM",
                    "YEM",
                    "ZAF",
                    "ZMB",
                    "ZWE",
                ]
            ],
        },
        "UNFCCC": {
            "title": "Parties to the UNFCCC",
            "comment": "Parties to the UN Framework Convention on Climate Change.",
            "children": [
                [
                    "AFG",
                    "AGO",
                    "ALB",
                    "AND",
                    "ARE",
                    "ARG",
                    "ARM",
                    "ATG",
                    "AUS",
                    "AUT",
                    "AZE",
                    "BDI",
                    "BEL",
                    "BEN",
                    "BFA",
                    "BGD",
                    "BGR",
                    "BHR",
                    "BHS",
                    "BIH",
                    "BLR",
                    "BLZ",
                    "BOL",
                    "BRA",
                    "BRB",
                    "BRN",
                    "BTN",
                    "BWA",
                    "CAF",
                    "CAN",
                    "CHE",
                    "CHL",
                    "CHN",
                    "CIV",
                    "CMR",
                    "COD",
                    "COG",
                    "COK",
                    "COL",
                    "COM",
                    "CPV",
                    "CRI",
                    "CUB",
                    "CYP",
                    "CZE",
                    "DEU",
                    "DJI",
                    "DMA",
                    "DNK",
                    "DOM",
                    "DZA",
                    "ECU",
                    "EGY",
                    "ERI",
                    "ESP",
                    "EST",
                    "ETH",
                    "EU_2020",
                    "FIN",
                    "FJI",
                    "FRA",
                    "FSM",
                    "GAB",
                    "GBR",
                    "GEO",
                    "GHA",
                    "GIN",
                    "GMB",
                    "GNB",
                    "GNQ",
                    "GRC",
                    "GRD",
                    "GTM",
                    "GUY",
                    "HND",
                    "HRV",
                    "HTI",
                    "HUN",
                    "IDN",
                    "IND",
                    "IRL",
                    "IRN",
                    "IRQ",
                    "ISL",
                    "ISR",
                    "ITA",
                    "JAM",
                    "JOR",
                    "JPN",
                    "KAZ",
                    "KEN",
                    "KGZ",
                    "KHM",
                    "KIR",
                    "KNA",
                    "KOR",
                    "KWT",
                    "LAO",
                    "LBN",
                    "LBR",
                    "LBY",
                    "LCA",
                    "LIE",
                    "LKA",
                    "LSO",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MAR",
                    "MCO",
                    "MDA",
                    "MDG",
                    "MDV",
                    "MEX",
                    "MHL",
                    "MKD",
                    "MLI",
                    "MLT",
                    "MMR",
                    "MNE",
                    "MNG",
                    "MOZ",
                    "MRT",
                    "MUS",
                    "MWI",
                    "MYS",
                    "NAM",
                    "NER",
                    "NGA",
                    "NIC",
                    "NIU",
                    "NLD",
                    "NOR",
                    "NPL",
                    "NRU",
                    "NZL",
                    "OMN",
                    "PAK",
                    "PAN",
                    "PER",
                    "PHL",
                    "PLW",
                    "PNG",
                    "POL",
                    "PRK",
                    "PRT",
                    "PRY",
                    "PSE",
                    "QAT",
                    "ROU",
                    "RUS",
                    "RWA",
                    "SAU",
                    "SDN",
                    "SEN",
                    "SGP",
                    "SLB",
                    "SLE",
                    "SLV",
                    "SMR",
                    "SOM",
                    "SRB",
                    "SSD",
                    "STP",
                    "SUR",
                    "SVK",
                    "SVN",
                    "SWE",
                    "SWZ",
                    "SYC",
                    "SYR",
                    "TCD",
                    "TGO",
                    "THA",
                    "TJK",
                    "TKM",
                    "TLS",
                    "TON",
                    "TTO",
                    "TUN",
                    "TUR",
                    "TUV",
                    "TZA",
                    "UGA",
                    "UKR",
                    "URY",
                    "USA",
                    "UZB",
                    "VAT",
                    "VCT",
                    "VEN",
                    "VNM",
                    "VUT",
                    "WSM",
                    "YEM",
                    "ZAF",
                    "ZMB",
                    "ZWE",
                ],
                ["Annex-I", "Non-Annex-I"],
            ],
        },
        "AOSIS": {
            "title": "Alliance of Small Island States",
            "children": [
                [
                    "ATG",
                    "BHS",
                    "BLZ",
                    "BRB",
                    "COK",
                    "COM",
                    "CPV",
                    "CUB",
                    "DMA",
                    "DOM",
                    "FJI",
                    "FSM",
                    "GNB",
                    "GRD",
                    "GUY",
                    "HTI",
                    "JAM",
                    "KIR",
                    "KNA",
                    "LCA",
                    "MDV",
                    "MHL",
                    "MUS",
                    "NIU",
                    "NRU",
                    "PLW",
                    "PNG",
                    "SGP",
                    "SLB",
                    "STP",
                    "SUR",
                    "SYC",
                    "TLS",
                    "TON",
                    "TTO",
                    "TUV",
                    "VCT",
                    "VUT",
                    "WSM",
                ]
            ],
        },
        "G7": {
            "title": "Group of Seven",
            "children": [["CAN", "DEU", "EU_2020", "FRA", "GBR", "ITA", "JPN", "USA"]],
        },
        "G8": {
            "title": "Group of Eight",
            "children": [
                ["CAN", "DEU", "EU_2020", "FRA", "GBR", "ITA", "JPN", "RUS", "USA"]
            ],
        },
        "G20": {
            "title": "Group of 20",
            "children": [
                [
                    "ARG",
                    "AUS",
                    "BRA",
                    "CAN",
                    "CHN",
                    "DEU",
                    "EU_2020",
                    "FRA",
                    "GBR",
                    "IDN",
                    "IND",
                    "ITA",
                    "JPN",
                    "KOR",
                    "MEX",
                    "RUS",
                    "SAU",
                    "TUR",
                    "USA",
                    "ZAF",
                ]
            ],
        },
        "OECD": {
            "title": "Organisation for Economic Co-operation and Development",
            "children": [
                [
                    "AUS",
                    "AUT",
                    "BEL",
                    "CAN",
                    "CHE",
                    "CHL",
                    "COL",
                    "CRI",
                    "CZE",
                    "DEU",
                    "DNK",
                    "ESP",
                    "EST",
                    "FIN",
                    "FRA",
                    "GBR",
                    "GRC",
                    "HUN",
                    "IRL",
                    "ISL",
                    "ISR",
                    "ITA",
                    "JPN",
                    "KOR",
                    "LTU",
                    "LUX",
                    "LVA",
                    "MEX",
                    "NLD",
                    "NOR",
                    "NZL",
                    "POL",
                    "PRT",
                    "SVK",
                    "SVN",
                    "SWE",
                    "TUR",
                    "USA",
                ]
            ],
        },
    },
}
