# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_plotly.ipynb.

# %% auto 0
__all__ = ['PLOTLY_KEY', 'MARKDOWN_KEY', 'TEMPLATE', 'get_custom_code', 'PlotlyProc']

# %% ../nbs/00_plotly.ipynb 2
from nbdev.process import Processor
import json


# %% ../nbs/00_plotly.ipynb 3
PLOTLY_KEY = 'application/vnd.plotly.v1+json'
MARKDOWN_KEY = 'text/markdown'

# %% ../nbs/00_plotly.ipynb 4
TEMPLATE = """<CustomCode html={
    `<!DOCTYPE html>
    <html>
      <head>
        <title>Parcel Sandbox</title>
        <meta charset="UTF-8" />
      </head>
  
      <body>
        <div id="{id}" style="height: 150px; width: 100%;"></div>
  
        <script src="src/index.js"></script>
      </body>
  
    </html>
  `} js={
    `import Plotly from "plotly.js-dist-min";
    window.PLOTLYENV = window.PLOTLYENV || {};
      if (document.getElementById("{id}")) {
        Plotly.newPlot({data}).then(function () {
          var gd = document.getElementById(
            "{id}"
          );
          var x = new MutationObserver(function (mutations, observer) {
            {
              var display = window.getComputedStyle(gd).display;
              if (!display || display === "none") {
                {
                  console.log([gd, "removed!"]);
                  Plotly.purge(gd);
                  observer.disconnect();
                }
              }
            }
          });

          // Listen for the removal of the full notebook cells
          var notebookContainer = gd.closest("#notebook-container");
          if (notebookContainer) {
            {
              x.observe(notebookContainer, { childList: true });
            }
          }

          // Listen for the clearing of the current output cell
          var outputEl = gd.closest(".output");
          if (outputEl) {
            {
              x.observe(outputEl, { childList: true });
            }
          }
        });
      }


`}
dependencies= {{
"plotly.js-dist-min": "latest",
}}
/> """

def get_custom_code(data):
    return open('../template/custom_code.html').read()

# %% ../nbs/00_plotly.ipynb 5
class PlotlyProc(Processor):
    "A processor that will do the conversion for outputs"
    has_multiple_cells = False
    def cell(self, cell):
        if 'outputs' in cell:
            output = cell['outputs']
            for k in output:
                if 'data' in k:
                    data = k['data']
                    if PLOTLY_KEY in data:
                        data[MARKDOWN_KEY] = [get_custom_code(data[PLOTLY_KEY])]
                        # data[HTML_KEY]['mimeType'] = PLOTLY_KEY
                        del data[PLOTLY_KEY]   
                        print('Plotly replaced')
