from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkStatisticsAlgorithm(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    class InputPorts(int): ...
    class OutputIndices(int): ...
    INPUT_DATA:'InputPorts'
    INPUT_MODEL:'InputPorts'
    LEARN_PARAMETERS:'InputPorts'
    OUTPUT_DATA:'OutputIndices'
    OUTPUT_MODEL:'OutputIndices'
    OUTPUT_TEST:'OutputIndices'
    assess_names:'getset_descriptor'
    assess_option:'getset_descriptor'
    derive_option:'getset_descriptor'
    input_model:'getset_descriptor'
    input_model_connection:'getset_descriptor'
    learn_option:'getset_descriptor'
    learn_option_parameter_connection:'getset_descriptor'
    learn_option_parameters:'getset_descriptor'
    number_of_primary_tables:'getset_descriptor'
    number_of_requests:'getset_descriptor'
    test_option:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddColumn(self, namCol:str) -> None: ...
    def AddColumnPair(self, namColX:str, namColY:str) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetAssessNames(self) -> 'vtkStringArray': ...
    def GetAssessOption(self) -> bool: ...
    @overload
    def GetColumnForRequest(self, r:int, c:int) -> str: ...
    @overload
    def GetColumnForRequest(self, r:int, c:int, columnName:str) -> int: ...
    def GetDeriveOption(self) -> bool: ...
    def GetLearnOption(self) -> bool: ...
    def GetNumberOfColumnsForRequest(self, request:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPrimaryTables(self) -> int: ...
    def GetNumberOfRequests(self) -> int: ...
    def GetTestOption(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStatisticsAlgorithm': ...
    def RequestSelectedColumns(self) -> int: ...
    def ResetAllColumnStates(self) -> None: ...
    def ResetRequests(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStatisticsAlgorithm': ...
    def SetAssessNames(self, __a:'vtkStringArray') -> None: ...
    def SetAssessOption(self, _arg:bool) -> None: ...
    def SetColumnStatus(self, namCol:str, status:int) -> None: ...
    def SetDeriveOption(self, _arg:bool) -> None: ...
    def SetInputModel(self, model:'vtkDataObject') -> None: ...
    def SetInputModelConnection(self, model:'vtkAlgorithmOutput') -> None: ...
    def SetLearnOption(self, _arg:bool) -> None: ...
    def SetLearnOptionParameterConnection(self, params:'vtkAlgorithmOutput') -> None: ...
    def SetLearnOptionParameters(self, params:'vtkDataObject') -> None: ...
    def SetNumberOfPrimaryTables(self, _arg:int) -> None: ...
    def SetParameter(self, parameter:str, index:int, value:'vtkVariant') -> bool: ...
    def SetTestOption(self, _arg:bool) -> None: ...

class vtkAutoCorrelativeStatistics(vtkStatisticsAlgorithm):
    slice_cardinality:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSliceCardinality(self) -> int: ...
    def GetSliceCardinalityMaxValue(self) -> int: ...
    def GetSliceCardinalityMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAutoCorrelativeStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAutoCorrelativeStatistics': ...
    def SetSliceCardinality(self, _arg:int) -> None: ...

class vtkBivariateLinearTableThreshold(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    class LinearThresholdType(int): ...
    class OutputPorts(int): ...
    BLT_ABOVE:'LinearThresholdType'
    BLT_BELOW:'LinearThresholdType'
    BLT_BETWEEN:'LinearThresholdType'
    BLT_NEAR:'LinearThresholdType'
    OUTPUT_ROW_DATA:'OutputPorts'
    OUTPUT_ROW_IDS:'OutputPorts'
    column_ranges:'getset_descriptor'
    distance_threshold:'getset_descriptor'
    inclusive:'getset_descriptor'
    linear_threshold_type:'getset_descriptor'
    number_of_columns_to_threshold:'getset_descriptor'
    use_normalized_distance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddColumnToThreshold(self, column:int, component:int) -> None: ...
    @overload
    def AddLineEquation(self, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    @overload
    def AddLineEquation(self, p:MutableSequence[float], slope:float) -> None: ...
    @overload
    def AddLineEquation(self, a:float, b:float, c:float) -> None: ...
    def ClearColumnsToThreshold(self) -> None: ...
    def ClearLineEquations(self) -> None: ...
    @overload
    @staticmethod
    def ComputeImplicitLineFunction(p1:MutableSequence[float], p2:MutableSequence[float], abc:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeImplicitLineFunction(p:MutableSequence[float], slope:float, abc:MutableSequence[float]) -> None: ...
    def GetColumnRanges(self) -> Tuple[float, float]: ...
    def GetColumnToThreshold(self, idx:int, column:int, component:int) -> None: ...
    def GetDistanceThreshold(self) -> float: ...
    def GetInclusive(self) -> int: ...
    def GetLinearThresholdType(self) -> int: ...
    def GetNumberOfColumnsToThreshold(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectedRowIds(self, selection:int=0) -> 'vtkIdTypeArray': ...
    def GetUseNormalizedDistance(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBivariateLinearTableThreshold': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBivariateLinearTableThreshold': ...
    @overload
    def SetColumnRanges(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetColumnRanges(self, _arg:Sequence[float]) -> None: ...
    def SetDistanceThreshold(self, _arg:float) -> None: ...
    def SetInclusive(self, _arg:int) -> None: ...
    def SetLinearThresholdType(self, _arg:int) -> None: ...
    def SetLinearThresholdTypeToAbove(self) -> None: ...
    def SetLinearThresholdTypeToBelow(self) -> None: ...
    def SetLinearThresholdTypeToBetween(self) -> None: ...
    def SetLinearThresholdTypeToNear(self) -> None: ...
    def SetUseNormalizedDistance(self, _arg:int) -> None: ...
    def UseNormalizedDistanceOff(self) -> None: ...
    def UseNormalizedDistanceOn(self) -> None: ...

class vtkComputeQuantiles(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    number_of_intervals:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIntervals(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkComputeQuantiles': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkComputeQuantiles': ...
    def SetNumberOfIntervals(self, _arg:int) -> None: ...

class vtkComputeQuartiles(vtkComputeQuantiles):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkComputeQuartiles': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkComputeQuartiles': ...

class vtkContingencyStatistics(vtkStatisticsAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContingencyStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContingencyStatistics': ...

class vtkCorrelativeStatistics(vtkStatisticsAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCorrelativeStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCorrelativeStatistics': ...

class vtkDescriptiveStatistics(vtkStatisticsAlgorithm):
    ghosts_to_skip:'getset_descriptor'
    sample_estimate:'getset_descriptor'
    signed_deviations:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetGhostsToSkip(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleEstimate(self) -> bool: ...
    def GetSignedDeviations(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDescriptiveStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDescriptiveStatistics': ...
    def SampleEstimateOff(self) -> None: ...
    def SampleEstimateOn(self) -> None: ...
    def SetGhostsToSkip(self, _arg:int) -> None: ...
    def SetSampleEstimate(self, _arg:bool) -> None: ...
    def SetSignedDeviations(self, _arg:int) -> None: ...
    def SignedDeviationsOff(self) -> None: ...
    def SignedDeviationsOn(self) -> None: ...

class vtkExtractFunctionalBagPlot(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    density_for_p50:'getset_descriptor'
    density_for_p_user:'getset_descriptor'
    p_user:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractFunctionalBagPlot': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractFunctionalBagPlot': ...
    def SetDensityForP50(self, _arg:float) -> None: ...
    def SetDensityForPUser(self, _arg:float) -> None: ...
    def SetPUser(self, _arg:int) -> None: ...

class vtkExtractHistogram(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    accumulation:'getset_descriptor'
    bin_accumulation_array_name:'getset_descriptor'
    bin_count:'getset_descriptor'
    bin_extents_array_name:'getset_descriptor'
    bin_range:'getset_descriptor'
    bin_values_array_name:'getset_descriptor'
    calculate_averages:'getset_descriptor'
    center_bins_around_min_and_max:'getset_descriptor'
    component:'getset_descriptor'
    custom_bin_ranges:'getset_descriptor'
    normalize:'getset_descriptor'
    use_custom_bin_ranges:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AccumulationOff(self) -> None: ...
    def AccumulationOn(self) -> None: ...
    def CalculateAveragesOff(self) -> None: ...
    def CalculateAveragesOn(self) -> None: ...
    def CenterBinsAroundMinAndMaxOff(self) -> None: ...
    def CenterBinsAroundMinAndMaxOn(self) -> None: ...
    def GetAccumulation(self) -> bool: ...
    def GetBinAccumulationArrayName(self) -> str: ...
    def GetBinCount(self) -> int: ...
    def GetBinCountMaxValue(self) -> int: ...
    def GetBinCountMinValue(self) -> int: ...
    def GetBinExtentsArrayName(self) -> str: ...
    def GetBinRange(self) -> Tuple[float, float]: ...
    def GetBinValuesArrayName(self) -> str: ...
    def GetCalculateAverages(self) -> bool: ...
    def GetCenterBinsAroundMinAndMax(self) -> bool: ...
    def GetComponent(self) -> int: ...
    def GetComponentMaxValue(self) -> int: ...
    def GetComponentMinValue(self) -> int: ...
    def GetCustomBinRanges(self) -> Tuple[float, float]: ...
    def GetNormalize(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseCustomBinRanges(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractHistogram': ...
    def NormalizeOff(self) -> None: ...
    def NormalizeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractHistogram': ...
    def SetAccumulation(self, _arg:bool) -> None: ...
    def SetBinAccumulationArrayName(self, _arg:str) -> None: ...
    def SetBinCount(self, _arg:int) -> None: ...
    def SetBinExtentsArrayName(self, _arg:str) -> None: ...
    def SetBinValuesArrayName(self, _arg:str) -> None: ...
    def SetCalculateAverages(self, _arg:bool) -> None: ...
    def SetCenterBinsAroundMinAndMax(self, _arg:bool) -> None: ...
    def SetComponent(self, _arg:int) -> None: ...
    @overload
    def SetCustomBinRanges(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetCustomBinRanges(self, _arg:Sequence[float]) -> None: ...
    def SetNormalize(self, _arg:bool) -> None: ...
    def SetUseCustomBinRanges(self, _arg:bool) -> None: ...
    def UseCustomBinRangesOff(self) -> None: ...
    def UseCustomBinRangesOn(self) -> None: ...

class vtkHighestDensityRegionsStatistics(vtkStatisticsAlgorithm):
    sigma:'getset_descriptor'
    sigma_matrix:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    @overload
    def ComputeHDR(self, inObservations:'vtkDataArray', outDensity:'vtkDataArray') -> float: ...
    @overload
    def ComputeHDR(self, inObs:'vtkDataArray', inPOI:'vtkDataArray', outDensity:'vtkDataArray') -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHighestDensityRegionsStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHighestDensityRegionsStatistics': ...
    def SetSigma(self, sigma:float) -> None: ...
    def SetSigmaMatrix(self, s11:float, s12:float, s21:float, s22:float) -> None: ...

class vtkKMeansDistanceFunctor(vtkmodules.vtkCommonCore.vtkObject):
    data_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllocateElementArray(self, size:int) -> Pointer: ...
    def CreateCoordinateArray(self) -> 'vtkAbstractArray': ...
    def DeallocateElementArray(self, __a:Pointer) -> None: ...
    def GetDataType(self) -> int: ...
    def GetEmptyTuple(self, dimension:int) -> 'vtkVariantArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkKMeansDistanceFunctor': ...
    def PackElements(self, curTable:'vtkTable', vElements:Pointer) -> None: ...
    def PairwiseUpdate(self, clusterCenters:'vtkTable', row:int, data:'vtkVariantArray', dataCardinality:int, totalCardinality:int) -> None: ...
    def PerturbElement(self, __a:'vtkTable', __b:'vtkTable', __c:int, __d:int, __e:int, __f:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKMeansDistanceFunctor': ...
    @overload
    def UnPackElements(self, curTable:'vtkTable', newTable:'vtkTable', vLocalElements:Pointer, vGlobalElements:Pointer, np:int) -> None: ...
    @overload
    def UnPackElements(self, curTable:'vtkTable', vLocalElements:Pointer, numRows:int, numCols:int) -> None: ...

class vtkKMeansDistanceFunctorCalculator(vtkKMeansDistanceFunctor):
    distance_expression:'getset_descriptor'
    function_parser:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDistanceExpression(self) -> str: ...
    def GetFunctionParser(self) -> 'vtkFunctionParser': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkKMeansDistanceFunctorCalculator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKMeansDistanceFunctorCalculator': ...
    def SetDistanceExpression(self, _arg:str) -> None: ...
    def SetFunctionParser(self, __a:'vtkFunctionParser') -> None: ...

class vtkKMeansStatistics(vtkStatisticsAlgorithm):
    default_number_of_clusters:'getset_descriptor'
    distance_functor:'getset_descriptor'
    ghosts_to_skip:'getset_descriptor'
    k_values_array_name:'getset_descriptor'
    max_num_iterations:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetDefaultNumberOfClusters(self) -> int: ...
    def GetDistanceFunctor(self) -> 'vtkKMeansDistanceFunctor': ...
    def GetGhostsToSkip(self) -> int: ...
    def GetKValuesArrayName(self) -> str: ...
    def GetMaxNumIterations(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkKMeansStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKMeansStatistics': ...
    def SetDefaultNumberOfClusters(self, _arg:int) -> None: ...
    def SetDistanceFunctor(self, __a:'vtkKMeansDistanceFunctor') -> None: ...
    def SetGhostsToSkip(self, _arg:int) -> None: ...
    def SetKValuesArrayName(self, _arg:str) -> None: ...
    def SetMaxNumIterations(self, _arg:int) -> None: ...
    def SetParameter(self, parameter:str, index:int, value:'vtkVariant') -> bool: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkLengthDistribution(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    sample_size:'getset_descriptor'
    sort_sample:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLengthQuantile(self, qq:float=0.5) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleSize(self) -> int: ...
    def GetSortSample(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLengthDistribution': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLengthDistribution': ...
    def SetSampleSize(self, _arg:int) -> None: ...
    def SetSortSample(self, _arg:bool) -> None: ...
    def SortSampleOff(self) -> None: ...
    def SortSampleOn(self) -> None: ...

class vtkMultiCorrelativeStatistics(vtkStatisticsAlgorithm):
    ghosts_to_skip:'getset_descriptor'
    median_absolute_deviation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetGhostsToSkip(self) -> int: ...
    def GetMedianAbsoluteDeviation(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MedianAbsoluteDeviationOff(self) -> None: ...
    def MedianAbsoluteDeviationOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMultiCorrelativeStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiCorrelativeStatistics': ...
    def SetGhostsToSkip(self, _arg:int) -> None: ...
    def SetMedianAbsoluteDeviation(self, _arg:bool) -> None: ...

class vtkOrderStatistics(vtkStatisticsAlgorithm):
    class QuantileDefinitionType(int): ...
    InverseCDF:'QuantileDefinitionType'
    InverseCDFAveragedSteps:'QuantileDefinitionType'
    NearestObservation:'QuantileDefinitionType'
    ghosts_to_skip:'getset_descriptor'
    maximum_histogram_size:'getset_descriptor'
    number_of_intervals:'getset_descriptor'
    quantile_definition:'getset_descriptor'
    quantize:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    def GetGhostsToSkip(self) -> int: ...
    def GetMaximumHistogramSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIntervals(self) -> int: ...
    def GetQuantileDefinition(self) -> int: ...
    def GetQuantize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrderStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrderStatistics': ...
    def SetGhostsToSkip(self, _arg:int) -> None: ...
    def SetMaximumHistogramSize(self, _arg:int) -> None: ...
    def SetNumberOfIntervals(self, _arg:int) -> None: ...
    def SetParameter(self, parameter:str, index:int, value:'vtkVariant') -> bool: ...
    @overload
    def SetQuantileDefinition(self, _arg:'QuantileDefinitionType') -> None: ...
    @overload
    def SetQuantileDefinition(self, __a:int) -> None: ...
    def SetQuantize(self, _arg:bool) -> None: ...

class vtkPCAStatistics(vtkMultiCorrelativeStatistics):
    class NormalizationType(int): ...
    class ProjectionType(int): ...
    DIAGONAL_SPECIFIED:'NormalizationType'
    DIAGONAL_VARIANCE:'NormalizationType'
    FIXED_BASIS_ENERGY:'ProjectionType'
    FIXED_BASIS_SIZE:'ProjectionType'
    FULL_BASIS:'ProjectionType'
    NONE:'NormalizationType'
    NUM_BASIS_SCHEMES:'ProjectionType'
    NUM_NORMALIZATION_SCHEMES:'NormalizationType'
    TRIANGLE_SPECIFIED:'NormalizationType'
    basis_scheme:'getset_descriptor'
    basis_scheme_by_name:'getset_descriptor'
    fixed_basis_energy:'getset_descriptor'
    fixed_basis_size:'getset_descriptor'
    normalization_scheme:'getset_descriptor'
    normalization_scheme_by_name:'getset_descriptor'
    specified_normalization:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBasisScheme(self) -> int: ...
    def GetBasisSchemeName(self, schemeIndex:int) -> str: ...
    @overload
    def GetEigenvalue(self, request:int, i:int) -> float: ...
    @overload
    def GetEigenvalue(self, i:int) -> float: ...
    @overload
    def GetEigenvalues(self, request:int, __b:'vtkDoubleArray') -> None: ...
    @overload
    def GetEigenvalues(self, __a:'vtkDoubleArray') -> None: ...
    @overload
    def GetEigenvector(self, i:int, eigenvector:'vtkDoubleArray') -> None: ...
    @overload
    def GetEigenvector(self, request:int, i:int, eigenvector:'vtkDoubleArray') -> None: ...
    @overload
    def GetEigenvectors(self, request:int, eigenvectors:'vtkDoubleArray') -> None: ...
    @overload
    def GetEigenvectors(self, eigenvectors:'vtkDoubleArray') -> None: ...
    def GetFixedBasisEnergy(self) -> float: ...
    def GetFixedBasisEnergyMaxValue(self) -> float: ...
    def GetFixedBasisEnergyMinValue(self) -> float: ...
    def GetFixedBasisSize(self) -> int: ...
    def GetNormalizationScheme(self) -> int: ...
    def GetNormalizationSchemeName(self, scheme:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpecifiedNormalization(self) -> 'vtkTable': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPCAStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPCAStatistics': ...
    def SetBasisScheme(self, _arg:int) -> None: ...
    def SetBasisSchemeByName(self, schemeName:str) -> None: ...
    def SetFixedBasisEnergy(self, _arg:float) -> None: ...
    def SetFixedBasisSize(self, _arg:int) -> None: ...
    def SetNormalizationScheme(self, _arg:int) -> None: ...
    def SetNormalizationSchemeByName(self, schemeName:str) -> None: ...
    def SetParameter(self, parameter:str, index:int, value:'vtkVariant') -> bool: ...
    def SetSpecifiedNormalization(self, __a:'vtkTable') -> None: ...

class vtkStrahlerMetric(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    max_strahler:'getset_descriptor'
    metric_array_name:'getset_descriptor'
    normalize:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMaxStrahler(self) -> float: ...
    def GetNormalize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStrahlerMetric': ...
    def NormalizeOff(self) -> None: ...
    def NormalizeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStrahlerMetric': ...
    def SetMetricArrayName(self, _arg:str) -> None: ...
    def SetNormalize(self, _arg:int) -> None: ...

class vtkStreamingStatistics(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    class InputPorts(int): ...
    class OutputIndices(int): ...
    INPUT_DATA:'InputPorts'
    INPUT_MODEL:'InputPorts'
    LEARN_PARAMETERS:'InputPorts'
    OUTPUT_DATA:'OutputIndices'
    OUTPUT_MODEL:'OutputIndices'
    OUTPUT_TEST:'OutputIndices'
    statistics_algorithm:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamingStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamingStatistics': ...
    def SetStatisticsAlgorithm(self, __a:'vtkStatisticsAlgorithm') -> None: ...

