"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.CLOUDFRONT_ZONE_ID,
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRmcm9udC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZGZyb250LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUdBOztHQUVHO0FBQ0gsTUFBYSxnQkFBZ0I7SUFPM0IsWUFBNkIsWUFBa0Q7UUFBbEQsaUJBQVksR0FBWixZQUFZLENBQXNDO0lBQy9FLENBQUM7SUFFTSxJQUFJLENBQUMsT0FBMkI7UUFDckMsT0FBTztZQUNMLFlBQVksRUFBRSxnQkFBZ0IsQ0FBQyxrQkFBa0I7WUFDakQsT0FBTyxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVTtTQUN0QyxDQUFDO0lBQ0osQ0FBQzs7QUFmSCw0Q0FnQkM7QUFmQzs7O0dBR0c7QUFDb0IsbUNBQWtCLEdBQUcsZ0JBQWdCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuXG4vKipcbiAqIFVzZSBhIENsb3VkRnJvbnQgRGlzdHJpYnV0aW9uIGFzIGFuIGFsaWFzIHJlY29yZCB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIENsb3VkRnJvbnRUYXJnZXQgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gIC8qKlxuICAgKiBUaGUgaG9zdGVkIHpvbmUgSWQgaWYgdXNpbmcgYW4gYWxpYXMgcmVjb3JkIGluIFJvdXRlNTMuXG4gICAqIFRoaXMgdmFsdWUgbmV2ZXIgY2hhbmdlcy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURGUk9OVF9aT05FX0lEID0gJ1oyRkRUTkRBVEFRWVcyJztcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRpc3RyaWJ1dGlvbjogY2xvdWRmcm9udC5DbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaG9zdGVkWm9uZUlkOiBDbG91ZEZyb250VGFyZ2V0LkNMT1VERlJPTlRfWk9ORV9JRCxcbiAgICAgIGRuc05hbWU6IHRoaXMuZGlzdHJpYnV0aW9uLmRvbWFpbk5hbWUsXG4gICAgfTtcbiAgfVxufVxuIl19