"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target
 */
class UserPoolDomainTarget {
    constructor(domain) {
        this.domain = domain;
    }
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.CLOUDFRONT_ZONE_ID,
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUEsMkRBQXVEO0FBRXZEOztHQUVHO0FBQ0gsTUFBYSxvQkFBb0I7SUFDL0IsWUFBNkIsTUFBc0I7UUFBdEIsV0FBTSxHQUFOLE1BQU0sQ0FBZ0I7SUFDbkQsQ0FBQztJQUVNLElBQUksQ0FBQyxPQUFtQjtRQUM3QixPQUFPO1lBQ0wsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsb0JBQW9CO1lBQ3pDLFlBQVksRUFBRSxvQ0FBZ0IsQ0FBQyxrQkFBa0I7U0FDbEQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQVZELG9EQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVXNlclBvb2xEb21haW4gfSBmcm9tICdAYXdzLWNkay9hd3MtY29nbml0byc7XG5pbXBvcnQgeyBBbGlhc1JlY29yZFRhcmdldENvbmZpZywgSUFsaWFzUmVjb3JkVGFyZ2V0LCBJUmVjb3JkU2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ2xvdWRGcm9udFRhcmdldCB9IGZyb20gJy4vY2xvdWRmcm9udC10YXJnZXQnO1xuXG4vKipcbiAqIFVzZSBhIHVzZXIgcG9vbCBkb21haW4gYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgVXNlclBvb2xEb21haW5UYXJnZXQgaW1wbGVtZW50cyBJQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRvbWFpbjogVXNlclBvb2xEb21haW4pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IElSZWNvcmRTZXQpOiBBbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRuc05hbWU6IHRoaXMuZG9tYWluLmNsb3VkRnJvbnREb21haW5OYW1lLFxuICAgICAgaG9zdGVkWm9uZUlkOiBDbG91ZEZyb250VGFyZ2V0LkNMT1VERlJPTlRfWk9ORV9JRCxcbiAgICB9O1xuICB9XG59XG4iXX0=