import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant#enable_multiple_grants IntegrationGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant#id IntegrationGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the integration; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant#integration_name IntegrationGrant#integration_name}
    */
    readonly integrationName: string;
    /**
    * The privilege to grant on the integration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant#privilege IntegrationGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant#roles IntegrationGrant#roles}
    */
    readonly roles?: string[];
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant#with_grant_option IntegrationGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant snowflake_integration_grant}
*/
export declare class IntegrationGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_integration_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/integration_grant snowflake_integration_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationGrantConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationGrantConfig);
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationName?;
    get integrationName(): string;
    set integrationName(value: string);
    get integrationNameInput(): string | undefined;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
