# Generated by Django 4.2.16 on 2024-12-05 14:02

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('learning_paths', '0004_auto_20240207_1633'),
    ]

    operations = [
        migrations.AddField(
            model_name='learningpathstep',
            name='weight',
            field=models.FloatField(default=1.0, help_text="Weight of this course in the learning path's aggregate grade.Specify as a floating point number between 0 and 1, where 1 represents 100%.", validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(1.0)]),
        ),
        migrations.CreateModel(
            name='LearningPathGradingCriteria',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('required_completion', models.FloatField(default=0.8, help_text='The minimum average completion (0.0-1.0) across all steps in the learning path required to mark it as completed.')),
                ('required_grade', models.FloatField(default=0.75, help_text='Minimum weighted arithmetic mean grade (0.0-1.0) required across all steps to pass this learning path. The weight of each step is determined by its `weight` field.')),
                ('learning_path', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='grading_criteria', to='learning_paths.learningpath')),
            ],
        ),
    ]
