# Generated by Django 4.2.16 on 2025-03-12 13:08

from django.db import migrations, models
import learning_paths.keys
import uuid


def set_keys_from_uuids(apps, schema_editor):
    """
    Assign unique keys to existing learning paths based on their UUIDs.
    """
    LearningPath = apps.get_model("learning_paths", "LearningPath")

    for learning_path in LearningPath.objects.all():
        key_str = f"path-v1:test+test+test+{learning_path.uuid}"
        learning_path.key = learning_paths.keys.LearningPathKey.from_string(key_str)
        learning_path.save(update_fields=["key"])


def reverse_migration(apps, schema_editor):
    """
    No reverse operation needed
    """
    pass


class Migration(migrations.Migration):
    dependencies = [
        ("learning_paths", "0006_enrollment_models"),
    ]

    operations = [
        migrations.AddField(
            model_name="learningpath",
            name="key",
            field=learning_paths.keys.LearningPathKeyField(
                db_index=True,
                help_text="Unique identifier for this Learning Path.<br/>It must follow the format: <i>path-v1:{org}+{number}+{run}+{group}</i>.",
                max_length=255,
                null=True,  # Temporarily allow nulls.
                unique=False,  # Temporarily allow non-unique keys.
            ),
            preserve_default=False,
        ),
        migrations.RunPython(set_keys_from_uuids, reverse_migration),
        migrations.AlterField(
            model_name="learningpath",
            name="key",
            field=learning_paths.keys.LearningPathKeyField(
                db_index=True,
                help_text="Unique identifier for this Learning Path.<br/>It must follow the format: <i>path-v1:{org}+{number}+{run}+{group}</i>.",
                max_length=255,
                unique=True,
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="learningpath",
            name="uuid",
            field=models.UUIDField(
                blank=True,
                default=uuid.uuid4,
                editable=False,
                help_text="Legacy identifier for compatibility with Course Discovery.",
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="learningpath",
            name="sequential",
            field=models.BooleanField(
                default=False,
                help_text="Whether the courses in this Learning Path are meant to be taken sequentially.",
                verbose_name="Is sequential",
            ),
        ),
    ]
