# Generated by Django 4.2.20 on 2025-05-26 16:31

from django.conf import settings
from django.db import migrations, models
import django.utils.timezone
import model_utils.fields


def delete_historical_model_if_exists(apps, schema_editor):
    """Delete HistoricalLearningPathEnrollment model if it exists."""
    try:
        HistoricalLearningPathEnrollment = apps.get_model(
            "learning_paths", "HistoricalLearningPathEnrollment"
        )
        schema_editor.delete_model(HistoricalLearningPathEnrollment)
    except LookupError:
        # Model doesn't exist in Django's registry, skip deletion
        pass


def reverse_delete_historical_model(apps, schema_editor):
    """Reverse operation - this is a no-op since we cannot recreate the model."""
    pass


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("learning_paths", "0012_alter_learningpath_subtitle"),
    ]

    operations = [
        migrations.RunPython(
            delete_historical_model_if_exists, reverse_delete_historical_model
        ),
        migrations.AddField(
            model_name="learningpathenrollmentallowed",
            name="created",
            field=model_utils.fields.AutoCreatedField(
                default=django.utils.timezone.now,
                editable=False,
                verbose_name="created",
            ),
        ),
        migrations.AddField(
            model_name="learningpathenrollmentallowed",
            name="modified",
            field=model_utils.fields.AutoLastModifiedField(
                default=django.utils.timezone.now,
                editable=False,
                verbose_name="modified",
            ),
        ),
        migrations.AlterField(
            model_name="learningpathenrollmentallowed",
            name="email",
            field=models.EmailField(db_index=True, max_length=254),
        ),
        migrations.CreateModel(
            name="LearningPathEnrollmentAudit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "state_transition",
                    models.CharField(
                        choices=[
                            (
                                "from unenrolled to allowed to enroll",
                                "from unenrolled to allowed to enroll",
                            ),
                            (
                                "from allowed to enroll to enrolled",
                                "from allowed to enroll to enrolled",
                            ),
                            ("from enrolled to enrolled", "from enrolled to enrolled"),
                            (
                                "from enrolled to unenrolled",
                                "from enrolled to unenrolled",
                            ),
                            (
                                "from unenrolled to enrolled",
                                "from unenrolled to enrolled",
                            ),
                            (
                                "from allowed to enroll to unenrolled",
                                "from allowed to enroll to unenrolled",
                            ),
                            (
                                "from unenrolled to unenrolled",
                                "from unenrolled to unenrolled",
                            ),
                            ("N/A", "N/A"),
                        ],
                        default="N/A",
                        max_length=255,
                    ),
                ),
                ("reason", models.TextField(blank=True)),
                ("org", models.CharField(blank=True, db_index=True, max_length=255)),
                ("role", models.CharField(blank=True, max_length=255)),
                (
                    "enrolled_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="learning_path_audit",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "enrollment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="audit",
                        to="learning_paths.learningpathenrollment",
                    ),
                ),
                (
                    "enrollment_allowed",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="audit",
                        to="learning_paths.learningpathenrollmentallowed",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="learningpathenrollmentallowed",
            name="is_active",
            field=models.BooleanField(
                db_index=True, default=True, help_text="Indicates if the enrollment allowance is active"
            ),
        ),
        migrations.RemoveField(
            model_name="learningpathenrollment",
            name="enrolled_at",
        ),
    ]
