# Generated by Django 4.2.20 on 2025-07-14 13:10

from django.db import migrations, models


def transfer_duration_data(apps, schema_editor):
    """Transfer duration_in_days values to duration field with '{x} days' format."""
    LearningPath = apps.get_model("learning_paths", "LearningPath")

    for learning_path in LearningPath.objects.filter(duration_in_days__isnull=False):
        learning_path.duration = f"{learning_path.duration_in_days} days"
        learning_path.save()


def reverse_transfer_duration_data(apps, schema_editor):
    """Reverse operation: extract numeric values from duration field back to duration_in_days."""
    LearningPath = apps.get_model("learning_paths", "LearningPath")

    for learning_path in LearningPath.objects.filter(duration__endswith=" days"):
        try:
            days_str = learning_path.duration.replace(" days", "")
            learning_path.duration_in_days = int(days_str)
            learning_path.save()
        except ValueError:
            # Skip entries that don't match the expected format.
            pass


class Migration(migrations.Migration):
    dependencies = [
        ("learning_paths", "0013_enrollment_audit"),
    ]

    operations = [
        migrations.AddField(
            model_name="learningpath",
            name="duration",
            field=models.CharField(
                blank=True,
                help_text="Approximate time it should take to complete this Learning Path. Example: '10 Weeks'.",
                max_length=255,
            ),
        ),
        migrations.AddField(
            model_name="learningpath",
            name="time_commitment",
            field=models.CharField(
                blank=True, help_text="Approximate time commitment. Example: '4-6 hours/week'.", max_length=255
            ),
        ),
        migrations.RunPython(
            transfer_duration_data,
            reverse_transfer_duration_data,
        ),
        migrations.RemoveField(
            model_name="learningpath",
            name="duration_in_days",
        ),
    ]
