# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-common-sql",
        "name": "Common SQL",
        "description": "`Common SQL Provider <https://en.wikipedia.org/wiki/SQL>`__\n",
        "suspended": False,
        "versions": [
            "1.5.0",
            "1.4.0",
            "1.3.4",
            "1.3.3",
            "1.3.2",
            "1.3.1",
            "1.3.0",
            "1.2.0",
            "1.1.0",
            "1.0.0",
        ],
        "dependencies": ["sqlparse>=0.4.2"],
        "additional-extras": [{"name": "pandas", "dependencies": ["pandas>=0.17.1"]}],
        "integrations": [
            {
                "integration-name": "Common SQL",
                "external-doc-url": "https://en.wikipedia.org/wiki/SQL",
                "how-to-guide": ["/docs/apache-airflow-providers-common-sql/operators.rst"],
                "logo": "/integration-logos/common/sql/sql.png",
                "tags": ["software"],
            }
        ],
        "operators": [
            {
                "integration-name": "Common SQL",
                "python-modules": ["airflow.providers.common.sql.operators.sql"],
            }
        ],
        "hooks": [
            {"integration-name": "Common SQL", "python-modules": ["airflow.providers.common.sql.hooks.sql"]}
        ],
        "sensors": [
            {"integration-name": "Common SQL", "python-modules": ["airflow.providers.common.sql.sensors.sql"]}
        ],
    }
