##############################################################################
#
# Copyright (c) 2002 Zope Foundation and Contributors.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

from six import reraise
from zope.deferredimport import deprecated


# BBB Zope 5.0
deprecated(
    'Please import from zExceptions.',
    NotFound='zExceptions:NotFound',
    BadRequest='zExceptions:BadRequest',
    InternalError='zExceptions:InternalError',
    Forbidden='zExceptions:Forbidden',
)


class Retry(Exception):
    """Raise this to retry a request
    """

    def __init__(self, t=None, v=None, tb=None):
        self._args = t, v, tb

    def reraise(self):
        t, v, tb = self._args
        if t is None:
            t = Retry
        if tb is None:
            raise t(v)
        try:
            reraise(t, v, tb)
        finally:
            tb = None
