# -*- coding: utf-8 -*-

"""
    my_countries_api_1234567

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from my_countries_api_1234567.api_helper import APIHelper
from my_countries_api_1234567.configuration import Configuration
from my_countries_api_1234567.controllers.base_controller import BaseController
from my_countries_api_1234567.models.country_response import CountryResponse

class CountriesController(BaseController):

    """A Controller to access Endpoints in the my_countries_api_1234567 API."""


    def get_countries(self):
        """Does a GET request to /countries.

        This endpoint let user to access countries code and name.

        Returns:
            CountryResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/countries'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, CountryResponse.from_dictionary)
