"""Lookup tables
"""

'''def get_sic_nr()

    lu_tabe = industrydemand_name_sic2007()'''
def economic_sectors_regional_MISTRAL():
    """
    Reginal sector ID with description from
    economic_sectors_regiona.csv of MISTRAl
    population/economic simuations

    match_int: Integer of GVA input
    """
    lookup_dict = {

        # Industry sectors
        # ---------------
        'mining':	                        {'match_int': 2, 'description': "Mining & quarrying"},
        'food_production':	                {'match_int': 3, 'description': "Food, drink & tobacco"},
        'tobacco':                          {'match_int': 3, 'description': "Food, drink & tobacco"},
        'textiles':	                        {'match_int': 4, 'description': "Textiles etc"},
        'wood':	                            {'match_int': 5, 'description': "Wood & paper"},
        'paper':	                        {'match_int': 5, 'description': "Wood & paper"},
        'printing':	                        {'match_int': 6, 'description': "Printing & recording"},
        'chemicals':	                    {'match_int': 8, 'description': "Chemicals, etc"},
        'pharmaceuticals':	                {'match_int': 9, 'description': "Pharmaceuticals"},
        'beverages':	                    {'match_int': 29, 'description': "Food & beverage services"},
        'fabricated_metal_products':	    {'match_int': 11, 'description': "Metals & metal prods"},
        'electrical_equipment':	            {'match_int': 12, 'description': "Electronics"},
        'non_metallic_mineral_products':	{'match_int': 10, 'description': "Non-metallic min. prods."},
        'motor_vehicles':	                {'match_int': 15, 'description': "Motor vehicles, etc"},
        'machinery':	                    {'match_int': 14, 'description': "Machinery, etc"},
        'waste_collection':	                {'match_int': 19, 'description': "Water, sewerage & waste"},
        'water_collection_treatment':	    {'match_int': 19, 'description': "Water, sewerage & waste"},
        'other_manufacturing':	            {'match_int': 17, 'description': "Other manuf. & repair"},

        # Not classified industrial GVA
        # -----------------------------
        #wearing_appeal
        #leather
        #rubber_plastics
        #basic_metals
        #computer
        #other_transport_equipment
        #furniture

        # Service sectors
        # ---------------
        'education':	                    {'match_int': 40, 'description': "Education"},
        'health':	                        {'match_int': 41, 'description': "Health"},
        'hospitality':	                    {'match_int': 28, 'description': "Accomodation"},
        'offices':	                        {'match_int': 35, 'description': "Head offices & manag. cons."},
        'retail':	                        {'match_int': 23, 'description': "Retail trade"},
        'storage':	                        {'match_int': 27, 'description': "Warehousing & postal"},

        # Not classified industrial GVA
        # -----------------------------
        # emergency_services
        # military
        # community_arts_leisure

        #'':	{'match_int': 7, 'description': "Coke & petroleum"},
        #'':	{'match_int': 13, 'description': "Electrical equipment"},
        #'':	{'match_int': 16, 'description': "Other trans. equipment"},
        #'':	{'match_int': 18, 'description': "Electricity & gas"},
        #'':	{'match_int': 20, 'description': "Construction"},
        #'':	{'match_int': 21, 'description': "Motor vehicles trade"},
        #'':	{'match_int': 22, 'description': "Wholesale trade"},
        #'':	{'match_int': 24, 'description': "Land transport"},
        #'':	{'match_int': 25, 'description': "Water transport"},
        #'':	{'match_int': 26, 'description': "Air transport"},
        #'':	{'match_int': 30, 'description': "Media"},
        #'':	{'match_int': 31, 'description': "IT services"},
        #'':	{'match_int': 32, 'description': "Financial & insurance"},
        #'':	{'match_int': 33, 'description': "Real estate"},
        #'':	{'match_int': 34, 'description': "Legal & accounting"},
        #'':	{'match_int': 39, 'description': "PAD"},
        #'':	{'match_int': 42, 'description': "Residential & social"},
        #'':	{'match_int': 43, 'description': "Arts"},
        #'':	{'match_int': 44, 'description': "Recreational services"},
        #'':	{'match_int': 45, 'description': "Other services"},
        #'':	{'match_int': 46, 'description': "Unallocated"},
        #'':	{'match_int': 37, 'description': "Other professional services"},
        #'':	{'match_int': 36, 'description': "Archit. & engin. services"},
        #'':	{'match_int': 38, 'description': "Business support services"},
        #'':	{'match_int': 1, 'description': "Agriculture etc"}
    }

    return lookup_dict

def industrydemand_name_sic2007():
    """Lookup table of industry energy demands and SIC letter and number

    Return
    ------
    lookup : dict
        name_used_in_model: {'SIC_2007_nr', 'SIC_2007_letter}
    Info
    ----
    https://unstats.un.org/unsd/cr/registry/regcst.asp?Cl=27
    """
    lookup = {
        'mining': {
            'sic_2007_nr': 8,
            'sic_2007_letter': 'B'},
        'food_production': {
            'sic_2007_nr': 10,
            'sic_2007_letter': 'C'},
        'beverages': {
            'sic_2007_nr': 11,
            'sic_2007_letter':'C'},
        'tobacco': {
            'sic_2007_nr': 12,
            'sic_2007_letter':'C'},
        'textiles': {
            'sic_2007_nr': 13,
            'sic_2007_letter': 'C'},
        'wearing_appeal': {
            'sic_2007_nr': 14,
            'sic_2007_letter': 'C'},
        'leather': {
            'sic_2007_nr': 15,
            'sic_2007_letter': 'C'},
        'wood': {
            'sic_2007_nr': 16,
            'sic_2007_letter': 'C'},
        'paper': {
            'sic_2007_nr': 17,
            'sic_2007_letter': 'C'},
        'printing': {
            'sic_2007_nr': 18,
            'sic_2007_letter': 'C'},
        'chemicals': {
            'sic_2007_nr': 20,
            'sic_2007_letter': 'C'},
        'pharmaceuticals': {
            'sic_2007_nr': 21,
            'sic_2007_letter': 'C'},
        'rubber_plastics': {
            'sic_2007_nr': 22,
            'sic_2007_letter': 'C'},
        'non_metallic_mineral_products': {
            'sic_2007_nr': 23,
            'sic_2007_letter': 'C'},
        'basic_metals': {
            'sic_2007_nr': 24,
            'sic_2007_letter': 'C'},
        'fabricated_metal_products': {
            'sic_2007_nr': 25,
            'sic_2007_letter': 'C'},
        'computer': {
            'sic_2007_nr': 26,
            'sic_2007_letter': 'C'},
        'electrical_equipment': {
            'sic_2007_nr': 27,
            'sic_2007_letter': 'C'},
        'machinery': {
            'sic_2007_nr': 28,
            'sic_2007_letter': 'C'},
        'motor_vehicles': {
            'sic_2007_nr': 29,
            'sic_2007_letter': 'C'},
        'other_transport_equipment': {
            'sic_2007_nr': 30,
            'sic_2007_letter': 'C'},
        'furniture': {
            'sic_2007_nr': 31,
            'sic_2007_letter': 'C'},
        'other_manufacturing': {
            'sic_2007_nr': 32,
            'sic_2007_letter': 'C'},
        'water_collection_treatment': {
            'sic_2007_nr': 36,
            'sic_2007_letter': 'E'},
        'waste_collection': {
            'sic_2007_nr': 38,
            'sic_2007_letter': 'E'}}

    return lookup

def basic_lookups():
    """Definition of basic lookup tables

    Return
    ------
    lookups : dict
        Lookup information
    """
    lookups = {}

    # Specify all submodels
    lookups['submodels_names'] = [
        'residential',
        'service',
        'industry']

    # Assign BESI categories to merged AddressPoint dataset
    lookups['building_cnt_lu'] = {
        "commercial_General": 1,
        "primary_Industry": 2,
        "public_Services": 3,
        "education": 4,
        "hospitality": 5,
        "community_arts_leisure": 6,
        "industrial": 7,
        "health": 8,
        "offices": 9,
        "retail": 10,
        "storage": 11,
        "residential": 12,
        "military": 13,
        'emergency_services': 8,
        'other': 14}

    lookups['dwtype'] = {
        0: 'detached',
        1: 'semi_detached',
        2: 'terraced',
        3: 'flat',
        4: 'bungalow'}

    lookups['fueltypes'] = {
        'solid_fuel': 0,
        'gas': 1,
        'electricity': 2,
        'oil': 3,
        'biomass': 4,
        'hydrogen': 5,
        'heat': 6}

    lookups['fueltypes_nr'] = int(len(lookups['fueltypes']))

    return lookups

def lad_msoa_mapping():
    """Map between lad and msoa

    {LAD: [MOAS]}
    """
    msoa_lad_map = {
        'E06000047': ['E02004297', 'E02004290', 'E02004298', 'E02004299', 'E02004291', 'E02004300', 'E02004292', 'E02004301', 'E02004302', 'E02004303', 'E02004293', 'E02004304', 'E02004294', 'E02004305', 'E02004295', 'E02004320', 'E02004321', 'E02004322', 'E02004296', 'E02004306', 'E02004323', 'E02004308', 'E02004309', 'E02004307', 'E02004324', 'E02004310', 'E02004311', 'E02004312', 'E02004313', 'E02004314', 'E02004316', 'E02004325', 'E02004315', 'E02004326', 'E02004328', 'E02004327', 'E02004329', 'E02004317', 'E02004330', 'E02004331', 'E02004318', 'E02004348', 'E02004332', 'E02004319', 'E02004349', 'E02004350', 'E02004333', 'E02004334', 'E02004335', 'E02004336', 'E02004351', 'E02004337', 'E02004338', 'E02004339', 'E02004352', 'E02004353', 'E02004354', 'E02004355', 'E02004340', 'E02004341', 'E02004342', 'E02004343', 'E02004344', 'E02004345', 'E02004346', 'E02004347'], 
        'E06000005': ['E02002559', 'E02002560', 'E02002561', 'E02002562', 'E02002563', 'E02002564', 'E02002565', 'E02002566', 'E02002567', 'E02002568', 'E02002569', 'E02002570', 'E02002571', 'E02002572', 'E02002573'], 
        'E06000001': ['E02002483', 'E02002484', 'E02002485', 'E02002487', 'E02002488', 'E02002489', 'E02002490', 'E02002491', 'E02002492', 'E02002493', 'E02002494', 'E02006909'], 
        'E06000002': ['E02002496', 'E02002497', 'E02002498', 'E02002499', 'E02002500', 'E02002501', 'E02002502', 'E02002503', 'E02002504', 'E02002505', 'E02002506', 'E02002507', 'E02002508', 'E02002509', 'E02002510', 'E02002512', 'E02002513', 'E02002514', 'E02006811'], 
        'E06000057': ['E02005706', 'E02005707', 'E02005708', 'E02005702', 'E02005703', 'E02005704', 'E02005705', 'E02005720', 'E02005734', 'E02005735', 'E02005721', 'E02005737', 'E02005736', 'E02005738', 'E02005722', 'E02005723', 'E02005739', 'E02005724', 'E02005727', 'E02005740', 'E02005741', 'E02005709', 'E02005710', 'E02005711', 'E02005712', 'E02005713', 'E02005714', 'E02005716', 'E02005715', 'E02005717', 'E02005718', 'E02005719', 'E02005725', 'E02005726', 'E02005730', 'E02005729', 'E02005728', 'E02005731', 'E02005732', 'E02005733'], 
        'E06000003': ['E02002515', 'E02002516', 'E02002517', 'E02002518', 'E02002519', 'E02002520', 'E02002521', 'E02002523', 'E02002524', 'E02002525', 'E02002526', 'E02002527', 'E02002529', 'E02002530', 'E02002532', 'E02002533', 'E02002534', 'E02006812', 'E02006910'], 
        'E06000004': ['E02002535', 'E02002536', 'E02002537', 'E02002538', 'E02002539', 'E02002540', 'E02002541', 'E02002542', 'E02002543', 'E02002544', 'E02002545', 'E02002546', 'E02002547', 'E02002548', 'E02002549', 'E02002550', 'E02002551', 'E02002552', 'E02002553', 'E02002554', 'E02002555', 'E02002556', 'E02002557', 'E02002558'], 
        'E08000037': ['E02001682', 'E02001683', 'E02001684', 'E02001685', 'E02001686', 'E02001688', 'E02001689', 'E02001690', 'E02001691', 'E02001692', 'E02001693', 'E02001694', 'E02001695', 'E02001696', 'E02001697', 'E02001698', 'E02001699', 'E02001700', 'E02001701', 'E02001702', 'E02001703', 'E02001704', 'E02001705', 'E02001706', 'E02001707', 'E02006841', 'E02006842'], 
        'E08000021': ['E02001708', 'E02001709', 'E02001710', 'E02001711', 'E02001712', 'E02001713', 'E02001714', 'E02001715', 'E02001718', 'E02001719', 'E02001720', 'E02001721', 'E02001722', 'E02001723', 'E02001724', 'E02001725', 'E02001726', 'E02001727', 'E02001728', 'E02001729', 'E02001730', 'E02001731', 'E02001732', 'E02001733', 'E02001734', 'E02001735', 'E02001736', 'E02001737', 'E02006893'], 
        'E08000022': ['E02001738', 'E02001739', 'E02001740', 'E02001741', 'E02001742', 'E02001743', 'E02001744', 'E02001745', 'E02001746', 'E02001747', 'E02001748', 'E02001749', 'E02001750', 'E02001751', 'E02001752', 'E02001753', 'E02001754', 'E02001755', 'E02001756', 'E02001757', 'E02001758', 'E02001759', 'E02001760', 'E02001761', 'E02001762', 'E02001763', 'E02001764', 'E02001765', 'E02001766', 'E02001767'], 
        'E08000023': ['E02001768', 'E02001769', 'E02001770', 'E02001771', 'E02001772', 'E02001773', 'E02001774', 'E02001775', 'E02001776', 'E02001777', 'E02001778', 'E02001779', 'E02001780', 'E02001781', 'E02001782', 'E02001783', 'E02001784', 'E02001785', 'E02001786', 'E02001787', 'E02001788', 'E02001789', 'E02001790'], 
        'E08000024': ['E02001791', 'E02001792', 'E02001793', 'E02001794', 'E02001795', 'E02001796', 'E02001797', 'E02001798', 'E02001799', 'E02001800', 'E02001801', 'E02001802', 'E02001803', 'E02001804', 'E02001805', 'E02001806', 'E02001807', 'E02001808', 'E02001809', 'E02001810', 'E02001811', 'E02001812', 'E02001813', 'E02001814', 'E02001815', 'E02001816', 'E02001817', 'E02001818', 'E02001819', 'E02001820', 'E02001821', 'E02001822', 'E02001823', 'E02001824', 'E02001825', 'E02001826'], 
        'E06000008': ['E02002615', 'E02002616', 'E02002617', 'E02002618', 'E02002619', 'E02002620', 'E02002621', 'E02002622', 'E02002623', 'E02002624', 'E02002625', 'E02002626', 'E02002627', 'E02002628', 'E02002629', 'E02002630', 'E02002631', 'E02002632'], 
        'E06000009': ['E02002633', 'E02002634', 'E02002635', 'E02002636', 'E02002637', 'E02002638', 'E02002639', 'E02002640', 'E02002641', 'E02002642', 'E02002643', 'E02002644', 'E02002645', 'E02002646', 'E02002647', 'E02002648', 'E02002649', 'E02002650', 'E02002651'], 
        'E06000049': ['E02003853', 'E02003854', 'E02003855', 'E02003856', 'E02003857', 'E02003858', 'E02003859', 'E02003860', 'E02003861', 'E02003863', 'E02003862', 'E02003864', 'E02003865', 'E02003866', 'E02003867', 'E02003868', 'E02003869', 'E02003870', 'E02003871', 'E02003872', 'E02003873', 'E02003811', 'E02003812', 'E02003813', 'E02003814', 'E02003815', 'E02003816', 'E02003817', 'E02003818', 'E02003819', 'E02003820', 'E02003821', 'E02003822', 'E02003825', 'E02003826', 'E02003827', 'E02003828', 'E02003829', 'E02003830', 'E02003823', 'E02003831', 'E02003824', 'E02003832', 'E02003833', 'E02003834', 'E02003835', 'E02003836', 'E02003838', 'E02003837', 'E02003839', 'E02003840'], 
        'E06000050': ['E02003841', 'E02003874', 'E02003875', 'E02003842', 'E02003843', 'E02003844', 'E02003845', 'E02003846', 'E02003847', 'E02003848', 'E02003849', 'E02003876', 'E02003850', 'E02003851', 'E02003877', 'E02003852', 'E02003878', 'E02003879', 'E02003880', 'E02003881', 'E02003882', 'E02003794', 'E02003883', 'E02003884', 'E02003795', 'E02003885', 'E02003796', 'E02003797', 'E02003798', 'E02003800', 'E02003799', 'E02003801', 'E02003802', 'E02003803', 'E02003886', 'E02003804', 'E02003887', 'E02003888', 'E02003805', 'E02003889', 'E02003806', 'E02003890', 'E02003807', 'E02003808', 'E02003891', 'E02003809', 'E02003810'], 
        'E06000006': ['E02002574', 'E02002575', 'E02002576', 'E02002577', 'E02002578', 'E02002579', 'E02002580', 'E02002581', 'E02002582', 'E02002583', 'E02002584', 'E02002585', 'E02002586', 'E02002587', 'E02002588', 'E02002589'], 
        'E06000007': ['E02002590', 'E02002591', 'E02002592', 'E02002593', 'E02002594', 'E02002595', 'E02002596', 'E02002597', 'E02002598', 'E02002599', 'E02002600', 'E02002601', 'E02002602', 'E02002603', 'E02002604', 'E02002605', 'E02002606', 'E02002607', 'E02002608', 'E02002609', 'E02002610', 'E02002611', 'E02002612', 'E02002613', 'E02002614'], 
        'E07000026': ['E02003965', 'E02003966', 'E02003967', 'E02003968', 'E02003969', 'E02003970', 'E02003971', 'E02003972', 'E02003973', 'E02003974', 'E02003975', 'E02003976'], 
        'E07000027': ['E02003977', 'E02003978', 'E02003979', 'E02003980', 'E02003981', 'E02003982', 'E02003983', 'E02003984', 'E02003985', 'E02003986'], 
        'E07000028': ['E02003987', 'E02003988', 'E02003989', 'E02003990', 'E02003991', 'E02003992', 'E02003993', 'E02003994', 'E02003995', 'E02003996', 'E02003997', 'E02003998', 'E02003999'], 
        'E07000029': ['E02004000', 'E02004001', 'E02004002', 'E02004003', 'E02004004', 'E02004005', 'E02004006', 'E02004007'], 
        'E07000030': ['E02004008', 'E02004009', 'E02004010', 'E02004011', 'E02004012', 'E02004013', 'E02004014'], 
        'E07000031': ['E02004015', 'E02004016', 'E02004017', 'E02004018', 'E02004019', 'E02004020', 'E02004021', 'E02004022', 'E02004023', 'E02004024', 'E02004025', 'E02004026', 'E02004027', 'E02004028'], 
        'E08000001': ['E02000984', 'E02000985', 'E02000986', 'E02000987', 'E02000988', 'E02000989', 'E02000990', 'E02000991', 'E02000992', 'E02000993', 'E02000994', 'E02000995', 'E02000996', 'E02000997', 'E02000998', 'E02000999', 'E02001000', 'E02001001', 'E02001002', 'E02001003', 'E02001004', 'E02001005', 'E02001006', 'E02001007', 'E02001008', 'E02001009', 'E02001010', 'E02001011', 'E02001012', 'E02001013', 'E02001014', 'E02001015', 'E02001016', 'E02001017', 'E02001018'], 
        'E08000002': ['E02001019', 'E02001020', 'E02001021', 'E02001022', 'E02001023', 'E02001024', 'E02001025', 'E02001026', 'E02001027', 'E02001028', 'E02001029', 'E02001030', 'E02001031', 'E02001032', 'E02001033', 'E02001034', 'E02001035', 'E02001036', 'E02001037', 'E02001038', 'E02001039', 'E02001040', 'E02001041', 'E02001042', 'E02001043', 'E02001044'], 
        'E08000003': ['E02001045', 'E02001046', 'E02001047', 'E02001048', 'E02001049', 'E02001050', 'E02001051', 'E02001052', 'E02001053', 'E02001055', 'E02001056', 'E02001057', 'E02001059', 'E02001061', 'E02001062', 'E02001063', 'E02001064', 'E02001065', 'E02001066', 'E02001067', 'E02001068', 'E02001069', 'E02001070', 'E02001071', 'E02001072', 'E02001073', 'E02001074', 'E02001075', 'E02001076', 'E02001077', 'E02001078', 'E02001079', 'E02001080', 'E02001081', 'E02001082', 'E02001083', 'E02001084', 'E02001085', 'E02001086', 'E02001087', 'E02001088', 'E02001089', 'E02001090', 'E02001091', 'E02001092', 'E02001093', 'E02001094', 'E02001095', 'E02001096', 'E02001097', 'E02006902', 'E02006912', 'E02006913', 'E02006914', 'E02006915', 'E02006916', 'E02006917'], 
        'E08000004': ['E02001098', 'E02001099', 'E02001100', 'E02001101', 'E02001102', 'E02001103', 'E02001104', 'E02001105', 'E02001106', 'E02001107', 'E02001108', 'E02001109', 'E02001110', 'E02001111', 'E02001112', 'E02001113', 'E02001114', 'E02001115', 'E02001116', 'E02001117', 'E02001118', 'E02001119', 'E02001121', 'E02001123', 'E02001124', 'E02001125', 'E02001126', 'E02001127', 'E02001128', 'E02001129', 'E02001130', 'E02001131', 'E02006860'], 
        'E08000005': ['E02001132', 'E02001133', 'E02001134', 'E02001135', 'E02001136', 'E02001137', 'E02001138', 'E02001139', 'E02001140', 'E02001141', 'E02001142', 'E02001143', 'E02001144', 'E02001145', 'E02001146', 'E02001147', 'E02001148', 'E02001149', 'E02001150', 'E02001151', 'E02001152', 'E02001153', 'E02001154', 'E02001155', 'E02001156'], 
        'E08000006': ['E02001157', 'E02001158', 'E02001159', 'E02001160', 'E02001161', 'E02001162', 'E02001163', 'E02001164', 'E02001165', 'E02001166', 'E02001167', 'E02001168', 'E02001169', 'E02001170', 'E02001171', 'E02001172', 'E02001173', 'E02001174', 'E02001175', 'E02001176', 'E02001177', 'E02001178', 'E02001179', 'E02001180', 'E02001181', 'E02001182', 'E02001183', 'E02001184', 'E02001185', 'E02001186'], 
        'E08000007': ['E02001187', 'E02001188', 'E02001189', 'E02001190', 'E02001191', 'E02001192', 'E02001193', 'E02001194', 'E02001195', 'E02001196', 'E02001197', 'E02001198', 'E02001199', 'E02001200', 'E02001201', 'E02001202', 'E02001203', 'E02001204', 'E02001205', 'E02001206', 'E02001207', 'E02001208', 'E02001209', 'E02001210', 'E02001211', 'E02001212', 'E02001213', 'E02001214', 'E02001215', 'E02001216', 'E02001217', 'E02001218', 'E02001219', 'E02001220', 'E02001221', 'E02001222', 'E02001223', 'E02001224', 'E02001225', 'E02001226', 'E02001227', 'E02001228'], 
        'E08000008': ['E02001229', 'E02001230', 'E02001231', 'E02001232', 'E02001233', 'E02001234', 'E02001235', 'E02001236', 'E02001237', 'E02001238', 'E02001239', 'E02001240', 'E02001241', 'E02001242', 'E02001243', 'E02001244', 'E02001245', 'E02001246', 'E02001247', 'E02001248', 'E02001249', 'E02001250', 'E02001251', 'E02001252', 'E02001253', 'E02001254', 'E02001255', 'E02001256', 'E02001257', 'E02001258'], 
        'E08000009': ['E02001259', 'E02001260', 'E02001261', 'E02001262', 'E02001263', 'E02001264', 'E02001265', 'E02001266', 'E02001267', 'E02001268', 'E02001269', 'E02001270', 'E02001271', 'E02001272', 'E02001273', 'E02001274', 'E02001275', 'E02001276', 'E02001277', 'E02001278', 'E02001279', 'E02001280', 'E02001281', 'E02001282', 'E02001283', 'E02001284', 'E02001285', 'E02001286'], 
        'E08000010': ['E02001287', 'E02001288', 'E02001289', 'E02001290', 'E02001291', 'E02001292', 'E02001293', 'E02001294', 'E02001295', 'E02001296', 'E02001297', 'E02001298', 'E02001299', 'E02001300', 'E02001301', 'E02001302', 'E02001303', 'E02001304', 'E02001305', 'E02001306', 'E02001307', 'E02001308', 'E02001309', 'E02001310', 'E02001311', 'E02001312', 'E02001313', 'E02001314', 'E02001315', 'E02001316', 'E02001317', 'E02001318', 'E02001319', 'E02001320', 'E02001321', 'E02001322', 'E02001323', 'E02001324', 'E02001325', 'E02001326'], 
        'E07000117': ['E02005176', 'E02005177', 'E02005178', 'E02005179', 'E02005180', 'E02005181', 'E02005182', 'E02005183', 'E02005184', 'E02005185', 'E02005186', 'E02006881'], 
        'E07000118': ['E02005189', 'E02005190', 'E02005191', 'E02005192', 'E02005193', 'E02005194', 'E02005195', 'E02005196', 'E02005197', 'E02005198', 'E02005199', 'E02005200', 'E02005201', 'E02005202'], 
        'E07000119': ['E02005203', 'E02005204', 'E02005205', 'E02005206', 'E02005207', 'E02005208', 'E02005209', 'E02005210', 'E02005211'], 
        'E07000120': ['E02005212', 'E02005213', 'E02005214', 'E02005215', 'E02005216', 'E02005217', 'E02005218', 'E02005219', 'E02005220'], 
        'E07000121': ['E02005221', 'E02005222', 'E02005223', 'E02005224', 'E02005225', 'E02005226', 'E02005228', 'E02005229', 'E02005230', 'E02005231', 'E02005233', 'E02005234', 'E02005235', 'E02005236', 'E02005237', 'E02005238', 'E02005239', 'E02006871'], 
        'E07000122': ['E02005240', 'E02005241', 'E02005242', 'E02005243', 'E02005244', 'E02005245', 'E02005246', 'E02005247', 'E02005248', 'E02005249', 'E02005250', 'E02005251', 'E02005252'], 
        'E07000123': ['E02005253', 'E02005254', 'E02005255', 'E02005256', 'E02005257', 'E02005258', 'E02005259', 'E02005260', 'E02005261', 'E02005262', 'E02005263', 'E02005264', 'E02005265', 'E02005266', 'E02005267', 'E02005268', 'E02005269'], 
        'E07000124': ['E02005270', 'E02005271', 'E02005272', 'E02005273', 'E02005274', 'E02005275', 'E02005276', 'E02005277'], 
        'E07000125': ['E02005278', 'E02005279', 'E02005280', 'E02005281', 'E02005284', 'E02005285', 'E02005286', 'E02006884'], 
        'E07000126': ['E02005287', 'E02005288', 'E02005289', 'E02005290', 'E02005291', 'E02005292', 'E02005293', 'E02005294', 'E02005295', 'E02005296', 'E02005297', 'E02005298', 'E02005299', 'E02005300', 'E02005301', 'E02005302', 'E02005303'], 
        'E07000127': ['E02005304', 'E02005305', 'E02005306', 'E02005307', 'E02005308', 'E02005309', 'E02005310', 'E02005311', 'E02005312', 'E02005313', 'E02005314', 'E02005315', 'E02005316', 'E02005317', 'E02005318'], 
        'E07000128': ['E02005319', 'E02005320', 'E02005321', 'E02005322', 'E02005323', 'E02005324', 'E02005325', 'E02005326', 'E02005327', 'E02005328', 'E02005329', 'E02005330', 'E02005331', 'E02005332'], 
        'E08000011': ['E02001327', 'E02001328', 'E02001329', 'E02001330', 'E02001331', 'E02001332', 'E02001333', 'E02001334', 'E02001335', 'E02001336', 'E02001337', 'E02001338', 'E02001339', 'E02001340', 'E02001341', 'E02001342', 'E02001343', 'E02001344', 'E02001345', 'E02001346'], 
        'E08000012': ['E02001347', 'E02001348', 'E02001349', 'E02001350', 'E02001351', 'E02001352', 'E02001353', 'E02001354', 'E02001355', 'E02001356', 'E02001357', 'E02001358', 'E02001359', 'E02001360', 'E02001361', 'E02001362', 'E02001363', 'E02001364', 'E02001365', 'E02001366', 'E02001367', 'E02001368', 'E02001369', 'E02001370', 'E02001371', 'E02001372', 'E02001373', 'E02001374', 'E02001375', 'E02001376', 'E02001377', 'E02001378', 'E02001380', 'E02001381', 'E02001382', 'E02001383', 'E02001384', 'E02001385', 'E02001386', 'E02001387', 'E02001388', 'E02001389', 'E02001390', 'E02001391', 'E02001392', 'E02001393', 'E02001394', 'E02001395', 'E02001396', 'E02001397', 'E02001398', 'E02001399', 'E02001400', 'E02001401', 'E02001402', 'E02001403', 'E02001404', 'E02001405', 'E02006932', 'E02006933', 'E02006934'], 
        'E08000014': ['E02001429', 'E02001430', 'E02001431', 'E02001432', 'E02001433', 'E02001434', 'E02001435', 'E02001436', 'E02001437', 'E02001438', 'E02001439', 'E02001440', 'E02001441', 'E02001442', 'E02001443', 'E02001444', 'E02001445', 'E02001446', 'E02001447', 'E02001448', 'E02001449', 'E02001450', 'E02001451', 'E02001452', 'E02001453', 'E02001454', 'E02001455', 'E02001456', 'E02001457', 'E02001458', 'E02001459', 'E02001460', 'E02001461', 'E02001462', 'E02001463', 'E02001464', 'E02001465', 'E02001466'], 
        'E08000013': ['E02001406', 'E02001407', 'E02001408', 'E02001409', 'E02001410', 'E02001411', 'E02001412', 'E02001413', 'E02001414', 'E02001415', 'E02001416', 'E02001417', 'E02001418', 'E02001419', 'E02001420', 'E02001421', 'E02001422', 'E02001423', 'E02001424', 'E02001425', 'E02001426', 'E02001427', 'E02001428'], 
        'E08000015': ['E02001467', 'E02001468', 'E02001469', 'E02001470', 'E02001471', 'E02001472', 'E02001473', 'E02001474', 'E02001475', 'E02001476', 'E02001477', 'E02001478', 'E02001479', 'E02001480', 'E02001481', 'E02001482', 'E02001483', 'E02001484', 'E02001485', 'E02001486', 'E02001487', 'E02001488', 'E02001489', 'E02001490', 'E02001491', 'E02001492', 'E02001493', 'E02001494', 'E02001495', 'E02001496', 'E02001497', 'E02001498', 'E02001499', 'E02001500', 'E02001501', 'E02001502', 'E02001503', 'E02001504', 'E02001505', 'E02001506', 'E02001507', 'E02001508'], 
        'E06000011': ['E02002684', 'E02002685', 'E02002686', 'E02002687', 'E02002688', 'E02002689', 'E02002691', 'E02002692', 'E02002693', 'E02002694', 'E02002695', 'E02002696', 'E02002697', 'E02002698', 'E02002699', 'E02002700', 'E02002701', 'E02002702', 'E02002703', 'E02002704', 'E02002705', 'E02002706', 'E02002707', 'E02002708', 'E02002709', 'E02002710', 'E02002711', 'E02002712', 'E02002714', 'E02002715', 'E02002716', 'E02002717', 'E02002718', 'E02002719', 'E02002720', 'E02002721', 'E02002722', 'E02002723', 'E02002724', 'E02002725', 'E02006814', 'E02006891', 'E02006892'], 
        'E06000010': ['E02002652', 'E02002653', 'E02002654', 'E02002655', 'E02002656', 'E02002657', 'E02002658', 'E02002659', 'E02002660', 'E02002661', 'E02002662', 'E02002663', 'E02002664', 'E02002665', 'E02002666', 'E02002667', 'E02002668', 'E02002669', 'E02002670', 'E02002671', 'E02002672', 'E02002673', 'E02002674', 'E02002675', 'E02002676', 'E02002677', 'E02002678', 'E02002679', 'E02002680', 'E02002681', 'E02002682', 'E02006813'], 
        'E06000012': ['E02002726', 'E02002727', 'E02002728', 'E02002729', 'E02002730', 'E02002731', 'E02002732', 'E02002733', 'E02002734', 'E02002735', 'E02002736', 'E02002737', 'E02002738', 'E02002739', 'E02002740', 'E02002741', 'E02002742', 'E02002743', 'E02002744', 'E02002745', 'E02002746', 'E02002747', 'E02002748'], 
        'E06000013': ['E02002749', 'E02002750', 'E02002751', 'E02002752', 'E02002753', 'E02002754', 'E02002755', 'E02002756', 'E02002757', 'E02002758', 'E02002759', 'E02002760', 'E02002761', 'E02002762', 'E02002763', 'E02002764', 'E02002765', 'E02002766', 'E02002767', 'E02002768', 'E02002769', 'E02002770', 'E02002771'], 
        'E06000014': ['E02002772', 'E02002773', 'E02002774', 'E02002775', 'E02002776', 'E02002777', 'E02002778', 'E02002779', 'E02002780', 'E02002781', 'E02002782', 'E02002783', 'E02002784', 'E02002785', 'E02002786', 'E02002787', 'E02002788', 'E02002789', 'E02002790', 'E02002791', 'E02002792', 'E02002793', 'E02002794', 'E02002795'], 
        'E07000163': ['E02005742', 'E02005743', 'E02005744', 'E02005745', 'E02005746', 'E02005747', 'E02005748', 'E02005749'], 
        'E07000164': ['E02005750', 'E02005751', 'E02005752', 'E02005753', 'E02005754', 'E02005755', 'E02005756', 'E02005757', 'E02005758', 'E02005759', 'E02005760'], 
        'E07000165': ['E02005761', 'E02005762', 'E02005763', 'E02005764', 'E02005765', 'E02005766', 'E02005767', 'E02005768', 'E02005769', 'E02005770', 'E02005771', 'E02005772', 'E02005773', 'E02005774', 'E02005775', 'E02005776', 'E02005777', 'E02005778', 'E02005779', 'E02005780', 'E02005781'], 
        'E07000166': ['E02005782', 'E02005783', 'E02005784', 'E02005785', 'E02005786', 'E02005787'], 
        'E07000167': ['E02005788', 'E02005789', 'E02005790', 'E02005791', 'E02005794', 'E02006870'], 
        'E07000168': ['E02005795', 'E02005796', 'E02005797', 'E02005798', 'E02005799', 'E02005800', 'E02005801', 'E02005802', 'E02005803', 'E02005804', 'E02005805', 'E02005806', 'E02005807', 'E02005808'], 
        'E07000169': ['E02005809', 'E02005810', 'E02005811', 'E02005812', 'E02005813', 'E02005814', 'E02005815', 'E02005816', 'E02005817', 'E02005818'], 
        'E08000016': ['E02001509', 'E02001510', 'E02001511', 'E02001512', 'E02001513', 'E02001514', 'E02001515', 'E02001516', 'E02001517', 'E02001518', 'E02001519', 'E02001520', 'E02001521', 'E02001522', 'E02001523', 'E02001524', 'E02001525', 'E02001526', 'E02001527', 'E02001528', 'E02001529', 'E02001530', 'E02001531', 'E02001532', 'E02001533', 'E02001534', 'E02001535', 'E02001536', 'E02001537', 'E02001538'], 
        'E08000017': ['E02001539', 'E02001540', 'E02001541', 'E02001542', 'E02001543', 'E02001544', 'E02001545', 'E02001546', 'E02001547', 'E02001548', 'E02001549', 'E02001550', 'E02001551', 'E02001552', 'E02001553', 'E02001554', 'E02001555', 'E02001556', 'E02001557', 'E02001558', 'E02001559', 'E02001560', 'E02001561', 'E02001562', 'E02001563', 'E02001564', 'E02001565', 'E02001566', 'E02001567', 'E02001568', 'E02001569', 'E02001570', 'E02001571', 'E02001572', 'E02001573', 'E02001574', 'E02001575', 'E02001576', 'E02001577'], 
        'E08000018': ['E02001578', 'E02001579', 'E02001580', 'E02001581', 'E02001582', 'E02001583', 'E02001584', 'E02001585', 'E02001586', 'E02001587', 'E02001588', 'E02001589', 'E02001590', 'E02001591', 'E02001592', 'E02001593', 'E02001594', 'E02001595', 'E02001596', 'E02001597', 'E02001598', 'E02001599', 'E02001600', 'E02001601', 'E02001602', 'E02001603', 'E02001604', 'E02001605', 'E02001606', 'E02001607', 'E02001608', 'E02001609', 'E02001610'], 
        'E08000019': ['E02001611', 'E02001612', 'E02001613', 'E02001614', 'E02001615', 'E02001616', 'E02001617', 'E02001618', 'E02001619', 'E02001620', 'E02001621', 'E02001622', 'E02001623', 'E02001624', 'E02001625', 'E02001626', 'E02001627', 'E02001628', 'E02001629', 'E02001630', 'E02001631', 'E02001632', 'E02001633', 'E02001634', 'E02001635', 'E02001636', 'E02001637', 'E02001638', 'E02001639', 'E02001640', 'E02001642', 'E02001643', 'E02001646', 'E02001647', 'E02001648', 'E02001649', 'E02001650', 'E02001651', 'E02001652', 'E02001653', 'E02001654', 'E02001655', 'E02001656', 'E02001657', 'E02001658', 'E02001659', 'E02001660', 'E02001661', 'E02001662', 'E02001663', 'E02001664', 'E02001665', 'E02001666', 'E02001669', 'E02001670', 'E02001671', 'E02001672', 'E02001673', 'E02001674', 'E02001675', 'E02001676', 'E02001678', 'E02001679', 'E02001680', 'E02001681', 'E02006803', 'E02006843', 'E02006844', 'E02006868', 'E02006869'], 
        'E08000032': ['E02002183', 'E02002184', 'E02002185', 'E02002186', 'E02002187', 'E02002188', 'E02002189', 'E02002190', 'E02002191', 'E02002192', 'E02002193', 'E02002194', 'E02002195', 'E02002196', 'E02002197', 'E02002198', 'E02002199', 'E02002200', 'E02002201', 'E02002202', 'E02002203', 'E02002204', 'E02002205', 'E02002206', 'E02002207', 'E02002208', 'E02002209', 'E02002210', 'E02002211', 'E02002212', 'E02002213', 'E02002214', 'E02002215', 'E02002216', 'E02002217', 'E02002218', 'E02002219', 'E02002220', 'E02002221', 'E02002222', 'E02002223', 'E02002224', 'E02002225', 'E02002226', 'E02002227', 'E02002228', 'E02002229', 'E02002230', 'E02002231', 'E02002232', 'E02002233', 'E02002234', 'E02002235', 'E02002236', 'E02002237', 'E02002238', 'E02002239', 'E02002240', 'E02002241', 'E02002242', 'E02002243'], 
        'E08000033': ['E02002244', 'E02002245', 'E02002246', 'E02002247', 'E02002248', 'E02002249', 'E02002250', 'E02002251', 'E02002252', 'E02002253', 'E02002254', 'E02002255', 'E02002256', 'E02002257', 'E02002258', 'E02002259', 'E02002260', 'E02002261', 'E02002262', 'E02002263', 'E02002264', 'E02002265', 'E02002266', 'E02002267', 'E02002268', 'E02002269', 'E02002270'], 
        'E08000034': ['E02002271', 'E02002272', 'E02002273', 'E02002274', 'E02002275', 'E02002276', 'E02002277', 'E02002278', 'E02002279', 'E02002280', 'E02002281', 'E02002282', 'E02002283', 'E02002284', 'E02002285', 'E02002286', 'E02002287', 'E02002288', 'E02002289', 'E02002290', 'E02002291', 'E02002292', 'E02002293', 'E02002294', 'E02002295', 'E02002296', 'E02002297', 'E02002298', 'E02002299', 'E02002300', 'E02002301', 'E02002302', 'E02002303', 'E02002304', 'E02002305', 'E02002306', 'E02002307', 'E02002308', 'E02002309', 'E02002310', 'E02002311', 'E02002312', 'E02002313', 'E02002314', 'E02002315', 'E02002316', 'E02002317', 'E02002318', 'E02002319', 'E02002320', 'E02002321', 'E02002322', 'E02002323', 'E02002324', 'E02002325', 'E02002326', 'E02002327', 'E02002328', 'E02002329'], 
        'E08000035': ['E02002330', 'E02002331', 'E02002332', 'E02002333', 'E02002334', 'E02002335', 'E02002336', 'E02002337', 'E02002338', 'E02002339', 'E02002340', 'E02002341', 'E02002342', 'E02002343', 'E02002344', 'E02002345', 'E02002346', 'E02002347', 'E02002348', 'E02002349', 'E02002350', 'E02002351', 'E02002352', 'E02002353', 'E02002354', 'E02002356', 'E02002357', 'E02002358', 'E02002359', 'E02002360', 'E02002361', 'E02002362', 'E02002363', 'E02002364', 'E02002366', 'E02002367', 'E02002368', 'E02002369', 'E02002370', 'E02002371', 'E02002373', 'E02002374', 'E02002375', 'E02002376', 'E02002377', 'E02002379', 'E02002380', 'E02002381', 'E02002382', 'E02002383', 'E02002384', 'E02002385', 'E02002386', 'E02002387', 'E02002388', 'E02002389', 'E02002390', 'E02002391', 'E02002392', 'E02002393', 'E02002394', 'E02002395', 'E02002396', 'E02002397', 'E02002398', 'E02002399', 'E02002400', 'E02002401', 'E02002402', 'E02002403', 'E02002404', 'E02002405', 'E02002406', 'E02002407', 'E02002408', 'E02002409', 'E02002410', 'E02002411', 'E02002412', 'E02002414', 'E02002415', 'E02002416', 'E02002417', 'E02002418', 'E02002419', 'E02002420', 'E02002421', 'E02002422', 'E02002423', 'E02002424', 'E02002425', 'E02002426', 'E02002427', 'E02002428', 'E02002429', 'E02002430', 'E02002431', 'E02002432', 'E02002433', 'E02002434', 'E02002435', 'E02002436', 'E02002437', 'E02006852', 'E02006861', 'E02006875', 'E02006876'], 
        'E08000036': ['E02002438', 'E02002439', 'E02002440', 'E02002441', 'E02002442', 'E02002443', 'E02002444', 'E02002445', 'E02002446', 'E02002447', 'E02002448', 'E02002449', 'E02002450', 'E02002451', 'E02002452', 'E02002453', 'E02002454', 'E02002455', 'E02002456', 'E02002457', 'E02002458', 'E02002459', 'E02002460', 'E02002461', 'E02002462', 'E02002463', 'E02002464', 'E02002465', 'E02002466', 'E02002467', 'E02002468', 'E02002469', 'E02002470', 'E02002471', 'E02002472', 'E02002473', 'E02002474', 'E02002475', 'E02002476', 'E02002477', 'E02002478', 'E02002479', 'E02002480', 'E02002481', 'E02002482'], 
        'E06000015': ['E02002796', 'E02002797', 'E02002798', 'E02002799', 'E02002800', 'E02002801', 'E02002802', 'E02002803', 'E02002804', 'E02002805', 'E02002806', 'E02002807', 'E02002808', 'E02002809', 'E02002810', 'E02002811', 'E02002812', 'E02002813', 'E02002814', 'E02002815', 'E02002816', 'E02002817', 'E02002818', 'E02002819', 'E02002820', 'E02002821', 'E02002822', 'E02002823', 'E02002824', 'E02002825', 'E02002826'], 
        'E06000016': ['E02002827', 'E02002828', 'E02002829', 'E02002830', 'E02002831', 'E02002832', 'E02002833', 'E02002834', 'E02002835', 'E02002836', 'E02002837', 'E02002838', 'E02002839', 'E02002842', 'E02002843', 'E02002844', 'E02002845', 'E02002846', 'E02002847', 'E02002848', 'E02002849', 'E02002851', 'E02002852', 'E02002853', 'E02002854', 'E02002855', 'E02002856', 'E02002857', 'E02002858', 'E02002860', 'E02002861', 'E02002862', 'E02006815', 'E02006817', 'E02006819', 'E02006850', 'E02006851'], 
        'E06000018': ['E02002868', 'E02002869', 'E02002871', 'E02002872', 'E02002873', 'E02002874', 'E02002875', 'E02002876', 'E02002877', 'E02002878', 'E02002879', 'E02002880', 'E02002881', 'E02002882', 'E02002883', 'E02002884', 'E02002885', 'E02002886', 'E02002887', 'E02002888', 'E02002889', 'E02002890', 'E02002891', 'E02002892', 'E02002893', 'E02002894', 'E02002895', 'E02002896', 'E02002897', 'E02002898', 'E02002899', 'E02002901', 'E02002902', 'E02002903', 'E02002904', 'E02006834', 'E02006904', 'E02006905'], 
        'E06000017': ['E02002863', 'E02002864', 'E02002865', 'E02002866', 'E02002867'], 
        'E07000032': ['E02004029', 'E02004030', 'E02004031', 'E02004032', 'E02004033', 'E02004034', 'E02004035', 'E02004036', 'E02004037', 'E02004038', 'E02004039', 'E02004040', 'E02004041', 'E02004043', 'E02004044', 'E02006827'], 
        'E07000033': ['E02004045', 'E02004046', 'E02004047', 'E02004048', 'E02004049', 'E02004050', 'E02004051', 'E02004052', 'E02004053', 'E02004054'], 
        'E07000034': ['E02004055', 'E02004056', 'E02004057', 'E02004058', 'E02004059', 'E02004060', 'E02004061', 'E02004062', 'E02004063', 'E02004064', 'E02004065', 'E02004066', 'E02004067'], 
        'E07000035': ['E02004068', 'E02004069', 'E02004070', 'E02004071', 'E02004072', 'E02004073', 'E02004074', 'E02004075', 'E02004076', 'E02004077'], 
        'E07000036': ['E02004078', 'E02004080', 'E02004081', 'E02004082', 'E02004083', 'E02004084', 'E02004085', 'E02004086', 'E02004087', 'E02004088', 'E02004089', 'E02004090', 'E02004091', 'E02004092', 'E02006828'], 
        'E07000037': ['E02004093', 'E02004094', 'E02004095', 'E02004096', 'E02004097', 'E02004098', 'E02004100', 'E02004102', 'E02004103', 'E02004104', 'E02006872'], 
        'E07000038': ['E02004105', 'E02004106', 'E02004108', 'E02004109', 'E02004110', 'E02004111', 'E02004112', 'E02004113', 'E02004114', 'E02004115', 'E02004116', 'E02004117', 'E02006804'], 
        'E07000039': ['E02004118', 'E02004119', 'E02004120', 'E02004121', 'E02004122', 'E02004123', 'E02004124', 'E02004125', 'E02004126', 'E02004128', 'E02006919', 'E02006920'], 
        'E07000129': ['E02005334', 'E02005335', 'E02005336', 'E02005337', 'E02005338', 'E02005339', 'E02005340', 'E02005341', 'E02005342', 'E02005343', 'E02005344', 'E02006820'], 
        'E07000130': ['E02005345', 'E02005346', 'E02005347', 'E02005348', 'E02005349', 'E02005350', 'E02005351', 'E02005352', 'E02005353', 'E02005354', 'E02005355', 'E02005356', 'E02005357', 'E02005358', 'E02005359', 'E02005360', 'E02005361', 'E02005362', 'E02005363', 'E02005364', 'E02005365', 'E02005366'], 
        'E07000131': ['E02005368', 'E02005369', 'E02005370', 'E02005371', 'E02005372', 'E02005373', 'E02005374', 'E02005375', 'E02005376', 'E02006816'], 
        'E07000132': ['E02005377', 'E02005378', 'E02005379', 'E02005380', 'E02005381', 'E02005382', 'E02005383', 'E02005384', 'E02005385', 'E02005386', 'E02005387', 'E02005388', 'E02005389', 'E02005390'], 
        'E07000133': ['E02005391', 'E02005392', 'E02005393', 'E02005394', 'E02005395', 'E02005396'], 
        'E07000134': ['E02005397', 'E02005398', 'E02005399', 'E02005400', 'E02005401', 'E02005402', 'E02005403', 'E02005404', 'E02005405', 'E02005406', 'E02005407', 'E02005408', 'E02005409'], 
        'E07000135': ['E02005412', 'E02005414', 'E02005415', 'E02005416', 'E02006818', 'E02006911'], 
        'E07000136': ['E02005417', 'E02005418', 'E02005419', 'E02005420', 'E02005422', 'E02005423', 'E02006864', 'E02006865'], 
        'E07000137': ['E02005424', 'E02005425', 'E02005426', 'E02005427', 'E02005428', 'E02005429', 'E02005430', 'E02005431', 'E02005432', 'E02005433', 'E02005434', 'E02005435', 'E02005436', 'E02005437', 'E02005438', 'E02005439', 'E02005440', 'E02005441'], 
        'E07000138': ['E02005442', 'E02005443', 'E02005444', 'E02005445', 'E02005446', 'E02005447', 'E02005448', 'E02005449', 'E02005450', 'E02005451', 'E02005452'], 
        'E07000139': ['E02005453', 'E02005455', 'E02005456', 'E02005457', 'E02005458', 'E02005459', 'E02005460', 'E02005461', 'E02005462', 'E02005463', 'E02005464', 'E02006866', 'E02006867'], 
        'E07000140': ['E02005465', 'E02005466', 'E02005467', 'E02005468', 'E02005469', 'E02005470', 'E02005471', 'E02005472', 'E02005473', 'E02005474', 'E02005475'], 
        'E07000141': ['E02005476', 'E02005477', 'E02005478', 'E02005479', 'E02005480', 'E02005481', 'E02005482', 'E02005483', 'E02005484', 'E02005485', 'E02005486', 'E02005487', 'E02005488', 'E02005489', 'E02005490', 'E02005491'], 
        'E07000142': ['E02005492', 'E02005493', 'E02005494', 'E02005495', 'E02005496', 'E02005497', 'E02005498', 'E02005499', 'E02005500', 'E02005501', 'E02005502'], 
        'E07000150': ['E02005612', 'E02005613', 'E02005614', 'E02005615', 'E02005616', 'E02005617', 'E02006862', 'E02006863'], 
        'E07000151': ['E02005619', 'E02005620', 'E02005621', 'E02005622', 'E02005623', 'E02005624', 'E02005625', 'E02005626', 'E02005627', 'E02005628'], 
        'E07000152': ['E02005629', 'E02005630', 'E02005631', 'E02005632', 'E02005633', 'E02005634', 'E02005635', 'E02005636', 'E02005637', 'E02005638'], 
        'E07000153': ['E02005639', 'E02005640', 'E02005641', 'E02005642', 'E02005643', 'E02005644', 'E02005645', 'E02005646', 'E02005647', 'E02005648', 'E02005649'], 
        'E07000154': ['E02005650', 'E02005651', 'E02005652', 'E02005653', 'E02005654', 'E02005655', 'E02005656', 'E02005657', 'E02005658', 'E02005659', 'E02005660', 'E02005661', 'E02005662', 'E02005663', 'E02005664', 'E02005665', 'E02005666', 'E02005667', 'E02005668', 'E02005669', 'E02005670', 'E02005671', 'E02005672', 'E02005673', 'E02005674', 'E02005675', 'E02005676', 'E02005677', 'E02005678', 'E02005679', 'E02005680'], 
        'E07000155': ['E02005681', 'E02005682', 'E02005683', 'E02005684', 'E02005685', 'E02005686', 'E02005687', 'E02005688', 'E02005689', 'E02005690', 'E02005691'], 
        'E07000156': ['E02005692', 'E02005693', 'E02005694', 'E02005695', 'E02005696', 'E02005697', 'E02005698', 'E02005699', 'E02005700', 'E02005701'], 
        'E07000170': ['E02005819', 'E02005820', 'E02005821', 'E02005822', 'E02005823', 'E02005824', 'E02005825', 'E02005826', 'E02005827', 'E02005828', 'E02005829', 'E02005830', 'E02005831', 'E02005832', 'E02005833', 'E02005834'], 
        'E07000171': ['E02005835', 'E02005836', 'E02005837', 'E02005838', 'E02005839', 'E02005840', 'E02005842', 'E02005843', 'E02005844', 'E02005846', 'E02005847', 'E02005848', 'E02005849', 'E02006903'], 
        'E07000172': ['E02005850', 'E02005851', 'E02005852', 'E02005853', 'E02005856', 'E02005857', 'E02005858', 'E02005859', 'E02005860', 'E02005861', 'E02005862', 'E02005863', 'E02005864', 'E02006906'], 
        'E07000173': ['E02005865', 'E02005866', 'E02005868', 'E02005869', 'E02005870', 'E02005871', 'E02005872', 'E02005873', 'E02005874', 'E02005875', 'E02005876', 'E02005877', 'E02005878', 'E02005879', 'E02006835'], 
        'E07000174': ['E02005880', 'E02005881', 'E02005882', 'E02005883', 'E02005884', 'E02005885', 'E02005886', 'E02005887', 'E02005888', 'E02005889', 'E02005890', 'E02005891', 'E02005892'], 
        'E07000175': ['E02005893', 'E02005894', 'E02005895', 'E02005896', 'E02005897', 'E02005898', 'E02005899', 'E02005900', 'E02005901', 'E02005902', 'E02005903', 'E02005904', 'E02005905'], 
        'E07000176': ['E02005906', 'E02005907', 'E02005908', 'E02005909', 'E02005910', 'E02005911', 'E02005912', 'E02005913', 'E02005914', 'E02005915', 'E02005916', 'E02005917', 'E02005918', 'E02005919', 'E02005920'], 
        'E06000019': ['E02002905', 'E02002906', 'E02002907', 'E02002908', 'E02002909', 'E02002910', 'E02002911', 'E02002912', 'E02002913', 'E02002914', 'E02002915', 'E02002916', 'E02002917', 'E02002918', 'E02002919', 'E02002920', 'E02002921', 'E02002922', 'E02002923', 'E02002924', 'E02002925', 'E02002926', 'E02002927'], 
        'E06000051': ['E02006015', 'E02006016', 'E02006023', 'E02006017', 'E02006018', 'E02006024', 'E02006025', 'E02006019', 'E02006020', 'E02006021', 'E02006026', 'E02006027', 'E02006022', 'E02006028', 'E02006029', 'E02006030', 'E02006031', 'E02006032', 'E02006033', 'E02006034', 'E02006035', 'E02006036', 'E02006037', 'E02006038', 'E02006008', 'E02006039', 'E02006009', 'E02006040', 'E02006010', 'E02006041', 'E02006011', 'E02006042', 'E02006012', 'E02006013', 'E02006014', 'E02006043', 'E02006044', 'E02006045', 'E02006046'], 
        'E06000021': ['E02002951', 'E02002952', 'E02002953', 'E02002954', 'E02002955', 'E02002956', 'E02002957', 'E02002958', 'E02002959', 'E02002960', 'E02002961', 'E02002962', 'E02002963', 'E02002964', 'E02002965', 'E02002966', 'E02002967', 'E02002968', 'E02002969', 'E02002970', 'E02002971', 'E02002972', 'E02002973', 'E02002974', 'E02002975', 'E02002976', 'E02002977', 'E02002978', 'E02002979', 'E02002980', 'E02002981', 'E02002982', 'E02002983', 'E02002984'], 
        'E06000020': ['E02002928', 'E02002929', 'E02002930', 'E02002931', 'E02002932', 'E02002933', 'E02002934', 'E02002935', 'E02002936', 'E02002937', 'E02002938', 'E02002939', 'E02002940', 'E02002941', 'E02002942', 'E02002943', 'E02002944', 'E02002945', 'E02002946', 'E02002947', 'E02002948', 'E02002949', 'E02002950'], 
        'E07000192': ['E02006118', 'E02006119', 'E02006120', 'E02006121', 'E02006122', 'E02006123', 'E02006124', 'E02006125', 'E02006126', 'E02006127', 'E02006128', 'E02006129', 'E02006130'], 
        'E07000193': ['E02006131', 'E02006132', 'E02006133', 'E02006134', 'E02006135', 'E02006136', 'E02006137', 'E02006138', 'E02006139', 'E02006140', 'E02006141', 'E02006142', 'E02006143', 'E02006144', 'E02006145'], 
        'E07000194': ['E02006146', 'E02006147', 'E02006148', 'E02006149', 'E02006150', 'E02006151', 'E02006152', 'E02006153', 'E02006154', 'E02006155', 'E02006156', 'E02006157'], 
        'E07000195': ['E02006158', 'E02006159', 'E02006160', 'E02006161', 'E02006162', 'E02006163', 'E02006164', 'E02006165', 'E02006166', 'E02006167', 'E02006168', 'E02006169', 'E02006170', 'E02006171', 'E02006172', 'E02006173'], 
        'E07000196': ['E02006174', 'E02006175', 'E02006176', 'E02006177', 'E02006178', 'E02006179', 'E02006180', 'E02006181', 'E02006182', 'E02006183', 'E02006184', 'E02006185', 'E02006186', 'E02006187'], 
        'E07000197': ['E02006188', 'E02006189', 'E02006190', 'E02006191', 'E02006192', 'E02006193', 'E02006194', 'E02006195', 'E02006196', 'E02006197', 'E02006198', 'E02006199', 'E02006200', 'E02006201', 'E02006202', 'E02006203'], 
        'E07000198': ['E02006204', 'E02006205', 'E02006206', 'E02006207', 'E02006208', 'E02006209', 'E02006210', 'E02006211', 'E02006212', 'E02006213', 'E02006214', 'E02006215', 'E02006216'], 
        'E07000199': ['E02006217', 'E02006218', 'E02006219', 'E02006220', 'E02006221', 'E02006222', 'E02006223', 'E02006224', 'E02006225', 'E02006226'], 
        'E07000218': ['E02006468', 'E02006469', 'E02006470', 'E02006471', 'E02006472', 'E02006473', 'E02006474'], 
        'E07000219': ['E02006475', 'E02006476', 'E02006477', 'E02006478', 'E02006479', 'E02006480', 'E02006481', 'E02006482', 'E02006483', 'E02006484', 'E02006485', 'E02006486', 'E02006487', 'E02006488', 'E02006489', 'E02006490', 'E02006806'], 
        'E07000220': ['E02006492', 'E02006493', 'E02006494', 'E02006495', 'E02006496', 'E02006497', 'E02006498', 'E02006499', 'E02006500', 'E02006501', 'E02006502', 'E02006503'], 
        'E07000221': ['E02006504', 'E02006505', 'E02006506', 'E02006507', 'E02006508', 'E02006509', 'E02006510', 'E02006511', 'E02006512', 'E02006513', 'E02006514', 'E02006515', 'E02006516', 'E02006517', 'E02006518'], 
        'E07000222': ['E02006519', 'E02006520', 'E02006521', 'E02006522', 'E02006523', 'E02006524', 'E02006525', 'E02006526', 'E02006527', 'E02006528', 'E02006529', 'E02006530', 'E02006531', 'E02006532', 'E02006533'], 
        'E08000025': ['E02001827', 'E02001828', 'E02001829', 'E02001830', 'E02001831', 'E02001832', 'E02001833', 'E02001834', 'E02001835', 'E02001836', 'E02001837', 'E02001838', 'E02001839', 'E02001840', 'E02001841', 'E02001842', 'E02001843', 'E02001844', 'E02001845', 'E02001846', 'E02001847', 'E02001848', 'E02001849', 'E02001850', 'E02001851', 'E02001852', 'E02001854', 'E02001855', 'E02001856', 'E02001857', 'E02001858', 'E02001859', 'E02001860', 'E02001861', 'E02001862', 'E02001863', 'E02001864', 'E02001865', 'E02001866', 'E02001867', 'E02001868', 'E02001869', 'E02001870', 'E02001871', 'E02001872', 'E02001873', 'E02001874', 'E02001875', 'E02001876', 'E02001877', 'E02001878', 'E02001879', 'E02001880', 'E02001881', 'E02001882', 'E02001883', 'E02001884', 'E02001886', 'E02001888', 'E02001889', 'E02001890', 'E02001892', 'E02001893', 'E02001895', 'E02001896', 'E02001897', 'E02001898', 'E02001899', 'E02001900', 'E02001901', 'E02001902', 'E02001903', 'E02001904', 'E02001905', 'E02001906', 'E02001907', 'E02001908', 'E02001909', 'E02001910', 'E02001911', 'E02001913', 'E02001914', 'E02001915', 'E02001916', 'E02001918', 'E02001919', 'E02001920', 'E02001921', 'E02001922', 'E02001923', 'E02001924', 'E02001925', 'E02001926', 'E02001927', 'E02001928', 'E02001929', 'E02001930', 'E02001931', 'E02001932', 'E02001933', 'E02001934', 'E02001935', 'E02001936', 'E02001937', 'E02001938', 'E02001939', 'E02001941', 'E02001942', 'E02001943', 'E02001944', 'E02001945', 'E02001946', 'E02001947', 'E02001948', 'E02001949', 'E02001950', 'E02001951', 'E02001952', 'E02001953', 'E02001954', 'E02001955', 'E02001956', 'E02001957', 'E02006807', 'E02006809', 'E02006895', 'E02006896', 'E02006897', 'E02006898', 'E02006899', 'E02006900', 'E02006901'], 
        'E08000026': ['E02001958', 'E02001959', 'E02001961', 'E02001962', 'E02001963', 'E02001964', 'E02001965', 'E02001966', 'E02001967', 'E02001968', 'E02001969', 'E02001970', 'E02001971', 'E02001972', 'E02001973', 'E02001974', 'E02001975', 'E02001976', 'E02001977', 'E02001978', 'E02001979', 'E02001980', 'E02001981', 'E02001982', 'E02001983', 'E02001984', 'E02001985', 'E02001986', 'E02001987', 'E02001988', 'E02001989', 'E02001990', 'E02001991', 'E02001992', 'E02001993', 'E02001994', 'E02001995', 'E02001996', 'E02001997', 'E02001998', 'E02001999', 'E02006805'], 
        'E08000027': ['E02002000', 'E02002001', 'E02002002', 'E02002003', 'E02002004', 'E02002005', 'E02002006', 'E02002007', 'E02002008', 'E02002009', 'E02002010', 'E02002011', 'E02002012', 'E02002013', 'E02002014', 'E02002015', 'E02002016', 'E02002017', 'E02002018', 'E02002019', 'E02002020', 'E02002021', 'E02002022', 'E02002023', 'E02002024', 'E02002025', 'E02002026', 'E02002027', 'E02002028', 'E02002029', 'E02002030', 'E02002031', 'E02002032', 'E02002033', 'E02002034', 'E02002035', 'E02002036', 'E02002037', 'E02002038', 'E02002039', 'E02002040', 'E02002041', 'E02002042'], 
        'E08000028': ['E02002043', 'E02002044', 'E02002045', 'E02002046', 'E02002047', 'E02002048', 'E02002049', 'E02002051', 'E02002052', 'E02002053', 'E02002054', 'E02002055', 'E02002056', 'E02002057', 'E02002058', 'E02002059', 'E02002060', 'E02002061', 'E02002062', 'E02002063', 'E02002064', 'E02002065', 'E02002066', 'E02002067', 'E02002068', 'E02002069', 'E02002070', 'E02002071', 'E02002072', 'E02002073', 'E02002074', 'E02002075', 'E02002076', 'E02002077', 'E02002078', 'E02002079', 'E02002080', 'E02006810'], 
        'E08000029': ['E02002081', 'E02002082', 'E02002083', 'E02002084', 'E02002085', 'E02002086', 'E02002087', 'E02002088', 'E02002089', 'E02002090', 'E02002091', 'E02002092', 'E02002093', 'E02002094', 'E02002095', 'E02002096', 'E02002097', 'E02002098', 'E02002099', 'E02002101', 'E02002102', 'E02002103', 'E02002104', 'E02002105', 'E02002106', 'E02002107', 'E02002108', 'E02002109', 'E02006808'], 
        'E08000030': ['E02002110', 'E02002111', 'E02002112', 'E02002113', 'E02002114', 'E02002115', 'E02002116', 'E02002117', 'E02002118', 'E02002119', 'E02002120', 'E02002121', 'E02002122', 'E02002123', 'E02002124', 'E02002125', 'E02002126', 'E02002127', 'E02002128', 'E02002129', 'E02002130', 'E02002131', 'E02002132', 'E02002133', 'E02002134', 'E02002135', 'E02002136', 'E02002137', 'E02002138', 'E02002139', 'E02002140', 'E02002141', 'E02002142', 'E02002143', 'E02002144', 'E02002145', 'E02002146', 'E02002147', 'E02002148'], 
        'E08000031': ['E02002149', 'E02002150', 'E02002151', 'E02002152', 'E02002153', 'E02002154', 'E02002155', 'E02002156', 'E02002157', 'E02002158', 'E02002159', 'E02002160', 'E02002161', 'E02002162', 'E02002163', 'E02002164', 'E02002165', 'E02002166', 'E02002167', 'E02002168', 'E02002169', 'E02002170', 'E02002171', 'E02002174', 'E02002175', 'E02002176', 'E02002177', 'E02002178', 'E02002179', 'E02002180', 'E02002181', 'E02002182', 'E02006894'], 
        'E07000234': ['E02006696', 'E02006697', 'E02006698', 'E02006699', 'E02006700', 'E02006701', 'E02006702', 'E02006703', 'E02006704', 'E02006705', 'E02006706', 'E02006707', 'E02006708', 'E02006709'], 
        'E07000235': ['E02006710', 'E02006711', 'E02006712', 'E02006713', 'E02006714', 'E02006715', 'E02006716', 'E02006717', 'E02006718', 'E02006719', 'E02006720'], 
        'E07000236': ['E02006721', 'E02006722', 'E02006723', 'E02006724', 'E02006725', 'E02006726', 'E02006727', 'E02006728', 'E02006729', 'E02006730', 'E02006731', 'E02006732', 'E02006733'], 
        'E07000237': ['E02006734', 'E02006735', 'E02006736', 'E02006737', 'E02006738', 'E02006739', 'E02006740', 'E02006741', 'E02006742', 'E02006743', 'E02006744', 'E02006745', 'E02006746', 'E02006747'], 
        'E07000238': ['E02006748', 'E02006749', 'E02006750', 'E02006751', 'E02006752', 'E02006753', 'E02006754', 'E02006755', 'E02006756', 'E02006757', 'E02006758', 'E02006759', 'E02006760', 'E02006761', 'E02006762', 'E02006763', 'E02006764', 'E02006765', 'E02006766'], 
        'E07000239': ['E02006767', 'E02006768', 'E02006769', 'E02006770', 'E02006771', 'E02006772', 'E02006773', 'E02006774', 'E02006775', 'E02006776', 'E02006777', 'E02006778', 'E02006779', 'E02006780'], 
        'E06000055': ['E02003616', 'E02003617', 'E02003618', 'E02003619', 'E02003620', 'E02003621', 'E02003622', 'E02003623', 'E02003624', 'E02003625', 'E02003626', 'E02003627', 'E02003628', 'E02003629', 'E02003630', 'E02003631', 'E02003632', 'E02003633', 'E02003634', 'E02003635'], 
        'E06000056': ['E02003599', 'E02003600', 'E02003601', 'E02003602', 'E02003603', 'E02003604', 'E02003605', 'E02003606', 'E02003607', 'E02003608', 'E02003609', 'E02003610', 'E02003611', 'E02003612', 'E02003613', 'E02003614', 'E02003615', 'E02003636', 'E02003637', 'E02003638', 'E02003639', 'E02003640', 'E02003641', 'E02003643', 'E02003642', 'E02003644', 'E02003645', 'E02003646', 'E02003647', 'E02003648', 'E02003649', 'E02003650', 'E02003651'], 
        'E06000032': ['E02003258', 'E02003259', 'E02003260', 'E02003261', 'E02003262', 'E02003263', 'E02003264', 'E02003265', 'E02003266', 'E02003267', 'E02003268', 'E02003269', 'E02003270', 'E02003271', 'E02003272', 'E02003273', 'E02003274', 'E02003275', 'E02003276', 'E02003277', 'E02003278'], 
        'E06000031': ['E02003237', 'E02003238', 'E02003239', 'E02003240', 'E02003241', 'E02003242', 'E02003243', 'E02003244', 'E02003245', 'E02003246', 'E02003247', 'E02003248', 'E02003249', 'E02003250', 'E02003251', 'E02003252', 'E02003253', 'E02003254', 'E02003255', 'E02003257', 'E02006877', 'E02006878'], 
        'E06000033': ['E02003279', 'E02003280', 'E02003281', 'E02003282', 'E02003283', 'E02003284', 'E02003285', 'E02003286', 'E02003287', 'E02003288', 'E02003289', 'E02003290', 'E02003291', 'E02003292', 'E02003293', 'E02003294', 'E02003295'], 
        'E06000034': ['E02003296', 'E02003297', 'E02003298', 'E02003299', 'E02003300', 'E02003301', 'E02003302', 'E02003303', 'E02003304', 'E02003305', 'E02003307', 'E02003308', 'E02003309', 'E02003310', 'E02003311', 'E02003312', 'E02003313', 'E02006859', 'E02006926'], 
        'E07000008': ['E02003719', 'E02003720', 'E02003721', 'E02003722', 'E02003723', 'E02003724', 'E02003725', 'E02003726', 'E02003727', 'E02003728', 'E02003729', 'E02003730', 'E02003731'], 
        'E07000009': ['E02003732', 'E02003733', 'E02003734', 'E02003735', 'E02003736', 'E02003737', 'E02003738', 'E02003739', 'E02003740', 'E02006825'], 
        'E07000010': ['E02003742', 'E02003743', 'E02003744', 'E02003745', 'E02003746', 'E02003747', 'E02003748', 'E02003749', 'E02003750', 'E02003751', 'E02003752'], 
        'E07000011': ['E02003753', 'E02003754', 'E02003755', 'E02003756', 'E02003757', 'E02003758', 'E02003759', 'E02003760', 'E02003761', 'E02003762', 'E02003763', 'E02003764', 'E02003765', 'E02003766', 'E02003767', 'E02003768', 'E02003769', 'E02003770', 'E02003771', 'E02003772', 'E02003773', 'E02003774'], 
        'E07000012': ['E02003775', 'E02003776', 'E02003777', 'E02003778', 'E02003779', 'E02003780', 'E02003781', 'E02003783', 'E02003784', 'E02003785', 'E02003786', 'E02003787', 'E02003788', 'E02003789', 'E02003790', 'E02003791', 'E02003792', 'E02003793', 'E02006873', 'E02006874'], 
        'E07000066': ['E02004424', 'E02004425', 'E02004426', 'E02004427', 'E02004428', 'E02004429', 'E02004430', 'E02004431', 'E02004432', 'E02004433', 'E02004434', 'E02004435', 'E02004436', 'E02004437', 'E02004438', 'E02004439', 'E02004440', 'E02004441', 'E02004442', 'E02004443', 'E02004444', 'E02004445'], 
        'E07000067': ['E02004446', 'E02004447', 'E02004448', 'E02004449', 'E02004450', 'E02004451', 'E02004452', 'E02004453', 'E02004454', 'E02004455', 'E02004456', 'E02004457', 'E02004458', 'E02004459', 'E02004460', 'E02004461', 'E02004462', 'E02004463'], 
        'E07000068': ['E02004464', 'E02004465', 'E02004466', 'E02004467', 'E02004468', 'E02004469', 'E02004470', 'E02004471', 'E02004472'], 
        'E07000069': ['E02004473', 'E02004474', 'E02004475', 'E02004476', 'E02004477', 'E02004478', 'E02004479', 'E02004480', 'E02004481', 'E02004482', 'E02004483', 'E02004484'], 
        'E07000070': ['E02004485', 'E02004486', 'E02004487', 'E02004488', 'E02004489', 'E02004490', 'E02004491', 'E02004492', 'E02004493', 'E02004494', 'E02004495', 'E02004496', 'E02004497', 'E02004498', 'E02004499', 'E02004500', 'E02004501', 'E02004502', 'E02004503', 'E02004504', 'E02004505'], 
        'E07000071': ['E02004506', 'E02004507', 'E02004508', 'E02004509', 'E02004512', 'E02004513', 'E02004514', 'E02004515', 'E02004516', 'E02004517', 'E02004518', 'E02004519', 'E02004520', 'E02004521', 'E02004522', 'E02004523', 'E02004524', 'E02004525', 'E02004526', 'E02006922'], 
        'E07000072': ['E02004527', 'E02004528', 'E02004529', 'E02004530', 'E02004531', 'E02004532', 'E02004533', 'E02004534', 'E02004535', 'E02004536', 'E02004537', 'E02004538', 'E02004539', 'E02004540', 'E02004541', 'E02004542', 'E02004543'], 
        'E07000073': ['E02004544', 'E02004545', 'E02004546', 'E02004547', 'E02004548', 'E02004549', 'E02004550', 'E02004551', 'E02004552', 'E02004553', 'E02004554'], 
        'E07000074': ['E02004555', 'E02004556', 'E02004557', 'E02004558', 'E02004559', 'E02004560', 'E02004561', 'E02004562'], 
        'E07000075': ['E02004563', 'E02004564', 'E02004565', 'E02004566', 'E02004567', 'E02004568', 'E02004569', 'E02004570', 'E02004571', 'E02004572'], 
        'E07000076': ['E02004573', 'E02004574', 'E02004575', 'E02004576', 'E02004577', 'E02004578', 'E02004579', 'E02004580', 'E02004581', 'E02004582', 'E02004583', 'E02004584', 'E02004585', 'E02004586', 'E02004587', 'E02004588', 'E02004589', 'E02004590'], 
        'E07000077': ['E02004591', 'E02004592', 'E02004593', 'E02004594', 'E02004595', 'E02004596', 'E02004597', 'E02004598', 'E02004599'], 
        'E07000095': ['E02004843', 'E02004844', 'E02004845', 'E02004846', 'E02004847', 'E02004848', 'E02004849', 'E02004850', 'E02004851', 'E02004852', 'E02004853', 'E02004854', 'E02004855'], 
        'E07000096': ['E02004856', 'E02004857', 'E02004858', 'E02004859', 'E02004860', 'E02004861', 'E02004862', 'E02004863', 'E02004864', 'E02004865', 'E02004866', 'E02004867', 'E02004868', 'E02004869', 'E02004870', 'E02004871', 'E02004872', 'E02004873', 'E02004874', 'E02004875', 'E02004876', 'E02004877'], 
        'E07000242': ['E02004878', 'E02004879', 'E02004880', 'E02004881', 'E02004882', 'E02004883', 'E02004884', 'E02004885', 'E02004886', 'E02004887', 'E02004888', 'E02004889', 'E02004890', 'E02004891', 'E02004892', 'E02004893', 'E02004894', 'E02004895'], 
        'E07000098': ['E02004896', 'E02004897', 'E02004898', 'E02004899', 'E02004900', 'E02004901', 'E02004902', 'E02004903', 'E02004904', 'E02004905', 'E02004906', 'E02004907', 'E02004908'], 
        'E07000099': ['E02004909', 'E02004910', 'E02004911', 'E02004912', 'E02004913', 'E02004914', 'E02004915', 'E02004916', 'E02004917', 'E02004918', 'E02004919', 'E02004920', 'E02004921', 'E02004922', 'E02004923'], 
        'E07000240': ['E02004924', 'E02004925', 'E02004926', 'E02004927', 'E02004928', 'E02004929', 'E02004930', 'E02004931', 'E02004932', 'E02004933', 'E02004934', 'E02004935', 'E02004936', 'E02004937', 'E02004938', 'E02004939', 'E02004940', 'E02004941', 'E02004942', 'E02004943'], 
        'E07000243': ['E02004944', 'E02004945', 'E02004946', 'E02004947', 'E02004948', 'E02004949', 'E02004950', 'E02004951', 'E02004952', 'E02004953', 'E02004954', 'E02004955'], 
        'E07000102': ['E02004956', 'E02004957', 'E02004958', 'E02004959', 'E02004960', 'E02004961', 'E02004962', 'E02004963', 'E02004964', 'E02004965', 'E02004966', 'E02004967'], 
        'E07000103': ['E02004968', 'E02004969', 'E02004970', 'E02004971', 'E02004972', 'E02004973', 'E02004974', 'E02004975', 'E02004976', 'E02004977', 'E02004978', 'E02004979'], 
        'E07000241': ['E02004980', 'E02004981', 'E02004982', 'E02004983', 'E02004984', 'E02004985', 'E02004986', 'E02004987', 'E02004988', 'E02004989', 'E02004990', 'E02004991', 'E02004992', 'E02004993', 'E02004994', 'E02004995'], 
        'E07000143': ['E02005503', 'E02005504', 'E02005505', 'E02005506', 'E02005507', 'E02005508', 'E02005509', 'E02005510', 'E02005511', 'E02005512', 'E02005513', 'E02005514', 'E02005515', 'E02005516', 'E02005517', 'E02005518', 'E02005519'], 
        'E07000144': ['E02005520', 'E02005521', 'E02005522', 'E02005523', 'E02005524', 'E02005525', 'E02005526', 'E02005527', 'E02005528', 'E02005529', 'E02005530', 'E02005531', 'E02005532', 'E02005533', 'E02005534', 'E02005535', 'E02005536', 'E02005537'], 
        'E07000145': ['E02005538', 'E02005539', 'E02005540', 'E02005541', 'E02005542', 'E02005543', 'E02005544', 'E02005545', 'E02005546', 'E02005547', 'E02005548', 'E02005549', 'E02005550'], 
        'E07000146': ['E02005551', 'E02005552', 'E02005553', 'E02005554', 'E02005555', 'E02005556', 'E02005557', 'E02005558', 'E02005559', 'E02005560', 'E02005561', 'E02005562', 'E02005563', 'E02005564', 'E02005565', 'E02005566', 'E02005567', 'E02005568', 'E02005569'], 
        'E07000147': ['E02005570', 'E02005571', 'E02005572', 'E02005573', 'E02005574', 'E02005575', 'E02005576', 'E02005577', 'E02005578', 'E02005579', 'E02005580', 'E02005581', 'E02005582', 'E02005583'], 
        'E07000148': ['E02005584', 'E02005585', 'E02005586', 'E02005587', 'E02005588', 'E02005589', 'E02005590', 'E02005592', 'E02005593', 'E02005594', 'E02005595', 'E02005596', 'E02006907', 'E02006908'], 
        'E07000149': ['E02005597', 'E02005598', 'E02005599', 'E02005600', 'E02005601', 'E02005602', 'E02005603', 'E02005604', 'E02005605', 'E02005606', 'E02005607', 'E02005608', 'E02005609', 'E02005610', 'E02005611'], 
        'E07000200': ['E02006227', 'E02006228', 'E02006229', 'E02006230', 'E02006231', 'E02006232', 'E02006233', 'E02006234', 'E02006235', 'E02006236', 'E02006237'], 
        'E07000201': ['E02006238', 'E02006239', 'E02006240', 'E02006241', 'E02006242', 'E02006243', 'E02006826'], 
        'E07000202': ['E02006245', 'E02006246', 'E02006247', 'E02006248', 'E02006249', 'E02006250', 'E02006251', 'E02006252', 'E02006253', 'E02006254', 'E02006255', 'E02006256', 'E02006257', 'E02006258', 'E02006259', 'E02006260'], 
        'E07000203': ['E02006261', 'E02006262', 'E02006263', 'E02006264', 'E02006265', 'E02006266', 'E02006267', 'E02006268', 'E02006269', 'E02006270', 'E02006271', 'E02006272'], 
        'E07000204': ['E02006273', 'E02006274', 'E02006275', 'E02006276', 'E02006277', 'E02006278', 'E02006279', 'E02006280', 'E02006281', 'E02006282', 'E02006283', 'E02006284', 'E02006285', 'E02006286'], 
        'E07000205': ['E02006287', 'E02006288', 'E02006289', 'E02006290', 'E02006291', 'E02006292', 'E02006293', 'E02006294', 'E02006295', 'E02006296', 'E02006297', 'E02006298', 'E02006299', 'E02006300', 'E02006301'], 
        'E07000206': ['E02006302', 'E02006303', 'E02006304', 'E02006305', 'E02006306', 'E02006307', 'E02006308', 'E02006309', 'E02006310', 'E02006311', 'E02006312', 'E02006313', 'E02006314', 'E02006315', 'E02006316'], 
        'E09000007': ['E02000166', 'E02000167', 'E02000168', 'E02000169', 'E02000170', 'E02000171', 'E02000172', 'E02000173', 'E02000174', 'E02000175', 'E02000176', 'E02000177', 'E02000178', 'E02000179', 'E02000180', 'E02000181', 'E02000182', 'E02000183', 'E02000184', 'E02000185', 'E02000186', 'E02000187', 'E02000188', 'E02000189', 'E02000190', 'E02000191', 'E02000192', 'E02000193'], 
        'E09000001': ['E02000001'], 
        'E09000012': ['E02000345', 'E02000346', 'E02000347', 'E02000348', 'E02000350', 'E02000351', 'E02000352', 'E02000353', 'E02000354', 'E02000355', 'E02000356', 'E02000357', 'E02000358', 'E02000359', 'E02000360', 'E02000361', 'E02000362', 'E02000363', 'E02000364', 'E02000365', 'E02000366', 'E02000367', 'E02000368', 'E02000369', 'E02000370', 'E02000371', 'E02006918', 'E02006921'], 
        'E09000013': ['E02000372', 'E02000373', 'E02000374', 'E02000375', 'E02000376', 'E02000377', 'E02000378', 'E02000379', 'E02000380', 'E02000381', 'E02000382', 'E02000383', 'E02000384', 'E02000385', 'E02000386', 'E02000387', 'E02000388', 'E02000389', 'E02000390', 'E02000391', 'E02000392', 'E02000393', 'E02000394', 'E02000395', 'E02000396'], 
        'E09000014': ['E02000397', 'E02000398', 'E02000400', 'E02000401', 'E02000402', 'E02000403', 'E02000404', 'E02000405', 'E02000406', 'E02000407', 'E02000408', 'E02000409', 'E02000410', 'E02000411', 'E02000412', 'E02000413', 'E02000414', 'E02000415', 'E02000416', 'E02000417', 'E02000418', 'E02000419', 'E02000420', 'E02000421', 'E02000422', 'E02000423', 'E02000424', 'E02000425', 'E02000426', 'E02000427', 'E02000428', 'E02000429', 'E02000430', 'E02000431', 'E02000432', 'E02006794'], 
        'E09000019': ['E02000554', 'E02000555', 'E02000556', 'E02000557', 'E02000558', 'E02000559', 'E02000560', 'E02000561', 'E02000562', 'E02000563', 'E02000564', 'E02000565', 'E02000566', 'E02000567', 'E02000568', 'E02000569', 'E02000570', 'E02000571', 'E02000572', 'E02000573', 'E02000574', 'E02000575', 'E02000576'], 
        'E09000020': ['E02000577', 'E02000578', 'E02000579', 'E02000580', 'E02000581', 'E02000582', 'E02000583', 'E02000584', 'E02000585', 'E02000586', 'E02000587', 'E02000588', 'E02000589', 'E02000590', 'E02000591', 'E02000592', 'E02000593', 'E02000594', 'E02000595', 'E02000596', 'E02000597'], 
        'E09000022': ['E02000619', 'E02000620', 'E02000621', 'E02000622', 'E02000623', 'E02000624', 'E02000625', 'E02000626', 'E02000627', 'E02000628', 'E02000629', 'E02000630', 'E02000631', 'E02000632', 'E02000633', 'E02000634', 'E02000635', 'E02000636', 'E02000637', 'E02000638', 'E02000639', 'E02000640', 'E02000641', 'E02000642', 'E02000643', 'E02000644', 'E02000645', 'E02000646', 'E02000647', 'E02000648', 'E02000649', 'E02000650', 'E02000651', 'E02000652', 'E02006801'], 
        'E09000023': ['E02000653', 'E02000654', 'E02000655', 'E02000657', 'E02000658', 'E02000659', 'E02000660', 'E02000661', 'E02000662', 'E02000663', 'E02000664', 'E02000665', 'E02000666', 'E02000667', 'E02000668', 'E02000669', 'E02000670', 'E02000671', 'E02000672', 'E02000673', 'E02000674', 'E02000675', 'E02000676', 'E02000677', 'E02000678', 'E02000679', 'E02000680', 'E02000681', 'E02000682', 'E02000683', 'E02000685', 'E02000686', 'E02000687', 'E02006783', 'E02006784', 'E02006798'], 
        'E09000025': ['E02000714', 'E02000715', 'E02000716', 'E02000717', 'E02000718', 'E02000719', 'E02000720', 'E02000721', 'E02000722', 'E02000723', 'E02000724', 'E02000725', 'E02000726', 'E02000727', 'E02000728', 'E02000729', 'E02000730', 'E02000731', 'E02000732', 'E02000733', 'E02000734', 'E02000735', 'E02000736', 'E02000737', 'E02000738', 'E02000739', 'E02000740', 'E02000741', 'E02000742', 'E02000743', 'E02000744', 'E02000745', 'E02000746', 'E02000747', 'E02000748', 'E02000749', 'E02000750'], 
        'E09000028': ['E02000807', 'E02000808', 'E02000809', 'E02000810', 'E02000812', 'E02000813', 'E02000814', 'E02000815', 'E02000816', 'E02000817', 'E02000818', 'E02000819', 'E02000820', 'E02000821', 'E02000822', 'E02000823', 'E02000824', 'E02000825', 'E02000826', 'E02000827', 'E02000828', 'E02000829', 'E02000830', 'E02000831', 'E02000832', 'E02000833', 'E02000834', 'E02000835', 'E02000836', 'E02000837', 'E02000838', 'E02000839', 'E02006802'], 
        'E09000030': ['E02000864', 'E02000865', 'E02000866', 'E02000867', 'E02000868', 'E02000869', 'E02000870', 'E02000871', 'E02000872', 'E02000873', 'E02000874', 'E02000875', 'E02000876', 'E02000877', 'E02000878', 'E02000879', 'E02000880', 'E02000881', 'E02000882', 'E02000883', 'E02000884', 'E02000885', 'E02000886', 'E02000887', 'E02000888', 'E02000889', 'E02000890', 'E02000891', 'E02000893', 'E02000894', 'E02006853', 'E02006854'], 
        'E09000032': ['E02000923', 'E02000924', 'E02000925', 'E02000926', 'E02000927', 'E02000928', 'E02000929', 'E02000930', 'E02000931', 'E02000932', 'E02000933', 'E02000934', 'E02000935', 'E02000936', 'E02000937', 'E02000938', 'E02000939', 'E02000940', 'E02000941', 'E02000942', 'E02000943', 'E02000944', 'E02000945', 'E02000946', 'E02000947', 'E02000948', 'E02000949', 'E02000950', 'E02000951', 'E02000952', 'E02000953', 'E02000954', 'E02000955', 'E02000956', 'E02000957', 'E02000958', 'E02000959'], 
        'E09000033': ['E02000960', 'E02000961', 'E02000962', 'E02000963', 'E02000964', 'E02000965', 'E02000966', 'E02000967', 'E02000968', 'E02000969', 'E02000970', 'E02000971', 'E02000972', 'E02000973', 'E02000974', 'E02000975', 'E02000976', 'E02000977', 'E02000978', 'E02000979', 'E02000980', 'E02000981', 'E02000982', 'E02000983'], 
        'E09000002': ['E02000002', 'E02000003', 'E02000004', 'E02000005', 'E02000007', 'E02000008', 'E02000009', 'E02000010', 'E02000011', 'E02000012', 'E02000013', 'E02000014', 'E02000015', 'E02000016', 'E02000017', 'E02000018', 'E02000019', 'E02000020', 'E02000021', 'E02000022', 'E02000023', 'E02006799'], 
        'E09000003': ['E02000024', 'E02000025', 'E02000026', 'E02000027', 'E02000028', 'E02000029', 'E02000030', 'E02000031', 'E02000032', 'E02000033', 'E02000034', 'E02000035', 'E02000036', 'E02000037', 'E02000038', 'E02000039', 'E02000040', 'E02000041', 'E02000042', 'E02000043', 'E02000044', 'E02000045', 'E02000046', 'E02000047', 'E02000048', 'E02000049', 'E02000050', 'E02000051', 'E02000052', 'E02000053', 'E02000054', 'E02000055', 'E02000056', 'E02000057', 'E02000058', 'E02000059', 'E02000060', 'E02000061', 'E02000062', 'E02000063', 'E02000064'], 
        'E09000004': ['E02000065', 'E02000066', 'E02000067', 'E02000068', 'E02000069', 'E02000070', 'E02000071', 'E02000072', 'E02000073', 'E02000074', 'E02000075', 'E02000077', 'E02000078', 'E02000079', 'E02000080', 'E02000081', 'E02000082', 'E02000083', 'E02000084', 'E02000085', 'E02000086', 'E02000087', 'E02000088', 'E02000089', 'E02000090', 'E02000091', 'E02000092', 'E02006785'], 
        'E09000005': ['E02000093', 'E02000094', 'E02000095', 'E02000096', 'E02000097', 'E02000098', 'E02000099', 'E02000100', 'E02000101', 'E02000102', 'E02000103', 'E02000104', 'E02000105', 'E02000106', 'E02000107', 'E02000108', 'E02000109', 'E02000110', 'E02000111', 'E02000112', 'E02000113', 'E02000114', 'E02000115', 'E02000116', 'E02000117', 'E02000118', 'E02000119', 'E02000120', 'E02000121', 'E02000122', 'E02000123', 'E02000124', 'E02000125', 'E02000126'], 
        'E09000006': ['E02000127', 'E02000128', 'E02000130', 'E02000131', 'E02000132', 'E02000133', 'E02000134', 'E02000135', 'E02000136', 'E02000137', 'E02000138', 'E02000139', 'E02000140', 'E02000141', 'E02000142', 'E02000144', 'E02000145', 'E02000146', 'E02000147', 'E02000148', 'E02000149', 'E02000150', 'E02000151', 'E02000152', 'E02000153', 'E02000154', 'E02000155', 'E02000156', 'E02000157', 'E02000158', 'E02000159', 'E02000160', 'E02000161', 'E02000162', 'E02000163', 'E02000165', 'E02006782', 'E02006787', 'E02006789'], 
        'E09000008': ['E02000194', 'E02000195', 'E02000196', 'E02000197', 'E02000198', 'E02000199', 'E02000200', 'E02000201', 'E02000202', 'E02000203', 'E02000204', 'E02000206', 'E02000207', 'E02000208', 'E02000209', 'E02000210', 'E02000211', 'E02000212', 'E02000213', 'E02000214', 'E02000215', 'E02000216', 'E02000217', 'E02000218', 'E02000219', 'E02000220', 'E02000221', 'E02000222', 'E02000223', 'E02000224', 'E02000225', 'E02000226', 'E02000227', 'E02000228', 'E02000229', 'E02000230', 'E02000231', 'E02000232', 'E02000233', 'E02000234', 'E02000235', 'E02000236', 'E02000237', 'E02006788'], 
        'E09000009': ['E02000238', 'E02000239', 'E02000240', 'E02000241', 'E02000242', 'E02000243', 'E02000244', 'E02000245', 'E02000246', 'E02000247', 'E02000248', 'E02000249', 'E02000250', 'E02000251', 'E02000252', 'E02000253', 'E02000254', 'E02000255', 'E02000256', 'E02000257', 'E02000258', 'E02000259', 'E02000260', 'E02000261', 'E02000262', 'E02000263', 'E02000264', 'E02000265', 'E02000266', 'E02000267', 'E02000268', 'E02000269', 'E02000270', 'E02000271', 'E02000272', 'E02000274', 'E02000275', 'E02000276', 'E02006791'], 
        'E09000010': ['E02000277', 'E02000278', 'E02000279', 'E02000280', 'E02000281', 'E02000282', 'E02000283', 'E02000284', 'E02000285', 'E02000286', 'E02000287', 'E02000288', 'E02000289', 'E02000290', 'E02000291', 'E02000292', 'E02000293', 'E02000294', 'E02000295', 'E02000296', 'E02000297', 'E02000298', 'E02000299', 'E02000300', 'E02000301', 'E02000302', 'E02000303', 'E02000304', 'E02000305', 'E02000306', 'E02000307', 'E02000308', 'E02000309', 'E02000311', 'E02000312', 'E02006793'], 
        'E09000011': ['E02000313', 'E02000314', 'E02000315', 'E02000316', 'E02000317', 'E02000318', 'E02000319', 'E02000320', 'E02000321', 'E02000323', 'E02000324', 'E02000326', 'E02000327', 'E02000328', 'E02000329', 'E02000331', 'E02000332', 'E02000333', 'E02000334', 'E02000335', 'E02000337', 'E02000339', 'E02000340', 'E02000341', 'E02000342', 'E02000343', 'E02000344', 'E02006786', 'E02006927', 'E02006928', 'E02006929', 'E02006930', 'E02006931'], 
        'E09000015': ['E02000433', 'E02000434', 'E02000435', 'E02000436', 'E02000437', 'E02000438', 'E02000439', 'E02000440', 'E02000441', 'E02000442', 'E02000443', 'E02000444', 'E02000445', 'E02000447', 'E02000448', 'E02000449', 'E02000451', 'E02000452', 'E02000453', 'E02000454', 'E02000455', 'E02000456', 'E02000457', 'E02000459', 'E02000460', 'E02000461', 'E02000462', 'E02000463', 'E02006795', 'E02006882'], 
        'E09000016': ['E02000464', 'E02000465', 'E02000466', 'E02000467', 'E02000468', 'E02000469', 'E02000470', 'E02000471', 'E02000472', 'E02000473', 'E02000474', 'E02000475', 'E02000476', 'E02000477', 'E02000478', 'E02000479', 'E02000480', 'E02000481', 'E02000482', 'E02000483', 'E02000484', 'E02000485', 'E02000486', 'E02000487', 'E02000488', 'E02000489', 'E02000490', 'E02000491', 'E02000492', 'E02000493'], 
        'E09000017': ['E02000494', 'E02000495', 'E02000496', 'E02000497', 'E02000498', 'E02000499', 'E02000500', 'E02000501', 'E02000502', 'E02000503', 'E02000504', 'E02000506', 'E02000507', 'E02000508', 'E02000509', 'E02000510', 'E02000511', 'E02000512', 'E02000513', 'E02000514', 'E02000515', 'E02000516', 'E02000517', 'E02000518', 'E02000519', 'E02000520', 'E02000521', 'E02000522', 'E02000523', 'E02000524', 'E02000525', 'E02006796'], 
        'E09000018': ['E02000526', 'E02000528', 'E02000529', 'E02000530', 'E02000531', 'E02000532', 'E02000533', 'E02000534', 'E02000535', 'E02000536', 'E02000537', 'E02000538', 'E02000539', 'E02000540', 'E02000541', 'E02000542', 'E02000543', 'E02000544', 'E02000545', 'E02000546', 'E02000547', 'E02000548', 'E02000549', 'E02000550', 'E02000551', 'E02000552', 'E02000553', 'E02006792'], 
        'E09000021': ['E02000598', 'E02000599', 'E02000600', 'E02000601', 'E02000602', 'E02000603', 'E02000604', 'E02000605', 'E02000606', 'E02000607', 'E02000608', 'E02000609', 'E02000610', 'E02000611', 'E02000612', 'E02000613', 'E02000614', 'E02000615', 'E02000616', 'E02000617'], 
        'E09000024': ['E02000689', 'E02000690', 'E02000691', 'E02000692', 'E02000693', 'E02000694', 'E02000695', 'E02000696', 'E02000697', 'E02000698', 'E02000699', 'E02000700', 'E02000701', 'E02000702', 'E02000703', 'E02000704', 'E02000705', 'E02000706', 'E02000707', 'E02000708', 'E02000709', 'E02000710', 'E02000711', 'E02000712', 'E02000713'], 
        'E09000026': ['E02000751', 'E02000752', 'E02000753', 'E02000754', 'E02000755', 'E02000756', 'E02000757', 'E02000758', 'E02000759', 'E02000760', 'E02000762', 'E02000763', 'E02000764', 'E02000765', 'E02000767', 'E02000768', 'E02000769', 'E02000770', 'E02000772', 'E02000773', 'E02000774', 'E02000776', 'E02000777', 'E02000779', 'E02000780', 'E02000781', 'E02000782', 'E02000783', 'E02006800', 'E02006924', 'E02006925'], 
        'E09000027': ['E02000784', 'E02000785', 'E02000786', 'E02000787', 'E02000788', 'E02000789', 'E02000790', 'E02000791', 'E02000792', 'E02000793', 'E02000794', 'E02000795', 'E02000796', 'E02000797', 'E02000798', 'E02000799', 'E02000800', 'E02000801', 'E02000802', 'E02000803', 'E02000804', 'E02000805', 'E02000806'], 
        'E09000029': ['E02000840', 'E02000841', 'E02000842', 'E02000843', 'E02000844', 'E02000845', 'E02000846', 'E02000847', 'E02000848', 'E02000849', 'E02000850', 'E02000851', 'E02000852', 'E02000853', 'E02000854', 'E02000855', 'E02000856', 'E02000857', 'E02000858', 'E02000859', 'E02000860', 'E02000861', 'E02000863', 'E02006836'], 
        'E09000031': ['E02000895', 'E02000896', 'E02000897', 'E02000898', 'E02000899', 'E02000900', 'E02000901', 'E02000902', 'E02000903', 'E02000904', 'E02000905', 'E02000906', 'E02000907', 'E02000908', 'E02000909', 'E02000910', 'E02000911', 'E02000912', 'E02000913', 'E02000914', 'E02000915', 'E02000916', 'E02000917', 'E02000918', 'E02000919', 'E02000920', 'E02000921', 'E02000922'], 
        'E06000036': ['E02003352', 'E02003353', 'E02003354', 'E02003355', 'E02003356', 'E02003357', 'E02003358', 'E02003359', 'E02003360', 'E02003361', 'E02003362', 'E02003363', 'E02003364', 'E02003365', 'E02003366'], 
        'E06000043': ['E02003491', 'E02003492', 'E02003493', 'E02003494', 'E02003495', 'E02003496', 'E02003497', 'E02003498', 'E02003499', 'E02003500', 'E02003501', 'E02003502', 'E02003503', 'E02003504', 'E02003505', 'E02003506', 'E02003507', 'E02003508', 'E02003509', 'E02003510', 'E02003511', 'E02003512', 'E02003513', 'E02003514', 'E02003515', 'E02003516', 'E02003517', 'E02003518', 'E02003519', 'E02003520', 'E02003521', 'E02003522', 'E02003523'], 
        'E06000046': ['E02003581', 'E02003582', 'E02003583', 'E02003584', 'E02003585', 'E02003586', 'E02003587', 'E02003588', 'E02003589', 'E02003590', 'E02003591', 'E02003592', 'E02003593', 'E02003594', 'E02003595', 'E02003596', 'E02003597', 'E02003598'], 
        'E06000035': ['E02003314', 'E02003315', 'E02003316', 'E02003317', 'E02003318', 'E02003319', 'E02003320', 'E02003321', 'E02003322', 'E02003323', 'E02003324', 'E02003325', 'E02003326', 'E02003327', 'E02003328', 'E02003329', 'E02003330', 'E02003331', 'E02003332', 'E02003333', 'E02003334', 'E02003335', 'E02003336', 'E02003337', 'E02003338', 'E02003339', 'E02003340', 'E02003341', 'E02003342', 'E02003343', 'E02003344', 'E02003345', 'E02003346', 'E02003347', 'E02003348', 'E02003349', 'E02003350', 'E02003351'], 
        'E06000042': ['E02003459', 'E02003460', 'E02003461', 'E02003462', 'E02003463', 'E02003464', 'E02003465', 'E02003466', 'E02003467', 'E02003468', 'E02003469', 'E02003470', 'E02003471', 'E02003472', 'E02003473', 'E02003474', 'E02003475', 'E02003476', 'E02003477', 'E02003478', 'E02003479', 'E02003480', 'E02003481', 'E02003482', 'E02003483', 'E02003484', 'E02003485', 'E02003486', 'E02003487', 'E02003488', 'E02003489', 'E02003490'], 
        'E06000044': ['E02003524', 'E02003525', 'E02003526', 'E02003527', 'E02003529', 'E02003530', 'E02003531', 'E02003532', 'E02003533', 'E02003534', 'E02003535', 'E02003536', 'E02003537', 'E02003538', 'E02003539', 'E02003540', 'E02003541', 'E02003542', 'E02003543', 'E02003544', 'E02003545', 'E02003546', 'E02003547', 'E02003548', 'E02006821'], 
        'E06000038': ['E02003389', 'E02003390', 'E02003391', 'E02003392', 'E02003393', 'E02003394', 'E02003395', 'E02003396', 'E02003397', 'E02003398', 'E02003399', 'E02003400', 'E02003401', 'E02003402', 'E02003403', 'E02003404', 'E02003405', 'E02003406'], 
        'E06000039': ['E02003407', 'E02003408', 'E02003409', 'E02003410', 'E02003411', 'E02003412', 'E02003413', 'E02003414', 'E02003415', 'E02003416', 'E02003417', 'E02003418', 'E02003419', 'E02003420'], 
        'E06000045': ['E02003549', 'E02003550', 'E02003551', 'E02003552', 'E02003553', 'E02003554', 'E02003555', 'E02003556', 'E02003557', 'E02003558', 'E02003559', 'E02003560', 'E02003561', 'E02003562', 'E02003563', 'E02003564', 'E02003565', 'E02003566', 'E02003567', 'E02003568', 'E02003569', 'E02003570', 'E02003571', 'E02003572', 'E02003573', 'E02003574', 'E02003575', 'E02003576', 'E02003577', 'E02003578', 'E02003579', 'E02003580'], 
        'E06000037': ['E02003367', 'E02003368', 'E02003369', 'E02003370', 'E02003371', 'E02003372', 'E02003373', 'E02003374', 'E02003375', 'E02003376', 'E02003377', 'E02003378', 'E02003379', 'E02003380', 'E02003381', 'E02003382', 'E02003383', 'E02003384', 'E02003385', 'E02003386', 'E02003387', 'E02003388'], 
        'E06000040': ['E02003421', 'E02003422', 'E02003423', 'E02003424', 'E02003425', 'E02003426', 'E02003427', 'E02003428', 'E02003429', 'E02003430', 'E02003431', 'E02003432', 'E02003433', 'E02003434', 'E02003435', 'E02003436', 'E02003437', 'E02003438'], 
        'E06000041': ['E02003439', 'E02003440', 'E02003441', 'E02003442', 'E02003443', 'E02003444', 'E02003445', 'E02003446', 'E02003447', 'E02003448', 'E02003449', 'E02003450', 'E02003451', 'E02003452', 'E02003453', 'E02003454', 'E02003455', 'E02003456', 'E02003457', 'E02003458'], 
        'E07000004': ['E02003652', 'E02003653', 'E02003654', 'E02003655', 'E02003656', 'E02003657', 'E02003658', 'E02003659', 'E02003660', 'E02003661', 'E02003662', 'E02003663', 'E02003664', 'E02003665', 'E02003666', 'E02003667', 'E02003668', 'E02003669', 'E02003670', 'E02003671', 'E02003672', 'E02003673', 'E02003674', 'E02003675'], 
        'E07000005': ['E02003676', 'E02003677', 'E02003678', 'E02003679', 'E02003680', 'E02003681', 'E02003682', 'E02003683', 'E02003685', 'E02003686', 'E02003687', 'E02006823'], 
        'E07000006': ['E02003688', 'E02003689', 'E02003690', 'E02003691', 'E02003692', 'E02003693', 'E02003694', 'E02003695'], 
        'E07000007': ['E02003696', 'E02003697', 'E02003698', 'E02003699', 'E02003701', 'E02003702', 'E02003703', 'E02003704', 'E02003705', 'E02003706', 'E02003707', 'E02003708', 'E02003709', 'E02003710', 'E02003711', 'E02003712', 'E02003713', 'E02003714', 'E02003715', 'E02003716', 'E02003717', 'E02003718', 'E02006824'], 
        'E07000061': ['E02004356', 'E02004357', 'E02004358', 'E02004359', 'E02004361', 'E02004362', 'E02004363', 'E02004364', 'E02004365', 'E02004366', 'E02004367', 'E02006857', 'E02006858'], 
        'E07000062': ['E02004368', 'E02004369', 'E02004370', 'E02004371', 'E02004372', 'E02004373', 'E02004374', 'E02004375', 'E02004376', 'E02004377', 'E02004378'], 
        'E07000063': ['E02004379', 'E02004380', 'E02004381', 'E02004382', 'E02004383', 'E02004384', 'E02004385', 'E02004386', 'E02004387', 'E02004388', 'E02004389', 'E02004390', 'E02004391'], 
        'E07000064': ['E02004392', 'E02004393', 'E02004394', 'E02004395', 'E02004396', 'E02004397', 'E02004398', 'E02004399', 'E02004400', 'E02004401', 'E02004402'], 
        'E07000065': ['E02004403', 'E02004404', 'E02004405', 'E02004406', 'E02004407', 'E02004408', 'E02004409', 'E02004410', 'E02004411', 'E02004412', 'E02004413', 'E02004414', 'E02004415', 'E02004416', 'E02004417', 'E02004418', 'E02004419', 'E02004420', 'E02004421', 'E02004422', 'E02004423'], 
        'E07000084': ['E02004675', 'E02004676', 'E02004677', 'E02004678', 'E02004679', 'E02004680', 'E02004681', 'E02004682', 'E02004683', 'E02004684', 'E02004685', 'E02004686', 'E02004687', 'E02004688', 'E02004689', 'E02004690', 'E02004691', 'E02004692', 'E02004693', 'E02004694', 'E02004695', 'E02004696'], 
        'E07000085': ['E02004697', 'E02004698', 'E02004699', 'E02004700', 'E02004702', 'E02004703', 'E02004704', 'E02004705', 'E02004706', 'E02004707', 'E02004708', 'E02004709', 'E02004710', 'E02006829', 'E02006838'], 
        'E07000086': ['E02004712', 'E02004713', 'E02004714', 'E02004715', 'E02004716', 'E02004717', 'E02004718', 'E02004719', 'E02004720', 'E02004721', 'E02004722', 'E02004723', 'E02004724', 'E02004725', 'E02004726'], 
        'E07000087': ['E02004727', 'E02004728', 'E02004729', 'E02004730', 'E02004731', 'E02004732', 'E02004733', 'E02004734', 'E02004735', 'E02004736', 'E02004737', 'E02004738', 'E02004739', 'E02004740'], 
        'E07000088': ['E02004741', 'E02004742', 'E02004743', 'E02004744', 'E02004745', 'E02004746', 'E02004747', 'E02004748', 'E02004749', 'E02004750'], 
        'E07000089': ['E02004751', 'E02004752', 'E02004753', 'E02004754', 'E02004755', 'E02004756', 'E02004757', 'E02004758', 'E02004759', 'E02004760', 'E02004761'], 
        'E07000090': ['E02004764', 'E02004765', 'E02004766', 'E02004767', 'E02004768', 'E02004769', 'E02004770', 'E02004771', 'E02004772', 'E02004774', 'E02004775', 'E02004776', 'E02004777', 'E02004778', 'E02006822', 'E02006830', 'E02006831'], 
        'E07000091': ['E02004779', 'E02004780', 'E02004781', 'E02004782', 'E02004783', 'E02004784', 'E02004785', 'E02004786', 'E02004787', 'E02004788', 'E02004789', 'E02004790', 'E02004791', 'E02004792', 'E02004793', 'E02004794', 'E02004795', 'E02004796', 'E02004797', 'E02004798', 'E02004799', 'E02004800', 'E02004801'], 
        'E07000092': ['E02004802', 'E02004803', 'E02004804', 'E02004805', 'E02004806', 'E02004807', 'E02004808', 'E02004809', 'E02004810', 'E02004811', 'E02004812', 'E02004813'], 
        'E07000093': ['E02004814', 'E02004815', 'E02004816', 'E02004817', 'E02004818', 'E02004819', 'E02004820', 'E02004821', 'E02004822', 'E02004823', 'E02004824', 'E02004825', 'E02004826', 'E02004827', 'E02004828'], 
        'E07000094': ['E02004829', 'E02004830', 'E02004831', 'E02004832', 'E02004833', 'E02004834', 'E02004835', 'E02004836', 'E02004837', 'E02004838', 'E02004839', 'E02004840', 'E02004841', 'E02004842'], 
        'E07000105': ['E02004996', 'E02004997', 'E02004998', 'E02004999', 'E02005000', 'E02005001', 'E02005002', 'E02005003', 'E02005004', 'E02005005', 'E02005006', 'E02005007', 'E02005008', 'E02005009'], 
        'E07000106': ['E02005010', 'E02005011', 'E02005012', 'E02005013', 'E02005014', 'E02005015', 'E02005016', 'E02005017', 'E02005018', 'E02005019', 'E02005020', 'E02005021', 'E02005022', 'E02005023', 'E02005025', 'E02005026', 'E02005027', 'E02006855', 'E02006856'], 
        'E07000107': ['E02005028', 'E02005029', 'E02005030', 'E02005031', 'E02005032', 'E02005033', 'E02005034', 'E02005035', 'E02005036', 'E02005037', 'E02005038', 'E02005039', 'E02005040'], 
        'E07000108': ['E02005041', 'E02005042', 'E02005043', 'E02005044', 'E02005045', 'E02005046', 'E02005047', 'E02005048', 'E02005049', 'E02005050', 'E02005051', 'E02005052', 'E02005053', 'E02005054'], 
        'E07000109': ['E02005055', 'E02005056', 'E02005057', 'E02005058', 'E02005059', 'E02005060', 'E02005061', 'E02005062', 'E02005063', 'E02005064', 'E02005065', 'E02005066', 'E02005067'], 
        'E07000110': ['E02005068', 'E02005069', 'E02005070', 'E02005071', 'E02005072', 'E02005073', 'E02005074', 'E02005075', 'E02005076', 'E02005077', 'E02005078', 'E02005079', 'E02005080', 'E02005081', 'E02005082', 'E02005083', 'E02005084', 'E02005085', 'E02005086'], 
        'E07000111': ['E02005087', 'E02005088', 'E02005089', 'E02005090', 'E02005091', 'E02005093', 'E02005094', 'E02005095', 'E02005096', 'E02005097', 'E02005098', 'E02005099', 'E02005100', 'E02005101', 'E02006832'], 
        'E07000112': ['E02005102', 'E02005103', 'E02005104', 'E02005105', 'E02005106', 'E02005107', 'E02005109', 'E02005110', 'E02005111', 'E02005112', 'E02005113', 'E02005114', 'E02006879', 'E02006880'], 
        'E07000113': ['E02005115', 'E02005116', 'E02005117', 'E02005118', 'E02005119', 'E02005120', 'E02005121', 'E02005122', 'E02005123', 'E02005124', 'E02005125', 'E02005126', 'E02005127', 'E02005128', 'E02005129', 'E02005130', 'E02005131'], 
        'E07000114': ['E02005132', 'E02005133', 'E02005134', 'E02005135', 'E02005136', 'E02005137', 'E02005138', 'E02005139', 'E02005140', 'E02005141', 'E02005142', 'E02005143', 'E02005144', 'E02005145', 'E02005146', 'E02005147', 'E02005148'], 
        'E07000115': ['E02005149', 'E02005150', 'E02005151', 'E02005153', 'E02005154', 'E02005155', 'E02005156', 'E02005157', 'E02005158', 'E02005159', 'E02005160', 'E02005161', 'E02006833'], 
        'E07000116': ['E02005162', 'E02005163', 'E02005164', 'E02005165', 'E02005166', 'E02005167', 'E02005168', 'E02005169', 'E02005170', 'E02005171', 'E02005172', 'E02005173', 'E02005174', 'E02005175'], 
        'E07000177': ['E02005921', 'E02005922', 'E02005923', 'E02005924', 'E02005925', 'E02005926', 'E02005927', 'E02005928', 'E02005929', 'E02005930', 'E02005931', 'E02005932', 'E02005933', 'E02005934', 'E02005935', 'E02005936', 'E02005937', 'E02005938', 'E02005939'], 
        'E07000178': ['E02005940', 'E02005941', 'E02005942', 'E02005943', 'E02005944', 'E02005945', 'E02005946', 'E02005947', 'E02005948', 'E02005949', 'E02005950', 'E02005951', 'E02005952', 'E02005953', 'E02005954', 'E02005955', 'E02005956', 'E02005957'], 
        'E07000179': ['E02005958', 'E02005959', 'E02005960', 'E02005961', 'E02005962', 'E02005963', 'E02005964', 'E02005965', 'E02005966', 'E02005967', 'E02005968', 'E02005969', 'E02005970', 'E02005971', 'E02005972', 'E02005973', 'E02005974', 'E02005975', 'E02005976', 'E02005977'], 
        'E07000180': ['E02005978', 'E02005979', 'E02005980', 'E02005981', 'E02005982', 'E02005983', 'E02005984', 'E02005985', 'E02005986', 'E02005987', 'E02005988', 'E02005991', 'E02005992', 'E02006886'], 
        'E07000181': ['E02005993', 'E02005994', 'E02005995', 'E02005996', 'E02005997', 'E02005998', 'E02005999', 'E02006000', 'E02006001', 'E02006002', 'E02006003', 'E02006004', 'E02006005', 'E02006006', 'E02006007'], 
        'E07000207': ['E02006317', 'E02006318', 'E02006319', 'E02006320', 'E02006321', 'E02006322', 'E02006323', 'E02006324', 'E02006325', 'E02006326', 'E02006327', 'E02006328', 'E02006329', 'E02006330', 'E02006331', 'E02006332', 'E02006333', 'E02006334'], 
        'E07000208': ['E02006335', 'E02006336', 'E02006337', 'E02006338', 'E02006339', 'E02006341', 'E02006342', 'E02006343', 'E02006837'], 
        'E07000209': ['E02006344', 'E02006345', 'E02006346', 'E02006347', 'E02006348', 'E02006349', 'E02006350', 'E02006351', 'E02006352', 'E02006353', 'E02006354', 'E02006355', 'E02006356', 'E02006357', 'E02006358', 'E02006359', 'E02006360', 'E02006361'], 
        'E07000210': ['E02006362', 'E02006363', 'E02006364', 'E02006365', 'E02006366', 'E02006367', 'E02006368', 'E02006369', 'E02006370', 'E02006371', 'E02006372', 'E02006373', 'E02006374'], 
        'E07000211': ['E02006375', 'E02006376', 'E02006377', 'E02006378', 'E02006379', 'E02006380', 'E02006381', 'E02006382', 'E02006383', 'E02006384', 'E02006385', 'E02006386', 'E02006387', 'E02006388', 'E02006389', 'E02006390', 'E02006391', 'E02006392'], 
        'E07000212': ['E02006393', 'E02006394', 'E02006395', 'E02006396', 'E02006397', 'E02006398', 'E02006399', 'E02006400', 'E02006401', 'E02006402'], 
        'E07000213': ['E02006403', 'E02006404', 'E02006405', 'E02006406', 'E02006407', 'E02006408', 'E02006409', 'E02006410', 'E02006411', 'E02006412', 'E02006413', 'E02006414', 'E02006415'], 
        'E07000214': ['E02006416', 'E02006417', 'E02006418', 'E02006419', 'E02006420', 'E02006421', 'E02006422', 'E02006423', 'E02006424', 'E02006425', 'E02006426', 'E02006427'], 
        'E07000215': ['E02006429', 'E02006430', 'E02006431', 'E02006432', 'E02006433', 'E02006434', 'E02006435', 'E02006436', 'E02006437', 'E02006438', 'E02006790'], 
        'E07000216': ['E02006439', 'E02006440', 'E02006441', 'E02006442', 'E02006443', 'E02006444', 'E02006445', 'E02006446', 'E02006447', 'E02006448', 'E02006449', 'E02006450', 'E02006451', 'E02006453', 'E02006454', 'E02006455', 'E02006839'], 
        'E07000217': ['E02006456', 'E02006457', 'E02006458', 'E02006459', 'E02006460', 'E02006461', 'E02006462', 'E02006463', 'E02006464', 'E02006465', 'E02006466', 'E02006467'], 
        'E07000223': ['E02006534', 'E02006535', 'E02006536', 'E02006537', 'E02006538', 'E02006539', 'E02006540', 'E02006541'], 
        'E07000224': ['E02006542', 'E02006543', 'E02006544', 'E02006545', 'E02006546', 'E02006547', 'E02006548', 'E02006549', 'E02006550', 'E02006551', 'E02006552', 'E02006553', 'E02006554', 'E02006555', 'E02006556', 'E02006557', 'E02006558', 'E02006559', 'E02006560'], 
        'E07000225': ['E02006561', 'E02006562', 'E02006563', 'E02006564', 'E02006565', 'E02006566', 'E02006567', 'E02006568', 'E02006569', 'E02006570', 'E02006571', 'E02006572', 'E02006573', 'E02006574'], 
        'E07000226': ['E02006575', 'E02006576', 'E02006577', 'E02006578', 'E02006579', 'E02006580', 'E02006581', 'E02006582', 'E02006583', 'E02006584', 'E02006585', 'E02006586', 'E02006587'], 
        'E07000227': ['E02006588', 'E02006589', 'E02006590', 'E02006591', 'E02006592', 'E02006593', 'E02006594', 'E02006595', 'E02006596', 'E02006597', 'E02006598', 'E02006599', 'E02006600', 'E02006601', 'E02006602', 'E02006603'], 
        'E07000228': ['E02006604', 'E02006605', 'E02006606', 'E02006607', 'E02006608', 'E02006609', 'E02006610', 'E02006611', 'E02006612', 'E02006613', 'E02006614', 'E02006615', 'E02006616', 'E02006617', 'E02006618', 'E02006619', 'E02006620'], 
        'E07000229': ['E02006621', 'E02006622', 'E02006623', 'E02006624', 'E02006625', 'E02006626', 'E02006627', 'E02006628', 'E02006629', 'E02006630', 'E02006631', 'E02006632', 'E02006633'], 
        'E06000022': ['E02002985', 'E02002986', 'E02002987', 'E02002988', 'E02002989', 'E02002990', 'E02002991', 'E02002992', 'E02002993', 'E02002994', 'E02002995', 'E02002996', 'E02002997', 'E02002998', 'E02002999', 'E02003000', 'E02003001', 'E02003002', 'E02003003', 'E02003004', 'E02003005', 'E02003006', 'E02003007', 'E02003008', 'E02003009', 'E02003010', 'E02003011'], 
        'E06000028': ['E02003172', 'E02003173', 'E02003174', 'E02003175', 'E02003176', 'E02003177', 'E02003178', 'E02003179', 'E02003180', 'E02003181', 'E02003182', 'E02003183', 'E02003184', 'E02003185', 'E02003186', 'E02003187', 'E02003188', 'E02003189', 'E02003190', 'E02003191', 'E02003192', 'E02006883', 'E02006885'], 
        'E06000023': ['E02003012', 'E02003013', 'E02003014', 'E02003015', 'E02003016', 'E02003017', 'E02003018', 'E02003019', 'E02003020', 'E02003021', 'E02003022', 'E02003023', 'E02003024', 'E02003025', 'E02003026', 'E02003027', 'E02003028', 'E02003029', 'E02003030', 'E02003031', 'E02003032', 'E02003033', 'E02003034', 'E02003036', 'E02003037', 'E02003038', 'E02003039', 'E02003040', 'E02003041', 'E02003043', 'E02003044', 'E02003045', 'E02003046', 'E02003047', 'E02003048', 'E02003049', 'E02003050', 'E02003051', 'E02003052', 'E02003053', 'E02003054', 'E02003055', 'E02003056', 'E02003057', 'E02003058', 'E02003059', 'E02003060', 'E02003061', 'E02003062', 'E02003063', 'E02003064', 'E02006887', 'E02006888', 'E02006889', 'E02006890'], 
        'E06000052': ['E02003931', 'E02003932', 'E02003933', 'E02003934', 'E02003935', 'E02003936', 'E02003937', 'E02003938', 'E02003939', 'E02003892', 'E02003940', 'E02003893', 'E02003894', 'E02003941', 'E02003942', 'E02003895', 'E02003896', 'E02003952', 'E02003953', 'E02003954', 'E02003955', 'E02003897', 'E02003898', 'E02003956', 'E02003899', 'E02003900', 'E02003957', 'E02003901', 'E02003902', 'E02003958', 'E02003959', 'E02003905', 'E02003906', 'E02003903', 'E02003960', 'E02003961', 'E02003904', 'E02003962', 'E02003963', 'E02003907', 'E02003964', 'E02003908', 'E02003909', 'E02003910', 'E02003918', 'E02003919', 'E02003911', 'E02003912', 'E02003920', 'E02003921', 'E02003922', 'E02003923', 'E02003924', 'E02003943', 'E02003925', 'E02003913', 'E02003944', 'E02003945', 'E02003926', 'E02003914', 'E02003946', 'E02003915', 'E02003916', 'E02003917', 'E02003947', 'E02003927', 'E02003948', 'E02003949', 'E02003950', 'E02003951', 'E02003928', 'E02003929', 'E02003930'], 
        'E06000053': ['E02006781'], 
        'E06000024': ['E02003065', 'E02003066', 'E02003067', 'E02003068', 'E02003069', 'E02003070', 'E02003071', 'E02003072', 'E02003073', 'E02003074', 'E02003075', 'E02003076', 'E02003077', 'E02003078', 'E02003079', 'E02003080', 'E02003081', 'E02003082', 'E02003084', 'E02003085', 'E02003086', 'E02003087', 'E02003088', 'E02003089', 'E02006845', 'E02006846'], 
        'E06000026': ['E02003122', 'E02003123', 'E02003124', 'E02003125', 'E02003126', 'E02003127', 'E02003128', 'E02003129', 'E02003130', 'E02003131', 'E02003132', 'E02003133', 'E02003134', 'E02003135', 'E02003136', 'E02003137', 'E02003138', 'E02003139', 'E02003140', 'E02003141', 'E02003142', 'E02003143', 'E02003144', 'E02003145', 'E02003146', 'E02003147', 'E02003148', 'E02003149', 'E02003150', 'E02003151', 'E02003152', 'E02003153'], 
        'E06000029': ['E02003194', 'E02003195', 'E02003196', 'E02003197', 'E02003198', 'E02003199', 'E02003200', 'E02003201', 'E02003202', 'E02003203', 'E02003204', 'E02003205', 'E02003206', 'E02003207', 'E02003208', 'E02003209', 'E02003210', 'E02003211'], 
        'E06000025': ['E02003090', 'E02003091', 'E02003092', 'E02003093', 'E02003094', 'E02003095', 'E02003096', 'E02003097', 'E02003098', 'E02003099', 'E02003100', 'E02003101', 'E02003102', 'E02003103', 'E02003104', 'E02003105', 'E02003106', 'E02003107', 'E02003108', 'E02003109', 'E02003110', 'E02003111', 'E02003112', 'E02003113', 'E02003114', 'E02003115', 'E02003116', 'E02003117', 'E02003118', 'E02003119', 'E02003120', 'E02003121'], 
        'E06000030': ['E02003212', 'E02003214', 'E02003215', 'E02003216', 'E02003217', 'E02003218', 'E02003219', 'E02003220', 'E02003221', 'E02003222', 'E02003223', 'E02003224', 'E02003225', 'E02003226', 'E02003227', 'E02003228', 'E02003229', 'E02003230', 'E02003231', 'E02003232', 'E02003233', 'E02003234', 'E02003235', 'E02003236', 'E02006847', 'E02006848', 'E02006849'], 
        'E06000027': ['E02003154', 'E02003155', 'E02003156', 'E02003157', 'E02003158', 'E02003159', 'E02003161', 'E02003163', 'E02003164', 'E02003165', 'E02003166', 'E02003167', 'E02003168', 'E02003169', 'E02003170', 'E02003171', 'E02006840'], 
        'E06000054': ['E02006644', 'E02006645', 'E02006646', 'E02006647', 'E02006648', 'E02006649', 'E02006650', 'E02006651', 'E02006652', 'E02006653', 'E02006654', 'E02006634', 'E02006655', 'E02006656', 'E02006657', 'E02006658', 'E02006659', 'E02006660', 'E02006635', 'E02006678', 'E02006679', 'E02006680', 'E02006681', 'E02006636', 'E02006637', 'E02006638', 'E02006682', 'E02006639', 'E02006640', 'E02006683', 'E02006684', 'E02006685', 'E02006686', 'E02006641', 'E02006687', 'E02006688', 'E02006689', 'E02006642', 'E02006690', 'E02006691', 'E02006643', 'E02006692', 'E02006693', 'E02006694', 'E02006661', 'E02006662', 'E02006695', 'E02006663', 'E02006664', 'E02006665', 'E02006666', 'E02006667', 'E02006668', 'E02006669', 'E02006670', 'E02006671', 'E02006672', 'E02006673', 'E02006674', 'E02006675', 'E02006676', 'E02006677'], 
        'E07000040': ['E02004129', 'E02004130', 'E02004131', 'E02004132', 'E02004133', 'E02004134', 'E02004135', 'E02004136', 'E02004137', 'E02004138', 'E02004139', 'E02004140', 'E02004141', 'E02004142', 'E02004143', 'E02004144', 'E02004145', 'E02004146', 'E02004147', 'E02004148'], 
        'E07000041': ['E02004149', 'E02004150', 'E02004151', 'E02004152', 'E02004153', 'E02004154', 'E02004155', 'E02004156', 'E02004157', 'E02004158', 'E02004159', 'E02004160', 'E02004161', 'E02004162', 'E02004163'], 
        'E07000042': ['E02004164', 'E02004165', 'E02004166', 'E02004167', 'E02004168', 'E02004169', 'E02004170', 'E02004171', 'E02004172', 'E02004173', 'E02004174'], 
        'E07000043': ['E02004175', 'E02004176', 'E02004177', 'E02004178', 'E02004179', 'E02004180', 'E02004181', 'E02004182', 'E02004183', 'E02004184', 'E02004185', 'E02004186', 'E02004187', 'E02004188'], 
        'E07000044': ['E02004189', 'E02004190', 'E02004191', 'E02004192', 'E02004193', 'E02004194', 'E02004195', 'E02004196', 'E02004197', 'E02004198', 'E02004199', 'E02004200'], 
        'E07000045': ['E02004201', 'E02004202', 'E02004203', 'E02004204', 'E02004205', 'E02004206', 'E02004207', 'E02004208', 'E02004209', 'E02004210', 'E02004211', 'E02004212', 'E02004213', 'E02004214', 'E02004215', 'E02004216', 'E02004217', 'E02004218', 'E02004219'], 
        'E07000046': ['E02004220', 'E02004221', 'E02004222', 'E02004223', 'E02004224', 'E02004225', 'E02004226', 'E02004227', 'E02004228'], 
        'E07000047': ['E02004229', 'E02004230', 'E02004231', 'E02004232', 'E02004233', 'E02004234', 'E02004235'], 
        'E07000048': ['E02004236', 'E02004237', 'E02004238', 'E02004239', 'E02004240', 'E02004241', 'E02004242'], 
        'E07000049': ['E02004243', 'E02004244', 'E02004245', 'E02004246', 'E02004247', 'E02004248', 'E02004249', 'E02004250', 'E02004251', 'E02004252', 'E02004253', 'E02004254'], 
        'E07000050': ['E02004255', 'E02004256', 'E02004257', 'E02004258', 'E02004259', 'E02004260', 'E02004261', 'E02004262'], 
        'E07000051': ['E02004263', 'E02004264', 'E02004265', 'E02004266', 'E02004267', 'E02004268'], 
        'E07000052': ['E02004269', 'E02004270', 'E02004271', 'E02004272', 'E02004273', 'E02004274', 'E02004275', 'E02004276', 'E02004277', 'E02004278', 'E02004279', 'E02004280'], 
        'E07000053': ['E02004281', 'E02004282', 'E02004283', 'E02004284', 'E02004285', 'E02004286', 'E02004287', 'E02004288', 'E02004289'], 
        'E07000078': ['E02004600', 'E02004601', 'E02004602', 'E02004603', 'E02004604', 'E02004605', 'E02004606', 'E02004607', 'E02004608', 'E02004609', 'E02004610', 'E02004611', 'E02004612', 'E02004613', 'E02004614'], 
        'E07000079': ['E02004615', 'E02004616', 'E02004617', 'E02004618', 'E02004619', 'E02004620', 'E02004621', 'E02004622', 'E02004623', 'E02004624', 'E02004625'], 
        'E07000080': ['E02004626', 'E02004627', 'E02004628', 'E02004629', 'E02004630', 'E02004631', 'E02004632', 'E02004633', 'E02004634', 'E02004635'], 
        'E07000081': ['E02004636', 'E02004637', 'E02004638', 'E02004639', 'E02004640', 'E02004641', 'E02004642', 'E02004643', 'E02004644', 'E02004645', 'E02004646', 'E02004647', 'E02004648', 'E02004649', 'E02004650'], 
        'E07000082': ['E02004651', 'E02004652', 'E02004653', 'E02004654', 'E02004655', 'E02004656', 'E02004657', 'E02004658', 'E02004659', 'E02004660', 'E02004661', 'E02004662', 'E02004663', 'E02004664', 'E02004665'], 
        'E07000083': ['E02004666', 'E02004667', 'E02004668', 'E02004669', 'E02004670', 'E02004671', 'E02004672', 'E02004673', 'E02004674'], 
        'E07000187': ['E02006047', 'E02006048', 'E02006049', 'E02006050', 'E02006051', 'E02006052', 'E02006053', 'E02006054', 'E02006055', 'E02006056', 'E02006057', 'E02006058', 'E02006059', 'E02006060'], 
        'E07000188': ['E02006061', 'E02006062', 'E02006063', 'E02006064', 'E02006065', 'E02006066', 'E02006067', 'E02006068', 'E02006069', 'E02006070', 'E02006071', 'E02006072', 'E02006073', 'E02006074'], 
        'E07000189': ['E02006075', 'E02006076', 'E02006077', 'E02006078', 'E02006079', 'E02006080', 'E02006081', 'E02006082', 'E02006083', 'E02006084', 'E02006085', 'E02006086', 'E02006087', 'E02006088', 'E02006089', 'E02006090', 'E02006091', 'E02006092', 'E02006093', 'E02006094', 'E02006095', 'E02006096', 'E02006097', 'E02006098'], 
        'E07000190': ['E02006099', 'E02006100', 'E02006101', 'E02006102', 'E02006103', 'E02006104', 'E02006105', 'E02006106', 'E02006107', 'E02006108', 'E02006109', 'E02006110', 'E02006111', 'E02006112'], 
        'E07000191': ['E02006113', 'E02006114', 'E02006115', 'E02006116', 'E02006117'], 
        'W06000001': ['W02000001', 'W02000002', 'W02000003', 'W02000004', 'W02000005', 'W02000006', 'W02000007', 'W02000008', 'W02000009'], 
        'W06000002': ['W02000010', 'W02000011', 'W02000012', 'W02000013', 'W02000014', 'W02000015', 'W02000016', 'W02000017', 'W02000018', 'W02000019', 'W02000020', 'W02000021', 'W02000022', 'W02000023', 'W02000024', 'W02000025', 'W02000026'], 
        'W06000003': ['W02000027', 'W02000028', 'W02000029', 'W02000030', 'W02000031', 'W02000032', 'W02000033', 'W02000034', 'W02000035', 'W02000036', 'W02000037', 'W02000038', 'W02000039', 'W02000040', 'W02000041'], 
        'W06000004': ['W02000042', 'W02000043', 'W02000044', 'W02000045', 'W02000047', 'W02000049', 'W02000050', 'W02000051', 'W02000052', 'W02000053', 'W02000054', 'W02000055', 'W02000056', 'W02000057', 'W02000419'], 
        'W06000005': ['W02000058', 'W02000059', 'W02000060', 'W02000061', 'W02000062', 'W02000063', 'W02000064', 'W02000065', 'W02000066', 'W02000067', 'W02000068', 'W02000069', 'W02000070', 'W02000071', 'W02000072', 'W02000073', 'W02000074', 'W02000075', 'W02000076', 'W02000077'], 
        'W06000006': ['W02000080', 'W02000081', 'W02000082', 'W02000083', 'W02000084', 'W02000085', 'W02000086', 'W02000087', 'W02000088', 'W02000089', 'W02000090', 'W02000091', 'W02000092', 'W02000093', 'W02000094', 'W02000095', 'W02000096', 'W02000420'], 
        'W06000023': ['W02000097', 'W02000098', 'W02000099', 'W02000100', 'W02000101', 'W02000102', 'W02000103', 'W02000104', 'W02000105', 'W02000106', 'W02000107', 'W02000108', 'W02000109', 'W02000110', 'W02000111', 'W02000113', 'W02000114', 'W02000414', 'W02000416'], 
        'W06000008': ['W02000116', 'W02000117', 'W02000118', 'W02000120', 'W02000122', 'W02000123', 'W02000124', 'W02000125', 'W02000421'], 
        'W06000009': ['W02000126', 'W02000127', 'W02000128', 'W02000129', 'W02000130', 'W02000131', 'W02000132', 'W02000133', 'W02000134', 'W02000135', 'W02000136', 'W02000137', 'W02000138', 'W02000139', 'W02000140', 'W02000141'], 
        'W06000010': ['W02000142', 'W02000143', 'W02000144', 'W02000145', 'W02000146', 'W02000147', 'W02000148', 'W02000149', 'W02000151', 'W02000152', 'W02000153', 'W02000154', 'W02000156', 'W02000157', 'W02000158', 'W02000159', 'W02000160', 'W02000161', 'W02000162', 'W02000163', 'W02000164', 'W02000165', 'W02000166', 'W02000167', 'W02000418'], 
        'W06000011': ['W02000168', 'W02000169', 'W02000170', 'W02000171', 'W02000172', 'W02000173', 'W02000174', 'W02000175', 'W02000176', 'W02000177', 'W02000178', 'W02000179', 'W02000180', 'W02000181', 'W02000182', 'W02000183', 'W02000184', 'W02000185', 'W02000186', 'W02000187', 'W02000188', 'W02000189', 'W02000190', 'W02000191', 'W02000192', 'W02000193', 'W02000194', 'W02000195', 'W02000196', 'W02000197', 'W02000198'], 
        'W06000012': ['W02000200', 'W02000201', 'W02000202', 'W02000203', 'W02000204', 'W02000205', 'W02000206', 'W02000207', 'W02000208', 'W02000209', 'W02000210', 'W02000211', 'W02000212', 'W02000213', 'W02000214', 'W02000215', 'W02000216', 'W02000217', 'W02000417'], 
        'W06000013': ['W02000218', 'W02000219', 'W02000220', 'W02000221', 'W02000222', 'W02000223', 'W02000224', 'W02000225', 'W02000226', 'W02000227', 'W02000228', 'W02000229', 'W02000230', 'W02000231', 'W02000232', 'W02000233', 'W02000234', 'W02000235', 'W02000236'], 
        'W06000014': ['W02000237', 'W02000238', 'W02000239', 'W02000240', 'W02000241', 'W02000242', 'W02000243', 'W02000244', 'W02000245', 'W02000246', 'W02000247', 'W02000248', 'W02000249', 'W02000250', 'W02000251'], 
        'W06000015': ['W02000367', 'W02000368', 'W02000369', 'W02000370', 'W02000371', 'W02000372', 'W02000373', 'W02000374', 'W02000375', 'W02000376', 'W02000377', 'W02000378', 'W02000379', 'W02000380', 'W02000381', 'W02000382', 'W02000383', 'W02000384', 'W02000385', 'W02000386', 'W02000387', 'W02000388', 'W02000389', 'W02000390', 'W02000391', 'W02000392', 'W02000393', 'W02000394', 'W02000395', 'W02000396', 'W02000397', 'W02000398', 'W02000399', 'W02000400', 'W02000401', 'W02000402', 'W02000403', 'W02000404', 'W02000405', 'W02000406', 'W02000407', 'W02000408', 'W02000409', 'W02000410', 'W02000411', 'W02000412', 'W02000422', 'W02000423'], 
        'W06000016': ['W02000252', 'W02000253', 'W02000254', 'W02000255', 'W02000256', 'W02000257', 'W02000258', 'W02000259', 'W02000260', 'W02000261', 'W02000262', 'W02000263', 'W02000264', 'W02000265', 'W02000266', 'W02000267', 'W02000268', 'W02000269', 'W02000270', 'W02000271', 'W02000272', 'W02000273', 'W02000274', 'W02000275', 'W02000276', 'W02000277', 'W02000278', 'W02000279', 'W02000280', 'W02000281', 'W02000282'], 
        'W06000024': ['W02000284', 'W02000285', 'W02000286', 'W02000287', 'W02000288', 'W02000289', 'W02000415'], 
        'W06000018': ['W02000290', 'W02000291', 'W02000292', 'W02000293', 'W02000294', 'W02000295', 'W02000296', 'W02000297', 'W02000298', 'W02000299', 'W02000300', 'W02000301', 'W02000302', 'W02000303', 'W02000304', 'W02000305', 'W02000306', 'W02000307', 'W02000308', 'W02000309', 'W02000310', 'W02000311', 'W02000312', 'W02000313'], 
        'W06000019': ['W02000314', 'W02000315', 'W02000316', 'W02000317', 'W02000318', 'W02000319', 'W02000320', 'W02000321', 'W02000322'], 
        'W06000020': ['W02000323', 'W02000324', 'W02000325', 'W02000326', 'W02000327', 'W02000328', 'W02000329', 'W02000330', 'W02000331', 'W02000332', 'W02000333', 'W02000334', 'W02000335'], 
        'W06000021': ['W02000336', 'W02000337', 'W02000338', 'W02000339', 'W02000340', 'W02000341', 'W02000342', 'W02000343', 'W02000344', 'W02000345', 'W02000346'], 
        'W06000022': ['W02000347', 'W02000348', 'W02000349', 'W02000350', 'W02000351', 'W02000352', 'W02000353', 'W02000354', 'W02000355', 'W02000356', 'W02000357', 'W02000358', 'W02000359', 'W02000360', 'W02000361', 'W02000362', 'W02000363', 'W02000364', 'W02000365', 'W02000366']
        }
    
    return msoa_lad_map