"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmutableRole = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Construct {
    constructor(scope, id, role) {
        super(scope, id);
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return { statementAdded: true, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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