/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.web.session;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.web.CacheSession;
import com.alachisoft.ncache.web.LockException;
import com.alachisoft.ncache.web.ProxyRequest;
import com.alachisoft.ncache.web.ProxyResponse;
import com.alachisoft.ncache.web.config.dom.MultiSiteConfig;
import com.alachisoft.ncache.web.config.dom.SessionConfiguration;
import com.alachisoft.ncache.web.session.NCacheManager;
import com.alachisoft.ncache.web.session.RegionalCache;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class NCacheSessionProvider
implements Filter {
    NCacheManager _cacheManager = null;
    String cacheName = null;
    Logger logger = Logger.getLogger(NCacheSessionProvider.class);
    private boolean lockRemoteSession = true;
    int lockTimeOut = 1;
    int numberOfRetries = 5;
    int retryInterval = 500;
    boolean emptySessions = false;
    String configPath = null;
    String sessionConfigPath = null;
    public static final String INITPARAM_LOCK_REMOTE_SESSION = "enable-session-locking";
    public static final String INITPARAM_LOCK_TIMEOUT = "lock-timeout";
    public static final String EMPTY_SESSIONS = "empty-session-when-locked";
    public static final String INITPARAM_NUMBER_OF_RETRIES = "retries-count";
    public static final String INITPARAM_RETRY_INTERVAL = "retry-interval";
    public static final String INITPARAM_SCONFIG_PATH = "configPath";
    public static final String INITPARAM_SCONFIG_FILE = "session.xml";
    private boolean _isMultiSite = false;
    private static SessionConfiguration[] _sessionConfigurations;
    private static SessionConfiguration _sessionConfiguration;

    public void init(FilterConfig filterConfig) throws ServletException {
        Object object;
        Object object2;
        this.sessionConfigPath = filterConfig.getInitParameter(INITPARAM_SCONFIG_PATH);
        try {
            if (this.sessionConfigPath != null) {
                object2 = Common.combinePath((String)this.sessionConfigPath, (String[])new String[]{INITPARAM_SCONFIG_FILE});
                object = new File((String)object2);
                if (!((File)object).exists() || !((File)object).canRead()) {
                    throw new ServletException("Unable to load NCache session configuration file");
                }
            } else {
                throw new ServletException("Please make sure that web.xml have \u00e2\u20ac\u02dcconfigPath\u00e2\u20ac\u2122 init-param for NCache filter.");
            }
            this.loadConfig(INITPARAM_SCONFIG_FILE, (String)object2);
        }
        catch (Exception exception) {
            this.logger.error((Object)("Unable to configure NCache session provider: " + exception.getMessage()));
            throw new ServletException(exception.getLocalizedMessage());
        }
        try {
            if (_sessionConfiguration != null) {
                object2 = _sessionConfiguration.getMultiSiteConfig();
                if (object2 != null) {
                    object = ((MultiSiteConfig)object2).getPrimaryCache();
                    this.cacheName = object[0] != null && ((MultiSiteConfig)object2).getPrimaryCache().length > 0 ? object[0].getId() : null;
                    this._isMultiSite = true;
                } else {
                    String string = this.cacheName = _sessionConfiguration.getCache() != null ? _sessionConfiguration.getCache().getId() : null;
                }
                if (this.cacheName == null) {
                    throw new ServletException("cacheName cannot be null");
                }
                object = _sessionConfiguration.getLocking().getEnableLocking();
                if (object != null) {
                    this.lockRemoteSession = this.convertToBoolean(INITPARAM_LOCK_REMOTE_SESSION, object.toString());
                }
                if (this.lockRemoteSession) {
                    object = _sessionConfiguration.getLocking().getLockTimeout();
                    if (object != null) {
                        this.lockTimeOut = this.convertToInt(INITPARAM_LOCK_TIMEOUT, object.toString());
                    }
                    if ((object = Integer.valueOf(_sessionConfiguration.getLocking().getRetriesCount())) != null) {
                        this.numberOfRetries = this.convertToInt(INITPARAM_NUMBER_OF_RETRIES, object.toString());
                    }
                    if ((object = Integer.valueOf(_sessionConfiguration.getLocking().getRetryInterval())) != null) {
                        this.retryInterval = this.convertToInt(INITPARAM_RETRY_INTERVAL, object.toString());
                    }
                    if ((object = Boolean.valueOf(_sessionConfiguration.getLocking().getEmptySessions())) != null) {
                        this.emptySessions = this.convertToBoolean(EMPTY_SESSIONS, object.toString());
                    }
                }
                this.configPath = this.sessionConfigPath;
                this.initLogging(filterConfig);
                this.logger.debug((Object)"Filter configuration:");
                this.logger.debug((Object)("\tcacheName: " + this.cacheName));
                this.logger.debug((Object)("\tlockRemoteSession: " + this.lockRemoteSession));
                this.logger.debug((Object)("\tlockTimeout: " + this.lockTimeOut));
                this.logger.debug((Object)("\tnumberOfRetries: " + this.numberOfRetries));
                this.logger.debug((Object)("\tretryInterval: " + this.retryInterval));
                this.logger.debug((Object)("\tconfigPath: " + this.configPath));
                this._cacheManager = this._isMultiSite ? new RegionalCache(this.cacheName.toString(), this.lockRemoteSession, this.lockTimeOut, this.numberOfRetries, this.retryInterval, this.emptySessions, this.configPath, (MultiSiteConfig)object2) : new NCacheManager(this.cacheName.toString(), this.lockRemoteSession, this.lockTimeOut, this.numberOfRetries, this.retryInterval, this.emptySessions, this.configPath, null);
            }
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    private void initLogging(FilterConfig filterConfig) {
        Serializable serializable;
        Object object;
        String string = _sessionConfiguration.getLogFile().getPropFile();
        boolean bl = false;
        if (string != null && (object = filterConfig.getServletContext().getRealPath(string)) != null && (serializable = new File((String)object)).exists() && serializable.canRead()) {
            PropertyConfigurator.configure((String)object);
            bl = true;
        }
        if (!bl && string != null && !((String)(object = string)).startsWith("/")) {
            object = "/" + string;
            try {
                serializable = this.getClass().getResource((String)object);
                if (serializable != null) {
                    PropertyConfigurator.configure((URL)serializable);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            string = null;
            PropertyConfigurator.configure((URL)this.getClass().getResource("/com/alachisoft/ncache/web/log4j.properties"));
            bl = true;
        }
        this.logger = Logger.getLogger(NCacheSessionProvider.class);
        if (bl) {
            this.logger.info((Object)("Logger initialized from " + (string == null ? "defaults" : string)));
        } else {
            this.logger.info((Object)"NCache is not able to initialize logging. Will use the global logger.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this._cacheManager == null) {
            return;
        }
        Object object = servletRequest;
        Object object2 = servletResponse;
        this.logger.info((Object)"processing request");
        this.logger.debug((Object)"In doFilter ...");
        if (!this._cacheManager.isConnected()) {
            this.logger.info((Object)("Cache [" + this.cacheName + "] is not initialized. retrying ..."));
            try {
                this._cacheManager.initializeCache(this.cacheName, this.configPath, null);
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        }
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse && this._cacheManager.isConnected()) {
            this.logger.debug((Object)"Generating proxy request and response");
            object2 = new ProxyResponse((HttpServletResponse)servletResponse);
            try {
                object = new ProxyRequest((HttpServletRequest)servletRequest, (ProxyResponse)((Object)object2), this._cacheManager);
            }
            catch (LockException lockException) {
                throw new RuntimeException(lockException);
            }
        }
        filterChain.doFilter(object, object2);
        this.logger.debug((Object)"Request completed.");
        if (object instanceof ProxyRequest) {
            CacheSession cacheSession;
            if (((ProxyRequest)((Object)object)).hasFatalError()) {
                try {
                    ((HttpServletResponse)servletResponse).sendError(500, "Session is locked by another request. Please try after few seconds.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((cacheSession = ((ProxyRequest)((Object)object)).getCacheSession()) != null) {
                HttpSession httpSession;
                this.logger.debug((Object)"Saving session state.");
                Object object3 = httpSession = ((HttpServletRequest)servletRequest).getSession(false);
                if (object3 == null) {
                    object3 = new Object();
                }
                try {
                    HttpSession httpSession2 = object3;
                    synchronized (httpSession2) {
                        this._cacheManager.finalizeCacheSession(httpSession, cacheSession);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                ((HttpServletResponse)servletResponse).addCookie(new Cookie(ProxyRequest.NCACHE_SESSION_ID, cacheSession.getSessionId()));
            } else {
                this.logger.debug((Object)"No valid session to store in cache.");
            }
        }
    }

    public void destroy() {
        if (this._cacheManager == null) {
            return;
        }
        this.logger.info((Object)"Closing filter. Application going down.");
        if (this._cacheManager.isConnected()) {
            this.logger.info((Object)("Disconnecting from cache: " + this.cacheName));
            this._cacheManager.disconnect();
        }
    }

    private int convertToInt(String string, String string2) {
        try {
            if (string2 == null || string2.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid value for parameter: " + string);
        }
    }

    private boolean convertToBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Invalid value for parameter: " + string);
    }

    private void loadConfig(String string, String string2) throws Exception {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder(string2);
        try {
            configurationBuilder.RegisterRootConfigurationObject(SessionConfiguration.class);
            configurationBuilder.ReadConfiguration();
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.getMessage(), exception.getCause());
        }
        _sessionConfigurations = new SessionConfiguration[configurationBuilder.getConfiguration().length];
        System.arraycopy(configurationBuilder.getConfiguration(), 0, _sessionConfigurations, 0, configurationBuilder.getConfiguration().length);
        if (_sessionConfigurations.length != 1) {
            throw new ConfigurationException("Please provide config for sessions or multi site sessions");
        }
        _sessionConfiguration = _sessionConfigurations[0];
    }
}

