/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.utility.jarscanner;

import com.alachisoft.ncache.utility.jarscanner.Fields;
import com.alachisoft.ncache.utility.jarscanner.JarFileLoader;
import com.alachisoft.ncache.utility.jarscanner.JarUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JARReflector {
    public String[] getClassNames(String path, String interfaceName) throws Exception {
        List list = this.getClasses(path, interfaceName);
        if (list == null && list.size() <= 0) {
            return null;
        }
        Collections.sort(list);
        String[] classes = list.toArray(new String[0]);
        return classes;
    }

    private List getClasses(String path, String interfaceName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (path.endsWith(".jar")) {
            List l = JarUtils.getClasseNamesInJAR(path);
            if (l != null && l.size() <= 0) {
                return null;
            }
            URL[] urls = new URL[]{};
            try (JarFileLoader cl = new JarFileLoader(urls);){
                cl.addFile(path);
                Class<?> interFace = Class.forName(interfaceName);
                for (int i = 0; i < l.size(); ++i) {
                    String[] tempClass = l.get(i).toString().split(".class");
                    Class<?> cls = cl.loadClass(tempClass[0]);
                    boolean match = this.isValidClass(cls, interFace);
                    if (!match) continue;
                    list.add(tempClass[0]);
                }
            }
            Collections.sort(list);
            return list;
        }
        if (path.endsWith(".class")) {
            File tempFile = new File(path);
            String pth = path.replaceAll(tempFile.getName(), "");
            File file = new File(pth);
            URL url = file.toURL();
            URL[] urls = new URL[]{url};
            Class<?> interFace = Class.forName(interfaceName);
            String[] tempClass = tempFile.getName().split("\\.");
            try (URLClassLoader clLoader = new URLClassLoader(urls);){
                Class<?> cls = clLoader.loadClass(tempClass[0]);
                boolean match = this.isValidClass(cls, interFace);
                if (match) {
                    list.add(tempClass[0]);
                }
            }
        }
        return list;
    }

    private boolean isValidClass(Class cls, Class interFace) {
        boolean match = !cls.isInterface() && !cls.isEnum() && interFace.isAssignableFrom(cls);
        return match;
    }

    private boolean isClass(Class cls) {
        boolean match = !cls.isInterface() && !cls.isEnum();
        return match;
    }

    public HashMap<String, List<Fields>> getFields(String path) throws Exception {
        HashMap<String, List<Fields>> map = new HashMap<String, List<Fields>>();
        if (path.endsWith(".jar")) {
            List l = JarUtils.getClasseNamesInJAR(path);
            if (l != null && l.size() <= 0) {
                return null;
            }
            URL[] urls = new URL[]{};
            try (JarFileLoader cl = new JarFileLoader(urls);){
                cl.addFile(path);
                for (int i = 0; i < l.size(); ++i) {
                    String[] tempClass = l.get(i).toString().split(".class");
                    Class<?> cls = cl.loadClass(tempClass[0]);
                    if (!this.isClass(cls)) continue;
                    List<Fields> fieldList = this.getFields(cls);
                    map.put(cls.getName().toString(), fieldList);
                }
            }
        }
        if (path.endsWith(".class")) {
            File tempFile = new File(path);
            String pth = path.replaceAll(tempFile.getName(), "");
            File file = new File(pth);
            URL url = file.toURL();
            URL[] urls = new URL[]{url};
            String[] tempClass = tempFile.getName().split("\\.");
            try (URLClassLoader clLoader = new URLClassLoader(urls);){
                List<Fields> fieldList;
                Class<?> cls = clLoader.loadClass(tempClass[0]);
                if (this.isClass(cls) && (fieldList = this.getFields(cls)) != null) {
                    map.put(cls.getName().toString(), fieldList);
                }
            }
        }
        return map;
    }

    private List<Fields> getFields(Class cls) {
        ArrayList<Fields> fieldList = new ArrayList<Fields>();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fieldList.add(new Fields(fields[i].getType().getCanonicalName().toString(), fields[i].getName().toString()));
        }
        return fieldList;
    }

    public HashMap<String, String> getManifestAttributes(String path) throws Exception {
        JarFile jarfile = new JarFile(path);
        Manifest manifest = jarfile.getManifest();
        Attributes mattr = manifest.getMainAttributes();
        HashMap<String, String> mainAttributes = new HashMap<String, String>();
        for (Object a : mattr.keySet()) {
            mainAttributes.put(a.toString(), mattr.getValue((Attributes.Name)a));
        }
        return mainAttributes;
    }

    public String[] getClasses(String path) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (path.endsWith(".jar")) {
                List l = JarUtils.getClasseNamesInJAR(path);
                if (l != null && l.size() <= 0) {
                    return null;
                }
                URL[] urls = new URL[]{};
                try (JarFileLoader cl = new JarFileLoader(urls);){
                    cl.addFile(path);
                    for (int i = 0; i < l.size(); ++i) {
                        String[] tempClass = l.get(i).toString().split(".class");
                        Class<?> cls = cl.loadClass(tempClass[0]);
                        if (!this.isClass(cls)) continue;
                        list.add(cls.getName().toString());
                    }
                }
            }
            if (list == null && list.size() <= 0) {
                return null;
            }
            Collections.sort(list);
            String[] classes = list.toArray(new String[0]);
            return classes;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class getClassForName(String path, String ClassName) {
        Class<?> clazz;
        URL[] urls = new URL[]{};
        JarFileLoader cl = new JarFileLoader(urls);
        Throwable throwable = null;
        try {
            Class<?> resultClass;
            cl.addFile(path);
            clazz = resultClass = Class.forName(ClassName);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    JARReflector.$closeResource(throwable, cl);
                    throw throwable3;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        JARReflector.$closeResource(throwable, cl);
        return clazz;
    }
}

