/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer;

import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.Event.NEvent;
import Alachisoft.NCache.Common.Event.NEventEnd;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.RPCFramework.RPCService;
import Alachisoft.NCache.Common.Util.BufferPool;
import Alachisoft.NCache.Management.MonitorServer;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.SocketServer;
import Alachisoft.NCache.SocketServer.Util.HelperFxn;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.HashMap;

public final class ClientManager {
    public boolean IsSizeRead = true;
    public int bytesRead = 0;
    public boolean ConnectionLost = false;
    public boolean IsDotNetClient = false;
    public byte[] Buffer = null;
    public byte[] PinnedBuffer = null;
    public byte[] tempDataBuffer = null;
    public byte[] discardingBuffer = new byte[20];
    public byte[] sendBuffer = null;
    public boolean _leftGracefully;
    private String _clientSocketId = null;
    private String _clientID = "NULL";
    private NEvent _clientDisposed;
    private ICommandExecuter _cmdExecuter;
    private boolean _cacheStopped;
    private Object _disposeSync = new Object();
    private Object _send_mutex = new Object();
    private String _toString;
    private float _clientsRequest = 0.0f;
    private float _clientsBytesSent = 0.0f;
    private float _clientsBytesRecieved = 0.0f;
    private Date _cmdStartTime = new Date(0L);
    private TimeSpan _cmdExecurionTime = new TimeSpan();
    private boolean _disposed;
    private Date _lastActivityTime = new Date(0L);
    private int maxIdleTimeAllowed = 1;
    private String _uniqueCacheID = "";
    private boolean _isBridgeSourceClient = false;
    private ByteBuffer lengthBuffer = ByteBuffer.allocate(30);
    private ByteBuffer dataBuffer;
    private SocketChannel _socketChannel;
    private HashMap<String, EnumerationPointer> _enumerationPointers = new HashMap();
    private InetAddress _clientAddress = null;
    private RPCService<MonitorServer> _monitorRPCService;

    public ClientManager(SocketChannel clientChannel, int size, int pinnedBufferSize) throws UnknownHostException {
        this.InitializeBuffer(size, pinnedBufferSize);
        this._socketChannel = clientChannel;
        this._clientSocketId = new Address(clientChannel.socket().getInetAddress().getHostAddress(), clientChannel.socket().getPort()).toString();
        this._clientDisposed = new NEvent("Client Disposed", null);
        if (LicenseManager.isExpress()) {
            this._clientAddress = clientChannel.socket().getInetAddress();
        }
    }

    public HashMap<String, EnumerationPointer> getEnumerationPointers() {
        return this._enumerationPointers;
    }

    public void setEnumerationPointers(HashMap<String, EnumerationPointer> value) {
        this._enumerationPointers = value;
    }

    public InetAddress getClientAddress() {
        return this._clientAddress;
    }

    public boolean getIsBridgeSourceClient() {
        return this._isBridgeSourceClient;
    }

    public void setIsBridgeSourceClient(boolean value) {
        this._isBridgeSourceClient = value;
    }

    public String getClientSocketId() {
        return this._clientSocketId;
    }

    public ICommandExecuter getCmdExecuter() {
        return this._cmdExecuter;
    }

    public void setCmdExecuter(ICommandExecuter value) {
        this._cmdExecuter = value;
    }

    public ByteBuffer getLengthBuffer() {
        return this.lengthBuffer;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public void setDataBuffer(ByteBuffer buffer) {
        this.dataBuffer = buffer;
    }

    public boolean hasPendingDataRead() {
        return this.dataBuffer != null;
    }

    public RPCService<MonitorServer> getMonitorRPCService() {
        return this._monitorRPCService;
    }

    public void setMonitorRPCService(RPCService<MonitorServer> value) {
        this._monitorRPCService = value;
    }

    public void addClientDisposedListner(NEventStart start, NEventEnd end) {
        this._clientDisposed.addNEventListners(start, end);
    }

    public void removeClientDisposedListner(NEventStart start, NEventEnd end) {
        this._clientDisposed.removeNEventListners(start);
    }

    public void InitializeBuffer(int size, int pinnedBufferSize) {
        this.PinnedBuffer = BufferPool.CheckoutBuffer((int)-1);
        this.sendBuffer = BufferPool.CheckoutBuffer((int)-1);
        this.Buffer = new byte[size];
    }

    public void AddToClientsRequest(long value) {
        this._clientsRequest = value;
    }

    public void AddToClientsBytesSent(long value) {
        this._clientsBytesSent = value;
    }

    public void AddToClientsBytesRecieved(long value) {
        this._clientsBytesRecieved = value;
    }

    public float getClientsRequests() {
        return this._clientsRequest;
    }

    public float getClientsBytesSent() {
        return this._clientsBytesSent;
    }

    public float getClientsBytesRecieved() {
        return this._clientsBytesRecieved;
    }

    public Object getSendMutex() {
        return this._send_mutex;
    }

    public String getUniqueCacheID() {
        return this._uniqueCacheID;
    }

    public void setUniqueCacheID(String value) {
        this._uniqueCacheID = value;
    }

    public boolean getIsDisposed() {
        return this._disposed;
    }

    public boolean getIsCacheStopped() {
        return this._cacheStopped;
    }

    public Socket getClientSocket() {
        return this.getSocketChannel().socket();
    }

    public SocketChannel getSocketChannel() {
        return this._socketChannel;
    }

    public String getClientID() {
        return this._clientID;
    }

    public void setClientID(String value) {
        this._clientID = value;
    }

    public void ReinitializeBuffer() {
        if (this.Buffer != null) {
            for (int i = 0; i < this.Buffer.length; ++i) {
                this.Buffer[i] = 0;
            }
        }
    }

    public void OnCacheStopped(String cacheId) {
        this._cacheStopped = true;
        this.dispose(false);
    }

    public byte[] ReplyPacket(String result, byte[] resultData) {
        byte[] command = HelperFxn.ToBytes(result);
        byte[] buffer = new byte[20 + command.length + resultData.length];
        byte[] commandSize = HelperFxn.ToBytes(new Integer(command.length).toString());
        byte[] dataSize = HelperFxn.ToBytes(new Integer(resultData.length).toString());
        System.arraycopy(commandSize, 0, buffer, 0, commandSize.length);
        System.arraycopy(dataSize, 0, buffer, 10, dataSize.length);
        System.arraycopy(command, 0, buffer, 20, command.length);
        System.arraycopy(resultData, 0, buffer, 20 + command.length, resultData.length);
        return buffer;
    }

    public byte[] ReplyPacket(String result, int dataLength) {
        byte[] command = HelperFxn.ToBytes(result);
        byte[] buffer = new byte[20 + command.length];
        byte[] commandSize = HelperFxn.ToBytes(new Integer(command.length).toString());
        byte[] dataSize = HelperFxn.ToBytes(new Integer(dataLength).toString());
        System.arraycopy(commandSize, 0, buffer, 0, commandSize.length);
        System.arraycopy(dataSize, 0, buffer, 10, dataSize.length);
        System.arraycopy(command, 0, buffer, 20, command.length);
        return buffer;
    }

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean disposingIntentionally) {
        Object object = this._disposeSync;
        synchronized (object) {
            this._disposed = true;
            try {
                if (this._enumerationPointers != null) {
                    for (String key : this._enumerationPointers.keySet()) {
                        this._cmdExecuter.DisposeEnumerator(this._enumerationPointers.get(key));
                    }
                    this._enumerationPointers = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._socketChannel != null) {
                try {
                    if (this._socketChannel.isConnected()) {
                        this._socketChannel.close();
                    }
                    this._socketChannel = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.Buffer = null;
            BufferPool.CheckinBuffer((byte[])this.PinnedBuffer);
            BufferPool.CheckinBuffer((byte[])this.sendBuffer);
            this.PinnedBuffer = null;
            this.sendBuffer = null;
            if (SocketServer.getIsServerCounterEnabled()) {
                SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
            }
            if (this._cmdExecuter != null) {
                block18: {
                    if (!this._cacheStopped) {
                        try {
                            this._cmdExecuter.OnClientDisconnected(this.getClientID(), this.getUniqueCacheID());
                        }
                        catch (Exception e) {
                            if (!SocketServer.getLogger().getIsErrorLogsEnabled()) break block18;
                            SocketServer.getLogger().getNCacheLog().Error("ClientManager.Dispose", e.toString());
                        }
                    }
                }
                if (this._cmdExecuter != null) {
                    this._cmdExecuter.dispose();
                    this._cmdExecuter = null;
                }
            }
            if (!disposingIntentionally) {
                this._clientDisposed.fireEvents(false, new Object[]{this.getClientID()});
            }
        }
    }

    public String toString() {
        return "[" + this._clientSocketId + " ->" + this._clientID + "]";
    }

    public void StartCommandExecution() {
        this._cmdStartTime = new Date();
        this._lastActivityTime = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MarkActivity() {
        ClientManager clientManager = this;
        synchronized (clientManager) {
            this._lastActivityTime = new Date();
        }
    }

    public boolean getIsIdle() {
        Date currentTime = new Date();
        TimeSpan idleTime = new TimeSpan();
        try {
            idleTime = TimeSpan.subtract((Date)currentTime, (Date)this._lastActivityTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idleTime.getTotalMinutes() > (double)this.maxIdleTimeAllowed;
    }

    public void StopCommandExecution() {
        try {
            Date now = new Date();
            this._cmdExecurionTime = TimeSpan.subtract((Date)now, (Date)this._cmdStartTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] GetPinnedBuffer(long size) {
        if ((long)this.PinnedBuffer.length < size) {
            this.PinnedBuffer = new byte[(int)size];
        }
        return this.PinnedBuffer;
    }

    public byte[] GetTempPinnedBuffer(int size) {
        if (this.tempDataBuffer == null || this.tempDataBuffer.length < size) {
            this.tempDataBuffer = new byte[size];
        }
        return this.tempDataBuffer;
    }
}

