/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.Command.ResponseBuilders.BulkGetResponseBuilder;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.BulkGetCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import java.util.HashMap;
import tangible.DotNetToJavaStringHelper;

public class BulkGetCommand
extends CommandBase {
    private OperationResult _getBulkResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._getBulkResult;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"BulkGetCmd.Exec", (String)"cmd parsed");
            }
        }
        catch (Exception exc) {
            this._getBulkResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        Object data = null;
        ICommandExecuter tempVar = clientManager.getCmdExecuter();
        NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
        try {
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)cmdInfo.IntendedRecipient)) {
                operationContext.Add(OperationContextFieldName.IntendedRecipient, (Object)cmdInfo.IntendedRecipient);
            }
            HashMap getResult = (HashMap)nCache.getCache().GetBulk((Object[])cmdInfo.Keys, cmdInfo.FlagMap, cmdInfo.providerName, operationContext);
            BulkGetResponseBuilder.BuildResponse(getResult, cmdInfo.CommandVersion, cmdInfo.RequestId, this._serializedResponsePackets, cmdInfo.IntendedRecipient);
        }
        catch (Exception exc) {
            this._getBulkResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"BulkGetCmd.Exec", (String)"cmd executed on cache");
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        BulkGetCommandProtocol.BulkGetCommand bulkGetCommand = command.getBulkGetCommand();
        cmdInfo.Keys = bulkGetCommand.getKeysList().toArray(new String[0]);
        cmdInfo.providerName = bulkGetCommand.getProviderName();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.FlagMap = new BitSet((byte)bulkGetCommand.getFlag());
        cmdInfo.ClientLastViewId = command.getClientLastViewId();
        cmdInfo.CommandVersion = command.getCommandVersion();
        return cmdInfo;
    }

    protected static final class CommandInfo {
        public String RequestId;
        public String[] Keys;
        public BitSet FlagMap;
        public String providerName;
        public long ClientLastViewId;
        public int CommandVersion;
        public String IntendedRecipient;

        protected CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Keys = this.Keys;
            varCopy.FlagMap = this.FlagMap;
            varCopy.providerName = this.providerName;
            varCopy.ClientLastViewId = this.ClientLastViewId;
            varCopy.CommandVersion = this.CommandVersion;
            varCopy.IntendedRecipient = this.IntendedRecipient;
            return varCopy;
        }
    }
}

