/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Util.JavaClrTypeMapping;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DeleteQueryCommandProtocol;
import com.alachisoft.ncache.common.protobuf.DeleteQueryResponseProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DeleteQueryCommand
extends CommandBase {
    private OperationResult _deleteQueryResult;

    public DeleteQueryCommand() {
        this.getOperationResult();
        this._deleteQueryResult = OperationResult.Success;
    }

    @Override
    public OperationResult getOperationResult() {
        return this._deleteQueryResult;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) throws Exception {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (RuntimeException exc) {
            this.getOperationResult();
            this._deleteQueryResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        Object data = null;
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            operationContext.Add(OperationContextFieldName.RemoveQueryOperation, (Object)false);
            nCache.getCache().DeleteQuery(cmdInfo.Query, cmdInfo.Values, operationContext);
            ResponseProtocol.Response.Builder resBuilder = ResponseProtocol.Response.newBuilder();
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setDeleteQueryResponse(DeleteQueryResponseProtocol.DeleteQueryResponse.newBuilder()).setResponseType(ResponseProtocol.Response.Type.DELETE_QUERY).setRequestId(Long.parseLong(cmdInfo.RequestId)).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this.getOperationResult();
            this._deleteQueryResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        int index;
        CommandInfo cmdInfo = new CommandInfo();
        DeleteQueryCommandProtocol.DeleteQueryCommand deleteQueryCommand = command.getDeleteQueryCommand();
        cmdInfo.Query = deleteQueryCommand.getQuery();
        if (clientManager.IsDotNetClient) {
            index = cmdInfo.Query.indexOf("$Text$");
            if (index != -1) {
                cmdInfo.Query = cmdInfo.Query.replace("$Text$", "System.String");
            } else {
                index = cmdInfo.Query.indexOf("$TEXT$");
                if (index != -1) {
                    cmdInfo.Query = cmdInfo.Query.replace("$TEXT$", "System.String");
                } else {
                    index = cmdInfo.Query.indexOf("$text$");
                    if (index != -1) {
                        cmdInfo.Query = cmdInfo.Query.replace("$text$", "System.String");
                    }
                }
            }
        } else {
            index = cmdInfo.Query.indexOf("$Text$");
            if (index != -1) {
                cmdInfo.Query = cmdInfo.Query.replace("$Text$", "java.lang.String");
            } else {
                index = cmdInfo.Query.indexOf("$TEXT$");
                if (index != -1) {
                    cmdInfo.Query = cmdInfo.Query.replace("$TEXT$", "java.lang.String");
                } else {
                    index = cmdInfo.Query.indexOf("$text$");
                    if (index != -1) {
                        cmdInfo.Query = cmdInfo.Query.replace("$text$", "java.lang.String");
                    }
                }
            }
        }
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.ClientLastViewId = command.getClientLastViewId();
        cmdInfo.CommandVersion = command.getCommandVersion();
        cmdInfo.Values = new HashMap();
        for (KeyValueProtocol.KeyValue deleteValue : deleteQueryCommand.getValuesList()) {
            String key = deleteValue.getKey();
            Class<?> type = null;
            Object value = null;
            for (ValueWithTypeProtocol.ValueWithType valueWithType : deleteValue.getValueList()) {
                String typeStr = valueWithType.getType();
                if (clientManager.IsDotNetClient) {
                    typeStr = JavaClrTypeMapping.ClrToJava((String)typeStr);
                }
                try {
                    type = Class.forName(typeStr);
                    if (valueWithType.getValue() != null) {
                        value = type == Date.class ? HelperFxn.getDateFromTicks((long)Long.parseLong(valueWithType.getValue())) : new ConfigurationBuilder().ConvertToPrimitive(type, valueWithType.getValue(), "");
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot convert '" + valueWithType.getValue() + "' to " + type.toString());
                }
                if (!cmdInfo.Values.containsKey(key)) {
                    cmdInfo.Values.put(key, value);
                    continue;
                }
                ArrayList<Object> list = cmdInfo.Values.get(key) instanceof ArrayList ? cmdInfo.Values.get(key) : null;
                if (list == null) {
                    list = new ArrayList<Object>();
                    list.add(cmdInfo.Values.get(key));
                    cmdInfo.Values.remove(key);
                    list.add(value);
                    cmdInfo.Values.put(key, list);
                    continue;
                }
                list.add(value);
            }
        }
        return cmdInfo;
    }

    protected static final class CommandInfo {
        public String RequestId;
        public String Query;
        public Map Values;
        public long ClientLastViewId;
        public int CommandVersion;

        protected CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Query = this.Query;
            varCopy.Values = this.Values;
            varCopy.ClientLastViewId = this.ClientLastViewId;
            varCopy.CommandVersion = this.CommandVersion;
            return varCopy;
        }
    }
}

