/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Util.ProtobufHelper;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.common.protobuf.GetCacheItemCommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetCacheItemResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.google.protobuf.ByteString;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import tangible.RefObject;

public class GetCacheItemCommand
extends CommandBase {
    @Override
    public boolean getCanHaveLargedata() {
        return true;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (Exception exc) {
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        ICommandExecuter tempVar = clientManager.getCmdExecuter();
        NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
        try {
            Object lockId = cmdInfo.LockId;
            long version = cmdInfo.CacheItemVersion;
            NCDateTime time = new NCDateTime(1970, 1, 1, 0, 0, 0, 0);
            Date lockDate = time.getDate();
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ReadThru, (Object)cmdInfo.FlagMap.IsBitSet((byte)16));
            operationContext.Add(OperationContextFieldName.GenerateQueryInfo, (Object)true);
            if (cmdInfo.ProviderName != null) {
                operationContext.Add(OperationContextFieldName.ReadThruProviderName, (Object)cmdInfo.ProviderName);
            }
            RefObject tempRef_version = new RefObject((Object)version);
            RefObject tempRef_lockId = new RefObject(lockId);
            RefObject tempRef_lockDate = new RefObject((Object)lockDate);
            CacheEntry entry = (CacheEntry)nCache.getCache().GetCacheEntry((Object)cmdInfo.Key, cmdInfo.Group, cmdInfo.SubGroup, tempRef_lockId, tempRef_lockDate, cmdInfo.LockTimeout, tempRef_version, cmdInfo.LockAccessTypes, operationContext);
            lockId = tempRef_lockId.argvalue;
            lockDate = (Date)tempRef_lockDate.argvalue;
            GetCacheItemResponseProtocol.GetCacheItemResponse.Builder build = GetCacheItemResponseProtocol.GetCacheItemResponse.newBuilder();
            ResponseProtocol.Response.Builder resBuilder = ResponseProtocol.Response.newBuilder();
            resBuilder.setRequestId(Long.parseLong(cmdInfo.RequestId));
            resBuilder.setResponseType(ResponseProtocol.Response.Type.GET_CACHE_ITEM);
            if (entry == null) {
                build.setLockId(lockId == null ? "" : lockId.toString());
                build.setLockTicks(new NCDateTime(lockDate).getTicks());
                GetCacheItemResponseProtocol.GetCacheItemResponse getCacheItemResponse = build.build();
                resBuilder.setGetItem(getCacheItemResponse);
                ResponseProtocol.Response response = resBuilder.build();
                this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
                return;
            }
            build = this.PopulateResponse(entry, build, clientManager);
            GetCacheItemResponseProtocol.GetCacheItemResponse getCacheItemResponse = build.build();
            resBuilder.setGetItem(getCacheItemResponse);
            ResponseProtocol.Response response = resBuilder.build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        GetCacheItemCommandProtocol.GetCacheItemCommand getCacheItemCommand = command.getGetCacheItemCommand();
        cmdInfo.CacheItemVersion = getCacheItemCommand.getVersion();
        cmdInfo.FlagMap = new BitSet((byte)getCacheItemCommand.getFlag());
        cmdInfo.Group = getCacheItemCommand.getGroup().length() == 0 ? null : getCacheItemCommand.getGroup();
        cmdInfo.Key = getCacheItemCommand.getKey();
        cmdInfo.LockAccessTypes = LockAccessType.forValue((int)getCacheItemCommand.getLockInfo().getLockAccessType());
        cmdInfo.LockId = getCacheItemCommand.getLockInfo().getLockId();
        cmdInfo.LockTimeout = new TimeSpan(getCacheItemCommand.getLockInfo().getLockTimeout());
        cmdInfo.ProviderName = getCacheItemCommand.getProviderName().length() == 0 ? null : getCacheItemCommand.getProviderName();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.SubGroup = getCacheItemCommand.getSubGroup().length() == 0 ? null : getCacheItemCommand.getSubGroup();
        return cmdInfo;
    }

    private GetCacheItemResponseProtocol.GetCacheItemResponse.Builder PopulateResponse(CacheEntry entry, GetCacheItemResponseProtocol.GetCacheItemResponse.Builder response, ClientManager clientManager) throws IllegalArgumentException {
        Object userValue;
        if (entry.getExpirationHint() instanceof AggregateExpirationHint) {
            ExpirationHint[] hints = ((AggregateExpirationHint)entry.getExpirationHint()).getHints();
            for (int i = 0; i < hints.length; ++i) {
                if (hints[i] instanceof FixedExpiration) {
                    response.setAbsExp(((FixedExpiration)hints[i]).getTicks());
                    continue;
                }
                if (!(hints[i] instanceof IdleExpiration)) continue;
                response.setSldExp(((IdleExpiration)hints[i]).getSlidingTime().getTotalTicks());
            }
        } else if (entry.getExpirationHint() instanceof FixedExpiration) {
            response.setAbsExp(((FixedExpiration)entry.getExpirationHint()).getTicks());
        } else if (entry.getExpirationHint() instanceof IdleExpiration) {
            response.setSldExp(((IdleExpiration)entry.getExpirationHint()).getSlidingTime().getTotalTicks());
        }
        DependencyProtocol.Dependency dep = ProtobufHelper.GetDependencyObj((ExpirationHint)entry.getExpirationHint());
        if (dep != null) {
            response.setDependency(dep);
        }
        if (entry.getPriority() != null) {
            response.setPriority(entry.getPriority().value());
        }
        if (entry.getQueryInfo() != null) {
            if (entry.getQueryInfo().get("tag-info") != null) {
                response.setTagInfo(ProtobufHelper.GetTagInfoObj((HashMap)(entry.getQueryInfo().get("tag-info") instanceof HashMap ? entry.getQueryInfo().get("tag-info") : null)));
            }
            if (entry.getQueryInfo().get("named-tag-info") != null) {
                response.setNamedTagInfo(ProtobufHelper.GetNamedTagInfoObj((HashMap)(entry.getQueryInfo().get("named-tag-info") instanceof HashMap ? entry.getQueryInfo().get("named-tag-info") : null), (boolean)clientManager.IsDotNetClient));
            }
        }
        if (entry.getExpirationHint() != null) {
            response.setHasExpired(entry.getExpirationHint().getHasExpired());
            response.setNeedsResync(entry.getExpirationHint().getNeedsReSync());
        }
        response.setFlag((int)entry.getFlag().getData());
        response.setVersion(entry.getVersion());
        response.setCreationTime(new NCDateTime(entry.getCreationTime()).getTicks());
        response.setLastModifiedTime(new NCDateTime(entry.getLastModifiedTime()).getTicks());
        if (entry.getLockId() != null) {
            response.setLockId(entry.getLockId() != null ? entry.getLockId().toString() : null);
        }
        response.setLockTicks(new NCDateTime(entry.getLockDate()).getTicks());
        if (entry.getGroupInfo() != null) {
            response.setGroup(entry.getGroupInfo().getGroup() != null ? entry.getGroupInfo().getGroup() : "");
            response.setSubGroup(entry.getGroupInfo().getSubGroup() != null ? entry.getGroupInfo().getSubGroup() : "");
        }
        if ((userValue = entry.getValue()) instanceof CallbackEntry) {
            userValue = ((CallbackEntry)userValue).getValue();
        }
        List arr = ((UserBinaryObject)userValue).getDataList();
        for (int i = 0; i < arr.size(); ++i) {
            response.addValue(ByteString.copyFrom((byte[])((byte[])arr.get(i))));
        }
        return response;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Key;
        public String Group;
        public String SubGroup;
        public BitSet FlagMap;
        public LockAccessType LockAccessTypes = LockAccessType.values()[0];
        public Object LockId;
        public TimeSpan LockTimeout = new TimeSpan();
        public long CacheItemVersion;
        public String ProviderName;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Key = this.Key;
            varCopy.Group = this.Group;
            varCopy.SubGroup = this.SubGroup;
            varCopy.FlagMap = this.FlagMap;
            varCopy.LockAccessTypes = this.LockAccessTypes;
            varCopy.LockId = this.LockId;
            varCopy.LockTimeout = this.LockTimeout;
            varCopy.CacheItemVersion = this.CacheItemVersion;
            varCopy.ProviderName = this.ProviderName;
            return varCopy;
        }
    }
}

