/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.IsLockedCommandProtocol;
import com.alachisoft.ncache.common.protobuf.IsLockedResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.util.Date;
import tangible.RefObject;

public class IsLockedCommand
extends CommandBase {
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("IsLockedCommand", "command: " + command + " Error" + arEx);
            }
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (RuntimeException exc) {
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            Object lockId = cmdInfo.LockId;
            NCDateTime time = new NCDateTime(1970, 1, 1, 0, 0, 0, 0);
            Date lockDate = time.getDate();
            RefObject tempRef_lockId = new RefObject(lockId);
            RefObject tempRef_lockDate = new RefObject((Object)lockDate);
            boolean res = nCache.getCache().IsLocked((Object)cmdInfo.Key, tempRef_lockId, tempRef_lockDate, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            lockId = tempRef_lockId.argvalue;
            lockDate = (Date)tempRef_lockDate.argvalue;
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setIsLockedResponse(IsLockedResponseProtocol.IsLockedResponse.newBuilder().setIsLocked(res).setLockId(lockId.toString()).setLockTime(new NCDateTime(lockDate).getTicks())).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.ISLOCKED).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        IsLockedCommandProtocol.IsLockedCommand isLockedCommand = command.getIsLockedCommand();
        cmdInfo.Key = isLockedCommand.getKey();
        cmdInfo.LockId = isLockedCommand.getLockId();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Key;
        public BitSet FlagMap;
        public Object LockId;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Key = this.Key;
            varCopy.FlagMap = this.FlagMap;
            varCopy.LockId = this.LockId;
            return varCopy;
        }
    }
}

