/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockCommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Date;
import tangible.RefObject;

public class LockCommand
extends CommandBase {
    private OperationResult _lockResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._lockResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"LockCmd.Exec", (String)"cmd parsed");
            }
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("LockCommand", "command: " + command + " Error" + arEx);
            }
            this._lockResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (RuntimeException exc) {
            this._lockResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            Object lockId = null;
            NCDateTime time = new NCDateTime(1970, 1, 1, 0, 0, 0, 0);
            Date lockDate = time.getDate();
            RefObject tempRef_lockId = new RefObject(lockId);
            RefObject tempRef_lockDate = new RefObject((Object)lockDate);
            boolean res = nCache.getCache().Lock((Object)cmdInfo.Key, cmdInfo.LockTimeout, tempRef_lockId, tempRef_lockDate, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            lockId = tempRef_lockId.argvalue;
            lockDate = (Date)tempRef_lockDate.argvalue;
            String lockIdString = lockId == null ? "" : lockId.toString();
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setLockResponse(LockResponseProtocol.LockResponse.newBuilder().setLockId(lockIdString).setLocked(res).setLockTime(new NCDateTime(lockDate).getTicks())).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.LOCK).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._lockResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
        finally {
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"LockCmd.Exec", (String)"cmd executed on cache");
            }
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        LockCommandProtocol.LockCommand lockCommand = command.getLockCommand();
        cmdInfo.Key = lockCommand.getKey();
        cmdInfo.LockTimeout = new TimeSpan(lockCommand.getLockTimeout());
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Key;
        public BitSet FlagMap;
        public TimeSpan LockTimeout = new TimeSpan();

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Key = this.Key;
            varCopy.FlagMap = this.FlagMap;
            varCopy.LockTimeout = this.LockTimeout;
            return varCopy;
        }
    }
}

