/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Caching.EventStatus;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Persistence.EventType;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.Command.ResponseBuilders.SyncEventResponseBuilder;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.EventIdCommandProtocol;
import com.alachisoft.ncache.common.protobuf.SyncEventsCommandProtocol;
import java.util.ArrayList;
import java.util.HashMap;

public class SyncEventCommand
extends CommandBase {
    private OperationResult _syncEventResult;

    public SyncEventCommand() {
        this.getOperationResult();
        this._syncEventResult = OperationResult.Success;
    }

    @Override
    public OperationResult getOperationResult() {
        return this._syncEventResult;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (RuntimeException exc) {
            this.getOperationResult();
            this._syncEventResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        Object data = null;
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            EventStatus eventStatus = nCache.GetEventsStatus();
            ArrayList syncEventResult = nCache.getCache().GetFilteredEvents(clientManager.getClientID(), cmdInfo.EventsList, eventStatus);
            SyncEventResponseBuilder.BuildResponse(syncEventResult, cmdInfo.RequestId, this._serializedResponsePackets, clientManager.getClientID());
        }
        catch (Exception exc) {
            this.getOperationResult();
            this._syncEventResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        HashMap<EventId, Object> eventList = new HashMap<EventId, Object>();
        SyncEventsCommandProtocol.SyncEventsCommand syncEventsCommand = command.getSyncEventsCommand();
        ArrayList eventIds = (ArrayList)syncEventsCommand.getEventIdsList();
        EventId cacheEventId = null;
        for (EventIdCommandProtocol.EventIdCommand eventId : eventIds) {
            cacheEventId = new EventId();
            cacheEventId.setEventUniqueID(eventId.getEventUniqueId());
            cacheEventId.setEventCounter(eventId.getEventCounter());
            cacheEventId.setOperationCounter(eventId.getOperationCounter());
            cacheEventId.setEventType(EventType.forValue((int)eventId.getEventType()));
            cacheEventId.setQueryChangeType(QueryChangeType.forValue((int)eventId.getQueryChangeType()));
            cacheEventId.setQueryId(eventId.getQueryId());
            if (cacheEventId.getQueryId() != null) {
                cacheEventId.setQueryId(null);
            }
            eventList.put(cacheEventId, null);
        }
        cmdInfo.EventsList = eventList;
        cmdInfo.RequestId = Long.toString(syncEventsCommand.getRequestId());
        return cmdInfo;
    }

    protected static final class CommandInfo {
        public HashMap EventsList;
        public int CommandVersion;
        public String RequestId;

        protected CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.EventsList = this.EventsList;
            varCopy.CommandVersion = this.CommandVersion;
            varCopy.RequestId = this.RequestId;
            return varCopy;
        }
    }
}

