/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.EventTask;

import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.EventTask.IEventTask;
import Alachisoft.NCache.SocketServer.SocketServer;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.HashmapChangedEventResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.google.protobuf.ByteString;
import java.util.HashMap;

public final class HashmapChangedEvent
implements IEventTask {
    private String _cacheId;
    private String _clientId;
    private NewHashmap _newmap;
    private boolean _isDotNetClient;

    public HashmapChangedEvent(String cacheId, String clientId, NewHashmap newHashmap, boolean isDotNetClient) {
        this._cacheId = cacheId;
        this._clientId = clientId;
        this._newmap = newHashmap;
        this._isDotNetClient = isDotNetClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Process() {
        block8: {
            try {
                ClientManager clientManager = null;
                HashMap hashMap = ConnectionManager.ConnectionTable;
                synchronized (hashMap) {
                    clientManager = (ClientManager)ConnectionManager.ConnectionTable.get(this._clientId);
                }
                if (clientManager != null) {
                    byte[] table = CompactBinaryFormatter.toByteBuffer((Object)this._newmap, (String)this._cacheId);
                    ResponseProtocol.Response.Builder response = ResponseProtocol.Response.newBuilder();
                    HashmapChangedEventResponseProtocol.HashmapChangedEventResponse.Builder hashmapChangedResponse = HashmapChangedEventResponseProtocol.HashmapChangedEventResponse.newBuilder();
                    hashmapChangedResponse.setTable(ByteString.copyFrom((byte[])table));
                    response.setHashmapChanged(hashmapChangedResponse);
                    response.setResponseType(ResponseProtocol.Response.Type.HASHMAP_CHANGED_EVENT);
                    byte[] serializedResponse = ResponseHelper.SerializeResponse((ResponseProtocol.Response)response.build());
                    ConnectionManager.AssureSend(clientManager, serializedResponse);
                }
            }
            catch (RuntimeException exc) {
                if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                    SocketServer.getLogger().getNCacheLog().Error("HashmapChangedEvent.Process", exc.toString());
                }
            }
            catch (Exception exc) {
                if (!SocketServer.getLogger().getIsErrorLogsEnabled()) break block8;
                SocketServer.getLogger().getNCacheLog().Error("HashmapChangedEvent.Process , Configuration Error: ", exc.toString());
            }
        }
    }
}

