/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.EventTask;

import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.EventTask.IEventTask;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.NodeJoinedEventResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import java.util.HashMap;

public final class NodeJoinedEvent
implements IEventTask {
    private String _cacheId;
    private Address _clusterAddress;
    private Address _serverAddress;
    private String _clientId;
    private boolean _reconnect;

    public NodeJoinedEvent(String cacheId, Address clusterAddress, Address serverAddress, String clientid, boolean reconn) {
        this._cacheId = cacheId;
        this._clusterAddress = clusterAddress;
        this._serverAddress = serverAddress;
        this._clientId = clientid;
        this._reconnect = reconn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Process() {
        ClientManager clientManager = null;
        HashMap hashMap = ConnectionManager.ConnectionTable;
        synchronized (hashMap) {
            clientManager = (ClientManager)ConnectionManager.ConnectionTable.get(this._clientId);
        }
        if (clientManager != null) {
            ResponseProtocol.Response.Builder response = ResponseProtocol.Response.newBuilder();
            NodeJoinedEventResponseProtocol.NodeJoinedEventResponse.Builder nodeJoined = NodeJoinedEventResponseProtocol.NodeJoinedEventResponse.newBuilder();
            nodeJoined.setClusterIp(this._clusterAddress.getIpAddress().getHostAddress());
            nodeJoined.setClusterPort(new Integer(this._clusterAddress.getPort()).toString());
            nodeJoined.setServerIp(this._serverAddress.getIpAddress().getHostAddress());
            nodeJoined.setServerPort(new Integer(this._serverAddress.getPort()).toString());
            nodeJoined.setReconnect(this._reconnect);
            response.setNodeJoined(nodeJoined);
            response.setResponseType(ResponseProtocol.Response.Type.NODE_JOINED_EVENT);
            byte[] serializedResponse = ResponseHelper.SerializeResponse((ResponseProtocol.Response)response.build());
            ConnectionManager.AssureSend(clientManager, serializedResponse);
        }
    }
}

