/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.EventTask;

import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.EventTask.IEventTask;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.NodeLeftEventResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import java.util.HashMap;

public final class NodeLeftEvent
implements IEventTask {
    private String _cacheId;
    private Address _clusterAddress;
    private Address _serverAddress;
    private String _clientId;

    public NodeLeftEvent(String cacheId, Address clusterAddress, Address serverAddress, String clientid) {
        this._cacheId = cacheId;
        this._clusterAddress = clusterAddress;
        this._serverAddress = serverAddress;
        this._clientId = clientid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Process() {
        ClientManager clientManager = null;
        HashMap hashMap = ConnectionManager.ConnectionTable;
        synchronized (hashMap) {
            clientManager = (ClientManager)ConnectionManager.ConnectionTable.get(this._clientId);
        }
        if (clientManager != null) {
            ResponseProtocol.Response.Builder response = ResponseProtocol.Response.newBuilder();
            NodeLeftEventResponseProtocol.NodeLeftEventResponse.Builder nodeLeft = NodeLeftEventResponseProtocol.NodeLeftEventResponse.newBuilder();
            nodeLeft.setClusterIp(this._clusterAddress.getIpAddress().getHostAddress());
            nodeLeft.setClusterPort(new Integer(this._clusterAddress.getPort()).toString());
            nodeLeft.setServerIp(this._serverAddress.getIpAddress().getHostAddress());
            nodeLeft.setServerPort(new Integer(this._serverAddress.getPort()).toString());
            response.setNodeLeft(nodeLeft);
            response.setResponseType(ResponseProtocol.Response.Type.NODE_LEFT_EVENT);
            byte[] serializedResponse = ResponseHelper.SerializeResponse((ResponseProtocol.Response)response.build());
            ConnectionManager.AssureSend(clientManager, serializedResponse);
        }
    }
}

