/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer;

import Alachisoft.NCache.Caching.AsyncCallbackInfo;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.EventContext;
import Alachisoft.NCache.Caching.EventStatus;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Queries.CQCallbackInfo;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Caching.SocketServerStats;
import Alachisoft.NCache.Caching.Util.HotConfig;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.SocketServer.CacheProvider;
import Alachisoft.NCache.SocketServer.CallbackTasks.AsyncOpCompletedCallback;
import Alachisoft.NCache.SocketServer.CallbackTasks.CQCallbackTask;
import Alachisoft.NCache.SocketServer.CallbackTasks.CompactTypeRegisterCallback;
import Alachisoft.NCache.SocketServer.CallbackTasks.DataSourceUpdatedCallbackTask;
import Alachisoft.NCache.SocketServer.CallbackTasks.ItemRemoveCallback;
import Alachisoft.NCache.SocketServer.CallbackTasks.ItemUpdateCallback;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.EventTask.BlockActivityEvent;
import Alachisoft.NCache.SocketServer.EventTask.CacheClearedEvent;
import Alachisoft.NCache.SocketServer.EventTask.CacheStoppedEvent;
import Alachisoft.NCache.SocketServer.EventTask.ConfigModifiedEvent;
import Alachisoft.NCache.SocketServer.EventTask.CustomEvent;
import Alachisoft.NCache.SocketServer.EventTask.HashmapChangedEvent;
import Alachisoft.NCache.SocketServer.EventTask.ItemAddedEvent;
import Alachisoft.NCache.SocketServer.EventTask.ItemRemovedEvent;
import Alachisoft.NCache.SocketServer.EventTask.ItemUpdatedEvent;
import Alachisoft.NCache.SocketServer.EventTask.LoggingInfoModifiedEvent;
import Alachisoft.NCache.SocketServer.EventTask.NodeJoinedEvent;
import Alachisoft.NCache.SocketServer.EventTask.NodeLeftEvent;
import Alachisoft.NCache.SocketServer.EventTask.UnBlockActivityEvent;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NotificationsType;
import Alachisoft.NCache.SocketServer.SocketServer;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public final class NCache
implements ICommandExecuter {
    private ClientManager _client;
    private boolean _isDotNetClient;
    private boolean _isBridgeClient;
    private Cache _cache = null;
    private String _cacheId = null;
    private String _licenceCode = "";
    private NEventStart _onItemUpdatedCallback = null;
    private NEventStart _onItemRemoveCallback = null;
    private NEventStart _asyncOperationCallback = null;
    private NEventStart _itemAdded = null;
    private NEventStart _itemUpdated = null;
    private NEventStart _itemRemoved = null;
    private NEventStart _cacheCleared = null;
    private NEventStart _customNotif = null;
    private NEventStart _dsUpdatedCallback = null;
    private NEventStart _configModified = null;
    private NEventStart _onCompactTypeModifiedCallback = null;
    private NEventStart _activeQuery = null;
    private NEventStart _nodeJoined = null;
    private NEventStart _nodeLeft = null;
    private NEventStart _cacheStopped = null;
    private NEventStart _cacheBecomeActive = null;
    private NEventStart _hashmapChanged = null;
    private NEventStart _blockClientActivity = null;
    private NEventStart _unblockClientActivity = null;
    private EventDataFilter _addDataFilter = EventDataFilter.None;
    private EventDataFilter _updateDataFilter = EventDataFilter.None;
    private EventDataFilter _removeDataFilter = EventDataFilter.None;
    private short _addSeq = (short)-1;
    private short _removeSeq = (short)-1;
    private short _updateSeq = (short)-1;
    private Object sync_lock_AddDataFilter = new Object();
    private Object sync_lock_UpdateDataFilter = new Object();
    private Object sync_lock_RemoveDataFilter = new Object();
    private boolean _cacheStoppedEventRegistered = false;

    public NCache(String cacheId, boolean isDonNetClient, ClientManager client) throws Exception {
        this(cacheId, isDonNetClient, client, "", null, null, null, null, false);
    }

    public NCache(String cacheId, boolean isDotNetClient, ClientManager client, String licenceInfo, String userId, String password, byte[] userIdBinary, byte[] paswordBinary, boolean isBridgeClient) throws Exception {
        this._cacheId = cacheId;
        this._isDotNetClient = isDotNetClient;
        this._client = client;
        this._licenceCode = licenceInfo;
        this._isBridgeClient = isBridgeClient;
        try {
            this._cache = CacheProvider.getProvider().GetCacheInstanceIgnoreReplica(cacheId, userIdBinary, paswordBinary);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e2) {
            throw e2;
        }
        if (this._cache == null) {
            throw new Exception("Cache is not registered");
        }
        if (!this._cache.getIsRunning()) {
            throw new Exception("Cache is not running");
        }
        if (LicenseManager.isExpress()) {
            if (this._cache.getCacheType().equals("local-cache")) {
                if (!client.getClientSocket().getLocalAddress().equals(client.getClientSocket().getInetAddress())) {
                    throw new OperationNotSupportedException("Server can not accept remote clients in this edition of NCache");
                }
            } else {
                InetAddress clientIp = client.getClientSocket().getInetAddress();
                Address clientAddress = new Address(clientIp, client.getClientSocket().getPort());
                if (!this._cache.IsServerNodeIp(clientAddress)) {
                    if (this._cache.getServerJustLeft() != null) {
                        if (this._cache.getServerJustLeft().equals(clientIp.getHostName())) {
                            throw new OperationNotSupportedException("Server can not accept remote clients in this edition of NCache");
                        }
                    } else if (this._cache.getConfiguration() != null && this._cache.getConfiguration().getCluster() != null) {
                        boolean foundInCluster = false;
                        ArrayList addresses = this._cache.getConfiguration().getCluster().GetAllConfiguredNodes();
                        if (addresses.size() > 0) {
                            int i = 0;
                            for (Address address : addresses) {
                                if (i >= 2) break;
                                ++i;
                                if (!address.getIpAddress().equals(clientAddress.getIpAddress())) continue;
                                foundInCluster = true;
                                break;
                            }
                        }
                        if (!foundInCluster) {
                            throw new OperationNotSupportedException("Server can not accept remote clients in this edition of NCache");
                        }
                    } else {
                        throw new OperationNotSupportedException("Server can not accept remote clients in this edition of NCache");
                    }
                }
            }
        }
        if (LicenseManager.isEntCacheServer() && this._cache.getCacheType().equals("mirror-server") && !this._cache.getIsCoordinator()) {
            throw new OperationNotSupportedException("Cannot connect to Passive Node in Mirror Cluster.");
        }
        this._cache.addCustomUpdateNotifListner(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.CustomUpdate(obj[0], obj[1], (EventContext)obj[2]);
                return null;
            }
        }, null);
        this._cache.addCustomRemoveNotifListner(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.CustomRemove(obj[0], obj[1], (ItemRemoveReason)obj[2], (BitSet)obj[3], (EventContext)obj[4]);
                return null;
            }
        }, null);
        this._cache.addActiveQueryListner(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.ActiveQueryChanged(obj[0], (QueryChangeType)obj[1], (ArrayList)obj[2], (EventContext)obj[3]);
                return null;
            }
        }, null);
        if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
            SocketServer.getLogger().getNCacheLog().Error("NCache.ctor", "Registering cache stopped event for " + this._client.getClientID());
        }
        this._cache.addCacheStoppedListner(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.OnCacheStopped((String)obj[0], (EventContext)obj[1]);
                return null;
            }
        }, null);
        if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
            SocketServer.getLogger().getNCacheLog().Error("NCache.ctor", "Cache stopped event registered for " + this._client.getClientID());
        }
        this._cache.addAsyncOperationCallbackListner(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.AsyncOperationCompleted(obj[0], obj[1], (EventContext)obj[2]);
                return null;
            }
        }, null);
        this._cache.addDsUpdatedListner(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.DataSourceUpdated(obj[0], (CallbackEntry)obj[1], (OpCode)obj[2]);
                return null;
            }
        }, null);
        this._cache.addBlockActivity(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.BlockClientActivity((String)obj[0], (String)obj[1], (Long)obj[2], (Integer)obj[3]);
                return null;
            }
        }, null);
        this._cache.addUnBlockActivity(new NEventStart(){

            public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                NCache.this.UnBlockClientActivity((String)obj[0], (String)obj[1], (Integer)obj[2]);
                return null;
            }
        }, null);
        this._cache.OnClientConnected(client.getClientID(), cacheId);
    }

    public String getCacheId() {
        return this._cacheId;
    }

    public Cache getCache() {
        return this._cache;
    }

    public NEventStart getAsyncOperationCallback() {
        return this._asyncOperationCallback;
    }

    public NEventStart getRemoveCallback() {
        return this._onItemRemoveCallback;
    }

    public NEventStart getUpdateCallback() {
        return this._onItemUpdatedCallback;
    }

    public boolean getIsDotnetClient() {
        return this._isDotNetClient;
    }

    public void OnCacheStopped(String cacheId, EventContext eventContext) {
        block4: {
            try {
                if (this._cacheStoppedEventRegistered) {
                    this.CacheStopped();
                }
            }
            catch (RuntimeException e) {
                if (!SocketServer.getLogger().getIsErrorLogsEnabled()) break block4;
                SocketServer.getLogger().getNCacheLog().Error("NCache.OnCacheStopped", e.toString());
            }
        }
        if (this._client != null) {
            this._client.OnCacheStopped(cacheId);
        }
    }

    public void OnCacheBecomeActive(String cacheId, EventContext eventContext) {
        if (this._client != null && this._isBridgeClient) {
            this._client.OnCacheStopped(cacheId);
        }
    }

    @Override
    public void dispose() {
        if (this._cache != null) {
            this.UnRegisterNotifications();
            this._client = null;
        }
    }

    @Override
    public void DisposeEnumerator(EnumerationPointer pointer) throws OperationFailedException {
        if (this._cache != null) {
            pointer.setDisposable(true);
            pointer.setSocketServerDispose(true);
            this._cache.GetNextChunk(pointer, new OperationContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UnRegisterNotifications() {
        Object object;
        if (this._onItemUpdatedCallback != null) {
            this._cache.removeCustomUpdateNotifListner(this._onItemUpdatedCallback);
            this._onItemUpdatedCallback = null;
        }
        if (this._onItemRemoveCallback != null) {
            this._cache.removeCustomRemoveNotifListner(this._onItemRemoveCallback);
            this._onItemRemoveCallback = null;
        }
        if (this._cacheCleared != null) {
            this._cache.removeCacheClearedListner(this._cacheCleared);
            this._cacheCleared = null;
        }
        if (this._cacheStopped != null) {
            this._cache.removeCacheStoppedListner(this._cacheStopped);
            this._cacheStopped = null;
        }
        if (this._asyncOperationCallback != null) {
            this._cache.removeAsyncOperationCallbackListner(this._asyncOperationCallback);
            this._asyncOperationCallback = null;
        }
        if (this._dsUpdatedCallback != null) {
            this._cache.removeDsUpdatedListner(this._dsUpdatedCallback);
            this._dsUpdatedCallback = null;
        }
        if (this._itemAdded != null) {
            this._cache.removeItemAddListner(this._itemAdded);
            this._itemAdded = null;
            object = this.sync_lock_AddDataFilter;
            synchronized (object) {
                this._addDataFilter = EventDataFilter.None;
                this._addSeq = (short)-1;
            }
        }
        if (this._itemUpdated != null) {
            this._cache.removeItemUpdatedListner(this._itemUpdated);
            this._itemUpdated = null;
            object = this.sync_lock_UpdateDataFilter;
            synchronized (object) {
                this._updateDataFilter = EventDataFilter.None;
                this._updateSeq = (short)-1;
            }
        }
        if (this._itemRemoved != null) {
            this._cache.removeItemRemovedListner(this._itemRemoved);
            this._itemRemoved = null;
            object = this.sync_lock_RemoveDataFilter;
            synchronized (object) {
                this._removeDataFilter = EventDataFilter.None;
                this._removeSeq = (short)-1;
            }
        }
        if (this._customNotif != null) {
            this._cache.removeCustomNotifListner(this._customNotif);
            this._customNotif = null;
        }
        if (this._nodeJoined != null) {
            this._cache.removeNodeJoinedListner(this._nodeJoined);
            this._nodeJoined = null;
        }
        if (this._nodeLeft != null) {
            this._cache.removeNodeLeftListner(this._nodeLeft);
            this._nodeLeft = null;
        }
        if (this._blockClientActivity != null) {
            this._cache.removeBlockActivity(this._blockClientActivity);
            this._blockClientActivity = null;
        }
        if (this._unblockClientActivity != null) {
            this._cache.removeUnBlockActivity(this._unblockClientActivity);
            this._unblockClientActivity = null;
        }
        if (this._hashmapChanged != null) {
            this._cache.removeHashmapChangedListner(this._hashmapChanged);
            this._hashmapChanged = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AsyncOperationCompleted(Object opCode, Object result, EventContext eventContext) {
        if (result instanceof Object[] && this._client != null) {
            AsyncCallbackInfo cbInfo = (AsyncCallbackInfo)(((Object[])result)[1] instanceof AsyncCallbackInfo ? ((Object[])result)[1] : null);
            if (cbInfo != null && !this._client.getClientID().equals(cbInfo.getClient())) {
                return;
            }
            LinkedList linkedList = ConnectionManager.getCallbackQueue();
            synchronized (linkedList) {
                ConnectionManager.getCallbackQueue().offer(new AsyncOpCompletedCallback(opCode, result, this._cacheId));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    public final EventStatus GetEventsStatus() {
        EventStatus eventStatus = new EventStatus();
        if (this._cacheCleared != null) {
            eventStatus.setIsCacheClearedEvent(true);
        }
        if (this._itemUpdated != null) {
            eventStatus.setIsItemUpdatedEvent(true);
        }
        if (this._itemAdded != null) {
            eventStatus.setIsItemAddedEvent(true);
        }
        if (this._itemRemoved != null) {
            eventStatus.setIsItemRemovedEvent(true);
        }
        return eventStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CustomUpdate(Object key, Object callbackInfo, EventContext eventContext) {
        CallbackInfo cbInfo;
        if (this._client != null && (cbInfo = (CallbackInfo)(callbackInfo instanceof CallbackInfo ? callbackInfo : null)) != null && this._client.getClientID().equals(cbInfo.getClient())) {
            LinkedList linkedList = ConnectionManager.getCallbackQueue();
            synchronized (linkedList) {
                ConnectionManager.getCallbackQueue().offer(new ItemUpdateCallback((Short)cbInfo.getCallback(), (String)key, cbInfo.getClient(), eventContext, cbInfo.getDataFilter()));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ActiveQueryChanged(Object key, QueryChangeType changeType, ArrayList<CQCallbackInfo> activeQueries, EventContext eventContext) {
        if (this._client != null && activeQueries != null && activeQueries.size() > 0) {
            LinkedList linkedList = ConnectionManager.getCallbackQueue();
            synchronized (linkedList) {
                for (CQCallbackInfo queryinfo : activeQueries) {
                    for (String clientId : queryinfo.getClientIds()) {
                        if (!this._client.getClientID().equals(clientId)) continue;
                        EventDataFilter dataFilter = EventDataFilter.None;
                        if (queryinfo.getDataFilters().containsKey(clientId)) {
                            dataFilter = (EventDataFilter)queryinfo.getDataFilters().get(clientId);
                        }
                        ConnectionManager.getCallbackQueue().offer(new CQCallbackTask(queryinfo.getCQId(), (String)key, changeType, this._client.getClientID(), eventContext, dataFilter));
                        ConnectionManager.getCallbackQueue().notify();
                        if (!SocketServer.getIsServerCounterEnabled()) continue;
                        SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CustomRemove(Object key, Object value, ItemRemoveReason reason, BitSet Flag, EventContext eventContext) {
        Object[] args;
        if (this._client != null && (args = (Object[])(value instanceof Object[] ? value : null)) != null) {
            Object val = args[0];
            CallbackInfo cbInfo = (CallbackInfo)(args[1] instanceof CallbackInfo ? args[1] : null);
            if (cbInfo != null && this._client.getClientID().equals(cbInfo.getClient())) {
                LinkedList linkedList = ConnectionManager.getCallbackQueue();
                synchronized (linkedList) {
                    ConnectionManager.getCallbackQueue().offer(new ItemRemoveCallback((Short)cbInfo.getCallback(), (String)key, val, reason, this._client.getClientID(), Flag, eventContext, cbInfo.getDataFilter()));
                    ConnectionManager.getCallbackQueue().notify();
                    if (SocketServer.getIsServerCounterEnabled()) {
                        SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CompactTypesModified(HashMap updatedCompactTypes, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            ConnectionManager.getCallbackQueue().offer(new CompactTypeRegisterCallback(updatedCompactTypes));
            ConnectionManager.getCallbackQueue().notify();
            if (SocketServer.getIsServerCounterEnabled()) {
                SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OnConfigModified(HotConfig hotConfig) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new ConfigModifiedEvent(hotConfig, this._cacheId, this._client.getClientID()));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnLoggingInfoModified(boolean enableErrorLogs, boolean enableDetailedLogs, String clientId) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new LoggingInfoModifiedEvent(enableErrorLogs, enableDetailedLogs, clientId));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ItemAdded(Object key, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new ItemAddedEvent(String.valueOf(key), this._cacheId, this._client.getClientID(), eventContext, this._addDataFilter));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ItemUpdated(Object key, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new ItemUpdatedEvent(String.valueOf(key), this._cacheId, this._client.getClientID(), eventContext, this._updateDataFilter));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ItemRemoved(Object key, Object value, ItemRemoveReason reason, BitSet Flag, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client == null) {
                return;
            }
            if (value instanceof CallbackEntry) {
                value = ((CallbackEntry)value).getValue();
            }
            ConnectionManager.getCallbackQueue().offer(new ItemRemovedEvent(String.valueOf(key), this._cacheId, reason, (UserBinaryObject)value, this._client.getClientID(), Flag, eventContext, this._removeDataFilter));
            ConnectionManager.getCallbackQueue().notify();
            if (SocketServer.getIsServerCounterEnabled()) {
                SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CacheCleared(EventContext eventContext) {
        if (this._client != null) {
            LinkedList linkedList = ConnectionManager.getCallbackQueue();
            synchronized (linkedList) {
                ConnectionManager.getCallbackQueue().offer(new CacheClearedEvent(this._cacheId, this._client.getClientID(), eventContext));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CacheStopped() {
        if (this._client != null) {
            LinkedList linkedList = ConnectionManager.getCallbackQueue();
            synchronized (linkedList) {
                ConnectionManager.getCallbackQueue().offer(new CacheStoppedEvent(this._cacheId, this._client.getClientID()));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CustomNotification(Object notifId, Object value, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client == null) {
                return;
            }
            ConnectionManager.getCallbackQueue().offer(new CustomEvent(this._cacheId, (byte[])notifId, (byte[])value, this._client.getClientID()));
            ConnectionManager.getCallbackQueue().notify();
            if (SocketServer.getIsServerCounterEnabled()) {
                SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DataSourceUpdated(Object result, CallbackEntry cbEntry, OpCode operationCode) {
        if (cbEntry != null) {
            if (this._client == null) {
                return;
            }
            Object tempVar = cbEntry.getWriteBehindOperationCompletedCallback();
            AsyncCallbackInfo asyncInfo = (AsyncCallbackInfo)(tempVar instanceof AsyncCallbackInfo ? tempVar : null);
            if (this._client.getClientID().equals(asyncInfo.getClient())) {
                LinkedList linkedList = ConnectionManager.getCallbackQueue();
                synchronized (linkedList) {
                    ConnectionManager.getCallbackQueue().offer(new DataSourceUpdatedCallbackTask((Short)asyncInfo.getCallback(), result, operationCode, this._client.getClientID()));
                    ConnectionManager.getCallbackQueue().notifyAll();
                    if (SocketServer.getIsServerCounterEnabled()) {
                        SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NodeJoined(Object clusterAddress, Object serverAddress, boolean reconnect, EventContext eventContext) {
        InetAddress clientIp;
        Address clientAddress;
        if (LicenseManager.isExpress() && !this._cache.IsServerNodeIp(clientAddress = new Address(clientIp = this._client.getClientSocket().getInetAddress(), this._client.getClientSocket().getPort()))) {
            if (this._cache.getServerJustLeft() == null) {
                if (this._client != null) {
                    this._client.OnCacheStopped(this._cacheId);
                }
                return;
            }
            if (!this._cache.getServerJustLeft().equals(clientIp)) {
                if (this._client != null) {
                    this._client.OnCacheStopped(this._cacheId);
                }
                return;
            }
        }
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client == null) {
                return;
            }
            ConnectionManager.getCallbackQueue().offer(new NodeJoinedEvent(this._cacheId, (Address)(clusterAddress instanceof Address ? clusterAddress : null), (Address)(serverAddress instanceof Address ? serverAddress : null), this._client.getClientID(), reconnect));
            ConnectionManager.getCallbackQueue().notify();
            if (SocketServer.getIsServerCounterEnabled()) {
                SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NodeLeft(Object clusterAddress, Object serverAddress, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client == null) {
                return;
            }
            ConnectionManager.getCallbackQueue().offer(new NodeLeftEvent(this._cacheId, (Address)(clusterAddress instanceof Address ? clusterAddress : null), (Address)(serverAddress instanceof Address ? serverAddress : null), this._client.getClientID()));
            ConnectionManager.getCallbackQueue().notify();
            if (SocketServer.getIsServerCounterEnabled()) {
                SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HashmapChanged(NewHashmap newmap, EventContext eventContext) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new HashmapChangedEvent(this._cacheId, this._client.getClientID(), newmap, this._isDotNetClient));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BlockClientActivity(String uniqueId, String serverIp, long timeoutInterval, int port) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new BlockActivityEvent(uniqueId, this._cacheId, this._client.getClientID(), serverIp, timeoutInterval, port));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UnBlockClientActivity(String uniqueId, String serverIp, int port) {
        LinkedList linkedList = ConnectionManager.getCallbackQueue();
        synchronized (linkedList) {
            if (this._client != null) {
                ConnectionManager.getCallbackQueue().offer(new UnBlockActivityEvent(uniqueId, this._cacheId, this._client.getClientID(), serverIp, port));
                ConnectionManager.getCallbackQueue().notify();
                if (SocketServer.getIsServerCounterEnabled()) {
                    SocketServer.getPerfStatsColl().setEventQueueCount(ConnectionManager.getCallbackQueue().size());
                }
            }
        }
    }

    @Override
    public String getID() {
        return this._cacheId;
    }

    @Override
    public void OnClientConnected(String clientID, String cacheId) throws OperationFailedException {
        if (this._cache != null) {
            this._cache.OnClientConnected(clientID, cacheId);
        }
    }

    @Override
    public void OnClientDisconnected(String clientID, String cacheId) throws OperationFailedException {
        if (this._cache != null) {
            this._cache.OnClientDisconnected(clientID, cacheId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MaxEventRequirement(EventDataFilter datafilter, NotificationsType eventType, short sequence) {
        switch (eventType) {
            case RegAddNotif: {
                Object object = this.sync_lock_AddDataFilter;
                synchronized (object) {
                    if (this._addSeq < sequence) {
                        this._addDataFilter = datafilter;
                        this._addSeq = sequence;
                    }
                    break;
                }
            }
            case RegRemoveNotif: {
                Object object = this.sync_lock_RemoveDataFilter;
                synchronized (object) {
                    if (this._removeSeq < sequence) {
                        this._removeDataFilter = datafilter;
                        this._removeSeq = sequence;
                    }
                    break;
                }
            }
            case RegUpdateNotif: {
                Object object = this.sync_lock_UpdateDataFilter;
                synchronized (object) {
                    if (this._updateSeq < sequence) {
                        this._updateDataFilter = datafilter;
                        this._updateSeq = sequence;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void UpdateSocketServerStats(SocketServerStats stats) {
        if (this._cache != null) {
            this._cache.UpdateSocketServerStats(stats);
        }
    }

    @Override
    public boolean IsCoordinator(String srcCacheID) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void RegisterNotification(NotificationsType type) {
        switch (type) {
            case RegAddNotif: {
                if (this._itemAdded != null) break;
                this._itemAdded = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.ItemAdded(obj[0], (EventContext)obj[1]);
                        return null;
                    }
                };
                this._cache.addItemAddedListner(this._itemAdded, null);
                break;
            }
            case RegUpdateNotif: {
                if (this._itemUpdated != null) break;
                this._itemUpdated = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.ItemUpdated(obj[0], (EventContext)obj[1]);
                        return null;
                    }
                };
                this._cache.addItemUpdatedListner(this._itemUpdated, null);
                break;
            }
            case RegRemoveNotif: {
                if (this._itemRemoved != null) break;
                this._itemRemoved = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.ItemRemoved(obj[0], obj[1], (ItemRemoveReason)obj[2], (BitSet)obj[3], (EventContext)obj[4]);
                        return null;
                    }
                };
                this._cache.addItemRemovedListner(this._itemRemoved, null);
                break;
            }
            case RegClearNotif: {
                if (this._cacheCleared != null) break;
                this._cacheCleared = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.CacheCleared((EventContext)obj[0]);
                        return null;
                    }
                };
                this._cache.addCacheClearedListner(this._cacheCleared, null);
                break;
            }
            case RegCustomNotif: {
                if (this._customNotif != null) break;
                this._customNotif = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.CustomNotification(obj[0], obj[1], (EventContext)obj[2]);
                        return null;
                    }
                };
                this._cache.addCustomNotifListner(this._customNotif, null);
                break;
            }
            case RegNodeJoinedNotif: {
                if (this._nodeJoined != null) break;
                this._nodeJoined = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.NodeJoined(obj[0], obj[1], (Boolean)obj[2], (EventContext)obj[3]);
                        return null;
                    }
                };
                this._cache.addNodeJoinedListner(this._nodeJoined, null);
                break;
            }
            case RegNodeLeftNotif: {
                if (this._nodeLeft != null) break;
                this._nodeLeft = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.NodeLeft(obj[0], obj[1], (EventContext)obj[2]);
                        return null;
                    }
                };
                this._cache.addNodeLeftListner(this._nodeLeft, null);
                break;
            }
            case RegCacheStoppedNotif: {
                this._cacheStoppedEventRegistered = true;
                break;
            }
            case RegHashmapChangedNotif: {
                this._hashmapChanged = new NEventStart(){

                    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                        NCache.this.HashmapChanged((NewHashmap)obj[0], (EventContext)obj[1]);
                        return null;
                    }
                };
                this._cache.addHashmapChangedListner(this._hashmapChanged, null);
                break;
            }
            case UnregAddNotif: {
                if (this._itemAdded == null) break;
                this._cache.removeItemAddListner(this._itemAdded);
                this._itemAdded = null;
                Object object = this.sync_lock_AddDataFilter;
                synchronized (object) {
                    this._addDataFilter = EventDataFilter.None;
                    this._addSeq = (short)-1;
                    break;
                }
            }
            case UnregUpdateNotif: {
                if (this._itemUpdated == null) break;
                this._cache.removeItemUpdatedListner(this._itemUpdated);
                this._itemUpdated = null;
                this.sync_lock_UpdateDataFilter = -1;
                Integer n = this.sync_lock_UpdateDataFilter;
                synchronized (this.sync_lock_UpdateDataFilter) {
                    this._updateDataFilter = EventDataFilter.None;
                    this._updateSeq = (short)-1;
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    break;
                }
            }
            case UnregRemoveNotif: {
                if (this._itemRemoved == null) break;
                this._cache.removeItemRemovedListner(this._itemRemoved);
                this._itemRemoved = null;
                Object object = this.sync_lock_RemoveDataFilter;
                synchronized (object) {
                    this._removeDataFilter = EventDataFilter.None;
                    this._removeSeq = (short)-1;
                    break;
                }
            }
            case UnregClearNotif: {
                if (this._cacheCleared == null) break;
                this._cache.removeCacheClearedListner(this._cacheCleared);
                this._cacheCleared = null;
                break;
            }
            case UnregCustomNotif: {
                if (this._customNotif == null) break;
                this._cache.removeCustomNotifListner(this._customNotif);
                this._customNotif = null;
                break;
            }
            case UnregNodeJoinedNotif: {
                if (this._nodeJoined == null) break;
                this._cache.removeNodeJoinedListner(this._nodeJoined);
                this._nodeJoined = null;
                break;
            }
            case UnregNodeLeftNotif: {
                if (this._nodeLeft == null) break;
                this._cache.removeNodeLeftListner(this._nodeLeft);
                this._nodeLeft = null;
                break;
            }
            case UnregCacheStoppedNotif: {
                this._cacheStoppedEventRegistered = false;
                break;
            }
            case UnregHashmapChangedNotif: {
                if (this._hashmapChanged == null) break;
                this._cache.removeHashmapChangedListner(this._hashmapChanged);
                this._hashmapChanged = null;
            }
        }
    }
}

