/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jmx2snmp.jmx;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class JmxAttribute {
    private final String attributeName;
    private final String type;
    private final ObjectName objectName;
    private final MBeanServer mbeanServer;
    private final String path;

    public JmxAttribute(String pAttributeName, String pType, ObjectName pObjectName, MBeanServer pMbeanServer) {
        this.attributeName = pAttributeName;
        this.type = pType;
        this.objectName = pObjectName;
        this.mbeanServer = pMbeanServer;
        String beanName = pObjectName.getKeyProperty("name");
        if (beanName == null) {
            beanName = pObjectName.getKeyProperty("type");
        }
        this.path = "<oid>." + beanName + "." + this.attributeName;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.attributeName;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() throws JMException {
        Object attributeValue = this.mbeanServer.getAttribute(this.objectName, this.attributeName);
        return attributeValue;
    }
}

