/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Util.SecurityUtil;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.NewDom.DomHelper;
import Alachisoft.NCache.Config.XmlConfigReader;
import Alachisoft.NCache.Management.CacheConfig;
import Alachisoft.NCache.Management.CacheInfo;
import Alachisoft.NCache.Management.ThinClientConfigManager;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import tangible.RefObject;

public class CacheConfigManager {
    public static final int DEF_TCP_PORT;
    public static final int DEF_HTTP_PORT = 8251;
    public static final String DEF_IPC_PORT_NAME = "jvcCacheHost";
    private static final String DIRNAME = "config";
    private static final String FILENAME = "config.ncconf";
    protected static int s_tcpPort;
    protected static int s_httpPort;
    protected static String s_ipcPortName;
    private static String s_configFileName;
    private static String s_configDir;

    protected CacheConfigManager() {
    }

    public static String getDirName() {
        return s_configDir;
    }

    public static String getFileName() {
        return s_configFileName;
    }

    public static int getTcpPort() {
        return s_tcpPort;
    }

    public static int getHttpPort() {
        return s_httpPort;
    }

    public static String getIPCPortName() {
        return s_ipcPortName;
    }

    public static void ScanConfiguration() throws ManagementException, Exception {
        String portName;
        int port;
        try {
            s_configDir = AppUtil.getInstallDir();
            if (s_configDir == null || s_configDir.length() == 0) {
                throw new ManagementException("Missing installation folder information");
            }
            if (!new File(s_configDir = Common.combinePath((String)s_configDir, (String[])new String[]{DIRNAME})).isDirectory()) {
                new File(s_configDir).mkdir();
            }
            if (!new File(s_configFileName = Common.combinePath((String)s_configDir, (String[])new String[]{FILENAME})).isFile() || new File(s_configFileName).length() == 0L) {
                CacheConfigManager.SaveConfiguration(null);
            }
        }
        catch (ManagementException e) {
            s_configFileName = "";
            throw e;
        }
        catch (Exception e) {
            s_configFileName = "";
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        String v = ServicePropValues.CACHE_MANAGEMENT_PORT;
        if (v != null) {
            s_tcpPort = port = Integer.parseInt(v);
        }
        v = ServicePropValues.HTTP_PORT;
        if (v != null) {
            s_httpPort = port = Integer.parseInt(v);
        }
        v = ServicePropValues.IPC_PortName;
        if (v != null && (portName = String.valueOf(v)) != null) {
            s_ipcPortName = portName;
        }
    }

    public static ArrayList GetCacheConfig(String cacheId, String userId, String password, boolean inProc) throws ManagementException {
        if (CacheConfigManager.getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt");
        }
        try {
            XmlConfigReader configReader = new XmlConfigReader(CacheConfigManager.getFileName(), cacheId);
            ArrayList propsList = configReader.getPropertiesList();
            ArrayList configsList = CacheConfig.GetConfigs(propsList);
            Iterator it = configsList.iterator();
            if (it.hasNext()) {
                CacheConfig config = (CacheConfig)it.next();
                if (!inProc) {
                    inProc = config.getUseInProc();
                }
            }
            if (inProc) {
                boolean isAuthorize = false;
                HashMap ht = (HashMap)propsList.get(0);
                HashMap cache = (HashMap)ht.get("cache");
                HashMap security = (HashMap)cache.get("security");
                HashMap user = (HashMap)security.get("user");
                String userName = ThinClientConfigManager.ExtractUserName(userId);
                isAuthorize = user.containsKey(userName);
                String domainController = (String)security.get("domain-controller");
                String port = (String)security.get("port");
                if (isAuthorize) {
                    isAuthorize = SecurityUtil.AuthorizeUserNamePassword((String)domainController, (String)userName, (String)password, (String)port);
                }
                if (!isAuthorize) {
                    throw new SecurityException("You do not have permissions to perform this operation");
                }
                return configsList;
            }
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ManagementException e2) {
            throw e2;
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static CacheConfig GetCacheConfig(String cacheId) throws ManagementException {
        if (CacheConfigManager.getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt");
        }
        try {
            XmlConfigReader configReader = new XmlConfigReader(CacheConfigManager.getFileName(), cacheId);
            return CacheConfig.FromProperties(configReader.getProperties());
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static CacheServerConfig GetUpdatedCacheConfig(String cacheId, String partId, String newNode, RefObject<ArrayList> affectedNodes, boolean isJoining) throws ManagementException {
        if (CacheConfigManager.getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt");
        }
        try {
            XmlConfigReader configReader = new XmlConfigReader(CacheConfigManager.getFileName(), cacheId);
            CacheServerConfig config = configReader.GetConfigDom();
            Object list = config.getCluster().getChannel().getInitialHosts().toLowerCase();
            String[] nodes = ((String)list).split("[,]", -1);
            if (isJoining) {
                for (String node : nodes) {
                    String[] nodename = node.split("[\\[]", -1);
                    ((ArrayList)affectedNodes.argvalue).add(nodename[0]);
                }
                if (((String)list).indexOf(newNode) == -1) {
                    list = (String)list + "," + newNode + "[" + config.getCluster().getChannel().getTcpPort() + "]";
                }
            } else {
                for (String node : nodes) {
                    String[] nodename = node.split("[\\[]", -1);
                    if (newNode.equals(nodename[0])) continue;
                    ((ArrayList)affectedNodes.argvalue).add(nodename[0]);
                }
                list = "";
                for (String node : (ArrayList)affectedNodes.argvalue) {
                    if (((String)list).length() == 0) {
                        list = node + "[" + config.getCluster().getChannel().getTcpPort() + "]";
                        continue;
                    }
                    list = (String)list + "," + node + "[" + config.getCluster().getChannel().getTcpPort() + "]";
                }
            }
            config.getCluster().getChannel().setInitialHosts((String)list);
            return config;
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static CacheServerConfig[] GetConfiguredCaches() throws ManagementException {
        if (FILENAME.length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        try {
            ConfigurationBuilder builder = new ConfigurationBuilder(CacheConfigManager.getFileName());
            builder.RegisterRootConfigurationObject(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class);
            builder.ReadConfiguration();
            Alachisoft.NCache.Config.NewDom.CacheServerConfig[] caches = new Alachisoft.NCache.Config.NewDom.CacheServerConfig[builder.getConfiguration().length];
            System.arraycopy(builder.getConfiguration(), 0, caches, 0, builder.getConfiguration().length);
            return CacheConfigManager.convertToOldDom(caches);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    private static CacheServerConfig[] convertToOldDom(Alachisoft.NCache.Config.NewDom.CacheServerConfig[] newCacheConfigsList) throws Exception {
        ArrayList<CacheServerConfig> oldCacheConfigsList = new ArrayList<CacheServerConfig>();
        for (int index = 0; index < newCacheConfigsList.length; ++index) {
            try {
                oldCacheConfigsList.add(DomHelper.convertToOldDom((Alachisoft.NCache.Config.NewDom.CacheServerConfig)newCacheConfigsList[index]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CacheServerConfig[] oldCacheConfigsArray = new CacheServerConfig[oldCacheConfigsList.size()];
        return oldCacheConfigsList.toArray(oldCacheConfigsArray);
    }

    public static CacheConfig[] GetConfiguredCaches2() throws ManagementException, ConfigurationException, UnknownHostException {
        if (CacheConfigManager.getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        try {
            XmlConfigReader xcr = new XmlConfigReader("", "");
            Map propMap = null;
            propMap = xcr.GetProperties2(CacheConfigManager.getFileName());
            ArrayList<CacheConfig> configList = new ArrayList<CacheConfig>();
            for (Map.Entry current : propMap.entrySet()) {
                Map properties = (Map)current.getValue();
                configList.add(CacheConfig.FromProperties2(properties));
            }
            CacheConfig[] configs = new CacheConfig[configList.size()];
            for (int i = 0; i < configList.size(); ++i) {
                configs[i] = configList.get(i) instanceof CacheConfig ? configList.get(i) : null;
            }
            return configs;
        }
        catch (ManagementException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static void SaveConfiguration(HashMap caches, HashMap partitionedCaches) throws ManagementException, IllegalArgumentException, IllegalAccessException, FileNotFoundException, UnsupportedEncodingException, IOException, Exception {
        if (CacheConfigManager.getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        ArrayList<CacheServerConfig> configurations = new ArrayList<CacheServerConfig>();
        if (caches != null) {
            for (Map.Entry current : caches.entrySet()) {
                try {
                    CacheInfo cacheInfo = (CacheInfo)current.getValue();
                    configurations.add(cacheInfo.getCacheProps());
                }
                catch (RuntimeException cacheInfo) {}
            }
        }
        if (partitionedCaches != null) {
            for (Map.Entry curr : partitionedCaches.entrySet()) {
                HashMap partitionedTable = curr.getValue() instanceof HashMap ? curr.getValue() : null;
                if (partitionedTable == null) continue;
                for (Map.Entry current : partitionedTable.entrySet()) {
                    try {
                        CacheInfo cacheInfo = (CacheInfo)current.getValue();
                        configurations.add(cacheInfo.getCacheProps());
                    }
                    catch (Exception ex) {
                        Exception exception = ex;
                    }
                }
            }
        }
        CacheConfigManager.SaveConfiguration(CacheConfigManager.convertToNewDom(configurations).toArray(new Alachisoft.NCache.Config.NewDom.CacheServerConfig[0]));
    }

    private static ArrayList<Alachisoft.NCache.Config.NewDom.CacheServerConfig> convertToNewDom(ArrayList<CacheServerConfig> oldCacheConfigsList) throws Exception {
        ArrayList<Alachisoft.NCache.Config.NewDom.CacheServerConfig> newCacheConfigsList = new ArrayList<Alachisoft.NCache.Config.NewDom.CacheServerConfig>();
        ListIterator<CacheServerConfig> itr = oldCacheConfigsList.listIterator();
        while (itr.hasNext()) {
            CacheServerConfig tempOldCacheConfig = (CacheServerConfig)itr.next();
            try {
                Alachisoft.NCache.Config.NewDom.CacheServerConfig tempNewCacheConfig = DomHelper.convertToNewDom((CacheServerConfig)tempOldCacheConfig);
                newCacheConfigsList.add(tempNewCacheConfig);
            }
            catch (Exception exception) {}
        }
        return newCacheConfigsList;
    }

    public static void SaveConfiguration(Object[] configuration) throws IllegalArgumentException, IllegalAccessException, ManagementException, FileNotFoundException, Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<configuration>\r\n");
        if (configuration != null && configuration.length > 0) {
            ConfigurationBuilder builder = new ConfigurationBuilder(configuration);
            builder.RegisterRootConfigurationObject(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class);
            xml.append(builder.GetXmlString());
        }
        xml.append("\r\n</configuration>");
        CacheConfigManager.WriteXmlToFile(xml.toString());
    }

    private static void WriteXmlToFile(String xml) throws ManagementException, FileNotFoundException, UnsupportedEncodingException, IOException {
        if (CacheConfigManager.getFileName().length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        FileOutputStream os = null;
        Writer writer = null;
        try {
            os = new FileOutputStream(CacheConfigManager.getFileName());
            writer = new OutputStreamWriter(os);
            writer.write(xml);
            writer.flush();
        }
        catch (RuntimeException e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (RuntimeException runtimeException) {}
                writer = null;
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (RuntimeException runtimeException) {}
                os = null;
            }
        }
    }

    static {
        s_tcpPort = DEF_TCP_PORT = Integer.parseInt(ServicePropValues.CACHE_MANAGEMENT_PORT);
        s_httpPort = 8251;
        s_ipcPortName = DEF_IPC_PORT_NAME;
        s_configFileName = "";
        s_configDir = "";
        try {
            CacheConfigManager.ScanConfiguration();
        }
        catch (ManagementException managementException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

