/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Management.CacheConfigManager;
import Alachisoft.NCache.Management.ICacheServer;
import Alachisoft.NCache.Management.NCacheRPCService;
import Alachisoft.NCache.Management.Security;
import Alachisoft.NCache.ServiceControl.NCacheService;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.HashMap;
import java.util.Map;

public class NCacheServiceBase {
    protected ICacheServer _server = null;
    protected String _address;
    protected int _port;
    private String _ipAddress;
    private String _userId = Security.getUserName();
    private String _password = Security.getPasswd();
    private boolean _useRemoting = false;

    public NCacheServiceBase(String address) throws Exception {
        this(address, CacheConfigManager.getTcpPort());
    }

    public NCacheServiceBase(String address, int port) throws Exception {
        this._address = address;
        this._port = port;
        this.Initialize();
        this._ipAddress = this._server.GetClusterIP();
    }

    protected void Initialize() throws Exception {
        NCacheService ncache = null;
        ncache = this._useRemoting ? new NCacheService(this._address, this._port, true) : new NCacheRPCService(this._address, this._port);
        try {
            this._server = ncache.GetCacheServer(new TimeSpan());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ncache.dispose();
        }
    }

    protected final ICacheServer getCacheServer() {
        return this._server;
    }

    public final String getClusterIP() {
        return this._ipAddress;
    }

    public HashMap GetServerCaches() {
        return this.GetServerCaches(this._userId, this._password);
    }

    public HashMap GetServerCaches(String userId, String password) {
        HashMap cacheList = new HashMap();
        Map coll = null;
        for (Map.Entry current : coll.entrySet()) {
            if (current.getValue() instanceof CacheServerConfig) {
                CacheServerConfig cacheProp = (CacheServerConfig)current.getValue();
                if (cacheProp.getCluster() == null || !cacheProp.getCluster().getTopology().equals("partitioned-server") && !cacheProp.getCluster().getTopology().equals("replicated-server") && !cacheProp.getCluster().getTopology().equals("partitioned-replicas-server") && !cacheProp.getCluster().getTopology().equals("mirror-server")) continue;
                cacheList.put(current.getKey(), cacheProp);
                continue;
            }
            if (!(current.getValue() instanceof HashMap)) continue;
            cacheList.put(current.getKey(), current.getValue());
        }
        return cacheList;
    }
}

