/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management.RPC;

import Alachisoft.NCache.Caching.CacheClearedCallback;
import Alachisoft.NCache.Caching.CustomRemoveCallback;
import Alachisoft.NCache.Caching.CustomUpdateCallback;
import Alachisoft.NCache.Caching.ItemAddedCallback;
import Alachisoft.NCache.Caching.ItemRemovedCallback;
import Alachisoft.NCache.Caching.ItemUpdatedListener;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Communication.IRequest;
import Alachisoft.NCache.Common.Enum.CacheStatusOnServerContainer;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.LoggingInfo;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatistics;
import Alachisoft.NCache.Common.Monitoring.ClientProcessStats;
import Alachisoft.NCache.Common.Monitoring.ConfiguredCacheInfo;
import Alachisoft.NCache.Common.Monitoring.Node;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.NewDom.ClientNodeStatusWrapper;
import Alachisoft.NCache.Management.BindedIpMap;
import Alachisoft.NCache.Management.CacheInfo;
import Alachisoft.NCache.Management.CacheRegisterationInfo;
import Alachisoft.NCache.Management.CacheServer;
import Alachisoft.NCache.Management.ClientCacheStatus;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration;
import Alachisoft.NCache.Management.ICacheServer;
import Alachisoft.NCache.Management.NewCacheRegisterationInfo;
import Alachisoft.NCache.Management.NodeInfoMap;
import Alachisoft.NCache.Management.RPC.ManagementChannelFormatter;
import Alachisoft.NCache.Management.RPC.RemoteServerBase;
import Alachisoft.NCache.Management.ServerLicenseInfo;
import com.alachisoft.ncache.common.monitoring.ClientCustomCounters;
import com.alachisoft.ncache.common.monitoring.ClientMetaData;
import com.alachisoft.ncache.common.monitoring.CounterDataCollection;
import com.alachisoft.ncache.common.monitoring.CounterMetadataCollection;
import com.alachisoft.ncache.common.protobuf.ManagementCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ManagementResponseProtocol;
import com.alachisoft.ncache.licensing.LicenseInfo;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import tangible.RefObject;

public class RemoteCacheServer
extends RemoteServerBase
implements ICacheServer {
    private String _user;
    private String _password;

    public RemoteCacheServer(String server, int port) throws IllegalAccessException, Exception {
        super(server, port);
    }

    public RemoteCacheServer(String server, int port, String bindIp) throws IllegalAccessException, Exception {
        super(server, port, bindIp);
    }

    public RemoteCacheServer(String server, int port, String bindIp, String user, String password) throws IllegalAccessException, Exception {
        super(server, port, bindIp);
        this._user = user;
        this._password = password;
    }

    @Override
    protected IChannelFormatter GetChannelFormatter() {
        return new ManagementChannelFormatter();
    }

    @Override
    protected boolean InitializeInternal() {
        return super.InitializeInternal();
    }

    private void exceptionOccured(ManagementResponseProtocol.ManagementResponse res) throws SecurityException, ManagementException {
        if (res != null && res.hasException() && res.getException() != null) {
            switch (res.getException().getType()) {
                case SECURITY: {
                    throw new SecurityException(res.getException().getMessage());
                }
            }
            throw new ManagementException(res.getException().getMessage());
        }
    }

    protected final Object ExecuteCommandOnCacehServer(ManagementCommandProtocol.ManagementCommand command) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementResponseProtocol.ManagementResponse response = null;
        if (this._requestManager != null) {
            Object tempVar = this._requestManager.SendRequest((IRequest)command);
            response = (ManagementResponseProtocol.ManagementResponse)(tempVar instanceof ManagementResponseProtocol.ManagementResponse ? tempVar : null);
            this.exceptionOccured(response);
        }
        if (response != null) {
            return response.get_returnValue();
        }
        return null;
    }

    private ManagementCommandProtocol.ManagementCommand GetManagementCommand(String method) {
        return this.GetManagementCommand(method, 1);
    }

    private ManagementCommandProtocol.ManagementCommand GetManagementCommand(String method, int overload) {
        ManagementCommandProtocol.ManagementCommand.Builder build = ManagementCommandProtocol.ManagementCommand.newBuilder();
        build.setMethodName(method);
        build.setOverload(overload);
        build.setObjectName("CacheServer");
        build.setSource(ManagementCommandProtocol.ManagementCommand.SourceType.TOOL);
        return build.build();
    }

    @Override
    public final String GetClusterIP() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetClusterIP");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public final String GetLocalCacheIP() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetLocalCacheIP");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        CacheServer.disposedStaticCall();
    }

    @Override
    public final void CopyAssemblies(String cacheName, String assemblyFileName, byte[] buffer) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("CopyAssemblies");
        command.getParameters().AddParameter((Object)cacheName);
        command.getParameters().AddParameter((Object)assemblyFileName);
        command.getParameters().AddParameter((Object)buffer);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void CopyBridgeAssemblies(String bridgeName, String assemblyFileName, byte[] buffer) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("CopyBridgeAssemblies");
        command.getParameters().AddParameter((Object)bridgeName);
        command.getParameters().AddParameter((Object)assemblyFileName);
        command.getParameters().AddParameter((Object)buffer);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final byte[] GetAssembly(String cacheName, String fileName) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetAssembly");
        command.getParameters().AddParameter((Object)cacheName);
        command.getParameters().AddParameter((Object)fileName);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (byte[])(tempVar instanceof byte[] ? tempVar : null);
    }

    @Override
    public final void ClearCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("ClearCache");
        command.getParameters().AddParameter((Object)cacheId);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final boolean Authorize(byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("Authorize");
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        try {
            return (Boolean)this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public final boolean IsSecurityEnabled() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("IsSecurityEnabled");
        try {
            return (Boolean)this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public final HashMap GetSecurityMap() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetSecurityMap");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (HashMap)(tempVar instanceof HashMap ? tempVar : null);
    }

    @Override
    public final ArrayList GetRunningCaches(String userId, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetRunningCaches");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
    }

    @Override
    public final Map GetCacheProps(byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheProps");
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (Map)(tempVar instanceof Map ? tempVar : null);
    }

    @Override
    public final Map CacheProps() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("CacheProps");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (Map)(tempVar instanceof Map ? tempVar : null);
    }

    @Override
    public final CacheServerConfig GetCacheConfiguration(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheConfiguration");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (CacheServerConfig)(tempVar instanceof CacheServerConfig ? tempVar : null);
    }

    @Override
    public final CacheInfo GetCacheInfo(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheInfo");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (CacheInfo)(tempVar instanceof CacheInfo ? tempVar : null);
    }

    @Override
    public final String GetHostName() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetHostName");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public final void ReloadSrvcConfig() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("ReloadSrvcConfig");
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final int GetSocketServerPort() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        Integer val = null;
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetSocketServerPort");
        try {
            val = (Integer)this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return val;
    }

    @Override
    public final CacheRegisterationInfo GetUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetUpdatedCacheConfiguration");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)partId);
        command.getParameters().AddParameter((Object)newNode);
        command.getParameters().AddParameter((Object)isJoining);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (CacheRegisterationInfo)(tempVar instanceof CacheRegisterationInfo ? tempVar : null);
    }

    @Override
    public final boolean RegisterCache(String cacheId, CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("RegisterCache", 1);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)config);
        command.getParameters().AddParameter((Object)partId);
        command.getParameters().AddParameter((Object)overwrite);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)hotApply);
        try {
            return (Boolean)this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public final NodeInfoMap GetNodeInfo() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetNodeInfo");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (NodeInfoMap)Common.readAs((Object)tempVar, NodeInfoMap.class);
    }

    @Override
    public final String CanApplyHotConfiguration(String cacheId, CacheServerConfig config) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("CanApplyHotConfig");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)config);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public final void RemoveCacheServerFromClientConfig(String cacheId, String serverName) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("RemoveCacheServerFromClientConfig");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)serverName);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void RemoveCacheFromClientConfig(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("RemoveCacheFromClientConfig");
        command.getParameters().AddParameter((Object)cacheId);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void UpdateClientServersList(String cacheId, CacheServerList serversPriorityList, String serverRuntimeContext) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("UpdateClientServersList");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)serversPriorityList);
        command.getParameters().AddParameter((Object)serverRuntimeContext);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void UpdateClientServersList(String cacheId, String[] servers, RefObject<String> xml, String clientCacheId, boolean loadBalance) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("UpdateClientServersList", 2);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)servers);
        command.getParameters().AddParameter(xml.argvalue);
        command.getParameters().AddParameter((Object)clientCacheId);
        command.getParameters().AddParameter((Object)loadBalance);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void UpdateSecurity(boolean enabled, HashMap newSecurityMap, String ldap, String ldapPort) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("UpdateSecurity");
        command.getParameters().AddParameter((Object)enabled);
        command.getParameters().AddParameter((Object)newSecurityMap);
        command.getParameters().AddParameter((Object)ldap);
        command.getParameters().AddParameter((Object)ldapPort);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void UpdateUserSecurityCredentials(String cacheId, String[] users, String[] passwords) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("UpdateUserSecurityCredentials");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)users);
        command.getParameters().AddParameter((Object)passwords);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final void GetUserSecurityCredentials(String cacheId, RefObject<String[]> users, RefObject<String[]> passwords) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        Object[] credenials = this.GetUserSecurityCredentials(cacheId);
        if (credenials != null) {
            users.argvalue = (String[])(credenials[0] instanceof String[] ? credenials[0] : null);
            passwords.argvalue = (String[])(credenials[1] instanceof String[] ? credenials[1] : null);
        }
    }

    @Override
    public final Object[] GetUserSecurityCredentials(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetUserSecurityCredentials");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (Object[])(tempVar instanceof Object[] ? tempVar : null);
    }

    @Override
    public final ClientConfiguration GetClientConfiguration(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetClientConfiguration");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (ClientConfiguration)(tempVar instanceof ClientConfiguration ? tempVar : null);
    }

    @Override
    public final void UpdateClientConfiguration(String cacheId, ClientConfiguration configuration) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("UpdateClientConfiguration");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)configuration);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public final String GetBindIP() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetBindIP");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public final int GetClientConfigId() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        Integer val = null;
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetClientConfigId");
        try {
            val = (Integer)this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return val;
    }

    @Override
    public final ClientNodeStatusWrapper GetClientNodeStatus(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetClientNodeStatus");
        command.getParameters().AddParameter((Object)cacheId);
        return (ClientNodeStatusWrapper)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean VerifyWindowsUser(String nodeName, String userName, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("VerifyWindowsUser");
        command.getParameters().AddParameter((Object)nodeName);
        command.getParameters().AddParameter((Object)userName);
        command.getParameters().AddParameter((Object)password);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean VerfyAdministrator(String userName, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("VerfyAdministrator");
        command.getParameters().AddParameter((Object)userName);
        command.getParameters().AddParameter((Object)password);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean VerifyNodeAdministrator(String userName, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("VerifyNodeAdministrator");
        command.getParameters().AddParameter((Object)userName);
        command.getParameters().AddParameter((Object)password);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void DisableLogging(LoggingInfo.LoggingSubsystem subsystem, LoggingInfo.LoggingType type) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("DisableLogging");
        command.getParameters().AddParameter((Object)subsystem);
        command.getParameters().AddParameter((Object)type);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void SynchronizeClientConfig() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("SynchronizeClientConfig");
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean ApplyCacheConfiguration(String cacheId, CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("ApplyCacheConfiguration", 1);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)props);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)hotApply);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void UnregisterCache(String cacheId, String partId, byte[] userId, byte[] password, Boolean isGracefulShutDown, Boolean removeServerOnly) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("UnregisterCache");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)partId);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)isGracefulShutDown);
        command.getParameters().AddParameter((Object)removeServerOnly);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void StartCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("StartCache");
        command.getParameters().AddParameter((Object)cacheId);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void StartCache(String cacheId, String partitionId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        this.StartCache(cacheId, partitionId, null, null);
    }

    @Override
    public final void StartCache(String cacheId, byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        this.StartCache(cacheId, null, null, null, null, null, null, null, userId, password, false);
    }

    @Override
    public final void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        this.StartCache(cacheId, partitionId, null, null, null, null, null, null, userId, password, twoPhaseInitialization);
    }

    @Override
    public final void StartCachePhase2(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand.Builder build = ManagementCommandProtocol.ManagementCommand.newBuilder();
        build.setMethodName("StartCachePhase2");
        ManagementCommandProtocol.ManagementCommand command = build.build();
        command.getParameters().AddParameter((Object)cacheId);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        this.StartCache(cacheId, partitionId, null, null, null, null, null, null, userId, password, false);
    }

    @Override
    public final void StartCache(String cacheId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        this.StartCache(cacheId, null, itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate, null, null, false);
    }

    @Override
    public final void StartCache(String cacheId, String partitionId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("StartCache", 7);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)partitionId);
        command.getParameters().AddParameter(null);
        command.getParameters().AddParameter(null);
        command.getParameters().AddParameter(null);
        command.getParameters().AddParameter(null);
        command.getParameters().AddParameter(null);
        command.getParameters().AddParameter(null);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)twoPhaseInitialization);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void StopCache(String cacheId, byte[] userId, byte[] password, Boolean isGracefulShutdown) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        this.StopCache(cacheId, null, userId, password, isGracefulShutdown);
    }

    public final int GetShutdownTimeout() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetShutdownTimeout");
        return (Integer)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void StopCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean isGraceFulNodeShutdown) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("StopCache", 2);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)partitionId);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)isGraceFulNodeShutdown);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final HashMap DetectNICs() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("DetectNICs");
        Object tempVar = this.ExecuteCommandOnCacehServer(command);
        return (HashMap)(tempVar instanceof HashMap ? tempVar : null);
    }

    @Override
    public final void BindToIP(BindedIpMap bindIPMap) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("BindToIP");
        command.getParameters().AddParameter((Object)bindIPMap);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final BindedIpMap BindedIp() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("BindedIp");
        Object tempVar = this.ExecuteCommandOnCacehServer(command);
        return (BindedIpMap)Common.readAs((Object)tempVar, BindedIpMap.class);
    }

    @Override
    public final int GetMaxPort() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetMaxPort");
        return (Integer)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final CacheStatusOnServerContainer IsClusteredCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("IsClusteredCache");
        command.getParameters().AddParameter((Object)cacheId);
        return (CacheStatusOnServerContainer)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean PortIsAvailable(int port) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("PortIsAvailable");
        command.getParameters().AddParameter((Object)port);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean NodeIsAllowed(int port, String id) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("NodeIsAllowed");
        command.getParameters().AddParameter((Object)port);
        command.getParameters().AddParameter((Object)id);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final StatusInfo GetCacheStatus(String cacheId, String partitionId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheStatus");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)partitionId);
        Object tempVar = this.ExecuteCommandOnCacehServer(command);
        return (StatusInfo)(tempVar instanceof StatusInfo ? tempVar : null);
    }

    @Override
    public final void StartMonitoringActivity() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("StartMonitoringActivity");
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void StopMonitoringActivity() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("StopMonitoringActivity");
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void PublishActivity() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("PublishActivity");
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void MakeCacheActive(String cacheId, boolean active) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("MakeCacheActive");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)active);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean IsBridgeTargetCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("IsBridgeTargetCache");
        command.getParameters().AddParameter((Object)cacheId);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void ClearCacheContent(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("ClearCacheContent");
        command.getParameters().AddParameter((Object)cacheId);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final boolean IsRunning(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("IsRunning");
        command.getParameters().AddParameter((Object)cacheId);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final CacheStatistics GetStatistics(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetStatistics");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = this.ExecuteCommandOnCacehServer(command);
        return (CacheStatistics)(tempVar instanceof CacheStatistics ? tempVar : null);
    }

    @Override
    public final long GetCacheCount(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheCount");
        command.getParameters().AddParameter((Object)cacheId);
        return (Long)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final void SetLocalCacheIP(String ip) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("SetLocalCacheIP");
        command.getParameters().AddParameter((Object)ip);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public void BalanceDataloadOnCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("BalanceDataloadOnCache");
        command.getParameters().AddParameter((Object)cacheId);
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public boolean IsCacheRegistered(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("IsCacheRegistered");
        command.getParameters().AddParameter((Object)cacheId);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final String GetLicenseKey() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetLicenseKey");
        return (String)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public final LicenseInfo[] GetLicenses() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetLicenses");
        return (LicenseInfo[])this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public ConfiguredCacheInfo[] GetAllConfiguredCaches() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetAllConfiguredCaches");
        return (ConfiguredCacheInfo[])this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public CacheNodeStatistics[] GetCacheStatistics(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheStatistics");
        command.getParameters().AddParameter((Object)cacheId);
        return (CacheNodeStatistics[])this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public CacheStatistics GetCacheStatistics2(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheStatistics2");
        command.getParameters().AddParameter((Object)cacheId);
        return (CacheStatistics)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public ConfiguredCacheInfo[] GetConfiguredPartitionedReplicaCaches() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetConfiguredPartitionedReplicaCaches");
        return (ConfiguredCacheInfo[])this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public Node[] GetCacheServers(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetCacheServers");
        command.getParameters().AddParameter((Object)cacheId);
        return (Node[])this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public HashMap GetSnmpPorts() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetSnmpPorts");
        return (HashMap)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public void StopServer() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("StopServer");
        this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public String GetServerPlatform() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetServerPlatform");
        return (String)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public Alachisoft.NCache.Config.NewDom.CacheServerConfig GetNewConfiguration(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetNewConfiguration");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
        return (Alachisoft.NCache.Config.NewDom.CacheServerConfig)(tempVar instanceof Alachisoft.NCache.Config.NewDom.CacheServerConfig ? tempVar : null);
    }

    @Override
    public boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws ConfigurationException, UnknownHostException, ManagementException, Exception {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("RegisterCache", 2);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)config);
        command.getParameters().AddParameter((Object)partId);
        command.getParameters().AddParameter((Object)overwrite);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)hotApply);
        try {
            return (Boolean)this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException ex) {
            Logger.getLogger(RemoteCacheServer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public boolean ApplyCacheConfiguration(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws IllegalArgumentException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException, Exception {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("ApplyCacheConfiguration", 2);
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)props);
        command.getParameters().AddParameter((Object)userId);
        command.getParameters().AddParameter((Object)password);
        command.getParameters().AddParameter((Object)hotApply);
        return (Boolean)this.ExecuteCommandOnCacehServer(command);
    }

    @Override
    public NewCacheRegisterationInfo GetNewUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetNewUpdatedCacheConfiguration");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)partId);
        command.getParameters().AddParameter((Object)newNode);
        command.getParameters().AddParameter((Object)isJoining);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
        return (NewCacheRegisterationInfo)(tempVar instanceof NewCacheRegisterationInfo ? tempVar : null);
    }

    @Override
    public ClientCacheStatus GetClientCahceStatus(String clientCacheID) throws ManagementException, ParserConfigurationException, ParserConfigurationException, InstantiationException, SAXException, IOException, IllegalAccessException, UnsupportedEncodingException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetClientCacheStatus");
        command.getParameters().AddParameter((Object)clientCacheID);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ClientCacheStatus)(tempVar instanceof ClientCacheStatus ? tempVar : null);
    }

    @Override
    public ServerLicenseInfo GetServerLicenseInfo() {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetServerLicenseInfo");
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ServerLicenseInfo)(tempVar instanceof ServerLicenseInfo ? tempVar : null);
    }

    @Override
    public ArrayList<ClientProcessStats> GetClientProcessStats(String cacheId) throws UnknownHostException {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("GetClientProcessStats");
        command.getParameters().AddParameter((Object)cacheId);
        Object tempVar = null;
        try {
            tempVar = this.ExecuteCommandOnCacehServer(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ArrayList)tempVar;
    }

    @Override
    public void PublishCustomClientCounters(String cacheId, ClientCustomCounters customCounters) {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("PublishCustomClientCounters");
        command.getParameters().AddParameter((Object)cacheId);
        command.getParameters().AddParameter((Object)customCounters);
        try {
            this.ExecuteCommandOnCacehServer(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getIsConnected() {
        return this._requestManager != null ? this._requestManager.getIsConnected() : false;
    }

    public void PublishMetadata(String sessionId, String version, ClientMetaData clientMeta) throws Exception {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("PublishMetaData", 3);
        command.getParameters().AddParameter((Object)sessionId);
        command.getParameters().AddParameter((Object)version);
        command.getParameters().AddParameter((Object)clientMeta);
        this.ExecuteCommandOnCacehServer(command);
    }

    public void PublishMetadata(String sessionId, CounterMetadataCollection counterMeta) throws Exception {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("PublishMetaData", 2);
        command.getParameters().AddParameter((Object)sessionId);
        command.getParameters().AddParameter((Object)counterMeta);
        this.ExecuteCommandOnCacehServer(command);
    }

    public int PublishData(String session, CounterDataCollection data) throws Exception {
        ManagementCommandProtocol.ManagementCommand command = this.GetManagementCommand("PublishData", 1);
        command.getParameters().AddParameter((Object)session);
        command.getParameters().AddParameter((Object)data);
        return (Integer)this.ExecuteCommandOnCacehServer(command);
    }

    static {
        CacheServer.callStaticBlock();
    }
}

