/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Util.SecurityUtil;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.NewDom.User;
import Alachisoft.NCache.Config.XmlConfigReader;
import Alachisoft.NCache.Management.CacheConfig;
import Alachisoft.NCache.Management.CacheConfigManager;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ThinClientConfigManager
extends CacheConfigManager {
    public static final int DEF_TCP_PORT = 8250;

    public static CacheServerConfig GetConfigDom(String cacheId, String filePath, String userId, String password, boolean inProc) throws ManagementException, SecurityException {
        try {
            XmlConfigReader configReader = new XmlConfigReader(filePath, cacheId);
            CacheServerConfig config = configReader.GetConfigDom();
            if (config == null) {
                return config;
            }
            if (!inProc) {
                inProc = config.getInProc();
            }
            if (inProc) {
                boolean isAuthorize = false;
                if (config.getSecurity() != null && config.getSecurity().getEnabled()) {
                    String userName = "";
                    User[] users = config.getSecurity().getUsers();
                    isAuthorize = false;
                    if (users != null) {
                        userName = ThinClientConfigManager.ExtractUserName(userId);
                        for (User user : users) {
                            if (user == null || !ThinClientConfigManager.parsedAdminUser(user.getId().toLowerCase()).equals(userName.toLowerCase())) continue;
                            isAuthorize = true;
                            break;
                        }
                    }
                    String domainController = config.getSecurity().getDomainController();
                    String port = config.getSecurity().getPort();
                    if (isAuthorize) {
                        isAuthorize = SecurityUtil.AuthorizeUserNamePassword((String)domainController, (String)ThinClientConfigManager.GetUserFullDn(config, userName), (String)password, (String)port);
                    }
                    if (!isAuthorize) {
                        throw new SecurityException("You do not have permissions to perform this operation");
                    }
                }
                return config;
            }
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static String parsedAdminUser(String userName) {
        String userNames = "";
        String[] splitUser = userName.split(",");
        String[] splits = new String[splitUser.length];
        for (String str : splitUser) {
            splits = str.split("-");
            if (!splits[0].toLowerCase().contains("cn")) continue;
            userNames = splits[1].toString();
            break;
        }
        return userNames;
    }

    public static String GetUserFullDn(CacheServerConfig config, String userName) {
        String userNames = "";
        User[] users = config.getSecurity().getUsers();
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                if (!ThinClientConfigManager.parsedAdminUser(users[i].getId().toString().toLowerCase()).equals(userName)) continue;
                userNames = users[i].getId().toString().replace("-", "=");
            }
            return userNames;
        }
        return userNames;
    }

    public static ArrayList GetCacheConfig(String cacheId, String filePath, String userId, String password, boolean inProc) throws ManagementException, Exception {
        try {
            XmlConfigReader configReader = new XmlConfigReader(filePath, cacheId);
            ArrayList propsList = configReader.getPropertiesList();
            ArrayList configsList = CacheConfig.GetConfigs(propsList, 8250L);
            Iterator it = configsList.iterator();
            if (it.hasNext()) {
                CacheConfig config = (CacheConfig)it.next();
                if (!inProc) {
                    inProc = config.getUseInProc();
                }
            }
            if (inProc) {
                boolean isAuthorize = false;
                HashMap ht = (HashMap)propsList.get(0);
                HashMap cache = (HashMap)ht.get("cache");
                if (cache.containsKey("security")) {
                    HashMap security = (HashMap)cache.get("security");
                    HashMap user = (HashMap)security.get("user");
                    String userName = ThinClientConfigManager.ExtractUserName(userId);
                    isAuthorize = user.containsKey(userName);
                    String domainController = (String)security.get("domain-controller");
                    String port = (String)security.get("port");
                    if (isAuthorize) {
                        isAuthorize = SecurityUtil.AuthorizeUserNamePassword((String)domainController, (String)userName, (String)password, (String)port);
                    }
                    if (!isAuthorize) {
                        throw new SecurityException("You do not have permissions to perform this operation");
                    }
                }
                return configsList;
            }
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ManagementException e2) {
            throw e2;
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public static String ExtractUserName(String userId) {
        String userName = userId;
        int index = userName.lastIndexOf("\\");
        userName = userName.substring(index + 1);
        return userName;
    }
}

