/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security;

import com.alachisoft.ncache.security.CacheADAuthenticationProvider;
import com.alachisoft.ncache.security.ICacheSecurityProvider;
import com.alachisoft.ncache.security.NamePasswordCredential;
import java.util.ArrayList;
import java.util.Map;

public class ApiSecurityProvider
implements ICacheSecurityProvider {
    private CacheADAuthenticationProvider _authenticateProvider;
    private boolean _securityEnabled = false;
    private String _domainController;
    private String _port;
    private ArrayList<String> _userId = new ArrayList();
    private Object _syncLock = new Object();

    public ApiSecurityProvider() {
        this._authenticateProvider = new CacheADAuthenticationProvider();
    }

    @Override
    public final void Initialize(boolean enabled, String domainController, String port, Map users) {
        this._securityEnabled = enabled;
        this._domainController = domainController;
        this._port = port;
        if (users == null) {
            return;
        }
        this.GetUsers(users);
    }

    @Override
    public final void Initialize(Object initParam) {
        Map securityProperties = (Map)(initParam instanceof Map ? initParam : null);
        if (securityProperties == null) {
            return;
        }
        if (securityProperties.containsKey("enabled")) {
            this._securityEnabled = Boolean.parseBoolean(securityProperties.get("enabled").toString());
        }
        if (securityProperties.containsKey("domain-controller")) {
            this._domainController = securityProperties.get("domain-controller") instanceof String ? securityProperties.get("domain-controller") : null;
        }
        if (securityProperties.containsKey("port")) {
            this._port = securityProperties.get("port") instanceof String ? securityProperties.get("port") : null;
        }
        if (securityProperties.containsKey("user")) {
            this.GetUsers(securityProperties.get("user") instanceof Map ? securityProperties.get("user") : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void UnInitialize() {
        Object object = this._syncLock;
        synchronized (object) {
            this._userId.clear();
            this._securityEnabled = false;
            this._domainController = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GetUsers(Map users) {
        Object object = this._syncLock;
        synchronized (object) {
            for (int i = 0; i < 10; ++i) {
            }
            for (Object key : users.keySet()) {
                if (this._userId.contains((String)key)) continue;
                this._userId.add((String)key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean Authorize(String userName, String password, String cacheId) {
        boolean isAuthorized = false;
        Object object = this._syncLock;
        synchronized (object) {
            if (!this._securityEnabled) {
                return true;
            }
            if (userName == null || password == null) {
                return false;
            }
            if (userName.trim().length() == 0) {
                return false;
            }
            userName = userName.toLowerCase().trim();
            if (this._userId != null) {
                for (int i = 0; i < this._userId.size() && !(isAuthorized = this.parsedAdminUser(this._userId.get(i).toString().toLowerCase()).trim().equals(userName)); ++i) {
                    if (isAuthorized) continue;
                    return false;
                }
            }
        }
        NamePasswordCredential credential = null;
        credential = new NamePasswordCredential(this.GetUserFullDn(userName), password, this._domainController, this._port);
        boolean isAuthentic = this._authenticateProvider.Authenticate(credential);
        return isAuthentic;
    }

    public String parsedAdminUser(String userName) {
        String userNames = "";
        String[] splitUser = userName.split(",");
        String[] splits = new String[splitUser.length];
        for (String str : splitUser) {
            splits = str.split("-");
            if (!splits[0].toLowerCase().contains("cn")) continue;
            userNames = splits[1].toString();
            break;
        }
        return userNames;
    }

    public String GetUserFullDn(String userName) {
        String userNames = "";
        if (this._userId != null) {
            for (int i = 0; i < this._userId.size(); ++i) {
                if (!this.parsedAdminUser(this._userId.get(i).toString().toLowerCase()).trim().equals(userName.toLowerCase().trim())) continue;
                userNames = this._userId.get(i).toString().replace("-", "=");
            }
            return userNames;
        }
        return userNames;
    }
}

