/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security;

import com.alachisoft.ncache.security.IAuthorizationProvider;
import com.alachisoft.ncache.security.OperationCode;
import com.alachisoft.ncache.security.SecurityConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CacheXMLAuthorizationProvider
implements IAuthorizationProvider {
    public static HashMap securityMap = null;
    public static boolean securityEnabled = false;
    public static String ldapPath = "";
    public static String ldapPort = "";

    public static String parsedAdminUser(String userName) {
        String userNames = "";
        String[] splitUser = userName.split(",");
        String[] splits = new String[splitUser.length];
        for (String str : splitUser) {
            splits = str.split("=");
            if (!splits[0].contains("cn")) continue;
            userNames = splits[1].toString();
            break;
        }
        return userNames;
    }

    public static String GetUserFullDn(String userName) {
        String userNames = "";
        ArrayList users = (ArrayList)securityMap.get("administrators");
        if (users != null) {
            for (int i = 0; i < users.size(); ++i) {
                if (!CacheXMLAuthorizationProvider.parsedAdminUser(users.get(i).toString().toLowerCase()).trim().equalsIgnoreCase(userName.trim())) continue;
                userNames = users.get(i).toString().toLowerCase();
            }
            return userNames;
        }
        return userNames;
    }

    public static void LoadSecurity() {
        try {
            String filePath = SecurityConfiguration.getConfigurationPath();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document document = null;
            DocumentBuilder db = dbf.newDocumentBuilder();
            File file = new File(filePath);
            if (!file.exists()) {
                return;
            }
            document = db.parse(file);
            boolean done = false;
            String enabled = "";
            NodeList enable = document.getElementsByTagName("enabled");
            NodeList ldap = document.getElementsByTagName("ldap");
            NodeList port = document.getElementsByTagName("port");
            if (enable != null) {
                Element enableElement = (Element)enable.item(0);
                enabled = enableElement.getFirstChild().getNodeValue().toLowerCase();
            }
            if (ldap != null) {
                Element ldapElement = (Element)ldap.item(0);
                ldapPath = ldapElement.getFirstChild().getNodeValue();
            }
            if (port != null) {
                Element portElement = (Element)port.item(0);
                ldapPort = portElement.getFirstChild().getNodeValue();
            }
            if (securityEnabled = Boolean.parseBoolean(enabled)) {
                securityMap = CacheXMLAuthorizationProvider.LoadSecurityXML(document);
            }
        }
        catch (Exception e) {
            securityEnabled = false;
        }
    }

    public static boolean isSecurityEnabled() {
        try {
            String filePath = SecurityConfiguration.getConfigurationPath();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document document = null;
            DocumentBuilder db = dbf.newDocumentBuilder();
            File file = new File(filePath);
            if (!file.exists()) {
                return false;
            }
            document = db.parse(file);
            boolean done = false;
            String enabled = "";
            NodeList enable = document.getElementsByTagName("enabled");
            NodeList ldap = document.getElementsByTagName("ldap");
            NodeList port = document.getElementsByTagName("port");
            if (enable != null) {
                Element enableElement = (Element)enable.item(0);
                enabled = enableElement.getFirstChild().getNodeValue().toLowerCase();
            }
            if (ldap != null) {
                Element ldapElement = (Element)ldap.item(0);
                ldapPath = ldapElement.getFirstChild().getNodeValue();
            }
            if (port != null) {
                Element portElement = (Element)port.item(0);
                ldapPort = portElement.getFirstChild().getNodeValue();
            }
            securityEnabled = Boolean.parseBoolean(enabled);
            return securityEnabled;
        }
        catch (Exception e) {
            securityEnabled = false;
            return securityEnabled;
        }
    }

    public static HashMap getSecurityMap() {
        try {
            String filePath = SecurityConfiguration.getConfigurationPath();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document document = null;
            DocumentBuilder db = dbf.newDocumentBuilder();
            File file = new File(filePath);
            if (!file.exists()) {
                return null;
            }
            document = db.parse(file);
            securityMap = CacheXMLAuthorizationProvider.LoadSecurityXML(document);
            return securityMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static HashMap LoadSecurityXML(Document document) {
        HashMap<String, Object> cacheSecurity = new HashMap<String, Object>();
        NodeList nodeSec = document.getElementsByTagName("administrators");
        NodeList enabled = document.getElementsByTagName("enabled");
        NodeList ldap = document.getElementsByTagName("ldap");
        NodeList port = document.getElementsByTagName("port");
        if (enabled.getLength() > 0) {
            Element enableElement = (Element)enabled.item(0);
            cacheSecurity.put("enabled", enableElement.getFirstChild().getNodeValue());
        }
        if (ldap.getLength() > 0) {
            Element ldapElement = (Element)ldap.item(0);
            cacheSecurity.put("ldap", ldapElement.getFirstChild().getNodeValue());
        }
        if (port.getLength() > 0) {
            Element portElement = (Element)port.item(0);
            cacheSecurity.put("port", portElement.getFirstChild().getNodeValue());
        }
        ArrayList cacheAdministrators = CacheXMLAuthorizationProvider.LoadNCacheAdministrators(nodeSec.item(0));
        cacheSecurity.put("administrators", cacheAdministrators);
        return cacheSecurity;
    }

    private static ArrayList LoadNCacheAdministrators(Node node) {
        NodeList uidList;
        ArrayList<String> uids = new ArrayList<String>();
        if (node != null && (uidList = ((Element)node).getElementsByTagName("uid")) != null && uidList.getLength() > 0) {
            for (int usersItem = 0; usersItem < uidList.getLength(); ++usersItem) {
                Node userNode = uidList.item(usersItem);
                if (userNode.getNodeType() != 1) continue;
                Element userElement = (Element)userNode;
                uids.add(userElement.getFirstChild().getNodeValue());
            }
        }
        return uids;
    }

    private static HashMap LoadNCacheUsers(Node node) {
        if (node == null) {
            return null;
        }
        NodeList uidList = ((Element)node).getElementsByTagName("cache");
        HashMap<String, ArrayList> caches = new HashMap<String, ArrayList>();
        if (uidList != null && uidList.getLength() > 0) {
            for (int usersItem = 0; usersItem < uidList.getLength(); ++usersItem) {
                Element cacheId;
                Node curNode = uidList.item(usersItem);
                if (curNode.getNodeType() != 1 || !(cacheId = (Element)curNode).hasAttribute("id")) continue;
                String cacheName = cacheId.getAttribute("id").toLowerCase();
                ArrayList cacheData = CacheXMLAuthorizationProvider.LoadUsers(cacheId);
                caches.put(cacheName, cacheData);
            }
        }
        return caches;
    }

    private static ArrayList LoadUsers(Element credentials) {
        NodeList uidList;
        ArrayList<String> uids = new ArrayList<String>();
        if (credentials != null && (uidList = credentials.getElementsByTagName("uid")) != null && uidList.getLength() > 0) {
            for (int usersItem = 0; usersItem < uidList.getLength(); ++usersItem) {
                Node userNode = uidList.item(usersItem);
                if (userNode.getNodeType() != 1) continue;
                Element userElement = (Element)userNode;
                uids.add(userElement.getFirstChild().getNodeValue());
            }
        }
        return uids;
    }

    @Override
    public final boolean Authorize(String ruleName) {
        if (ruleName == null || ruleName.length() == 0) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: ruleName");
        }
        return true;
    }

    @Override
    public final boolean AuthorizeNode(String userName) {
        boolean isAuthorize = false;
        if (!securityEnabled) {
            return true;
        }
        ArrayList users = (ArrayList)securityMap.get("administrators");
        if (users != null) {
            for (int i = 0; i < users.size() && !(isAuthorize = CacheXMLAuthorizationProvider.parsedAdminUser(users.get(i).toString().toLowerCase()).trim().equalsIgnoreCase(userName.trim())); ++i) {
            }
        }
        return isAuthorize;
    }

    @Override
    public final boolean AuthorizeAPI(String userId, OperationCode context, String cacheId) {
        if (!securityEnabled) {
            return true;
        }
        ArrayList superUsers = (ArrayList)securityMap.get("administrators");
        return superUsers != null && superUsers.contains(userId);
    }
}

