/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security;

import com.alachisoft.ncache.security.CacheADAuthenticationProvider;
import com.alachisoft.ncache.security.CacheXMLAuthorizationProvider;
import com.alachisoft.ncache.security.ICacheSecurityProvider;
import com.alachisoft.ncache.security.NamePasswordCredential;
import java.util.Map;

public class NodeSecurityProvider
implements ICacheSecurityProvider {
    private static NodeSecurityProvider provider;
    private CacheADAuthenticationProvider authenticateProvider;
    private CacheXMLAuthorizationProvider authorizeProvider = new CacheXMLAuthorizationProvider();

    public NodeSecurityProvider() {
        this.authenticateProvider = new CacheADAuthenticationProvider();
    }

    public static NodeSecurityProvider getNodeSecurity() {
        if (provider == null) {
            provider = new NodeSecurityProvider();
        }
        return provider;
    }

    public static void setNodeSecurity(NodeSecurityProvider value) {
        provider = value;
    }

    @Override
    public final boolean Authorize(String userName, String password, String arg0) {
        CacheXMLAuthorizationProvider.LoadSecurity();
        if (!CacheXMLAuthorizationProvider.securityEnabled) {
            return true;
        }
        try {
            boolean isAuthentic = this.authorizeProvider.AuthorizeNode(userName);
            if (isAuthentic) {
                NamePasswordCredential credential = new NamePasswordCredential(CacheXMLAuthorizationProvider.GetUserFullDn(userName), password, CacheXMLAuthorizationProvider.ldapPath, CacheXMLAuthorizationProvider.ldapPort);
                return this.authenticateProvider.Authenticate(credential);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public final void Initialize(Object initParam) {
    }

    @Override
    public final void Initialize(boolean enabled, String domainController, String port, Map users) {
    }

    @Override
    public final void UnInitialize() {
    }
}

