/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.ncactivate.license.EvaluationData;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class EvalLicense {
    public static Calendar EvaluationDt;
    private static EvaluationData edt;

    public static int EvaluationPeriod() {
        if (EvalLicense.edt.Extensions > 0) {
            return EvalLicense.edt.Period + EvalLicense.edt.Extensions * 30;
        }
        return EvalLicense.edt.Period;
    }

    public static void IsValid(byte[] evalData, int edid) throws LicensingException {
        try {
            if (EvaluationData.ReadEvaluationData(evalData, edid, edt) != 0) {
                throw new Exception();
            }
        }
        catch (LicensingException le) {
            throw le;
        }
        catch (Exception ex) {
            throw new LicensingException("EvaluationLicense information is either missing or corrupted. Inner Exception:" + ex.toString());
        }
        EvalLicense.isValidInternal(edid);
    }

    public static LicenseManager.LicenseType IsValid(int edid) throws LicensingException {
        try {
            if (EvaluationData.ReadEvaluationData(edid, edt) != 0) {
                throw new Exception();
            }
        }
        catch (LicensingException le) {
            throw le;
        }
        catch (Exception ex) {
            throw new LicensingException("EvaluationLicense information is either missing or corrupted. Inner Exception:" + ex.toString());
        }
        return EvalLicense.isValidInternal(edid);
    }

    private static LicenseManager.LicenseType isValidInternal(int edid) throws LicensingException {
        LicenseManager.LicenseType type = LicenseManager.LicenseType.InEvaluation;
        EvaluationDt = new GregorianCalendar();
        EvaluationDt.clear();
        EvaluationDt.setTimeZone(TimeZone.getTimeZone("UTC"));
        EvaluationDt.set(EvalLicense.edt.Year, EvalLicense.edt.Month, EvalLicense.edt.Days, 0, 0, 0);
        int evaluationPeriod = EvalLicense.EvaluationPeriod();
        GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        long nNow = now.getTimeInMillis();
        long nEvDt = EvaluationDt.getTimeInMillis();
        GregorianCalendar tSpan2 = new GregorianCalendar();
        tSpan2.clear();
        ((Calendar)tSpan2).setTimeZone(TimeZone.getTimeZone("UTC"));
        tSpan2.setTimeInMillis(nNow - nEvDt);
        String msg = new String();
        Object[] objectArray = new Object[2];
        objectArray[0] = tSpan2.get(6);
        objectArray[1] = evaluationPeriod - tSpan2.get(6);
        msg = String.format("Days used %s; Days left %d.", objectArray);
        Calendar temp = Calendar.getInstance();
        temp.setTime(EvaluationDt.getTime());
        temp.add(5, evaluationPeriod);
        if (now.before(temp)) {
            type = LicenseManager.LicenseType.InEvaluation;
        }
        if (now.after(temp)) {
            type = LicenseManager.LicenseType.Expired;
        }
        return type;
    }

    static {
        edt = new EvaluationData();
    }
}

