/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import com.alachisoft.ncache.licensing.ExpirationStatus;
import com.alachisoft.ncache.licensing.LicenseHelper;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.util.Calendar;

public class ExpirationInfo {
    private Calendar _expirationDate = LicenseHelper.getUTCDate();
    private int _gracePeriod = 0;
    private boolean _isPerpetual = false;
    private boolean _inEvaluation = false;
    private boolean _isServerOnly;
    private boolean _istrial;

    public Calendar getExpirationDate() {
        return this._expirationDate;
    }

    public void setExpirationDate(Calendar value) {
        this._expirationDate = value;
    }

    public int getGracePeriod() {
        return this._gracePeriod;
    }

    public void setGracePeriod(int value) {
        this._gracePeriod = value;
    }

    public boolean isPerpetual() {
        return this._isPerpetual;
    }

    public void setIsPerpetual(boolean value) {
        this._isPerpetual = value;
    }

    public boolean isInEvaluation() {
        return this._inEvaluation;
    }

    public void setInEvaluation(boolean value) {
        this._inEvaluation = value;
    }

    public boolean getIsTrial() {
        return this._istrial;
    }

    public void setIsTrial(boolean value) {
        this._istrial = value;
    }

    public boolean getIsServerOnly() {
        return this._isServerOnly;
    }

    public void setIsServerOnly(boolean value) {
        this._isServerOnly = value;
    }

    ExpirationStatus getExpirationStatus() {
        if (this._inEvaluation) {
            return ExpirationStatus.InEvaluation;
        }
        if (this._isPerpetual) {
            return ExpirationStatus.Licensed;
        }
        if (this._isServerOnly) {
            return ExpirationStatus.ServerOnly;
        }
        if (NCDateTime.getUTCNow().compareTo(this._expirationDate.getTime()) > 0) {
            NCDateTime ncDateTime = new NCDateTime(this._expirationDate.getTime());
            ncDateTime.addTicks(new NCDateTime(0, 0, this.getGracePeriod(), 0, 0, 0, 0).getTicks());
            if (NCDateTime.getUTCNow().compareTo(ncDateTime.getDate()) > 0) {
                return ExpirationStatus.Expired;
            }
            return ExpirationStatus.InGracePeriod;
        }
        return ExpirationStatus.Licensed;
    }

    public Calendar getHardExpirationDate() {
        Calendar calendar = LicenseHelper.getCopy(this._expirationDate);
        calendar.add(5, this._gracePeriod);
        return calendar;
    }
}

