/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Event.ILicenseExpiration;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import com.alachisoft.ncache.licensing.CloudLicense;
import com.alachisoft.ncache.licensing.EncryptionUtil;
import com.alachisoft.ncache.licensing.EvalLicense;
import com.alachisoft.ncache.licensing.ExpirationInfo;
import com.alachisoft.ncache.licensing.LicScheme;
import com.alachisoft.ncache.licensing.License;
import com.alachisoft.ncache.licensing.LicenseHelper;
import com.alachisoft.ncache.licensing.LicenseInfo;
import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.crypto.Crypto;
import com.alachisoft.ncache.ncactivate.license.ByteRef;
import com.alachisoft.ncache.ncactivate.license.CloudDll;
import com.alachisoft.ncache.ncactivate.license.EvaluationData;
import com.alachisoft.ncache.ncactivate.license.NCCpuInfo;
import com.alachisoft.ncache.ncactivate.license.NCCrypto;
import com.alachisoft.ncache.ncactivate.license.NCMisc;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import tangible.DotNetToJavaStringHelper;

public class LicenseManager {
    public static int editionId;
    public static boolean _isService;
    static String CLIENT_GUID;
    static String ENTERPRISE_GUID;
    static String PROF_CLIENT_GUID;
    static String PROFESSIONAL_GUID;
    private static Edition edition;
    private static ILicenseExpiration licenseExpirationCallBack;
    private static boolean _isFreeServer;
    private static boolean expiredFromEvaluation;
    private static int _prevCores;
    private static int _newCores;
    private static String _environmentName;
    private static int clientCpus;
    private static boolean _inEvaluation;
    private static boolean _isReactivation;
    private static String _editionIdString;
    private static boolean _isServerOnlyLicense;
    private static boolean _isTrialLicense;
    private static BuildType _ncBuildType;
    public static String editionInfo;

    public static void registerLicenseExpirationCallBack(ILicenseExpiration callback) {
        if (licenseExpirationCallBack == null) {
            licenseExpirationCallBack = callback;
        }
    }

    public static void onLicenseExpiration() {
        if (licenseExpirationCallBack != null) {
            licenseExpirationCallBack.onLicenseExpiration();
        }
    }

    public static boolean getExpiredFromEvaluation() {
        return expiredFromEvaluation;
    }

    public static void setExpiredFromEvaluation(boolean value) {
        expiredFromEvaluation = value;
    }

    public static String getEnvironmentName() {
        return _environmentName;
    }

    public static void setEnvironmentName(String value) {
        _environmentName = value;
    }

    public static String getEditionInfo() {
        return editionInfo;
    }

    public static void setEditionInfo(String value) {
        editionInfo = value;
    }

    public static int getClientCpus() {
        return clientCpus;
    }

    public static void setClientCpus(int value) {
        clientCpus = value;
    }

    public static boolean getInEvaluation() {
        return _inEvaluation;
    }

    public static void setInEvaluation(boolean value) {
        _inEvaluation = value;
    }

    public static int getPrevLicences() {
        return _prevCores;
    }

    public static void setPrevLicences(int value) {
        _prevCores = value;
    }

    public static int getNewLicenses() {
        return _newCores;
    }

    public static void setNewLicenses(int value) {
        _newCores = value;
    }

    public static boolean getReactivate() {
        return _isReactivation;
    }

    public static void setReactivate(boolean value) {
        _isReactivation = value;
    }

    public static boolean getIsServerOnly() {
        return _isServerOnlyLicense;
    }

    public static void setIsServerOnly(boolean value) {
        _isServerOnlyLicense = value;
    }

    public static boolean getIsTrialOnly() {
        return _isTrialLicense;
    }

    public static void setIsTrialOnly(boolean value) {
        _isTrialLicense = value;
    }

    public static boolean getIsService() {
        return _isService;
    }

    public static void setIsService(boolean value) {
        _isService = value;
    }

    public static LicenseInfo getLicenseInfo() {
        return LicenseInfo.getLicenseInfo();
    }

    public static String GetExpirationMessage() {
        ExpirationInfo expirationInfo = License.GetExpirationInfo();
        if (expirationInfo.isPerpetual()) {
            return "NCache is activated on this machine.";
        }
        if (LicenseHelper.getUTCDate().before(expirationInfo.getExpirationDate())) {
            return "NCache is activated on this machine. Activation will expire on " + LicenseHelper.getString(expirationInfo.getExpirationDate()) + ".";
        }
        long daysAfterExpiration = LicenseHelper.DifferenceInDays(expirationInfo.getExpirationDate(), LicenseHelper.getUTCDate());
        if (daysAfterExpiration > (long)expirationInfo.getGracePeriod()) {
            return "NCache license is expired.";
        }
        return "NCache license has expired on this machine. Grace period of " + expirationInfo.getGracePeriod() + " will expire on " + LicenseHelper.getString(expirationInfo.getHardExpirationDate()) + ".";
    }

    public static BuildType getNCacheBuildType() {
        block6: {
            try {
                String[] _code;
                block7: {
                    if (_ncBuildType != BuildType.NONE) break block6;
                    _code = null;
                    try {
                        String installCode = Crypto.Decode(RegUtil.getInstallCode());
                        String[] parsedCode = installCode.split("[:]", -1);
                        _code = parsedCode[0].split("[-]", -1);
                    }
                    catch (Exception e) {
                        if (editionInfo == null) break block7;
                        _code = editionInfo.split("[-]", -1);
                    }
                }
                if (_code != null && _code.length > 1) {
                    _ncBuildType = BuildType.getValueFromString(_code[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_ncBuildType == BuildType.NONE) {
            _ncBuildType = BuildType.CNTO;
        }
        return _ncBuildType;
    }

    public static ExpirationInfo getExpirationInfo() {
        ExpirationInfo ei = new ExpirationInfo();
        try {
            ActivationInfo ai = LicenseManager.getActivationInfo();
            ei.setIsPerpetual(ai.getIsPerpatual());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ai.getExpirationDate());
            ei.setExpirationDate(calendar);
            ei.setGracePeriod(ai.getGracePeriod());
            ei.setIsServerOnly(ai.getIsServerOnly());
            ei.setIsTrial(ai.getIsTrial());
        }
        catch (Exception e) {
            try {
                ei.setInEvaluation(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ei;
    }

    public static ActivationInfo getActivationInfo() {
        String authCode = LicenseManager.getAuthCode();
        try {
            return ActivationInfo.parse(authCode);
        }
        catch (LicensingException e) {
            return null;
        }
    }

    public static String getAuthCode() {
        return RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode);
    }

    public static Calendar getEvaluationDt() {
        if (EvalLicense.EvaluationDt == null) {
            return Calendar.getInstance();
        }
        return EvalLicense.EvaluationDt;
    }

    public static int getEvaluationPeriod() {
        return EvalLicense.EvaluationPeriod();
    }

    public static String getEditionName() {
        Edition edi = LicenseManager.getEdition();
        String ediName = "";
        ediName = edi == Edition.None ? "None" : (edi == Edition.developer ? "NCache Enterprise Developer" : (edi == Edition.enterpriseCacheServer ? "NCache Enterprise Cache Server" : (edi == Edition.enterpriseClient ? "NCache Enterprise Remote Client" : "None")));
        return ediName;
    }

    public static LicenseType LicenseMode(ILogger NCacheLog) throws LicensingException, LocalVerificationFailedException {
        return LicenseManager.LicenseMode(AppUtil.getEditionID(), null);
    }

    public static boolean Reactivate() throws LicensingException, LocalVerificationFailedException {
        String authCode = null;
        authCode = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode);
        System.out.println(authCode);
        try {
            AppUtil.VerifAuthKey(authCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AppUtil.GetReactivate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AppUtil.GetReactivate();
    }

    public static Edition getEdition() {
        if (edition == Edition.Null) {
            RegUtil.LoadRegistry();
            int editionId = AppUtil.getEditionID();
            edition = editionId == 52 ? Edition.enterpriseCacheServer : (editionId == 53 ? Edition.enterpriseClient : (editionId == 38 ? Edition.profCacheServer : (editionId == 39 ? Edition.profClient : (editionId == 19 ? Edition.developer : (editionId == 20 ? Edition.profDeveloper : (editionId == 40 ? Edition.express : (editionId == 70 ? Edition.enterpriseCacheServer : (editionId == 71 ? Edition.enterpriseClient : Edition.None))))))));
        }
        return edition;
    }

    public static Edition getEditionFromID(int editionId) {
        edition = editionId == 52 ? Edition.enterpriseCacheServer : (editionId == 53 ? Edition.enterpriseClient : (editionId == 38 ? Edition.profCacheServer : (editionId == 39 ? Edition.profClient : (editionId == 19 ? Edition.developer : (editionId == 20 ? Edition.profDeveloper : (editionId == 40 ? Edition.express : (editionId == 70 ? Edition.enterpriseCacheServer : (editionId == 71 ? Edition.enterpriseClient : Edition.None))))))));
        return edition;
    }

    public static boolean isEnterprise() {
        return edition == Edition.enterpriseCacheServer || edition == Edition.enterpriseClient || edition == Edition.developer;
    }

    public static boolean isDeveloper() {
        try {
            if (edition == Edition.Null) {
                edition = LicenseManager.getEdition();
            }
            if (edition == Edition.developer) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isProfessional() {
        return edition == Edition.profCacheServer || edition == Edition.profClient || edition == Edition.profDeveloper;
    }

    public static boolean isExpress() {
        return edition == Edition.express;
    }

    public static boolean isEntClient() {
        LicenseManager.getEdition();
        return edition == Edition.enterpriseClient;
    }

    public static boolean isEntDev() {
        return edition == Edition.developer;
    }

    public static boolean isEntCacheServer() {
        return edition == Edition.enterpriseCacheServer;
    }

    public static boolean isProCacheServer() {
        LicenseManager.getEdition();
        return edition == Edition.profCacheServer;
    }

    public static boolean isProClient() {
        LicenseManager.getEdition();
        return edition == Edition.profClient;
    }

    public static boolean isProDev() {
        LicenseManager.getEdition();
        return edition == Edition.profDeveloper;
    }

    private static Object convertToObject(byte[] bArray) {
        Object deserializedData = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            deserializedData = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        return deserializedData;
    }

    public static LicenseType LicenseMode(int edid, String version) throws LicensingException, LocalVerificationFailedException {
        try {
            version = AppUtil.getVersion();
            if (AppUtil.isCloudEdition) {
                try {
                    byte[] decryptedCode;
                    Object temp;
                    CloudLicense cloudLicense;
                    String uniqueRegId = "";
                    if (edid == 36) {
                        uniqueRegId = ENTERPRISE_GUID;
                    }
                    if (edid == 37) {
                        uniqueRegId = CLIENT_GUID;
                    }
                    EvaluationData evalData = new EvaluationData();
                    EvaluationData.ReadEvaluationData(edid, evalData);
                    byte[] encrypedCodeByteBuffer = null;
                    try {
                        encrypedCodeByteBuffer = CloudDll.readStub();
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                    if (encrypedCodeByteBuffer != null && (cloudLicense = (CloudLicense)(temp = LicenseManager.convertToObject(decryptedCode = EncryptionUtil.DecryptData(encrypedCodeByteBuffer)))) != null && edid == cloudLicense.getEdition() && evalData.Year == cloudLicense.getYear() && evalData.Month == cloudLicense.getMonth() && evalData.Days == cloudLicense.getDay()) {
                        return LicenseType.ActivePerProcessor;
                    }
                }
                catch (RuntimeException uniqueRegId) {
                    // empty catch block
                }
            }
            editionId = edid;
            if (License.isFree(edid)) {
                return LicenseType.ActivePerNode;
            }
            License.isActivated(edid);
            License.IsValid(version);
            if (License.LicenseScheme == LicScheme.PerNode) {
                return LicenseType.ActivePerNode;
            }
            return LicenseType.ActivePerProcessor;
        }
        catch (LicensingException le) {
            try {
                LicenseType type = EvalLicense.IsValid(edid);
                return type;
            }
            catch (LicensingException leEval) {
                throw new LicensingException(leEval.toString() + le.toString());
            }
            catch (SecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new LicensingException(ex.toString());
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (LocalVerificationFailedException lFE) {
            throw new LocalVerificationFailedException((Throwable)lFE);
        }
        catch (Exception e) {
            try {
                LicenseType type = EvalLicense.IsValid(edid);
                return type;
            }
            catch (LicensingException leEval) {
                throw new LicensingException(leEval.toString() + e.toString());
            }
            catch (Exception ex) {
                throw new LicensingException(ex.toString());
            }
        }
    }

    public static void setIsFreeClient() {
        _isFreeServer = true;
    }

    public static boolean getISFreeServer() {
        return _isFreeServer;
    }

    public static LicenseType LicenseMode(int edid, String version, byte[] data1, byte[] data2, byte[] data3, byte[] data4, byte[] data5, byte[] data6) throws LicensingException {
        try {
            editionId = edid;
            if (License.isFree(edid)) {
                return LicenseType.ActivePerProcessor;
            }
            ByteRef byteRef = new ByteRef();
            byteRef.data = data1;
            NCCrypto.EncryptDecryptBytes(byteRef, byteRef.data.length - NCMisc.g_DataOffset, NCMisc.g_DataOffset);
            License.isActivated(edid, data1);
            License.IsValid(version, data2, data3, data4, data5, data6);
            if (License.LicenseScheme == LicScheme.PerNode) {
                return LicenseType.ActivePerNode;
            }
            return LicenseType.ActivePerProcessor;
        }
        catch (LicensingException le) {
            try {
                EvalLicense.IsValid(data1, edid);
                return LicenseType.InEvaluation;
            }
            catch (LicensingException leEval) {
                throw new LicensingException(leEval.toString() + le.toString());
            }
            catch (Exception ex) {
                throw new LicensingException(ex.toString());
            }
        }
        catch (Exception e) {
            try {
                EvalLicense.IsValid(data1, edid);
                return LicenseType.InEvaluation;
            }
            catch (LicensingException leEval) {
                throw new LicensingException(leEval.toString() + e.toString());
            }
            catch (Exception ex) {
                throw new LicensingException(ex.toString());
            }
        }
    }

    public static byte[] getLCData(int opCode) throws LicensingException, LocalVerificationFailedException {
        byte[] buffer = null;
        ByteRef byteRef = new ByteRef();
        switch (opCode) {
            case 1: {
                buffer = NCMisc.ReadEvaluationData();
                break;
            }
            case 2: {
                int cpuCount = NCCpuInfo.GetNumProcessors();
                String cpuString = String.valueOf(cpuCount);
                buffer = cpuString.getBytes(Charset.forName("utf-8"));
                byteRef = new ByteRef();
                byteRef.data = buffer;
                NCCrypto.EncryptDecryptBytes(byteRef, byteRef.data.length, 0);
                break;
            }
            case 3: {
                ArrayList macs;
                try {
                    macs = EnvironmentUtil.GetAdaptersInfo();
                }
                catch (IOException ex) {
                    if (Trace.isOn()) {
                        Trace.out.println("License: isValid() " + ex.toString());
                    }
                    throw new LicensingException("License not verified due to following reason: " + ex.toString());
                }
                if (macs == null) break;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < macs.size(); ++i) {
                    String macString = (String)macs.get(i);
                    sb.append(macString);
                    if (i >= macs.size() - 1) continue;
                    sb.append(";");
                }
                buffer = sb.toString().getBytes(Charset.forName("utf-8"));
                byteRef.data = buffer;
                NCCrypto.EncryptDecryptBytes(byteRef, byteRef.data.length, 0);
                break;
            }
            case 4: {
                int physicalCores = NCCpuInfo.getPhysicalCoreCount();
                String physicalCoresString = String.valueOf(physicalCores);
                buffer = physicalCoresString.getBytes(Charset.forName("utf-8"));
                byteRef = new ByteRef();
                byteRef.data = buffer;
                NCCrypto.EncryptDecryptBytes(byteRef, byteRef.data.length, 0);
                break;
            }
            case 5: {
                int logicalCores = NCCpuInfo.getPhysicalCoreCount();
                String logicalCoresString = String.valueOf(logicalCores);
                buffer = logicalCoresString.getBytes(Charset.forName("utf-8"));
                byteRef = new ByteRef();
                byteRef.data = buffer;
                NCCrypto.EncryptDecryptBytes(byteRef, byteRef.data.length, 0);
                break;
            }
            case 6: {
                int socketCount = NCCpuInfo.getPhysicalCoreCount();
                String socketCountString = String.valueOf(socketCount);
                buffer = socketCountString.getBytes(Charset.forName("utf-8"));
                byteRef = new ByteRef();
                byteRef.data = buffer;
                NCCrypto.EncryptDecryptBytes(byteRef, byteRef.data.length, 0);
                break;
            }
        }
        return buffer;
    }

    public static void RaiseProductExpiryEvent(String message) {
        EventLogger.LogEvent((String)message, (EventType)EventType.ERROR);
    }

    public static void RaiseInvalidInstallEvent() {
        EventLogger.LogEvent((String)"NCache does not seem to be properly installed. Please re-install the product.", (EventType)EventType.ERROR);
    }

    public static void RaiseClusterNotAvailableEvent() {
        EventLogger.LogEvent((String)"NCache clustering is not available in a developer license.", (EventType)EventType.WARNING);
    }

    static {
        _isService = false;
        CLIENT_GUID = "1474D702-7432-4E3C-A2AE-83486A1ED079";
        ENTERPRISE_GUID = "9249E2CE-9323-4AF7-8437-138FA7B09026";
        PROF_CLIENT_GUID = "F44A0D3B-5FCD-4C66-BE3F-85553EDE2B43";
        PROFESSIONAL_GUID = "03862F75-0906-4A67-BA05-01A644BBF8B9";
        edition = Edition.Null;
        licenseExpirationCallBack = null;
        _prevCores = 0;
        _newCores = 0;
        _environmentName = "";
        _isReactivation = false;
        _ncBuildType = BuildType.NONE;
        editionInfo = "";
    }

    public static class ActivationInfo {
        private static final int maxCores = 4;
        public static int _licenseNumbers = 1;
        private static String _scheme = null;
        private static String _machineName = null;
        private static LicScheme _licScheme = LicScheme.PerNode;
        private static int _cores;
        private static int _clientLicenseLimit;
        private static int _serverLicenseLimit;
        private static int _processors;
        private static String _version;
        private static String _editionID;
        private static boolean _isPerpatual;
        private static Date _expirationDate;
        private static int _gracePeriod;
        private static String _mac1;
        private static String _mac2;
        private static String _mac3;
        private static String _mac4;
        private static boolean _isReactivation;
        private static boolean _isServeronly;
        private static boolean _allowAutoRenewal;
        private static boolean _isTrial;

        public String getScheme() {
            return _scheme;
        }

        public String getMachineName() {
            return _machineName;
        }

        public LicScheme getLicenseScheme() {
            return _licScheme;
        }

        public void setLicenseScheme(LicScheme value) {
            _licScheme = value;
        }

        public int getClientLicenseLimit() {
            return _clientLicenseLimit;
        }

        public void setClientLicenseLimit(int value) {
            _clientLicenseLimit = value;
        }

        public int getServerLicenseLimit() {
            return _serverLicenseLimit;
        }

        public void setServerLicenseLimit(int value) {
            _serverLicenseLimit = value;
        }

        public int getCores() {
            return _cores;
        }

        public int getProcessors() {
            return _processors;
        }

        public String getVersion() {
            return _version;
        }

        public static String getEditionID() {
            return _editionID;
        }

        public boolean getIsPerpatual() {
            return _isPerpatual;
        }

        public Date getExpirationDate() {
            return _expirationDate;
        }

        public boolean getIsTrial() {
            return _isTrial;
        }

        public int getGracePeriod() {
            String registryValue = RegUtil.getKey((InfoType)InfoType.USER, (RegKeys)RegKeys.EGP);
            if (registryValue != null && (registryValue instanceof String ? registryValue : null).equals("1")) {
                return _gracePeriod + 15;
            }
            return _gracePeriod;
        }

        public boolean getReactivate() {
            return _isReactivation;
        }

        public void setReactivate(boolean value) {
            _isReactivation = value;
        }

        public int remainingGraceDays() {
            NCDateTime ncDateTime = new NCDateTime(_expirationDate);
            ncDateTime.addDays((double)this.getGracePeriod());
            return TimeSpan.subtract((Date)ncDateTime.getDate(), (Date)NCDateTime.getUTCNow()).getDays();
        }

        public boolean getIsServerOnly() {
            return _isServeronly;
        }

        public void setIsServerOnly(boolean value) {
            _isServeronly = value;
        }

        public boolean getAllowAutoRenewal() {
            return _allowAutoRenewal;
        }

        public void setAllowAutoRenewal(boolean value) {
            _allowAutoRenewal = value;
        }

        public static ActivationInfo parse(String authCode) throws LicensingException {
            LicenseInfo licenseInfo;
            ActivationInfo ai;
            int tokensSize;
            String[] parts;
            block37: {
                block39: {
                    block38: {
                        String deodedAuthCode = Crypto.Decode(authCode);
                        parts = deodedAuthCode.split(":");
                        tokensSize = parts.length;
                        ai = new ActivationInfo();
                        licenseInfo = LicenseInfo.getLicenseInfo();
                        for (int i = 0; i < tokensSize; ++i) {
                            parts[i] = parts[i].toLowerCase();
                        }
                        String scheme = parts[0];
                        if (scheme.equalsIgnoreCase("cpu")) {
                            _licScheme = LicScheme.PerProcessor;
                        } else if (scheme.equalsIgnoreCase("node")) {
                            _licScheme = LicScheme.PerNode;
                        } else {
                            LicenseManager.setExpiredFromEvaluation(true);
                            throw new LicensingException("Invalid Authentication Code--Stage03");
                        }
                        if (tokensSize == 14 && !DotNetToJavaStringHelper.isNullOrEmpty((String)parts[13]) && parts[13].equalsIgnoreCase("TR")) {
                            throw new LicensingException("Invalid Authentication Code--Stage11");
                        }
                        _machineName = parts[1];
                        String machineName = licenseInfo.getMachineName();
                        if (!machineName.equalsIgnoreCase(_machineName)) {
                            throw new LicensingException("Invalid Authentication Code--Stage04");
                        }
                        if (_licScheme == LicScheme.PerNode) break block37;
                        _cores = Integer.parseInt(parts[2]);
                        _processors = Integer.parseInt(parts[3]);
                        LicenseManager.setPrevLicences(_processors);
                        LicenseManager.setNewLicenses(licenseInfo.getProcessors());
                        if (licenseInfo.getCores() <= _cores) break block38;
                        if (licenseInfo.getCores() > _processors * 4) break block39;
                    }
                    if (licenseInfo.getProcessors() <= _processors) break block37;
                }
                ai.setReactivate(true);
                String activation = parts[8];
                boolean voilatedCores = false;
                String string = "SOFTWARE\\Alachisoft\\NCache";
            }
            _version = parts[4];
            if (!licenseInfo.getVersion().equalsIgnoreCase(_version)) {
                throw new LicensingException("Invalid Authentication Code--Stage07");
            }
            _editionID = parts[5].toLowerCase();
            if (!_editionID.equalsIgnoreCase(_editionID)) {
                throw new LicensingException("Invalid Authentication Code--Stage08");
            }
            if (!parts[6].equalsIgnoreCase("null")) {
                _isPerpatual = false;
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                try {
                    _expirationDate = dateFormat.parse(parts[6]);
                }
                catch (ParseException voilatedCores) {
                    // empty catch block
                }
                try {
                    _gracePeriod = Integer.parseInt(parts[7]);
                }
                catch (Exception e) {
                    throw new LicensingException("Invalid Authentication Code--Stage10");
                }
            }
            _isPerpatual = true;
            _expirationDate = NCDateTime.MaxValue;
            _gracePeriod = 0;
            _mac1 = parts[9];
            _mac2 = parts[10];
            _mac3 = parts[11];
            _mac4 = parts[12];
            boolean hasMac1 = false;
            boolean hasMac2 = false;
            boolean hasMac3 = false;
            boolean hasMac4 = false;
            for (int count = 0; count < licenseInfo.macsInfo.size(); ++count) {
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)parts[9]) && parts[9].equalsIgnoreCase((String)licenseInfo.macsInfo.get(count))) {
                    hasMac1 = true;
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)parts[10]) && parts[10].equalsIgnoreCase((String)licenseInfo.macsInfo.get(count))) {
                    hasMac2 = true;
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)parts[11]) && parts[11].equalsIgnoreCase((String)licenseInfo.macsInfo.get(count))) {
                    hasMac3 = true;
                }
                if (DotNetToJavaStringHelper.isNullOrEmpty((String)parts[12]) || !parts[12].equalsIgnoreCase((String)licenseInfo.macsInfo.get(count))) continue;
                hasMac4 = true;
            }
            if (!(hasMac1 || hasMac2 || hasMac3 || hasMac4)) {
                throw new LicensingException("Invalid Authentication Code--Stage09");
            }
            if (tokensSize > 13) {
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)parts[13])) {
                    if (parts[13].equalsIgnoreCase("SO")) {
                        _isServeronly = true;
                        _inEvaluation = false;
                    } else {
                        _isServeronly = false;
                        _inEvaluation = false;
                    }
                } else {
                    _isServeronly = false;
                    _inEvaluation = false;
                }
            }
            if (tokensSize > 14 && !DotNetToJavaStringHelper.isNullOrEmpty((String)parts[14])) {
                _allowAutoRenewal = parts[14].equalsIgnoreCase("1");
            }
            if (tokensSize > 15 && !DotNetToJavaStringHelper.isNullOrEmpty((String)parts[15])) {
                LicenseManager.setEnvironmentName(parts[15]);
            }
            if (tokensSize > 16 && !DotNetToJavaStringHelper.isNullOrEmpty((String)parts[16])) {
                int result = 0;
                try {
                    result = Integer.parseInt(parts[16]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LicenseManager.setClientCpus(result);
            }
            if (tokensSize > 17 && !DotNetToJavaStringHelper.isNullOrEmpty((String)parts[17])) {
                _isTrial = parts[17].equalsIgnoreCase("TR");
            }
            if (tokensSize > 18) {
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)parts[19])) {
                    ai.setClientLicenseLimit(Integer.parseInt(parts[19]));
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)parts[20])) {
                    ai.setServerLicenseLimit(Integer.parseInt(parts[20]));
                }
            }
            LicenseManager.setExpiredFromEvaluation(false);
            return ai;
        }

        static {
            _clientLicenseLimit = Integer.MAX_VALUE;
            _serverLicenseLimit = Integer.MAX_VALUE;
            _version = null;
            _editionID = null;
            _expirationDate = new Date(0L);
            _mac1 = null;
            _mac2 = null;
            _mac3 = null;
            _mac4 = null;
            _isReactivation = false;
            _allowAutoRenewal = true;
            _isTrial = false;
        }
    }

    public static enum Edition {
        enterpriseCacheServer,
        enterpriseClient,
        profCacheServer,
        profClient,
        developer,
        profDeveloper,
        express,
        None,
        Null;

    }

    public static enum LicenseType {
        Expired,
        InEvaluation,
        ActivePerNode,
        ActivePerProcessor,
        UnRegistered,
        LicenseVoilated,
        None;


        public int getValue() {
            return this.ordinal();
        }

        public static LicenseType forValue(int value) {
            return LicenseType.values()[value];
        }
    }

    public static enum BuildType {
        ENT,
        CNT,
        PCNT,
        PROF,
        ENTO,
        CNTO,
        PROFO,
        PCNTO,
        DEV,
        PDEV,
        INVALID,
        NONE,
        ELAD,
        CELAD;


        public static BuildType getValueFromString(String value) {
            for (BuildType enumValue : BuildType.values()) {
                if (!enumValue.name().equalsIgnoreCase(value)) continue;
                return enumValue;
            }
            return INVALID;
        }
    }
}

