/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.cmdline;

import com.alachisoft.ncache.common.commandline.ArgumentAttributeAnnotation;
import com.alachisoft.ncache.common.commandline.CommandLineArgs;
import com.alachisoft.ncache.common.commandline.CommandLineArgumentParser;
import com.alachisoft.ncache.ncactivate.cmdline.exceptions.CorruptInstallationException;
import com.alachisoft.ncache.ncactivate.cmdline.exceptions.InvalidKeyException;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class LicenseTool {
    private static final String BUNDLE_NAME = "com/alachisoft/ncache/ncactivate/utils/stringtable.properties";
    private Properties stringTableProps;
    private AppUtil appUtil = new AppUtil();
    private String[] args;
    private CommandLineArgs cmdArgs;

    public LicenseTool() throws CorruptInstallationException {
        this.stringTableProps = this.appUtil.loadResourceBundle(BUNDLE_NAME);
        this.VerifyInstallation();
    }

    public Properties getStringTableProps() {
        return this.stringTableProps;
    }

    public AppUtil getAppUtil() {
        return this.appUtil;
    }

    public CommandLineArgs getCmdArgs() {
        return this.cmdArgs;
    }

    public final void VerifyInstallation() throws CorruptInstallationException {
        LicenseTool licenseTool = this;
        if (licenseTool.appUtil.getActivationData().Load() < 0) {
            throw new CorruptInstallationException("The software does not seem to be properly installed.");
        }
    }

    protected boolean intialize(String[] args, CommandLineArgs cmdArgs) {
        this.args = args;
        this.cmdArgs = cmdArgs;
        return this.Parse();
    }

    protected final boolean ValidateEvalKey(String key) throws InvalidKeyException {
        return this.appUtil.ValidateEvalKey(key);
    }

    protected boolean checkRequiredParams(HashMap<String, String> requiredParams) {
        StringBuilder missingArgsBuilder = new StringBuilder();
        for (Map.Entry<String, String> param : requiredParams.entrySet()) {
            if (!this.isNullOrEmpty(param.getValue())) continue;
            missingArgsBuilder.append(param.getKey()).append(", ");
        }
        String missingArgs = missingArgsBuilder.toString().trim();
        if (missingArgs.length() > 0) {
            System.err.println("Following arguments are required ".concat(missingArgs.substring(0, missingArgs.lastIndexOf(","))).concat("."));
            System.err.println("Use -h --help to view help.");
            return false;
        }
        if (!AppUtil.GetReactivate()) {
            this.getAppUtil();
            if (AppUtil.getProductInfo().Reactivation) {
                System.out.println("Machine is already activated for enough cores, reactivation not allowed");
                System.exit(0);
            }
        }
        return true;
    }

    public abstract void Run(String[] var1);

    protected abstract void Run();

    private boolean Parse() {
        if (this.args != null && this.cmdArgs != null) {
            try {
                CommandLineArgumentParser.Parse((Object)this.cmdArgs, (String[])this.args);
                return true;
            }
            catch (IllegalArgumentException iLE) {
                String defaultValue = null;
                try {
                    defaultValue = this.cmdArgs.getClass().getMethod("getHelp", new Class[0]).getAnnotation(ArgumentAttributeAnnotation.class).fullNotation();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                System.err.println(iLE.getMessage() + (String)(defaultValue == null ? "" : "\nUse \"" + defaultValue + "\" to view help."));
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return false;
    }

    protected boolean printUsage() {
        if (this.cmdArgs.getUsage().booleanValue()) {
            this.cmdArgs.printUsage();
            return true;
        }
        return false;
    }

    protected boolean pringLogo() {
        if (this.cmdArgs.getLogo().booleanValue()) {
            this.cmdArgs.printLogo();
            return true;
        }
        return false;
    }

    public boolean isNullOrEmpty(String param) {
        return param == null || param.isEmpty();
    }

    public String getMachineInfoCode() {
        return this.appUtil.generateMachineInfoCode();
    }
}

