/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.license;

import com.alachisoft.ncache.ncactivate.license.NCFileUtil;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.util.RuntimeUtil;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CloudDll {
    public static final String winStub = "cld_vc.dll";
    public static final String linuxStub = ".cld_vc.so";

    public static int InitializeStub(int version, byte[] data) throws LicensingException, Exception {
        String[] systemFolder = null;
        RuntimeUtil.OS operatingSystem = RuntimeUtil.getCurrentOS();
        try {
            if (operatingSystem == RuntimeUtil.OS.Windows) {
                String sys32Folder = System.getenv("WINDIR") + "\\system32";
                systemFolder = new String[]{sys32Folder};
                for (int i = 0; i < systemFolder.length; ++i) {
                    systemFolder[i] = systemFolder[i] + "\\cld_vc.dll";
                }
            } else {
                systemFolder = new String[]{"//usr//lib//.cld_vc.so", "//usr//bin//.cld_vc.so"};
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long dwSize = 0L;
        boolean fileExists = false;
        for (int i = 0; i < systemFolder.length && !fileExists; ++i) {
            fileExists = NCFileUtil.FileExists(systemFolder[i]);
            if (fileExists) {
                throw new Exception("Already Licensed...");
            }
            try {
                boolean result = true;
                for (i = 0; i < systemFolder.length && result; ++i) {
                    result = NCFileUtil.WriteFile(systemFolder[i], data, data.length);
                }
                if (result) {
                    return 0;
                }
                return -1;
            }
            catch (MissingResourceException mre) {
                mre.printStackTrace();
                if (data != null) continue;
                return -1;
            }
        }
        int ret = -1;
        return ret;
    }

    private static String[] getWinSystemDir(String delim, String prop) {
        StringTokenizer tokanizer = new StringTokenizer(prop);
        Vector<String> v = new Vector<String>();
        String token = "";
        while (tokanizer.hasMoreTokens()) {
            token = tokanizer.nextToken(";");
            if (token.indexOf(delim) == -1 || v.contains(token)) continue;
            v.add(token);
        }
        return v.toArray(new String[0]);
    }

    public static byte[] readStub() throws Exception {
        byte[] data = null;
        String[] systemFolder = null;
        RuntimeUtil.OS operatingSystem = RuntimeUtil.getCurrentOS();
        boolean isWindows = false;
        try {
            if (operatingSystem == RuntimeUtil.OS.Windows) {
                String sys32Folder = System.getenv("WINDIR") + "\\system32";
                systemFolder = new String[]{sys32Folder};
                for (int i = 0; i < systemFolder.length; ++i) {
                    systemFolder[i] = systemFolder[i] + "\\cld_vc.dll";
                }
                isWindows = true;
            } else {
                systemFolder = new String[]{"//usr//lib//", "//usr//bin//"};
            }
        }
        catch (Exception sys32Folder) {
            // empty catch block
        }
        for (int i = 0; i < systemFolder.length; ++i) {
            String ncStubFolder = "";
            ncStubFolder = isWindows ? systemFolder[i].replace(winStub, winStub) : systemFolder[i].replace(linuxStub, linuxStub);
            if (NCFileUtil.FileExists(ncStubFolder)) {
                if (isWindows) {
                    data = NCFileUtil.ReadFile((String)systemFolder[i]).data;
                    continue;
                }
                data = NCFileUtil.ReadFile((String)linuxStub).data;
                continue;
            }
            throw new Exception("Not Licensed for cloud...");
        }
        return data;
    }
}

