/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.license;

import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import com.alachisoft.ncache.runtime.util.RuntimeUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NCCpuInfo {
    private static final int coresPerLicense = 4;
    private static int _licenseCount = -1;
    private static int _physCPU = -1;
    private static int _logiCPU = -1;
    private static int _socketCount = -1;
    private static boolean _loaded = false;
    private static String _linuxPhysicalCPUCommand = "grep \"cpu cores\" /proc/cpuinfo | uniq | sed -e 's/[^0-9]*//g'";
    private static String _linuxLogicalCPUCommand = "grep \"processor\" /proc/cpuinfo | wc -l";
    private static String _linuxSocketCountCPUCommand = "grep \"physical id\" /proc/cpuinfo | sort | uniq | wc -l";
    private static int _maxCoresPerLicense = 4;
    private static int _maxLicense = 16;

    public static int PresentCores() {
        return _physCPU;
    }

    public static int PresentLicences() {
        return _socketCount;
    }

    public static int calculateLicenseCount(int existingCores) {
        int physicalCpus = 0;
        if (existingCores <= 8) {
            return 2;
        }
        while (true) {
            if (existingCores > physicalCpus * _maxCoresPerLicense && existingCores <= (physicalCpus + 1) * _maxCoresPerLicense) {
                if (physicalCpus == 0) {
                    physicalCpus = 1;
                    break;
                }
                ++physicalCpus;
                break;
            }
            ++physicalCpus;
        }
        return physicalCpus;
    }

    public static int getLicenseCount() throws LicensingException, LocalVerificationFailedException {
        return NCCpuInfo.getSocketCount();
    }

    public static int getPhysicalCoreCount() throws LicensingException, LocalVerificationFailedException {
        if (!_loaded) {
            NCCpuInfo.loadInfo();
        }
        return _physCPU;
    }

    public static int getLogicalCoreCount() throws LicensingException, LocalVerificationFailedException {
        if (!_loaded) {
            NCCpuInfo.loadInfo();
        }
        return _logiCPU;
    }

    public static int getSocketCount() throws LicensingException, LocalVerificationFailedException {
        if (!_loaded) {
            NCCpuInfo.loadInfo();
            _socketCount = _physCPU <= 8 ? 2 : NCCpuInfo.calculateLicenseCount(_physCPU);
        }
        _socketCount = NCCpuInfo.calculateLicenseCount(_physCPU);
        return _socketCount;
    }

    private static String[][] GetCommands() {
        String[][] cmds = null;
        if (RuntimeUtil.getCurrentOS().equals((Object)RuntimeUtil.OS.Linux)) {
            cmds = new String[][]{{"/bin/sh", "-c", _linuxPhysicalCPUCommand}, {"/bin/sh", "-c", _linuxLogicalCPUCommand}, {"/bin/sh", "-c", _linuxSocketCountCPUCommand}};
        } else if (RuntimeUtil.getCurrentOS().equals((Object)RuntimeUtil.OS.Windows)) {
            cmds = new String[][]{{"wmic", "cpu", "get"}};
        }
        return cmds;
    }

    private static String GetCommandOutput() throws IOException, LocalVerificationFailedException {
        String[][] cmds = NCCpuInfo.GetCommands();
        StringBuilder outputText = new StringBuilder();
        for (String[] cmd : cmds) {
            int c;
            Process p;
            try {
                p = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException iOE) {
                throw new LocalVerificationFailedException("Failed to execute shell command. Contact local server.");
            }
            BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
            StringBuilder buffer = new StringBuilder();
            while ((c = ((InputStream)stdoutStream).read()) != -1) {
                buffer.append((char)c);
            }
            if (buffer.toString().equals("")) {
                outputText.append(" ");
            } else {
                outputText.append(buffer.toString());
            }
            ((InputStream)stdoutStream).close();
            outputText.append(";");
        }
        return outputText.toString();
    }

    public static int GetNumProcessors() throws LicensingException, LocalVerificationFailedException {
        if (!_loaded) {
            NCCpuInfo.loadInfo();
        }
        return NCCpuInfo.getLicenseCount();
    }

    private static void ParseResult(String outString) throws LicensingException {
        if (RuntimeUtil.getCurrentOS().equals((Object)RuntimeUtil.OS.Windows)) {
            String[] rows = outString.split(";")[0].split("\n");
            if (rows.length >= 2) {
                int numberOfCores = rows[0].indexOf("NumberOfCores");
                int numberOfLogicalProcessors = rows[0].indexOf("NumberOfLogicalProcessors");
                int numberOfSockets = rows[0].indexOf("SocketDesignation");
                if (numberOfCores >= 0 && numberOfCores < rows[1].length()) {
                    try {
                        _physCPU = Character.getNumericValue(rows[1].charAt(numberOfCores));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (numberOfLogicalProcessors >= 0 && numberOfLogicalProcessors < rows[1].length()) {
                    try {
                        _logiCPU = Character.getNumericValue(rows[1].charAt(numberOfLogicalProcessors));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (numberOfSockets > 0) {
                    try {
                        for (int row = 1; row < rows.length - 1; ++row) {
                            String socketSubString;
                            if (numberOfSockets >= rows[row].length() || !(socketSubString = rows[row].substring(numberOfSockets)).substring(0, 3).toUpperCase().equals("CPU") && !socketSubString.substring(0, 3).toUpperCase().equals("PROC")) continue;
                            int currentSocketCount = 1;
                            String[] tokens = socketSubString.split(" ");
                            try {
                                currentSocketCount = Integer.parseInt(tokens[1]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (_socketCount >= currentSocketCount) continue;
                            _socketCount = currentSocketCount;
                        }
                    }
                    catch (Exception e) {
                        _socketCount = 2;
                    }
                }
                if (_socketCount < 1) {
                    _socketCount = 2;
                }
            }
        } else if (RuntimeUtil.getCurrentOS().equals((Object)RuntimeUtil.OS.Linux)) {
            String[] rows = outString.split(";");
            int i = 0;
            try {
                _physCPU = Integer.parseInt(rows[i++].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                _logiCPU = Integer.parseInt(rows[i++].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                _socketCount = Integer.parseInt(rows[i++].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_physCPU == -1) {
                if (_logiCPU == -1) {
                    throw new LicensingException("Invalid Authentication Code: Stage 1000");
                }
                _physCPU = _logiCPU;
            }
            if (_socketCount < 1) {
                _socketCount = 2;
            }
        } else {
            _socketCount = 2;
        }
    }

    public static void loadInfo() throws LicensingException, LocalVerificationFailedException {
        Boolean loaded = false;
        if (!_loaded) {
            try {
                if (RuntimeUtil.getCurrentOS() == RuntimeUtil.OS.Linux) {
                    String result = NCCpuInfo.GetCommandOutput();
                    NCCpuInfo.ParseResult(result);
                    loaded = true;
                } else if (RuntimeUtil.getCurrentOS() == RuntimeUtil.OS.Windows) {
                    String result = NCCpuInfo.GetCommandOutput();
                    NCCpuInfo.ParseResult(result);
                    _loaded = loaded;
                    loaded = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            _loaded = loaded;
        }
    }
}

