/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Parser;

import Alachisoft.NCache.Parser.Action;
import Alachisoft.NCache.Parser.LRAction;
import Alachisoft.NCache.Parser.Symbol;
import java.util.ArrayList;

public class LRActionTable {
    private ArrayList m_members = new ArrayList();

    public final int getCount() {
        return this.m_members.size();
    }

    public final ArrayList getMembers() {
        return this.m_members;
    }

    public final LRAction GetActionForSymbol(int p_symbolIndex) {
        for (Object actionObj : this.m_members) {
            LRAction action = (LRAction)actionObj;
            if (action.getSymbol().getTableIndex() != p_symbolIndex) continue;
            return action;
        }
        return null;
    }

    public final LRAction GetItem(int p_index) {
        if (p_index >= 0 && p_index < this.m_members.size()) {
            return (LRAction)this.m_members.get(p_index);
        }
        return null;
    }

    public final void AddItem(Symbol p_symbol, Action p_action, int p_value) {
        LRAction item = new LRAction();
        item.setSymbol(p_symbol);
        item.setAction(p_action);
        item.setValue(p_value);
        this.m_members.add(item);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("LALR table:\n");
        for (Object actionObj : this.m_members) {
            LRAction action = (LRAction)actionObj;
            result.append("- ").append(action.toString() + "\n");
        }
        return result.toString();
    }
}

