/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Parser;

import Alachisoft.NCache.Parser.SymbolType;

public class Symbol {
    private static final String c_quotedChars = "|-+*?()[]{}<>!\\u0022";
    private int m_tableIndex;
    private String m_name;
    private SymbolType m_kind = SymbolType.values()[0];

    public Symbol(int p_index, String p_name, SymbolType p_kind) {
        this.m_tableIndex = p_index;
        this.m_name = p_name;
        this.m_kind = p_kind;
    }

    protected Symbol() {
        this(-1, "", SymbolType.Error);
    }

    public final int getTableIndex() {
        return this.m_tableIndex;
    }

    public final String getName() {
        return this.m_name;
    }

    public final SymbolType getKind() {
        return this.m_kind;
    }

    public boolean equals(Object p_object) {
        Symbol symbol = (Symbol)p_object;
        return this.m_name.equals(symbol.getName()) && this.m_kind == symbol.getKind();
    }

    public int hashCode() {
        return (this.m_name + "||" + this.m_kind).hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.m_kind == SymbolType.NonTerminal) {
            result.append("<").append(this.m_name).append(">");
        } else if (this.m_kind == SymbolType.Terminal) {
            result.append(this.m_name);
        } else {
            result.append("(").append(this.m_name).append(")");
        }
        return result.toString();
    }

    private void PatternFormat(String p_source, StringBuilder p_target) {
        for (int i = 0; i < p_source.length(); ++i) {
            char ch = p_source.charAt(i);
            if (ch == '\'') {
                p_target.append("''");
                continue;
            }
            if (c_quotedChars.indexOf(ch) != -1) {
                p_target.append("'").append(ch).append("'");
                continue;
            }
            p_target.append(ch);
        }
    }

    protected final void CopyData(Symbol p_symbol) {
        this.m_name = p_symbol.getName();
        this.m_kind = p_symbol.getKind();
        this.m_tableIndex = p_symbol.getTableIndex();
    }
}

