/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.hibernate.jcache;

import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.hibernate.configuration.ConfigurationManager;
import com.alachisoft.ncache.hibernate.configuration.RegionConfiguraton;
import com.alachisoft.ncache.jsr107.NCacheCache;
import com.alachisoft.ncache.jsr107.NCacheConfiguration;
import com.alachisoft.ncache.jsr107.NCacheManager;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.Date;

public class HibernateNCacheCache<K, V>
extends NCacheCache<K, V> {
    private final ConfigurationManager config;
    private RegionConfiguraton regionConfiguration;

    public HibernateNCacheCache(NCacheManager cacheManager, RegionConfiguraton cfg, Cache ncache) throws FileNotFoundException, Exception {
        super(cacheManager, new NCacheConfiguration(cfg.getCacheName(), null, String.class, Object.class), ncache);
        if (ncache == null) {
            throw new NullPointerException();
        }
        this.config = ConfigurationManager.getInstance();
        this.regionConfiguration = cfg;
    }

    protected TimeSpan getSlidingExpiration() {
        return new TimeSpan(0, 0, this.regionConfiguration.getExpirationPeriod());
    }

    protected Date getAbsoluteExpiration() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, this.regionConfiguration.getExpirationPeriod());
        return calendar.getTime();
    }

    protected byte getExpiratonType() {
        if (this.regionConfiguration.getExpirationType().contains("Sliding")) {
            return 1;
        }
        if (this.regionConfiguration.getExpirationType().contains("None")) {
            return 3;
        }
        if (this.regionConfiguration.getExpirationType().contains("Absolute")) {
            return 4;
        }
        return 0;
    }

    public void put(K key, V value) {
        String[] keyParts = key.toString().split("#", 2);
        CacheItemPriority priority = this.regionConfiguration.getCacheItemPriority();
        if (keyParts.length > 1) {
            this.put(key, value, this.config.getCacheDependency(keyParts[0], keyParts[1]), priority);
        } else {
            this.put(key, value, null, priority);
        }
    }
}

