/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.File;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tangible.DotNetToJavaStringHelper;

public class AppUtil {
    public static final int MAX_BUCKETS = 1000;
    public static final String DeployedAssemblyDir = "deploy" + File.separator;
    private static Date START_DT;

    public static String getInstallDir() {
        String installPath = ServicePropValues.INSTALLDIR_DIR;
        if (installPath != null && !installPath.equals("")) {
            return installPath;
        }
        String path = ServicePropValues.getTGHome();
        if (path == null || path.length() == 0) {
            return null;
        }
        return path;
    }

    public static String GetAppSetting(String key) {
        return AppUtil.GetAppSetting("", key);
    }

    public static String GetAppSetting(String section, String key) {
        return "";
    }

    public static int DiffSeconds(Date dt) throws IllegalArgumentException {
        long utcTicks = 0L;
        try {
            utcTicks = new NCDateTime(NCDateTime.getUTCDate((Date)dt)).getTicks();
        }
        catch (ParseException e) {
            utcTicks = HelperFxn.getUTCTicks((Date)dt);
        }
        long timespan = utcTicks - new NCDateTime(START_DT).getTicks();
        int interval = (int)new TimeSpan(timespan).getTotalSeconds();
        return interval;
    }

    public static int fixedExpDiffSeconds(Date dt) throws IllegalArgumentException {
        long timespan = new NCDateTime(dt).getTicks() - new NCDateTime(START_DT).getTicks();
        int interval = (int)new TimeSpan(timespan).getTotalSeconds();
        return interval;
    }

    public static int DiffMilliseconds(Date dt) throws IllegalArgumentException {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar c = Calendar.getInstance(utc);
        c.clear();
        c.set(14, 0);
        c.setTime(dt);
        NCDateTime ncdt = null;
        ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
        NCDateTime date = null;
        NCDateTime start_ncd = null;
        start_ncd = new NCDateTime(START_DT);
        date = new NCDateTime(dt);
        int interval = date.getMilliseconds() - start_ncd.getMilliseconds();
        return interval;
    }

    public static long DiffTicks(Date dt) throws IllegalArgumentException {
        return HelperFxn.getUTCTicks((Date)dt) - new NCDateTime(START_DT).getTicks();
    }

    public static Date GetDateTime(int absoluteTime) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(START_DT);
        cal.add(13, absoluteTime);
        return cal.getTime();
    }

    public static int hashCode(String str) {
        int num;
        str = AppUtil.getLocationAffinityKey(str);
        char[] array = str.toCharArray();
        int[] intArray = new int[(int)Math.ceil((double)array.length / 2.0)];
        int j = 0;
        for (int i = 0; i < intArray.length; ++i) {
            char[] toInt = new char[2];
            if (j < array.length) {
                toInt[0] = array[j++];
            }
            if (j < array.length) {
                toInt[1] = array[j++];
            }
            intArray[i] = AppUtil.charToInt(toInt);
        }
        int num2 = num = 0x15051505;
        int i = array.length;
        int j2 = 0;
        while (i > 0) {
            num = (num << 5) + num + (num >> 27) ^ intArray[j2];
            if (i <= 2) break;
            num2 = (num2 << 5) + num2 + (num2 >> 27) ^ intArray[j2 + 1];
            i -= 4;
            j2 += 2;
        }
        return num + num2 * 1566083941;
    }

    private static int charToInt(char[] array) {
        return array[0] | array[1] << 16;
    }

    private static String getLocationAffinityKey(String key) {
        int indexStart = key.indexOf(123);
        int indexEnd = key.indexOf(125);
        if (indexStart != -1 && indexEnd != -1 && indexStart + 1 < indexEnd) {
            return key.substring(indexStart + 1, indexEnd);
        }
        return key;
    }

    public static String getLocalServerIp() throws ConfigurationException {
        Node localServerIp = null;
        try {
            File hfile;
            String directoryValue = Common.getNCHome();
            String separator = File.separator;
            if (directoryValue != null) {
                if (!directoryValue.endsWith(separator)) {
                    directoryValue = directoryValue.concat(separator);
                }
                directoryValue.replaceFirst(";", "");
                directoryValue = directoryValue.concat("config" + separator + "client.ncconf");
            }
            if (!(hfile = new File(directoryValue)).exists()) {
                throw new ConfigurationException("NCHOME not found");
            }
            Document response = null;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = builderFactory.newDocumentBuilder();
            response = builder.parse(hfile);
            boolean serverPortFound = false;
            NodeList serverPortNL = response.getElementsByTagName("ncache-server");
            if (serverPortNL != null) {
                Node ncacheServerDetails = serverPortNL.item(0);
                if (ncacheServerDetails == null) {
                    throw new Exception("ncache-server options not found in client.ncconf.");
                }
                NamedNodeMap attributes = ncacheServerDetails.getAttributes();
                localServerIp = attributes.getNamedItem("local-server-ip");
                return localServerIp.getTextContent();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("NCHOME not found");
        }
        return null;
    }

    public static boolean isMavenOnlyInstallation() {
        boolean isMaven = false;
        Object filePath = "";
        String installDirectory = AppUtil.getInstallDir();
        if (DotNetToJavaStringHelper.isNullOrEmpty(installDirectory)) {
            isMaven = true;
        } else {
            String fileDirectory = installDirectory + File.separator + "bin" + File.separator + "service";
            filePath = fileDirectory + File.separator + "Alachisoft.NCache.CacheHost.dll";
            File cacheHostDll = new File((String)filePath);
            if (!cacheHostDll.exists() && !(cacheHostDll = new File((String)(filePath = fileDirectory + File.separator + "Alachisoft.NCache.CacheHost.exe"))).exists()) {
                isMaven = true;
            }
        }
        return isMaven;
    }

    static {
        try {
            boolean x = false;
            NCDateTime time = new NCDateTime(2004, 11, 30, 0, 0, 0, 0);
            START_DT = time.getLocalizedDate();
            boolean bl = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

