/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Communication.Secure;

import Alachisoft.NCache.Common.Communication.Secure.SSLManagerFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SecureStream
extends Socket {
    private final LinkedHashMap<String, X509Certificate[]> authorizedNodeCertificates = new LinkedHashMap();
    String keyStoreType;
    private boolean tlsNeedClientAuth = true;
    private String[] tlsCipherSuites = new String[0];
    private String[] tlsProtocols = new String[]{"TLSv1", "SSLv3"};
    private volatile transient SSLContext sslContext;
    private String keyStoreURL;
    private volatile transient KeyManager km;
    private volatile transient TrustManager tm;
    private String keyStorePin;
    private String keyStorePinProperty;
    private String keyStoreKeyPin;
    private String keyStoreKeyPinProperty;
    private String trustStoreURL;
    private String trustStoreType;
    private String trustStorePin;
    private String trustStorePinProperty;
    private boolean rebindNeeded;

    public SecureStream(Socket secondaryClient) {
    }

    private static SSLContext createSSLContext(KeyManager km, TrustManager tm) throws GeneralSecurityException {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        SSLContext ctx = SSLContext.getInstance("TLS");
        if (km != null) {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = km;
        } else {
            keyManagerArray = null;
        }
        if (tm != null) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = tm;
        } else {
            trustManagerArray = null;
        }
        ctx.init(keyManagerArray, trustManagerArray, null);
        return ctx;
    }

    private static X509Certificate[] toArray(Collection<X509Certificate[]> c) {
        int size = 0;
        for (X509Certificate[] certs : c) {
            size += certs.length;
        }
        X509Certificate[] dest = new X509Certificate[size];
        int destPos = 0;
        for (X509Certificate[] certs : c) {
            System.arraycopy(certs, 0, dest, destPos, certs.length);
            destPos += certs.length;
        }
        return dest;
    }

    private static String[] intersect(String[] ss1, String[] ss2) {
        String[] ss = new String[Math.min(ss1.length, ss2.length)];
        int len = 0;
        block0: for (String s1 : ss1) {
            for (String s2 : ss2) {
                if (!s1.equals(s2)) continue;
                ss[len++] = s1;
                continue block0;
            }
        }
        if (len == ss.length) {
            return ss;
        }
        String[] dest = new String[len];
        System.arraycopy(ss, 0, dest, 0, len);
        return dest;
    }

    public String[] getTlsCipherSuites() {
        return this.tlsCipherSuites;
    }

    public void setTlsCipherSuites(String ... tlsCipherSuites) {
        if (Arrays.equals(this.tlsCipherSuites, tlsCipherSuites)) {
            return;
        }
        this.tlsCipherSuites = tlsCipherSuites;
        this.needRebind();
    }

    public final boolean isTls() {
        return this.tlsCipherSuites.length > 0;
    }

    public final String[] getTlsProtocols() {
        return this.tlsProtocols;
    }

    public final void setTlsProtocols(String ... tlsProtocols) {
        if (Arrays.equals(this.tlsProtocols, tlsProtocols)) {
            return;
        }
        this.tlsProtocols = tlsProtocols;
        this.needRebind();
    }

    public final boolean isTlsNeedClientAuth() {
        return this.tlsNeedClientAuth;
    }

    public final void setTlsNeedClientAuth(boolean tlsNeedClientAuth) {
        if (this.tlsNeedClientAuth == tlsNeedClientAuth) {
            return;
        }
        this.tlsNeedClientAuth = tlsNeedClientAuth;
        this.needRebind();
    }

    void needRebind() {
        this.rebindNeeded = true;
    }

    private ServerSocket createTLSServerSocket() throws IOException, GeneralSecurityException {
        SSLContext sslContext = this.sslContext();
        SSLServerSocketFactory ssf = sslContext.getServerSocketFactory();
        SSLServerSocket ss = (SSLServerSocket)ssf.createServerSocket();
        ss.setEnabledProtocols(this.tlsProtocols);
        ss.setEnabledCipherSuites(this.tlsCipherSuites);
        ss.setNeedClientAuth(this.tlsNeedClientAuth);
        return ss;
    }

    private SSLSocket createTLSSocket(Socket s, String hostName, int port) throws GeneralSecurityException, IOException {
        SSLContext sslContext = this.sslContext();
        SSLSocketFactory sf = sslContext.getSocketFactory();
        SSLSocket ssl = (SSLSocket)sf.createSocket(s, hostName, port, true);
        ssl.setEnabledProtocols(SecureStream.intersect(this.tlsProtocols, this.tlsProtocols));
        ssl.setEnabledCipherSuites(SecureStream.intersect(this.tlsCipherSuites, this.tlsCipherSuites));
        ssl.startHandshake();
        return ssl;
    }

    SSLContext sslContext() throws GeneralSecurityException, IOException {
        SSLContext ctx = this.sslContext;
        if (ctx != null) {
            return ctx;
        }
        this.sslContext = ctx = SecureStream.createSSLContext(this.km(), this.tm());
        return ctx;
    }

    private KeyManager km() throws GeneralSecurityException, IOException {
        KeyManager ret = this.km;
        if (ret != null || this.keyStoreURL == null) {
            return ret;
        }
        String keyStorePin = this.keyStorePin();
        this.km = ret = SSLManagerFactory.createKeyManager(this.keyStoreType(), this.keyStoreURL, this.keyStorePin(), this.keyPin(keyStorePin));
        return ret;
    }

    private TrustManager tm() throws GeneralSecurityException, IOException {
        TrustManager ret = this.tm;
        if (ret != null || this.trustStoreURL == null && this.authorizedNodeCertificates.isEmpty()) {
            return ret;
        }
        ret = this.trustStoreURL != null ? SSLManagerFactory.createTrustManager(this.trustStoreType(), this.trustStoreURL, this.trustStorePin()) : SSLManagerFactory.createTrustManager(this.getAllAuthorizedNodeCertificates());
        this.tm = ret;
        return ret;
    }

    private String keyStoreType() {
        if (this.keyStoreType == null) {
            throw new IllegalStateException("keyStoreURL requires keyStoreType");
        }
        return this.keyStoreType;
    }

    public final String getKeyStorePin() {
        return this.keyStorePin;
    }

    public final void setKeyStorePin(String keyStorePin) {
        this.checkNotEmpty("keyStorePin", keyStorePin);
        this.keyStorePin = keyStorePin;
    }

    private String keyStorePin() {
        if (this.keyStorePin != null) {
            return this.keyStorePin;
        }
        if (this.keyStorePinProperty == null) {
            throw new IllegalStateException("keyStoreURL requires keyStorePin or keyStorePinProperty");
        }
        String pin = System.getProperty(this.keyStorePinProperty);
        if (pin == null) {
            throw new IllegalStateException("No such keyStorePinProperty: " + this.keyStorePinProperty);
        }
        return pin;
    }

    private void checkNotEmpty(String name, String val) {
        if (val != null && val.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    private String keyPin(String keyStorePin) {
        if (this.keyStoreKeyPin != null) {
            return this.keyStoreKeyPin;
        }
        if (this.keyStoreKeyPinProperty == null) {
            return keyStorePin;
        }
        String pin = System.getProperty(this.keyStoreKeyPinProperty);
        if (pin == null) {
            throw new IllegalStateException("No such keyPinProperty: " + this.keyStoreKeyPinProperty);
        }
        return pin;
    }

    private String trustStoreType() {
        if (this.trustStoreType == null) {
            throw new IllegalStateException("trustStoreURL requires trustStoreType");
        }
        return this.trustStoreType;
    }

    private String trustStorePin() {
        if (this.trustStorePin != null) {
            return this.trustStorePin;
        }
        if (this.trustStorePinProperty == null) {
            throw new IllegalStateException("trustStoreURL requires trustStorePin or trustStorePinProperty");
        }
        String pin = System.getProperty(this.trustStorePinProperty);
        if (pin == null) {
            throw new IllegalStateException("No such trustStorePinProperty: " + this.trustStorePinProperty);
        }
        return pin;
    }

    public X509Certificate[] getAllAuthorizedNodeCertificates() {
        return SecureStream.toArray(this.authorizedNodeCertificates.values());
    }

    public void InitializeAsClient(String targetHost, boolean provideCert) {
    }

    public void write(byte[] buffer) throws IOException {
    }

    public int read(byte[] argvalue, int totalBytesRecieved, int i) throws IOException {
        return 0;
    }
}

