/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Configuration;

import Alachisoft.NCache.Common.Configuration.Activator;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationCommentAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationRootAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.Configuration.DynamicConfigType;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tangible.DotNetToJavaStringHelper;

public class ConfigurationBuilder {
    private static final String DYNAMIC_CONFIG_SECTION = "dynamic-config-object";
    private static String[] _excludedText = new String[]{"sec", "%", "mb"};
    private HashMap _baseConfigurationMap = new HashMap();
    private HashMap<String, DynamicConfigType> _dynamicSectionTypeMap = new HashMap();
    private ArrayList _lastLoadedConfiugration = new ArrayList();
    private String _file;
    private String _path = null;

    public ConfigurationBuilder(Object[] configuration) throws Exception {
        this.setConfiguration(configuration);
    }

    public ConfigurationBuilder(String file) {
        this._file = file;
    }

    public ConfigurationBuilder() {
    }

    public ConfigurationBuilder(String file, String path) {
        this._file = file;
        this._path = path;
    }

    private static String ValidateForRootConfiguration(Class type) {
        String rootAttrib = null;
        Annotation[] customAttributes = type.getAnnotations();
        if (customAttributes != null) {
            for (Annotation attrib : customAttributes) {
                if (!(attrib instanceof ConfigurationRootAnnotation)) continue;
                rootAttrib = ((ConfigurationRootAnnotation)attrib).value();
                break;
            }
        }
        return rootAttrib;
    }

    public final Object[] getConfiguration() {
        return this._lastLoadedConfiugration.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setConfiguration(Object[] value) throws Exception {
        ArrayList arrayList = this._lastLoadedConfiugration;
        synchronized (arrayList) {
            this._lastLoadedConfiugration.clear();
            for (int i = 0; i < value.length; ++i) {
                String rootAttrib = ConfigurationBuilder.ValidateForRootConfiguration(value[i].getClass());
                if (rootAttrib == null) {
                    throw new Exception(value[i].getClass() + " is not marked as RootConfiguration");
                }
                this._lastLoadedConfiugration.add(value[i]);
            }
        }
    }

    public final void RegisterRootConfigurationObject(Class type) throws Exception {
        String rootConfiguratinAttrib = ConfigurationBuilder.ValidateForRootConfiguration(type);
        if (rootConfiguratinAttrib == null) {
            throw new Exception(type.toString() + " is not marked as RootConfiguration");
        }
        this._baseConfigurationMap.put(rootConfiguratinAttrib.toLowerCase(), type);
    }

    public final void ReadConfiguration() throws ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, Exception {
        this.ReadConfiguration(this._file, this._path);
    }

    public final void ReadConfiguration(String xml) throws ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, Exception {
        this.ReadConfiguration(this._file, this._path);
    }

    public final void ReadConfiguration(Document bridges) throws InstantiationException, IllegalAccessException, Exception {
        NodeList nodeList = bridges.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 4 || node.getNodeType() == 8) continue;
                this.ReadConfigurationForNode(node);
            }
        }
    }

    private void ReadConfiguration(String file, String path) throws ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, Exception {
        if (file == null) {
            throw new Exception("File name can not be null");
        }
        path = path == null ? "" : path;
        this._lastLoadedConfiugration = new ArrayList();
        String fileName = path + file;
        if (!new File(fileName).isFile()) {
            throw new Exception("File " + fileName + " not found");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new File(fileName));
        }
        catch (Exception e) {
            throw new Exception("Can not open " + fileName + " Error:" + e.toString());
        }
        this.ReadConfiguration(document);
    }

    private Object GetConfigurationObject(String cofingStr) throws InstantiationException, IllegalAccessException {
        Object cfgObject = null;
        if (this._baseConfigurationMap.containsKey(cofingStr.toLowerCase())) {
            Class type = this._baseConfigurationMap.get(cofingStr.toLowerCase()) instanceof Class ? this._baseConfigurationMap.get(cofingStr.toLowerCase()) : null;
            cfgObject = Activator.createInstance(type);
            this._lastLoadedConfiugration.add(cfgObject);
        }
        return cfgObject;
    }

    private void ReadConfigurationForNode(Node node) throws InstantiationException, IllegalAccessException, Exception {
        int i;
        Object cfgObject = this.GetConfigurationObject(node.getNodeName().toLowerCase());
        NodeList nodeList = node.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            Node node1 = nodeList.item(i);
            if (node1.getNodeType() != 1) continue;
            Element element = (Element)node1;
            if (!node1.getNodeName().toLowerCase().equals(DYNAMIC_CONFIG_SECTION)) continue;
            this.ExtractDyanamicConfigSectionObjectType(node1);
        }
        if (cfgObject != null) {
            this.PopulateConfiugrationObject(cfgObject, node);
        } else {
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                this.ReadConfigurationForNode(node);
            }
        }
    }

    private void PopulateConfiugrationObject(Object config, Node node) throws Exception {
        Class sectionType;
        int i;
        if (node == null || config == null) {
            return;
        }
        Element element = (Element)node;
        NamedNodeMap attribs = element.getAttributes();
        for (int i2 = 0; i2 < attribs.getLength(); ++i2) {
            this.FillConfigWithAttribValue(config, attribs.item(i2));
        }
        NodeList nodeList = node.getChildNodes();
        HashMap sameSections = new HashMap();
        for (i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element childElements = (Element)nodeList.item(i);
            sectionType = null;
            if (childElements.getNodeName().toLowerCase() != DYNAMIC_CONFIG_SECTION || !childElements.hasAttributes()) continue;
            this.ExtractDyanamicConfigSectionObjectType(childElements);
        }
        for (i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element sectionNode = (Element)nodeList.item(i);
            sectionType = null;
            if (sectionNode.getNodeName().toLowerCase().equals(DYNAMIC_CONFIG_SECTION)) continue;
            sectionType = this.GetConfigSectionObjectType(config, sectionNode.getNodeName());
            if (sectionType != null) {
                if (sectionType.isArray()) {
                    String nonArrayType = sectionType.getCanonicalName().replace("[]", "");
                    ArrayList<Object> sameSessionList = null;
                    HashMap<String, Object> tmp = null;
                    if (!sameSections.containsKey(sectionType)) {
                        tmp = new HashMap<String, Object>();
                        tmp.put("section-name", sectionNode.getNodeName());
                        sameSessionList = new ArrayList<Object>();
                        tmp.put("section-list", sameSessionList);
                        sameSections.put(sectionType, tmp);
                    } else {
                        tmp = sameSections.get(sectionType) instanceof HashMap ? (HashMap)sameSections.get(sectionType) : null;
                        sameSessionList = tmp.get("section-list") instanceof ArrayList ? (ArrayList)tmp.get("section-list") : null;
                    }
                    Class<?> clas = Class.forName(nonArrayType);
                    Object singleSessionObject = Activator.createInstance(clas);
                    this.PopulateConfiugrationObject(singleSessionObject, sectionNode);
                    sameSessionList.add(singleSessionObject);
                } else {
                    Object objHandle;
                    Object sectionConfig = objHandle = Activator.createInstance(sectionType);
                    this.PopulateConfiugrationObject(sectionConfig, sectionNode);
                    this.SetConfigSectionObject(config, sectionConfig, sectionNode.getNodeName());
                }
            }
            if (sameSections.size() <= 0) continue;
            for (Map.Entry pair : sameSections.entrySet()) {
                Class classtype = pair.getKey() instanceof Class ? (Class)pair.getKey() : null;
                String type = classtype.getCanonicalName().replace("[]", "");
                HashMap tmp = pair.getValue() instanceof HashMap ? (HashMap)pair.getValue() : null;
                ArrayList sameSessionList = tmp.get("section-list") instanceof ArrayList ? (ArrayList)tmp.get("section-list") : null;
                String sectionName = tmp.get("section-name") instanceof String ? (String)tmp.get("section-name") : null;
                Object[] sessionArrayObj = new Object[sameSessionList.size()];
                for (int j = 0; j < sameSessionList.size(); ++j) {
                    sessionArrayObj[j] = Activator.createInstance(Class.forName(classtype.getCanonicalName().replace("[]", "")));
                }
                if (sessionArrayObj == null) continue;
                System.arraycopy(sameSessionList.toArray(), 0, sessionArrayObj, 0, sameSessionList.size());
                Object[] obj = sessionArrayObj;
                this.SetConfigSectionObject(config, obj, sectionName);
            }
        }
    }

    private Object GetConfigSectionObject(Object config, String sectionName) {
        return null;
    }

    private Class GetConfigSectionObjectType(Object config, String sectionName) {
        Class<?> sectionType = null;
        Class<?> type = config.getClass();
        Method[] objProps = type.getMethods();
        if (objProps != null) {
            for (int i = 0; i < objProps.length; ++i) {
                ConfigurationSectionAnnotation configAttrib;
                Method fieldInfo = objProps[i];
                Annotation[] customAttribs = fieldInfo.getAnnotations();
                if (customAttribs == null || customAttribs.length <= 0 || (configAttrib = (ConfigurationSectionAnnotation)(customAttribs[0] instanceof ConfigurationSectionAnnotation ? customAttribs[0] : null)) == null || !configAttrib.value().toLowerCase().equals(sectionName.toLowerCase()) || fieldInfo.getParameterTypes().length > 0) continue;
                sectionType = fieldInfo.getReturnType();
                break;
            }
        }
        if (sectionType == null && this._dynamicSectionTypeMap.containsKey(sectionName.toLowerCase())) {
            sectionType = this._dynamicSectionTypeMap.get(sectionName.toLowerCase()).getType();
        }
        return sectionType;
    }

    private void ExtractDyanamicConfigSectionObjectType(Node node) {
        Class<?> sectionType = null;
        if (node != null) {
            String assemblyName = null;
            Object className = null;
            boolean isArray = false;
            String sectionid = null;
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node attribute = map.item(i);
                if (attribute.getNodeName().toLowerCase().equals("assembly")) {
                    assemblyName = attribute.getNodeValue();
                }
                if (attribute.getNodeName().toLowerCase().equals("class")) {
                    className = attribute.getNodeValue();
                }
                if (attribute.getNodeName().toLowerCase().equals("section-id")) {
                    sectionid = attribute.getNodeValue();
                }
                if (!attribute.getNodeName().toLowerCase().equals("is-array")) continue;
                isArray = Boolean.parseBoolean(attribute.getNodeValue());
            }
            if (className == null || sectionid == null) {
                return;
            }
            Object assebmlyQualifiedName = null;
            assebmlyQualifiedName = assemblyName != null ? className + "," + assemblyName : className;
            try {
                sectionType = Class.forName((String)assebmlyQualifiedName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (sectionType != null && !DotNetToJavaStringHelper.isNullOrEmpty(sectionid)) {
                this._dynamicSectionTypeMap.put(sectionid, new DynamicConfigType(sectionType, isArray));
            }
        }
    }

    private void SetConfigSectionObject(Object config, Object sectionConfig, String sectionName) throws ConfigurationException {
        Class<?> type = config.getClass();
        Method[] objProps = type.getMethods();
        if (objProps != null) {
            for (int i = 0; i < objProps.length; ++i) {
                Method fieldInfo = objProps[i];
                Annotation[] customAttribs = fieldInfo.getAnnotations();
                if (customAttribs == null || customAttribs.length <= 0) continue;
                ConfigurationSectionAnnotation configSection = (ConfigurationSectionAnnotation)(customAttribs[0].annotationType().equals(ConfigurationSectionAnnotation.class) ? customAttribs[0] : null);
                try {
                    if (configSection == null || !configSection.value().equals(sectionName.toLowerCase()) || fieldInfo.getParameterTypes().length == 0) continue;
                    fieldInfo.invoke(config, sectionConfig);
                    break;
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage());
                }
            }
        }
    }

    public Object ConvertToPrimitive(Class targetType, String value, String appendedText) {
        Object primitiveValue = null;
        if (appendedText != null && !appendedText.equals("")) {
            value = value.toLowerCase().replace(appendedText.toLowerCase(), "");
        }
        if (targetType.getCanonicalName().equals("byte")) {
            primitiveValue = Byte.parseByte(value);
        } else if (targetType.getCanonicalName().equals("short")) {
            primitiveValue = Short.parseShort(value);
        } else if (targetType.getCanonicalName().equals("double")) {
            primitiveValue = Double.parseDouble(value);
        } else if (targetType.getCanonicalName().equals("boolean")) {
            primitiveValue = Boolean.parseBoolean(value.toLowerCase());
        } else if (targetType.getCanonicalName().equals("char")) {
            primitiveValue = value;
        } else if (targetType.getCanonicalName().equals("int")) {
            primitiveValue = Integer.parseInt(value);
        } else if (targetType.getCanonicalName().equals("long")) {
            primitiveValue = Long.decode(value);
        } else if (targetType.getCanonicalName().equals("float")) {
            primitiveValue = Float.valueOf(Float.parseFloat(value));
        } else if (targetType.getCanonicalName().equals("java.lang.Byte")) {
            primitiveValue = Byte.parseByte(value);
        } else if (targetType.getCanonicalName().equals("java.lang.Double")) {
            primitiveValue = Double.parseDouble(value);
        } else if (targetType.getCanonicalName().equals("java.lang.Integer")) {
            primitiveValue = Integer.parseInt(value);
        }
        if (targetType.getCanonicalName().equals("java.lang.Short")) {
            primitiveValue = Short.parseShort(value);
        } else if (targetType.getCanonicalName().equals("java.lang.Boolean")) {
            primitiveValue = Boolean.parseBoolean(value.toLowerCase());
        } else if (targetType.getCanonicalName().equals("java.lang.Character")) {
            if (value.toCharArray().length == 1) {
                primitiveValue = Character.valueOf(value.toCharArray()[0]);
            }
        } else if (targetType.getCanonicalName().equals("java.math.BigDecimal")) {
            primitiveValue = BigDecimal.valueOf(Double.parseDouble(value));
        } else if (targetType.getCanonicalName().equals("java.lang.Long")) {
            primitiveValue = Long.decode(value);
        }
        if (targetType.getCanonicalName().equals("java.lang.String")) {
            primitiveValue = value;
        } else if (targetType.getCanonicalName().equals("java.lang.Float")) {
            primitiveValue = Float.valueOf(Float.parseFloat(value));
        } else if (targetType.getCanonicalName().equals("java.lang.Object[]")) {
            primitiveValue = new Object[]{value};
        }
        return primitiveValue;
    }

    private String ExcludeExtraText(String input) {
        String output = input;
        if (input != null) {
            input = input.toLowerCase();
            for (int i = 0; i < _excludedText.length; ++i) {
                if (input.indexOf(_excludedText[i]) < 0) continue;
                output = input.replace(_excludedText[i], "");
                break;
            }
        }
        return output;
    }

    private void FillConfigWithAttribValue(Object config, Node xmlAttrib) throws Exception {
        Class<?> type = config.getClass();
        Method[] objProps = type.getMethods();
        if (objProps != null) {
            for (int i = 0; i < objProps.length; ++i) {
                Method fieldInfo = objProps[i];
                Annotation[] customAttribs = fieldInfo.getAnnotations();
                if (customAttribs == null || customAttribs.length <= 0) continue;
                ConfigurationAttributeAnnotation configAttrib = (ConfigurationAttributeAnnotation)(customAttribs[0].annotationType().equals(ConfigurationAttributeAnnotation.class) ? customAttribs[0] : null);
                try {
                    if (configAttrib == null || !xmlAttrib.getNodeName().toLowerCase().equals(configAttrib.value()) || fieldInfo.getParameterTypes().length == 0) continue;
                    Class<?>[] typs = fieldInfo.getParameterTypes();
                    fieldInfo.invoke(config, this.ConvertToPrimitive(typs[0], xmlAttrib.getNodeValue(), configAttrib.appendText()));
                    break;
                }
                catch (Exception e) {
                    throw new Exception("Can not set the value for attribute " + configAttrib.value() + " Errror :" + e.toString());
                }
            }
        }
    }

    public final String GetXmlString() throws IllegalArgumentException, IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        if (this._lastLoadedConfiugration != null) {
            for (Object cfgObject : this._lastLoadedConfiugration) {
                sb.append(this.GetXmlString(cfgObject));
            }
        }
        return sb.toString();
    }

    public final String GetXmlString(Object cfgObject) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        String rootXmlStr = null;
        Class<?> type = cfgObject.getClass();
        Annotation[] cfgObjCustomAttribs = type.getAnnotations();
        if (cfgObjCustomAttribs != null && cfgObjCustomAttribs.length > 0) {
            for (int i = 0; i < cfgObjCustomAttribs.length; ++i) {
                ConfigurationRootAnnotation rootAttrib;
                if (cfgObjCustomAttribs[i].annotationType() != ConfigurationRootAnnotation.class || (rootAttrib = (ConfigurationRootAnnotation)cfgObjCustomAttribs[i]) == null) continue;
                rootXmlStr = rootAttrib.value();
            }
        }
        return this.GetSectionXml(cfgObject, rootXmlStr, 1);
    }

    private String getRightPadString(int padCount) {
        Object padString = "";
        for (int i = 0; i < padCount; ++i) {
            padString = (String)padString + " ";
        }
        return padString;
    }

    private String GetSectionXml(Object configSection, String sectionName, int indent) throws IllegalArgumentException, IllegalAccessException {
        String endStr = "\r\n";
        String preStr = this.getRightPadString(indent * 2);
        StringBuilder sb = new StringBuilder(preStr + "<" + sectionName);
        Class<?> type = configSection.getClass();
        Method[] propertiesInfo = type.getMethods();
        if (propertiesInfo != null && propertiesInfo.length > 0) {
            for (int i = 0; i < propertiesInfo.length; ++i) {
                Annotation[] customAttribs;
                Method property = propertiesInfo[i];
                if (property.getReturnType().equals(Void.TYPE) || (customAttribs = property.getAnnotations()) == null || customAttribs.length <= 0) continue;
                for (int j = 0; j < customAttribs.length; ++j) {
                    String appendedText;
                    ConfigurationAttributeAnnotation attrib = (ConfigurationAttributeAnnotation)(customAttribs[j].annotationType() == ConfigurationAttributeAnnotation.class ? customAttribs[j] : null);
                    if (attrib == null) continue;
                    Object propertyValue = null;
                    try {
                        propertyValue = property.invoke(configSection, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    String string = appendedText = attrib.appendText() != null ? attrib.appendText() : "";
                    if (propertyValue != null) {
                        sb.append(" " + attrib.value() + "=\"" + propertyValue.toString() + appendedText + "\"");
                        continue;
                    }
                    sb.append(" " + attrib.value() + "=\"\"");
                }
            }
        }
        boolean subsectionsFound = false;
        boolean firstSubSection = true;
        StringBuilder comments = null;
        if (propertiesInfo != null && propertiesInfo.length > 0) {
            for (int i = 0; i < propertiesInfo.length; ++i) {
                Annotation[] customAttribs;
                Method property = propertiesInfo[i];
                if (property.getReturnType().equals(Void.TYPE) || (customAttribs = property.getAnnotations()) == null || customAttribs.length <= 0) continue;
                for (int j = 0; j < customAttribs.length; ++j) {
                    Object propertyValue;
                    if (property.isAnnotationPresent(ConfigurationCommentAnnotation.class)) {
                        String propStr;
                        propertyValue = null;
                        try {
                            propertyValue = property.invoke(configSection, new Object[0]);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        if (propertyValue != null && !DotNetToJavaStringHelper.isNullOrEmpty(propStr = (String)(propertyValue instanceof String ? propertyValue : null))) {
                            if (comments == null) {
                                comments = new StringBuilder();
                            }
                            comments.append(String.format("%1$s<!--%2$s-->%3$s", preStr, propStr, endStr));
                        }
                    }
                    if (!property.isAnnotationPresent(ConfigurationSectionAnnotation.class)) continue;
                    propertyValue = null;
                    try {
                        propertyValue = property.invoke(configSection, new Object[0]);
                    }
                    catch (InvocationTargetException propStr) {
                        // empty catch block
                    }
                    if (propertyValue == null) continue;
                    subsectionsFound = true;
                    if (firstSubSection) {
                        sb.append(">" + endStr);
                        firstSubSection = false;
                    }
                    if (propertyValue.getClass().isArray()) {
                        Object[] array = (Object[])(propertyValue instanceof Object[] ? propertyValue : null);
                        for (int k = 0; k < array.length; ++k) {
                            Object actualSectionObj = array[k];
                            if (actualSectionObj == null) continue;
                            sb.append(this.GetSectionXml(actualSectionObj, property.getAnnotation(ConfigurationSectionAnnotation.class).value(), indent + 1));
                        }
                        continue;
                    }
                    sb.append(this.GetSectionXml(propertyValue, property.getAnnotation(ConfigurationSectionAnnotation.class).value(), indent + 1));
                }
            }
        }
        if (subsectionsFound) {
            sb.append(preStr + "</" + sectionName + ">" + endStr);
        } else {
            sb.append("/>" + endStr);
        }
        Object xml = "";
        xml = comments != null ? comments.toString() + sb.toString() : sb.toString();
        return xml;
    }
}

